//
// Square.cpp - example of usage graphics commands to create 3D graphics.
//
// This example is based on code written by
// Fabio de Albuquerque Dela Antonio (fabio914 at gmail.com)
// See : https://github.com/fabio914/arduinogl/blob/master/examples
//

#include "Square.h"

// Constructor
Square::Square(Display* display) : Model()
{
    glUseCanvas(display);
}


void Square::Setup()
{
    // Let model size change in the range 2 .. 8.
    // Set 3 as initial size
    SetShamScaleMode(3.f, 2.f, 8.f, 0.4f); 
    
    glPointSize(4);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluOrtho2D(-5.0, 5.0, -5.0, 5.0);

    glMatrixMode(GL_MODELVIEW);
}


void Square::Render()
{
    float scale = GetScaleValue();

    glLoadIdentity();
    glRotatef(GetAngleValue(), 0.f, 0.f, 1.f);
    glScalef(scale, scale, 0.f);
    glTranslatef(-0.5f, -0.5f, 0.f);

    glBegin(GL_POLYGON);
    glVertex3f(0.f, 1.f, 0.f);
    glVertex3f(0.f, 0.f, 0.f);
    glVertex3f(1.f, 0.f, 0.f);
    glVertex3f(1.f, 1.f, 0.f);
    glEnd();
}