//
// BaseModel.cpp - abstract class for 3D demo models
//

#include "Model.h"

Model::Model()
{
}

void Model::SetShamAngleMode()
{
    _angle.SetAngle(AngleSham, 0, DirectionLeft, 1.f);
}

void Model::SetRealAngleMode(float initialValue)
{
    _angle.SetAngle(AngleReal, 0, DirectionLeft, 1.f);
}

float Model::GetAngleValue()
{
    return _angle.GetAngle();
}


void Model::SetFixedScaleMode(float scale)
{
    _scale.SetScale(ScaleFixed, scale, scale, scale, 0);
}


void Model::SetShamScaleMode(float initialValue, float minValue, float maxValue, float delta)
{
    _scale.SetScale(ScaleSham, initialValue, minValue, maxValue, delta);
}


void Model::SetRealScaleMode(float minValue, float maxValue, float delta)
{
    _scale.SetScale(ScaleFixed, 0, minValue, maxValue, delta);
}


float Model::GetScaleValue()
{
    return _scale.GetScale();
}