//
// Cube.cpp - example of usage graphics commands to create 3D graphics.
//
// This example is based on code written by
// Fabio de Albuquerque Dela Antonio (fabio914 at gmail.com)
// See : https://github.com/fabio914/arduinogl/blob/master/examples
//

#include "Cube.h"

// Constructor
Cube::Cube(Display * display) : Model()
{
    glUseCanvas(display);

    _perspectiveAspect = display->DisplayWidth() / display->DisplayHeight();
}

/**
* @brief  Model setup.
* @retval None
*/
void Cube::Setup()
{
    // Make the model a little bigger
    SetFixedScaleMode(2.3f);
    
    glPointSize(4);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();

    gluPerspective(30.0, _perspectiveAspect, 0.1f, 9999.f);

    glMatrixMode(GL_MODELVIEW);
}

/**
* @brief  Renders a square for given view angle and scale.
* @param  None
* @retval None
*/
void Cube::Render()
{
    const float scale = GetScaleValue();

    // Put the initial matrix at glMatrices[glmatrixMode == GL_PROJECTION]
    glLoadIdentity();
    
    // Transform matrix
    gluLookAt(10, 8, -10, 0, 0, 0, 0, 1, 0);

    glRotatef(GetAngleValue(), 0.f, 1.f, 0.f);
    glScalef(scale, scale, scale);

    DrawCube();
}


void Cube::DrawCube()
{
    glBegin(GL_POLYGON);
    glVertex3f(-1, -1, -1);
    glVertex3f(1, -1, -1);
    glVertex3f(1, 1, -1);
    glVertex3f(-1, 1, -1);
    glEnd();

    glBegin(GL_POLYGON);
    glVertex3f(1, -1, -1);
    glVertex3f(1, -1, 1);
    glVertex3f(1, 1, 1);
    glVertex3f(1, 1, -1);
    glEnd();

    glBegin(GL_POLYGON);
    glVertex3f(1, -1, 1);
    glVertex3f(-1, -1, 1);
    glVertex3f(-1, 1, 1);
    glVertex3f(1, 1, 1);
    glEnd();

    glBegin(GL_POLYGON);
    glVertex3f(-1, -1, 1);
    glVertex3f(-1, -1, -1);
    glVertex3f(-1, 1, -1);
    glVertex3f(-1, 1, 1);
    glEnd();

    glBegin(GL_POLYGON);
    glVertex3f(-1, -1, 1);
    glVertex3f(1, -1, 1);
    glVertex3f(1, -1, -1);
    glVertex3f(-1, -1, -1);
    glEnd();

    glBegin(GL_POLYGON);
    glVertex3f(-1, 1, -1);
    glVertex3f(1, 1, -1);
    glVertex3f(1, 1, 1);
    glVertex3f(-1, 1, 1);
    glEnd();
}