//
// main.cpp - 3D Graphics Demo
//

#define STM32

#include "mbed.h"
#include "RK043FN48H.h"
#include "Canvas.h"
#include "Square.h"
#include "Cube.h"
#include "Sphere.h"
#include "Pyramid.h"
#include "Pikachu.h"
#include "Bunny.h"

RK043FN48H display;

void SetTitle(char *name);

int main()
{
    SetTitle("Pikachu 3D demo.");
         
    // Initialize canvas
    Canvas canvas(display.DisplayWidth(), display.DisplayHeight()); 
    canvas.SetDrawColor(0xFF, 0x55, 0x55, 0xFF);
    
    // Initialize 3D model
    Pikachu model(&canvas);
    model.Setup();
    
    while(true) {
        canvas.Clear();       
        model.Render();
        display.CopyBitmap(Foreground, canvas.GetBitmap(), canvas.DisplayWidth(), canvas.DisplayHeight(), canvas.GetDrawColor());
           
        wait(0.06f);
    }   
}




void SetTitle(char *name)
{
     // Draw text in the background
    display.SetActiveLayer(Background);
    display.DrawText(150, 8, name);
    display.SetActiveLayer(Foreground);   
}