//
// Square.h - example of usage graphics commands to create 3D graphics
//
// This example is based on code written by
// Fabio de Albuquerque Dela Antonio (fabio914 at gmail.com)
// See : https://github.com/fabio914/arduinogl/blob/master/examples
//
#pragma once

#include <ArduinoGL.h>
#include "Model.h"

/**
* @brief 3D model of the square
*/
class Square : public Model
{
public:

    Square(Display * display);

    /**
    * @brief  Model setup.
    * @retval None
    */
    void virtual Setup();

    /**
    * @brief  Renders a square for given view angle.
    *         Scale of the square changes for every frame.
    *         Single frame is rendered.
    * @param  None
    * @retval None
    */
    void virtual Render();
};
