//
// Cube.h - example of usage graphics commands to create 3D graphics.
//
// This example is based on code written by
// Fabio de Albuquerque Dela Antonio (fabio914 at gmail.com)
// See : https://github.com/fabio914/arduinogl/blob/master/examples
//

#pragma once

#include <ArduinoGL.h>
#include "Model.h"

/**
 * @brief 3D model of the cube
 */
class Cube : public Model
{
public:

    Cube(Display* display);

    /**
    * @brief  Model setup.
    * @retval None
    */
    void virtual Setup();

    /**
    * @brief  Render single frame on the display.
    * @retval None
    */
    void virtual Render();

private:

    void DrawCube();
    
    float _perspectiveAspect;
};