//
//  Scale.cpp
//

#include "Scale.h"
#include "mbed.h"   // for AnalogIn

#ifdef ARDUINO
int scalePin = 1;
#else
AnalogIn scaleRead(A1);
#endif

Scale::Scale()
{
    // Set ScaleFixed as default
    SetScale(ScaleFixed, 1.f, 1.f, 8.f, 0.4f);
}

void Scale::SetScale(ScaleType type, float initialValue, float minValue, float maxValue, float delta)
{
    _type = type;

    _scale = initialValue;
    _delta = delta;
    _minScale = minValue;
    _maxScale = maxValue;
}


float Scale::GetScale()
{
    switch(_type) {

        case ScaleReal:

            // Get real value
            _scale = ReadScale();
            break;

        case ScaleSham:

            // Simulate changes
            _scale += _delta;

            if(_scale > _maxScale)
                _delta *= -1.f;

            if(_scale < _minScale)
                _delta *= -1.f;

            break;

        default:
            break;
    }
    
    return _scale;
}

/// Read the scale from a potentiometer attached to analog pin
float Scale::ReadScale()
{
    float scale = _scale;

#ifdef ARDUINO
    scale = analogRead(scalePin);
#else
    scale = scaleRead;
#endif

    return _minScale + scale * (_maxScale - _minScale)/1024.f;
}