//
//  Angle.cpp - Calculate rotation angle. Reads the rotation angle from a potentiometer.
//
#include "Angle.h"

#define FULL_ANGLE_DEG 360.0f

#ifdef STM32
#include "mbed.h"   // for AnalogIn on STM32 environment
AnalogIn angleRead(A0);
#define MAX_ANALOG_INPUT_VALUE 1024.f
#endif

#ifdef ARDUINO
int anglePin = 0;
#define MAX_ANALOG_INPUT_VALUE 1024.f
#endif


Angle::Angle()
{
    // Set simulated angle as default
    SetAngle(AngleSham, 0, DirectionLeft, 1.f);
}


void Angle::SetAngle(AngleType type, float initialValue, AngleDirection direction, float delta)
{
    _type = type;

    _angle = initialValue;
    _direction = direction;
    _delta = delta;
}


float Angle::GetAngle()
{
    switch(_type) {
        
        case AngleReal:
            _angle = ReadAngle();
            break;
            
        case AngleSham:
            if (_direction == DirectionLeft) {
                _angle += _delta;
                if (_angle > FULL_ANGLE_DEG) {
                    _angle -= FULL_ANGLE_DEG;
                }
            } else { // Right
                _angle -= _delta;
                if (_angle < 0) {
                    _angle += FULL_ANGLE_DEG;
                }
            }
            break;

        default:
            break;
    }

    return _angle;
}


float Angle::ReadAngle()
{
    float angle = 0;

#ifdef STM32
    angle = angleRead / MAX_ANALOG_INPUT_VALUE * FULL_ANGLE;
#endif

#ifdef ARDUINO
    angle = analogRead(anglePin) / MAX_ANALOG_INPUT_VALUE * FULL_ANGLE;
#endif

    return angle;
}