#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h" 

Serial device(D14, D15);  // TX , RX
Serial pc(USBTX,USBRX);
AnalogIn entrada(A1); //PB1
AnalogOut salida(PTE30);
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
QEI wheel (PTD5, PTD0, NC, 1);
DebouncedIn button3(PTC12);

//------------------------------------------------------------//
// Definiendo variables a emplear
float  yr, pid,pidn,ap, ai, ad, cycle; 
float kp, ki, kd, sp, err,med;
int m,c;
int const L = 13;
char medicion[4];
char estado;
char dato;
char buffer[L],P[4],I[4], SP[4];

/*codigos movimiento del curzor 18 para izquierda
1A para derecha*/

//int C1=0x0E; // solo muestra el curzor
int C2=0x18; // desplaza izquierda
int C3=0x1A; // desplaza derecha
int C4=0x0C; // quito cursor bajo
int C1=0x0F;
int j; //variable controla cambio 4 posiciones
//------------------------------------------------------------//

//------------------------------------------------------------//

// Funciones
void flush_buffer(){
   for (c=0;c<=L;c++){
       buffer[c]='\0';
       }
    
   }
void flush_bufferP(){
   for (c=0;c<=4;c++){
       P[c]='\0';
       }
       

   } 
   
void flush_bufferI(){
   for (c=0;c<=4;c++){
       I[c]='\0';
       }
       
   }   

void flush_bufferSP(){
   for (c=0;c<=4;c++){
       SP[c]='\0';
       }
   }   
//------------------------------------------------------------//


//------------------------------------------------------------//


int main() {
   
// Condiciones por defecto del sistema //
   kp = 0.35;
   ki = 0.7;
   kd = 0;
   sp=0.5; 
   ai=0;
   j=0;
   
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
    lcd.locate(0,0);
    lcd.printf("Sp:%.2f",sp);
    lcd.locate(8,0);
    lcd.printf("Kp:%.2f",kp);
    lcd.locate(0,1);
    lcd.printf("Ki:%.2f",ki);
    lcd.locate(8,1);
    lcd.printf("E:OFF");
//------------------------------------------------------------//
           
//------------------------------------------------------------//           
    while(1) {
encoder: if (button3.falling()) {   //INCREMENTA POSICION DEL MENU CON BOTON 3 (Switche encoder)
               ++j;
               if(j>3){ j=0;}
                    lcd.writeCommand(C1);
                    lcd.locate(0,0);
                    lcd.printf("Sp:%.2f",sp);
                    lcd.locate(8,0);
                    lcd.printf("Kp:%.2f",kp);
                    lcd.locate(0,1);
                    lcd.printf("Ki:%.2f",ki);
                    lcd.locate(8,1);
                    lcd.printf("E:OFF");
                }
 if (j==0){      
               sp=sp+(wheel.getPulses()*0.05);
               wheel.reset();
                 if (sp>3.2){sp=3.2;} 
                 if (sp<0){sp=0;}
                    //lcd.cls();
                    lcd.locate(8,1);
                    lcd.printf("     ");
                    lcd.locate(8,1);
                    lcd.printf("E:OFF");
                    lcd.locate(2,0);
                    lcd.printf("     ");
                    lcd.locate(2,0);
                    lcd.printf(":%.2f",sp);
                    wait(0.2);
                                        
            }
        if (j==1){      
               kp=kp+(wheel.getPulses())*0.01;
               wheel.reset();
                 if (kp>1){kp=1;} 
                 if (kp<0){kp=0;}
                 
                    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
                    lcd.locate(8,0);
                    lcd.printf("     ");
                    lcd.locate(8,0);
                    lcd.printf("Kp:%.2f",kp);
                    wait(0.2);
                 }  
    
        if (j==2){      
               ki=ki+(wheel.getPulses())*0.01;
               wheel.reset();
                 if (ki>1){ki=1;} 
                 if (ki<0){ki=0;}
                 
                    lcd.locate(0,1);
                    lcd.printf("     ");
                    lcd.locate(0,1);
                    lcd.printf("Ki:%.2f",ki);
                    wait(0.2);
                 }                        
if(j==3){
lcd.locate(8,1);
lcd.printf("     ");
lcd.locate(8,1);
lcd.printf("E:ON");
goto inicio;}
  }                      
// Ciclo principal

inicio: fflush(stdin);
        flush_buffer();
        flush_bufferP();
        flush_bufferI();
        flush_bufferSP();
        if (button3.falling()) {   //INCREMENTA POSICION DEL MENU CON BOTON 3 (Switche encoder)
        goto encoder;}                    
        
        wait(0.1); // 0.2 funciona
        if (device.readable()) { 
            flush_buffer();       
            goto lectura;}
        if(estado=='G') {
               goto controlador;}
        else{ goto inicio;}            
        
         
//------------------------------------------------------------//        
lectura: estado=device.getc();
        if(estado=='G') {goto inicio;}
        if(estado=='T'){goto inicio;}
        else{
        for(m=0;m<=L;m++){         
            dato=device.getc();
            buffer[m]=dato;}
        goto imprimir;}
        
imprimir:
         pc.printf("%s",buffer);
         for (m=0;m<L;m++){
            if (buffer[m]=='P')break;
            P[m]=buffer[m];
            } 
            pc.printf("\n\r%s", P);
        
        
         for (m=5;m<L;m++){
            if (buffer[m]=='I'){break;}
            I[m-5]=buffer[m];
            }
        
        pc.printf("\n\r%s", I);
        
        for (m=10;m<L;m++){
            if (buffer[m]=='S'){break;}
            SP[m-10]=buffer[m];}
        
        pc.printf("\n\r%s", SP);
        
        kp=atof(P);
        ki=atof(I);
        sp=atof(SP); 
        j=3; 
        pc.printf("\n\r%.1f    %.2f    %.2f\n\r", sp,kp,ki);
        lcd.cls();
                    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
                    lcd.locate(0,0);
                    lcd.printf("Sp:%.2f",sp);
                    lcd.locate(8,0);
                    lcd.printf("Kp:%.2f",kp);
                    lcd.locate(0,1);
                    lcd.printf("Ki:%.2f",ki); 
                    lcd.locate(8,1);
                    lcd.printf("     ");
                    lcd.locate(8,1);
                    lcd.printf("E:ON");
                    
        goto inicio;
//------------------------------------------------------------//        
                 
controlador: med=3.3*entrada.read();
           sprintf(medicion,"%.3f",med);      
           pc.printf("%.3f    %.3f    %.3f  \n\r",3.3*entrada.read(),pid,err);
           if (device.writeable()){device.puts(medicion);}
           err = (sp - med);
           ap = kp*err;
           ai =(ki*err)+ai;  
           
           pid = (ap+ai)/3.3;         
           if (pid > 0.99){
           pid=1.0;
           }
           else if (pid<0.0){
           pid=0.0;
           }
           salida.write(pid);
          
           goto inicio;
//------------------------------------------------------------//           
}