#include "mbed.h"
#include "PinDetect.h"

 //////////sensors pins///////
 
 PinDetect  sig1_sen ( p15 );
 PinDetect  sig2_sen ( p17 );
 PinDetect  sig3_sen ( p16 );
 PinDetect  sig4_sen ( p14 );
 
 DigitalOut led1 ( LED1 );

  
/////signal 1////////////////

 DigitalOut sig1_red ( p20 );
 DigitalOut sig1_yellow ( p19 );
 DigitalOut sig1_green ( p18 );

/////signal 2////////////////
 
 DigitalOut sig2_red ( p30 );
 DigitalOut sig2_yellow ( p29 );
 DigitalOut sig2_green ( p28 );

/////signal 3///////////////

 DigitalOut sig3_red ( p26 ); 
 DigitalOut sig3_yellow ( p25 ); 
 DigitalOut sig3_green ( p24 );
 
//////signal 4//////////////

 DigitalOut sig4_red ( p21 ); 
 DigitalOut sig4_yellow ( p22 ); 
 DigitalOut sig4_green ( p23 ); 
 
 
 int counter_sensors[4] = {0,0,0,0};/////////array which keeps traffic intensity of each signal
 int priorities[4] = {0,0,0,0};   ///////////array which assigns priorities to signals
 int signal = 0;   
 
///////////////////////// pin 20/////////////////////////////////

void keyPressed_sen1( void ) {
    
counter_sensors[0]++;
   
     
}

/////////////////// pin 19 //////////////////////////

void keyPressed_sen2( void ) {
   
counter_sensors[1]++;   
     
}

/////////////////////////// pin 18 ///////////////////////////

void keyPressed_sen3( void ) {

counter_sensors[2]++;
     
}

///////////////////////// pin 17 ////////////////////////////////
 
void keyPressed_sen4( void ) {
  
  counter_sensors[3]++;
     
 }


//////////////////// initialization of red signals ///////////

void sigs_initialization ( void ){
    
    sig1_red = 1;
    sig2_red = 1;
    sig3_red = 1;
    sig4_red = 1;
    

}

int max_value_index (void)
       {
       int max = counter_sensors[0];
       int location = 0;
       for ( int i=1; i<4; i++ )
            {
            if( counter_sensors[i] > max )
                {
                max = counter_sensors[i];
                location = i;
                }
            }
       return location;
       }

int check_starvation()
    {
    if((signal + 1) == 4)
        {
        for(int i = 0;i < 4;i++)
            {
            if(priorities[i] == 0)
                {              
                return i;
                }
            }
        }
    return -1;    
    }

///////////////////////checking maximum traffic///////////////////

void check_counts ( void )
    {
    int max_signal_trafic = check_starvation();
    if(max_signal_trafic == -1)
        {
        max_signal_trafic = max_value_index();
        }
    if (max_signal_trafic == 0) 
        {
        if ( counter_sensors[0] != 0)
            {
            sig1_red = 0;
            sig1_yellow = 1;
            wait( 1 );
            sig1_yellow = 0;
            sig1_green = 1;
            priorities[0] = 1;
            signal++;        
            wait( 2 * counter_sensors[0] );
            sig1_green = 0;
           
            sig1_yellow = 1;
            wait( 1 );
            sig1_yellow = 0;
            wait( 1 );
            sig1_red = 1;
            counter_sensors[0] = 0;
            }
        }
    if ( max_signal_trafic == 1 )
        {
        sig2_red = 0;
        sig2_yellow = 1;
        wait ( 1 );
        sig2_yellow = 0;
        sig2_green = 1;
       
        priorities[1]=1;
        signal++;
        wait( 2 * counter_sensors[1] );
        sig2_green = 0;      
        sig2_yellow = 1;
        wait ( 1 );
        sig2_yellow = 0;
        wait( 1 );
        sig2_red = 1;
        counter_sensors[1] = 0;
        }
    if ( max_signal_trafic == 2)
        {
        sig3_red = 0;
        sig3_yellow = 1;
        wait ( 1 );
        sig3_yellow = 0;
        sig3_green = 1;
        priorities[2] = 1;
        signal++;
        wait( 2 * counter_sensors[2] );
        sig3_green = 0;
        sig3_yellow = 1;
        wait ( 1 );
        sig3_yellow = 0;
        wait( 1 );
        sig3_red = 1;
        counter_sensors[2] = 0;
        }   
            
    if ( max_signal_trafic == 3)
        {
        sig4_red = 0;
        sig4_yellow = 1;
        wait ( 1 );
        sig4_yellow = 0;
        sig4_green = 1;
        priorities[3]=1;
        signal++;
        wait( 2 * counter_sensors[3] );
        sig4_green = 0;  
        sig4_yellow = 1;
        wait ( 1 );
        sig4_yellow = 0;
        wait( 1 );
        sig4_red = 1;
        counter_sensors[3] = 0;
        }
    if(signal == 4)
        {
        priorities[0] = 0;
        priorities[1] = 0;
        priorities[2] = 0;
        priorities[3] = 0;    
        signal = 0;           
	    }
   } 

 int main() {
 

    sigs_initialization();
 

////////////////////////pin 20//////////////////////////////////
     
     if ( sig1_green != 1 ) {
     
     sig1_sen.mode( PullDown );
     sig1_sen.attach_asserted( &keyPressed_sen1 );
     sig1_sen.setSampleFrequency(); // Defaults to 20ms.
     
     }
     
/////////////////////////////////////////////////////////////////

////////////////////pin 19////////////////////////////////////     
     
     if ( sig2_green != 1 ){
     
     sig2_sen.mode( PullDown );
     sig2_sen.attach_asserted( &keyPressed_sen2 );
     sig2_sen.setSampleFrequency();
     
     }
/////////////////////////////////////////////////////////////

///////////////// pin 18////////////////////////////////////
    
    if ( sig3_green != 1){    
    
     sig3_sen.mode( PullDown );
     sig3_sen.attach_asserted( &keyPressed_sen3 );
     sig3_sen.setSampleFrequency();    
     
     }
///////////////////////////////////////////////////////////


////////////////////// pin 17///////////////////////////////
    
    if ( sig4_green != 1){
     
     sig4_sen.mode( PullDown );
     sig4_sen.attach_asserted( &keyPressed_sen4 );   
     sig4_sen.setSampleFrequency();    
     
     }
/////////////////////////////////////////////////////////////     
    
    
     while( 1 ) {
     
         led1=!led1;
         check_counts();
          
     
     }
 }
