#include "mbed.h"

DigitalOut myled(LED4);
I2C i2c(p9, p10);

// Connections made:
// SDA to pin9  of LPC4088 QSB
// SCL to pin10 of LPC4088 QSB
// on I2C bus is PCF8574 connected at sub-address 0 (0x40).
// all supplied at 3.3V
// no external pullup (Assuming that I2C-class is using 5K internal pullup)
// 

// this example does not work on my LPC4088 QSB.
// mbed: 92:4fc01daae5a5
//
// note When I connect an external pulldown! (not pullup) of 10K on SDA & SCL it seems to work
//      This is not logical.

void 
i2cIoWrite (char address, char data)
{
  i2c.start ();     
  i2c.write (address);
  i2c.write (data);
  i2c.stop ();
}


int 
main() 
{
  i2c.frequency (100000);

  while (1)
  {
    myled = 1;
    i2cIoWrite (0x40, 0x55);
    wait(0.5);
    myled = 0;    
    i2cIoWrite (0x40, 0xAA);
    wait (0.5);
  }
}
