#include "mbed.h"
#include "my_i2c.h"

DigitalInOut sda(p9);
DigitalInOut scl(p10);


#define SDA(state) if (state) { \
  sda.input ();                 \
  sda = 1;                      \
} else {                        \
  sda = 0;                      \
  sda.output ();                \
}

#define SCL(state) if (state) { \
  scl.input ();                 \
  scl = 1;                      \
} else {                        \
  scl = 0;                      \
  scl.output ();                \
}

#define IO_DELAY() wait_us (1)


void my_i2cWriteByte (unsigned char byte);
bool my_i2cGetAck ();
unsigned char my_i2cReadByte ();


bool
my_i2cStart (unsigned char slaveAddress)
{
  SDA(1);
  SCL(1);
  IO_DELAY();
  SDA(0);
  IO_DELAY();

  my_i2cWriteByte (slaveAddress);

  return my_i2cGetAck ();
}


bool
my_i2cStop ()
{
  SDA(0);
  SCL(0);
  IO_DELAY();

  SCL(1);
  IO_DELAY();

  SDA(1);
  IO_DELAY();

  return true;
}


bool
my_i2cRepeatedStart (unsigned char slaveAddress)
{
  SCL(0);
  IO_DELAY();

  SDA(1);

  IO_DELAY();

  SCL(1);

  IO_DELAY();

  SDA(0);
  my_i2cWriteByte (slaveAddress);

  return my_i2cGetAck ();
}


bool
my_i2cWrite (unsigned char data)
{
  my_i2cWriteByte (data);
  return my_i2cGetAck ();
}


unsigned char
my_i2cReadByte ()
{
  unsigned char data = 0;

  for (int i = 0x80; i > 0x00; i >>= 1)
  {
    SCL(0);
    SDA(1);
    IO_DELAY();

    SCL(1);
    IO_DELAY();

    if (sda)
    { // turn bit to 1...
      data |= i;
    }
  }
  return data;
}


unsigned char
my_i2cReadAck ()
{
  unsigned char data = my_i2cReadByte ();

  SCL(0);
  SDA(0);
  IO_DELAY();

  SCL(1);

  // wait till scl is high
  IO_DELAY();

  return data;
}


unsigned char
my_i2cReadNak ()
{
  unsigned char data = my_i2cReadByte ();

  SCL(0);
  SDA(1);
  IO_DELAY();

  SCL(1);
  // wait till scl is high
  IO_DELAY();

  return data;
}


unsigned char
my_i2cRead (unsigned char ack)
{
  if (ack)
  {
    return my_i2cReadAck ();
  }
  return my_i2cReadNak ();
}


void
my_i2cWriteByte (unsigned char byte)
{
  for (int i = 0x80; i > 0x00; i >>= 1)
  {
    SCL(0);
    SDA((byte & i) ? true : false);
    IO_DELAY();

    SCL(1);
    IO_DELAY();
  }
}


bool
my_i2cGetAck ()
{
  SCL(0);
  SDA(1);
  IO_DELAY();

  SCL(1);
// wait till clock = 1...
  IO_DELAY();

  bool ack = false;
  ack = sda;

  return !ack;
}
