#include "mbed.h"
#include "my_i2c.h"

DigitalOut myled(LED1);

// Connections made:
// SDA to pin9  of LPC4088 QSB
// SCL to pin10 of LPC4088 QSB
// on I2C bus is PCF8574 connected at sub-address 0 (0x40).
// all supplied at 3.3V
// no external pullup (5K internal pullup used by my_i2c functions)
// 
// note in the my_i2c functions a delay of 1us is added after each transition of the pin.
//      so this means an absolute maximum frequency of 500kHz.

int main() {
    
    while(1) {
        myled = 1;
        my_i2cStart(0x40);
        my_i2cWrite (0x55);
        my_i2cStop();
        wait(0.5);
        myled = 0;
        my_i2cStart(0x40);
        my_i2cWrite (0xAA);
        my_i2cStop();
        wait(0.5);
    }
}
