#include "mbed.h"
#include "USBSDFileSystem.h"

DigitalOut myled(LED1);

USBSDFileSystem sd("sd", p11, p12, p13, p14); // the pinout on the mbed testbed board // mosi, miso, sclk, cs


void mylog (int i)
{
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "a");
    if(fp == NULL) {
        printf("Could not open file for write\n");
    } else
    {
      fprintf(fp, "[%d]Hello fun SD Card World!\n", i);
      printf("appending: '[%d]Hello fun SD Card World!'\n", i);
      fclose(fp); 
    }
}


int main() 
{
    sd.usbMode (1); // allow fopen/fprintf when connected with USB-drive.
    printf("Hello World!\n\n");   
    
    printf("now a USB drive should appear on your PC\n");
    wait (60);
       
    printf("create directory and append to log file\n");
    mkdir("/sd/mydir", 0777);
    mylog (0);    

    printf("Entering loop of 1 min cycle time\n");

    int i = 1;
    while(1) {
        myled = 0;
        wait(5);        
        //sd.disconnect ();
        mylog (i++);
        //sd.connect ();
        myled = 1;
        wait(55);
    }
    return 0;
}
