#include "mbed.h"
#include "SSD1306.h"
I2C i2c(D4,D5);
SSD1306 oled(i2c, 0x78);
DigitalOut UltrasonTriger(D9);
DigitalIn UltrasonEcho(D10);
Serial pc(USBTX, USBRX);
 
void Imp_Ultra(void);
int Rec_Ultra();
 
int main() {
    
    
    while(1) 
    {
        Imp_Ultra();           
    }
}
 
void Imp_Ultra(void)
{
    static Timer timer;
    float ultrason_distance;
    //blueth.printf("fonct\n");
    
    
    static short etat = 0;
    
    switch(etat)
    {
        case 0:
            UltrasonTriger = 1; // envoie une impulsion de 10us
            timer.start();
            etat = 1;
            break;
        case 1:
            
            if(timer.read_us() > 10) // fin de l'impulsion
            {
                UltrasonTriger = 0;
                timer.reset();
                etat = 2;   
            }
            break; 
        case 2:
            
            if(UltrasonEcho.read()==1)  // Si on a une reception
            {
                timer.start(); // lance timer pour mersurer l'impulsion
                etat = 3;
            }
            if(timer.read_ms()>30) etat = 4;  // Si au bout de 30ms pas de reception alors aucune mesure
            break;
        case 3:
            
            if(UltrasonEcho.read()==0)  // Mesurer le temps d'impulsion de la reception
            {
                ultrason_distance=timer.read_us()/58-8; // Calcul de la distance
                oled.clearDisplay();
                oled.printf("%3.2f",ultrason_distance);
                pc.printf("La dustance est de %3.2f cm\n",ultrason_distance);
                timer.stop();
                timer.reset();
                etat = 5;
            }
            if(timer.read_ms()>30) etat = 4;
            break;
        case 4:
            oled.clearDisplay();
            oled.printf("erreur");
            pc.printf("erreur"); // Si pas de recption
            timer.stop();
            timer.reset();
            etat = 5;
            break;
        case 5:
            break;
    }
}
