#include "MQTTTimer.h"
#include "CayenneMQTTClient.h"
#include "MQTTNetworkIDW01M1.h"
#include "SpwfInterface.h"
#include "mbed.h"
#include "XNucleoIKS01A2.h" // czujniki ruchu i otoczenia
#include "XNucleoNFC01A1.h" // modul nfc
#include "NDefLib/NDefNfcTag.h"
#include "NDefLib/RecordType/RecordURI.h"
#include "Servo.h"                                                                                           //biblioteka z funkcjami mbed
#include "XNucleoIKS01A2.h"                                                                                     //biblioteka ze sterownikiem plytki wykonującej pomiary (IKS)
#include "XNucleoNFC01A1.h"                                                                                     //biblioteka ze sterownikiem plytki NFC
#include "NDefLib/NDefNfcTag.h"                                                                                 //biblioteka z funkcjami plytki NFC - nadawanie tagu NFC
#include "NDefLib/RecordType/RecordText.h"

/* Instantiate the expansion board */
static XNucleoIKS01A2 *mems_expansion_board = XNucleoIKS01A2::instance(D14, D15, D4, D5);
    //instance the board with the default paramiters
I2C i2cChannel(XNucleoNFC01A1::DEFAULT_SDA_PIN,XNucleoNFC01A1::DEFAULT_SDL_PIN);                            
XNucleoNFC01A1 *nfcNucleo = XNucleoNFC01A1::instance(i2cChannel);

/* Retrieve the composing elements of the expansion board */
static HTS221Sensor *hum_temp = mems_expansion_board->ht_sensor;
static LPS22HBSensor *press_temp = mems_expansion_board->pt_sensor;

NDefLib::Message msg;

// Cayenne authentication info. This should be obtained from the Cayenne Dashboard.
char* username = "68880f30-7425-11e9-beb3-736c9e4bf7d0";
char* password = "19f07b4d8806fe42bdda724980634f39d8e639ba";
char* clientID = "bb8e7cc0-74b9-11e9-94e9-493d67fd755e";

AnalogIn ain(A0); //pin do pomiaru napiecia
DigitalOut myLed(LED2);
Servo myservo(PA_6); // pin do sterowania serwo
bool manualControl = false; // reczne sterowanie
// DigitalOut actuatorPin2(PA_7); 
float voltageMultiplier = 1.0; // mnoznik do wyskalowania odczytu napiecia z pinu A0
int publishInterval = 1000; // co ile publikowac dane na cayenne
float voltageChangeLevel = 1.5; // napiecie powyzej ktorego ma poruszyc serwo

// dane do WiFi.
char* ssid = "Interneto";
char* wifiPassword = "matu1234";

SpwfSAInterface interface(D8, D2); // TX, RX
MQTTNetwork<SpwfSAInterface> network(interface);
CayenneMQTT::MQTTClient<MQTTNetwork<SpwfSAInterface>, MQTTTimer> mqttClient(network, username, password, clientID);

void messageArrived(CayenneMQTT::MessageData& message)
{
    int error = 0;
    if (message.topic == COMMAND_TOPIC) {
        switch(message.channel) {
        case 4:
            // Set the onboard LED state & actuator PIN
            myLed = atoi(message.getValue());
            wait(0.1);
            myservo = myservo <= 0 ? 0.5 : -0.1;
            // actuatorPin2 = atoi(message.getValue());
            // Publish the updated LED state
            if ((error = mqttClient.publishData(DATA_TOPIC, message.channel, NULL, NULL, message.getValue())) != CAYENNE_SUCCESS) {
                printf("Publish LED state failure, error: %d\n", error);
            }
            break;
        case 6:
            // ustaw prog napiecia do wywolaniaobrotu serwa
            voltageChangeLevel = atof(message.getValue());
            
            // Publish the updated LED state
            if ((error = mqttClient.publishData(DATA_TOPIC, message.channel, NULL, NULL, message.getValue())) != CAYENNE_SUCCESS) {
                printf("Publish LED state failure, error: %d\n", error);
            }
            break;
        case 7:
            // przelacz manualne sterowanie
            manualControl = manualControl ? false : true;
            
            // Publish the updated LED state
            if ((error = mqttClient.publishData(DATA_TOPIC, message.channel, NULL, NULL, manualControl ? 1 : 0)) != CAYENNE_SUCCESS) {
                printf("Take manual control: %d\n", error);
            }
            break;
          }
        }
        
        // If this is a command message we publish a response. Here we are just sending a default 'OK' response.
        // An error response should be sent if there are issues processing the message.
        if ((error = mqttClient.publishResponse(message.id, NULL, message.clientID)) != CAYENNE_SUCCESS) {
            printf("Response failure, error: %d\n", error);
        }
}


/**
* Connect to the Cayenne server.
* @return Returns CAYENNE_SUCCESS if the connection succeeds, or an error code otherwise.
*/
int connectClient(void)
{
    int error = 0;
    // Connect to the server.
    printf("Connecting to %s:%d\n", CAYENNE_DOMAIN, CAYENNE_PORT);
    while ((error = network.connect(CAYENNE_DOMAIN, CAYENNE_PORT)) != 0) {
        printf("TCP connect failed, error: %d\n", error);
        wait(2);
    }

    if ((error = mqttClient.connect()) != MQTT::SUCCESS) {
        printf("MQTT connect failed, error: %d\n", error);
        return error;
    }
    printf("Connected\n");

    // Subscribe to required topics.
    if ((error = mqttClient.subscribe(COMMAND_TOPIC, CAYENNE_ALL_CHANNELS)) != CAYENNE_SUCCESS) {
        printf("Subscription to Command topic failed, error: %d\n", error);
    }
    if ((error = mqttClient.subscribe(CONFIG_TOPIC, CAYENNE_ALL_CHANNELS)) != CAYENNE_SUCCESS) {
        printf("Subscription to Config topic failed, error:%d\n", error);
    }

    // Send device info. Here we just send some example values for the system info. These should be changed to use actual system data, or removed if not needed.
    mqttClient.publishData(SYS_VERSION_TOPIC, CAYENNE_NO_CHANNEL, NULL, NULL, CAYENNE_VERSION);
    mqttClient.publishData(SYS_MODEL_TOPIC, CAYENNE_NO_CHANNEL, NULL, NULL, "mbedDevice");

    return CAYENNE_SUCCESS;
}

static void write_message(XNucleoNFC01A1 *nfcNucleo,NDefLib::Message &msg){                                     //funkcja uruchamiajaca proces tworzenia tagu NFC                    
    NDefLib::NDefNfcTag& tag = nfcNucleo->get_M24SR().get_NDef_tag();
    //open the i2c session with the nfc chip
    if(tag.open_session()){
        printf("Session opened\r\n");

        nfcNucleo->get_led1()=! nfcNucleo->get_led1();                                                          //zapala led1 przy przesylaniu danych przez I2C
        
        //write the tag
        if(tag.write(msg)){
            printf("message wrote\r\n");
            nfcNucleo->get_led2()=!nfcNucleo->get_led2();                                                       //zapala led2 przy tworzeniu tagu NFC
        }//if

        //close the i2c session
        if(tag.close_session()){
            printf("Session closed\r\n");
            nfcNucleo->get_led3()=!nfcNucleo->get_led3();                                                       //zapala led2 przy zakonczeniu przesylu danych przez I2C
        }
    }//if open session
}

void loop(void)
{
    float voltage_read = 0;
    NDefLib::RecordURI rUri(NDefLib::RecordURI::HTTPS,"cayenne.mydevices.com/shared/5d7376a3a4b14e4ee5849b49");
    msg.add_record(&rUri);
    

    // timer do publikacji wiadomosci mqtt
    MQTTTimer timer(publishInterval);

    while (true) {
        // wyslij wiadomosc z adresem panelu sterowania przez NFC
        write_message(nfcNucleo,msg);
        mqttClient.yield(1000);

        // sprawdz polaczenie z siecia i klientem mqtt, jesli brak sprobuj polaczyc ponownie
        if (!network.connected() || !mqttClient.connected()) {
            //network.disconnect();
            mqttClient.disconnect();
            while (connectClient() != CAYENNE_SUCCESS) {
                wait(2);
            }
        }

        // Publish data every few seconds. This should be changed to send your actual data to Cayenne.
        if (timer.expired()) {
            int error = 0;
            
            uint8_t id;
            float value1, value2, value3;
            // char buffer1[32], buffer2[32];
  
            /* Enable all sensors */
            hum_temp->enable();
            press_temp->enable();
            hum_temp->read_id(&id);
            press_temp->read_id(&id);
            hum_temp->get_temperature(&value1);
            hum_temp->get_humidity(&value3);
            // press_temp->get_temperature(&value1);
            press_temp->get_pressure(&value2);
            // printf("LPS22HB: [temp] %7s C, [press] %s mbar\r\n", print_double(buffer1, value1), print_double(buffer2, value2));

            voltage_read = ain.read() * voltageMultiplier;

            if ((error = mqttClient.publishData(DATA_TOPIC, 1, TYPE_TEMPERATURE, UNIT_CELSIUS, value1 - 3)) != CAYENNE_SUCCESS) {
                printf("Publish temperature failed, error: %d\n", error);
            }
            
            if ((error = mqttClient.publishData(DATA_TOPIC, 5, TYPE_RELATIVE_HUMIDITY, UNIT_PERCENT, value3)) != CAYENNE_SUCCESS) {
                printf("Publish humidity failed, error: %d\n", error);
            }

            if ((error = mqttClient.publishData(DATA_TOPIC, 3, TYPE_VOLTAGE, UNIT_VOLTS, voltage_read)) != CAYENNE_SUCCESS) {
                printf("Publish voltage failed, error: %d\n", error);
            }

            if ((error = mqttClient.publishData(DATA_TOPIC, 6, TYPE_VOLTAGE, UNIT_VOLTS, voltageChangeLevel)) != CAYENNE_SUCCESS) {
                printf("Publish voltage change level failed, error: %d\n", error);
            }
            
            if ((error = mqttClient.publishData(DATA_TOPIC, 2, TYPE_BAROMETRIC_PRESSURE, UNIT_HECTOPASCAL, value2)) != CAYENNE_SUCCESS) {
                printf("Publish barometric pressure failed, error: %d\n", error);
            }
            // Restart the countdown timer for publishing data every 2 seconds. Change the timeout parameter to publish at a different interval.
            timer.countdown_ms(publishInterval);
        }

      // jesli przekroczono ustawione napiecie o 5%, to zmien stan serwa
      if(!manualControl & voltage_read > voltageChangeLevel*1.05f)
      {
          // zmien pozycję serwa na pozycje otwartą
          myservo = 0.5;
      } else if(!manualControl & voltage_read < voltageChangeLevel*0.95f) // jesli napiecie spadlo ponizej 95% ustalonego napiecia, zmien stan serwa
      {
          myservo = -0.1;
        }
    }
}

int main()
{   
    myLed = 0;
    myservo = -0.1;
    
    interface.connect(ssid, wifiPassword, NSAPI_SECURITY_WPA2);
    mqttClient.setDefaultMessageHandler(messageArrived);

    // Connect to Cayenne.
    if (connectClient() == CAYENNE_SUCCESS) {
        // Run main loop.
        loop();
    }
        
    if (mqttClient.connected())
        mqttClient.disconnect();
    if (network.connected())
        network.disconnect();
    return 0;
}