#include "mbed.h"
#include "rtos.h"
#include "TextLCD.h"
#include "DHT.h"
////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////Pines a usar //////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////

TextLCD lcd(PA_9, PC_7,PB_5,PB_4,PB_10,PA_8);
DigitalIn Boton(BUTTON1);
AnalogIn analog_value(A0);

////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////Mensajes que se van amandar a imprimir/////////////////////////
////////////////////////////////////////////////////////////////////////////////////////

/* Mail 1 */
typedef struct {
  float GPS; /* AD result of measured voltage */
} mail_GPS;

/* Mail 2 */
typedef struct {
  float T; /* AD result of measured voltage */
  float H; /* AD result of measured voltage */              
} mail_DTH11;

/* Mail 3 */
typedef struct {
  float FYH; /* AD result of measured voltage */
} mail_FYH;

Mail<mail_GPS, 1000> mail_box1;
Mail<mail_DTH11, 1000> mail_box2;
Mail<mail_FYH, 1000> mail_box3;



////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////Programas a ralizar con el rtos////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////

void send_threadGPS (void) {
        int i=0;
        while (true){
        i++;
        mail_GPS *mail = mail_box1.alloc();
        mail-> GPS=  i*.33; 
        mail_box1.put(mail);
        Thread::wait(500);
        }
}


void send_threadDTH11 (void) {
    DHT sensor(PC_4, SEN11301P); // Use the SEN11301P sensor
    int err;        
    while(true){
        err = sensor.readData();
        printf("Temp: %.2f ",sensor.ReadTemperature(CELCIUS));
        printf("Hum: %.2f ",sensor.ReadHumidity()); // first time initialization
        mail_DTH11 *mail = mail_box2.alloc();
        mail-> T=  sensor.ReadTemperature(CELCIUS);
        mail-> H= sensor.ReadHumidity(); 
        mail_box2.put(mail);
    }
}

void send_threadFYH (void) {
    int j = 0;
    while (true) {
        j++; // fake data update
        mail_FYH *mail = mail_box3.alloc();
        mail-> FYH= (j * 0.1) * 33; 
        mail_box3.put(mail);
        Thread::wait(100);
    }
}

////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////Programa principal //////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////
int main (void) {
    
    Thread threadGPS;
    Thread threadDTH11;
    Thread threadFYH;
    threadGPS.start(callback(send_threadGPS));
    threadDTH11.start(callback(send_threadDTH11));
    threadFYH.start(callback(send_threadFYH));
    


    while (true) { 
        float meas;
        meas = analog_value.read(); 
        meas = meas * 3300;
        osEvent evt1 = mail_box1.get();
        osEvent evt2 = mail_box2.get();
        osEvent evt3 = mail_box3.get();
        if(meas > 3200){
             if (evt1.status == osEventMail) {
                mail_GPS *mail = (mail_GPS*)evt1.value.p;
                printf("GPS: %.4f V\n"   , mail->GPS);
                lcd.locate(0,0);
                lcd.printf("GPS: %.4f ", mail->GPS);   
                mail_box1.free(mail);
                }
             if (evt2.status == osEventMail) {
                mail_DTH11 *mail = (mail_DTH11*)evt2.value.p;
                printf("T: %.2f \n", mail->T);
                printf("H: %.2f \n", mail->H);
                lcd.locate(0,1);
                lcd.printf("T: %.2f ", mail->T);
                lcd.locate(8,1);
                lcd.printf("H: %.2f ", mail->H);    
                mail_box2.free(mail);
                }
            }
            
            else{
            lcd.cls();
            
             if (evt3.status == osEventMail) {
                mail_FYH *mail = (mail_FYH*)evt3.value.p;
                printf("FFECHA Y HORA: %f A\n\r"     , mail->FYH);
                lcd.locate(0,0);
                lcd.printf("Hora y Fecha");
                lcd.locate(0,1);
                lcd.printf("%f ", mail->FYH);   
                mail_box3.free(mail);
                }
            }
        
     }
}


