/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_ENET_REGISTERS_H__
#define __HW_ENET_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 ENET
 *
 * Ethernet MAC-NET Core
 *
 * Registers defined in this header file:
 * - HW_ENET_EIR - Interrupt Event Register
 * - HW_ENET_EIMR - Interrupt Mask Register
 * - HW_ENET_RDAR - Receive Descriptor Active Register
 * - HW_ENET_TDAR - Transmit Descriptor Active Register
 * - HW_ENET_ECR - Ethernet Control Register
 * - HW_ENET_MMFR - MII Management Frame Register
 * - HW_ENET_MSCR - MII Speed Control Register
 * - HW_ENET_MIBC - MIB Control Register
 * - HW_ENET_RCR - Receive Control Register
 * - HW_ENET_TCR - Transmit Control Register
 * - HW_ENET_PALR - Physical Address Lower Register
 * - HW_ENET_PAUR - Physical Address Upper Register
 * - HW_ENET_OPD - Opcode/Pause Duration Register
 * - HW_ENET_IAUR - Descriptor Individual Upper Address Register
 * - HW_ENET_IALR - Descriptor Individual Lower Address Register
 * - HW_ENET_GAUR - Descriptor Group Upper Address Register
 * - HW_ENET_GALR - Descriptor Group Lower Address Register
 * - HW_ENET_TFWR - Transmit FIFO Watermark Register
 * - HW_ENET_RDSR - Receive Descriptor Ring Start Register
 * - HW_ENET_TDSR - Transmit Buffer Descriptor Ring Start Register
 * - HW_ENET_MRBR - Maximum Receive Buffer Size Register
 * - HW_ENET_RSFL - Receive FIFO Section Full Threshold
 * - HW_ENET_RSEM - Receive FIFO Section Empty Threshold
 * - HW_ENET_RAEM - Receive FIFO Almost Empty Threshold
 * - HW_ENET_RAFL - Receive FIFO Almost Full Threshold
 * - HW_ENET_TSEM - Transmit FIFO Section Empty Threshold
 * - HW_ENET_TAEM - Transmit FIFO Almost Empty Threshold
 * - HW_ENET_TAFL - Transmit FIFO Almost Full Threshold
 * - HW_ENET_TIPG - Transmit Inter-Packet Gap
 * - HW_ENET_FTRL - Frame Truncation Length
 * - HW_ENET_TACC - Transmit Accelerator Function Configuration
 * - HW_ENET_RACC - Receive Accelerator Function Configuration
 * - HW_ENET_RMON_T_PACKETS - Tx Packet Count Statistic Register
 * - HW_ENET_RMON_T_BC_PKT - Tx Broadcast Packets Statistic Register
 * - HW_ENET_RMON_T_MC_PKT - Tx Multicast Packets Statistic Register
 * - HW_ENET_RMON_T_CRC_ALIGN - Tx Packets with CRC/Align Error Statistic Register
 * - HW_ENET_RMON_T_UNDERSIZE - Tx Packets Less Than Bytes and Good CRC Statistic Register
 * - HW_ENET_RMON_T_OVERSIZE - Tx Packets GT MAX_FL bytes and Good CRC Statistic Register
 * - HW_ENET_RMON_T_FRAG - Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register
 * - HW_ENET_RMON_T_JAB - Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register
 * - HW_ENET_RMON_T_COL - Tx Collision Count Statistic Register
 * - HW_ENET_RMON_T_P64 - Tx 64-Byte Packets Statistic Register
 * - HW_ENET_RMON_T_P65TO127 - Tx 65- to 127-byte Packets Statistic Register
 * - HW_ENET_RMON_T_P128TO255 - Tx 128- to 255-byte Packets Statistic Register
 * - HW_ENET_RMON_T_P256TO511 - Tx 256- to 511-byte Packets Statistic Register
 * - HW_ENET_RMON_T_P512TO1023 - Tx 512- to 1023-byte Packets Statistic Register
 * - HW_ENET_RMON_T_P1024TO2047 - Tx 1024- to 2047-byte Packets Statistic Register
 * - HW_ENET_RMON_T_P_GTE2048 - Tx Packets Greater Than 2048 Bytes Statistic Register
 * - HW_ENET_RMON_T_OCTETS - Tx Octets Statistic Register
 * - HW_ENET_IEEE_T_FRAME_OK - Frames Transmitted OK Statistic Register
 * - HW_ENET_IEEE_T_1COL - Frames Transmitted with Single Collision Statistic Register
 * - HW_ENET_IEEE_T_MCOL - Frames Transmitted with Multiple Collisions Statistic Register
 * - HW_ENET_IEEE_T_DEF - Frames Transmitted after Deferral Delay Statistic Register
 * - HW_ENET_IEEE_T_LCOL - Frames Transmitted with Late Collision Statistic Register
 * - HW_ENET_IEEE_T_EXCOL - Frames Transmitted with Excessive Collisions Statistic Register
 * - HW_ENET_IEEE_T_MACERR - Frames Transmitted with Tx FIFO Underrun Statistic Register
 * - HW_ENET_IEEE_T_CSERR - Frames Transmitted with Carrier Sense Error Statistic Register
 * - HW_ENET_IEEE_T_FDXFC - Flow Control Pause Frames Transmitted Statistic Register
 * - HW_ENET_IEEE_T_OCTETS_OK - Octet Count for Frames Transmitted w/o Error Statistic Register
 * - HW_ENET_RMON_R_PACKETS - Rx Packet Count Statistic Register
 * - HW_ENET_RMON_R_BC_PKT - Rx Broadcast Packets Statistic Register
 * - HW_ENET_RMON_R_MC_PKT - Rx Multicast Packets Statistic Register
 * - HW_ENET_RMON_R_CRC_ALIGN - Rx Packets with CRC/Align Error Statistic Register
 * - HW_ENET_RMON_R_UNDERSIZE - Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register
 * - HW_ENET_RMON_R_OVERSIZE - Rx Packets Greater Than MAX_FL and Good CRC Statistic Register
 * - HW_ENET_RMON_R_FRAG - Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register
 * - HW_ENET_RMON_R_JAB - Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register
 * - HW_ENET_RMON_R_P64 - Rx 64-Byte Packets Statistic Register
 * - HW_ENET_RMON_R_P65TO127 - Rx 65- to 127-Byte Packets Statistic Register
 * - HW_ENET_RMON_R_P128TO255 - Rx 128- to 255-Byte Packets Statistic Register
 * - HW_ENET_RMON_R_P256TO511 - Rx 256- to 511-Byte Packets Statistic Register
 * - HW_ENET_RMON_R_P512TO1023 - Rx 512- to 1023-Byte Packets Statistic Register
 * - HW_ENET_RMON_R_P1024TO2047 - Rx 1024- to 2047-Byte Packets Statistic Register
 * - HW_ENET_RMON_R_GTE2048 - Rx Packets Greater than 2048 Bytes Statistic Register
 * - HW_ENET_RMON_R_OCTETS - Rx Octets Statistic Register
 * - HW_ENET_IEEE_R_DROP - Frames not Counted Correctly Statistic Register
 * - HW_ENET_IEEE_R_FRAME_OK - Frames Received OK Statistic Register
 * - HW_ENET_IEEE_R_CRC - Frames Received with CRC Error Statistic Register
 * - HW_ENET_IEEE_R_ALIGN - Frames Received with Alignment Error Statistic Register
 * - HW_ENET_IEEE_R_MACERR - Receive FIFO Overflow Count Statistic Register
 * - HW_ENET_IEEE_R_FDXFC - Flow Control Pause Frames Received Statistic Register
 * - HW_ENET_IEEE_R_OCTETS_OK - Octet Count for Frames Received without Error Statistic Register
 * - HW_ENET_ATCR - Adjustable Timer Control Register
 * - HW_ENET_ATVR - Timer Value Register
 * - HW_ENET_ATOFF - Timer Offset Register
 * - HW_ENET_ATPER - Timer Period Register
 * - HW_ENET_ATCOR - Timer Correction Register
 * - HW_ENET_ATINC - Time-Stamping Clock Period Register
 * - HW_ENET_ATSTMP - Timestamp of Last Transmitted Frame
 * - HW_ENET_TGSR - Timer Global Status Register
 * - HW_ENET_TCSRn - Timer Control Status Register
 * - HW_ENET_TCCRn - Timer Compare Capture Register
 *
 * - hw_enet_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_ENET_BASE
#define HW_ENET_INSTANCE_COUNT (1U) //!< Number of instances of the ENET module.
#define HW_ENET0 (0U) //!< Instance number for ENET.
#define REGS_ENET0_BASE (0x400C0000U) //!< Base address for ENET.

//! @brief Table of base addresses for ENET instances.
static const uint32_t __g_regs_ENET_base_addresses[] = {
        REGS_ENET0_BASE,
    };

//! @brief Get the base address of ENET by instance number.
//! @param x ENET instance number, from 0 through 0.
#define REGS_ENET_BASE(x) (__g_regs_ENET_base_addresses[(x)])

//! @brief Get the instance number given a base address.
//! @param b Base address for an instance of ENET.
#define REGS_ENET_INSTANCE(b) ((b) == REGS_ENET0_BASE ? HW_ENET0 : 0)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_EIR - Interrupt Event Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_EIR - Interrupt Event Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * When an event occurs that sets a bit in EIR, an interrupt occurs if the
 * corresponding bit in the interrupt mask register (EIMR) is also set. Writing a 1 to
 * an EIR bit clears it; writing 0 has no effect. This register is cleared upon
 * hardware reset. TxBD[INT] and RxBD[INT] must be set to 1 to allow setting the
 * corresponding EIR register flags in enhanced mode, ENET_ECR[EN1588] = 1.
 * Legacy mode does not require these flags to be enabled.
 */
typedef union _hw_enet_eir
{
    uint32_t U;
    struct _hw_enet_eir_bitfields
    {
        uint32_t RESERVED0 : 15;       //!< [14:0]
        uint32_t TS_TIMER : 1;         //!< [15] Timestamp Timer
        uint32_t TS_AVAIL : 1;         //!< [16] Transmit Timestamp Available
        uint32_t WAKEUP : 1;           //!< [17] Node Wakeup Request Indication
        uint32_t PLR : 1;              //!< [18] Payload Receive Error
        uint32_t UN : 1;               //!< [19] Transmit FIFO Underrun
        uint32_t RL : 1;               //!< [20] Collision Retry Limit
        uint32_t LC : 1;               //!< [21] Late Collision
        uint32_t EBERR : 1;            //!< [22] Ethernet Bus Error
        uint32_t MII : 1;              //!< [23] MII Interrupt.
        uint32_t RXB : 1;              //!< [24] Receive Buffer Interrupt
        uint32_t RXF : 1;              //!< [25] Receive Frame Interrupt
        uint32_t TXB : 1;              //!< [26] Transmit Buffer Interrupt
        uint32_t TXF : 1;              //!< [27] Transmit Frame Interrupt
        uint32_t GRA : 1;              //!< [28] Graceful Stop Complete
        uint32_t BABT : 1;             //!< [29] Babbling Transmit Error
        uint32_t BABR : 1;             //!< [30] Babbling Receive Error
        uint32_t RESERVED1 : 1;        //!< [31]
    } B;
} hw_enet_eir_t;
#endif

/*!
 * @name Constants and macros for entire ENET_EIR register
 */
//@{
#define HW_ENET_EIR_ADDR(x)      (REGS_ENET_BASE(x) + 0x4U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_EIR(x)           (*(__IO hw_enet_eir_t *) HW_ENET_EIR_ADDR(x))
#define HW_ENET_EIR_RD(x)        (HW_ENET_EIR(x).U)
#define HW_ENET_EIR_WR(x, v)     (HW_ENET_EIR(x).U = (v))
#define HW_ENET_EIR_SET(x, v)    (HW_ENET_EIR_WR(x, HW_ENET_EIR_RD(x) |  (v)))
#define HW_ENET_EIR_CLR(x, v)    (HW_ENET_EIR_WR(x, HW_ENET_EIR_RD(x) & ~(v)))
#define HW_ENET_EIR_TOG(x, v)    (HW_ENET_EIR_WR(x, HW_ENET_EIR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_EIR bitfields
 */

/*!
 * @name Register ENET_EIR, field TS_TIMER[15] (W1C)
 *
 * The adjustable timer reached the period event. A period event interrupt can
 * be generated if ATCR[PEREN] is set and the timer wraps according to the
 * periodic setting in the ATPER register. Set the timer period value before setting
 * ATCR[PEREN].
 */
//@{
#define BP_ENET_EIR_TS_TIMER (15U)         //!< Bit position for ENET_EIR_TS_TIMER.
#define BM_ENET_EIR_TS_TIMER (0x00008000U) //!< Bit mask for ENET_EIR_TS_TIMER.
#define BS_ENET_EIR_TS_TIMER (1U)          //!< Bit field size in bits for ENET_EIR_TS_TIMER.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_TS_TIMER field.
#define BR_ENET_EIR_TS_TIMER(x) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_TS_TIMER))
#endif

//! @brief Format value for bitfield ENET_EIR_TS_TIMER.
#define BF_ENET_EIR_TS_TIMER(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_TS_TIMER), uint32_t) & BM_ENET_EIR_TS_TIMER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TS_TIMER field to a new value.
#define BW_ENET_EIR_TS_TIMER(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_TS_TIMER) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field TS_AVAIL[16] (W1C)
 *
 * Indicates that the timestamp of the last transmitted timing frame is
 * available in the ATSTMP register.
 */
//@{
#define BP_ENET_EIR_TS_AVAIL (16U)         //!< Bit position for ENET_EIR_TS_AVAIL.
#define BM_ENET_EIR_TS_AVAIL (0x00010000U) //!< Bit mask for ENET_EIR_TS_AVAIL.
#define BS_ENET_EIR_TS_AVAIL (1U)          //!< Bit field size in bits for ENET_EIR_TS_AVAIL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_TS_AVAIL field.
#define BR_ENET_EIR_TS_AVAIL(x) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_TS_AVAIL))
#endif

//! @brief Format value for bitfield ENET_EIR_TS_AVAIL.
#define BF_ENET_EIR_TS_AVAIL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_TS_AVAIL), uint32_t) & BM_ENET_EIR_TS_AVAIL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TS_AVAIL field to a new value.
#define BW_ENET_EIR_TS_AVAIL(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_TS_AVAIL) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field WAKEUP[17] (W1C)
 *
 * Read-only status bit to indicate that a magic packet has been detected. Will
 * act only if ECR[MAGICEN] is set.
 */
//@{
#define BP_ENET_EIR_WAKEUP   (17U)         //!< Bit position for ENET_EIR_WAKEUP.
#define BM_ENET_EIR_WAKEUP   (0x00020000U) //!< Bit mask for ENET_EIR_WAKEUP.
#define BS_ENET_EIR_WAKEUP   (1U)          //!< Bit field size in bits for ENET_EIR_WAKEUP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_WAKEUP field.
#define BR_ENET_EIR_WAKEUP(x) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_WAKEUP))
#endif

//! @brief Format value for bitfield ENET_EIR_WAKEUP.
#define BF_ENET_EIR_WAKEUP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_WAKEUP), uint32_t) & BM_ENET_EIR_WAKEUP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WAKEUP field to a new value.
#define BW_ENET_EIR_WAKEUP(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_WAKEUP) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field PLR[18] (W1C)
 *
 * Indicates a frame was received with a payload length error. See Frame
 * Length/Type Verification: Payload Length Check for more information.
 */
//@{
#define BP_ENET_EIR_PLR      (18U)         //!< Bit position for ENET_EIR_PLR.
#define BM_ENET_EIR_PLR      (0x00040000U) //!< Bit mask for ENET_EIR_PLR.
#define BS_ENET_EIR_PLR      (1U)          //!< Bit field size in bits for ENET_EIR_PLR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_PLR field.
#define BR_ENET_EIR_PLR(x)   (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_PLR))
#endif

//! @brief Format value for bitfield ENET_EIR_PLR.
#define BF_ENET_EIR_PLR(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_PLR), uint32_t) & BM_ENET_EIR_PLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PLR field to a new value.
#define BW_ENET_EIR_PLR(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_PLR) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field UN[19] (W1C)
 *
 * Indicates the transmit FIFO became empty before the complete frame was
 * transmitted. A bad CRC is appended to the frame fragment and the remainder of the
 * frame is discarded.
 */
//@{
#define BP_ENET_EIR_UN       (19U)         //!< Bit position for ENET_EIR_UN.
#define BM_ENET_EIR_UN       (0x00080000U) //!< Bit mask for ENET_EIR_UN.
#define BS_ENET_EIR_UN       (1U)          //!< Bit field size in bits for ENET_EIR_UN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_UN field.
#define BR_ENET_EIR_UN(x)    (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_UN))
#endif

//! @brief Format value for bitfield ENET_EIR_UN.
#define BF_ENET_EIR_UN(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_UN), uint32_t) & BM_ENET_EIR_UN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UN field to a new value.
#define BW_ENET_EIR_UN(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_UN) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field RL[20] (W1C)
 *
 * Indicates a collision occurred on each of 16 successive attempts to transmit
 * the frame. The frame is discarded without being transmitted and transmission
 * of the next frame commences. This error can only occur in half-duplex mode.
 */
//@{
#define BP_ENET_EIR_RL       (20U)         //!< Bit position for ENET_EIR_RL.
#define BM_ENET_EIR_RL       (0x00100000U) //!< Bit mask for ENET_EIR_RL.
#define BS_ENET_EIR_RL       (1U)          //!< Bit field size in bits for ENET_EIR_RL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_RL field.
#define BR_ENET_EIR_RL(x)    (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_RL))
#endif

//! @brief Format value for bitfield ENET_EIR_RL.
#define BF_ENET_EIR_RL(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_RL), uint32_t) & BM_ENET_EIR_RL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RL field to a new value.
#define BW_ENET_EIR_RL(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_RL) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field LC[21] (W1C)
 *
 * Indicates a collision occurred beyond the collision window (slot time) in
 * half-duplex mode. The frame truncates with a bad CRC and the remainder of the
 * frame is discarded.
 */
//@{
#define BP_ENET_EIR_LC       (21U)         //!< Bit position for ENET_EIR_LC.
#define BM_ENET_EIR_LC       (0x00200000U) //!< Bit mask for ENET_EIR_LC.
#define BS_ENET_EIR_LC       (1U)          //!< Bit field size in bits for ENET_EIR_LC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_LC field.
#define BR_ENET_EIR_LC(x)    (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_LC))
#endif

//! @brief Format value for bitfield ENET_EIR_LC.
#define BF_ENET_EIR_LC(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_LC), uint32_t) & BM_ENET_EIR_LC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LC field to a new value.
#define BW_ENET_EIR_LC(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_LC) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field EBERR[22] (W1C)
 *
 * Indicates a system bus error occurred when a uDMA transaction is underway.
 * When this bit is set, ECR[ETHEREN] is cleared, halting frame processing by the
 * MAC. When this occurs, software must ensure proper actions, possibly resetting
 * the system, to resume normal operation.
 */
//@{
#define BP_ENET_EIR_EBERR    (22U)         //!< Bit position for ENET_EIR_EBERR.
#define BM_ENET_EIR_EBERR    (0x00400000U) //!< Bit mask for ENET_EIR_EBERR.
#define BS_ENET_EIR_EBERR    (1U)          //!< Bit field size in bits for ENET_EIR_EBERR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_EBERR field.
#define BR_ENET_EIR_EBERR(x) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_EBERR))
#endif

//! @brief Format value for bitfield ENET_EIR_EBERR.
#define BF_ENET_EIR_EBERR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_EBERR), uint32_t) & BM_ENET_EIR_EBERR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EBERR field to a new value.
#define BW_ENET_EIR_EBERR(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_EBERR) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field MII[23] (W1C)
 *
 * Indicates that the MII has completed the data transfer requested.
 */
//@{
#define BP_ENET_EIR_MII      (23U)         //!< Bit position for ENET_EIR_MII.
#define BM_ENET_EIR_MII      (0x00800000U) //!< Bit mask for ENET_EIR_MII.
#define BS_ENET_EIR_MII      (1U)          //!< Bit field size in bits for ENET_EIR_MII.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_MII field.
#define BR_ENET_EIR_MII(x)   (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_MII))
#endif

//! @brief Format value for bitfield ENET_EIR_MII.
#define BF_ENET_EIR_MII(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_MII), uint32_t) & BM_ENET_EIR_MII)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MII field to a new value.
#define BW_ENET_EIR_MII(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_MII) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field RXB[24] (W1C)
 *
 * Indicates a receive buffer descriptor is not the last in the frame has been
 * updated.
 */
//@{
#define BP_ENET_EIR_RXB      (24U)         //!< Bit position for ENET_EIR_RXB.
#define BM_ENET_EIR_RXB      (0x01000000U) //!< Bit mask for ENET_EIR_RXB.
#define BS_ENET_EIR_RXB      (1U)          //!< Bit field size in bits for ENET_EIR_RXB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_RXB field.
#define BR_ENET_EIR_RXB(x)   (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_RXB))
#endif

//! @brief Format value for bitfield ENET_EIR_RXB.
#define BF_ENET_EIR_RXB(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_RXB), uint32_t) & BM_ENET_EIR_RXB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RXB field to a new value.
#define BW_ENET_EIR_RXB(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_RXB) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field RXF[25] (W1C)
 *
 * Indicates a frame has been received and the last corresponding buffer
 * descriptor has been updated.
 */
//@{
#define BP_ENET_EIR_RXF      (25U)         //!< Bit position for ENET_EIR_RXF.
#define BM_ENET_EIR_RXF      (0x02000000U) //!< Bit mask for ENET_EIR_RXF.
#define BS_ENET_EIR_RXF      (1U)          //!< Bit field size in bits for ENET_EIR_RXF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_RXF field.
#define BR_ENET_EIR_RXF(x)   (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_RXF))
#endif

//! @brief Format value for bitfield ENET_EIR_RXF.
#define BF_ENET_EIR_RXF(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_RXF), uint32_t) & BM_ENET_EIR_RXF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RXF field to a new value.
#define BW_ENET_EIR_RXF(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_RXF) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field TXB[26] (W1C)
 *
 * Indicates a transmit buffer descriptor has been updated.
 */
//@{
#define BP_ENET_EIR_TXB      (26U)         //!< Bit position for ENET_EIR_TXB.
#define BM_ENET_EIR_TXB      (0x04000000U) //!< Bit mask for ENET_EIR_TXB.
#define BS_ENET_EIR_TXB      (1U)          //!< Bit field size in bits for ENET_EIR_TXB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_TXB field.
#define BR_ENET_EIR_TXB(x)   (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_TXB))
#endif

//! @brief Format value for bitfield ENET_EIR_TXB.
#define BF_ENET_EIR_TXB(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_TXB), uint32_t) & BM_ENET_EIR_TXB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TXB field to a new value.
#define BW_ENET_EIR_TXB(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_TXB) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field TXF[27] (W1C)
 *
 * Indicates a frame has been transmitted and the last corresponding buffer
 * descriptor has been updated.
 */
//@{
#define BP_ENET_EIR_TXF      (27U)         //!< Bit position for ENET_EIR_TXF.
#define BM_ENET_EIR_TXF      (0x08000000U) //!< Bit mask for ENET_EIR_TXF.
#define BS_ENET_EIR_TXF      (1U)          //!< Bit field size in bits for ENET_EIR_TXF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_TXF field.
#define BR_ENET_EIR_TXF(x)   (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_TXF))
#endif

//! @brief Format value for bitfield ENET_EIR_TXF.
#define BF_ENET_EIR_TXF(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_TXF), uint32_t) & BM_ENET_EIR_TXF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TXF field to a new value.
#define BW_ENET_EIR_TXF(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_TXF) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field GRA[28] (W1C)
 *
 * This interrupt is asserted after the transmitter is put into a pause state
 * after completion of the frame currently being transmitted. See Graceful Transmit
 * Stop (GTS) for conditions that lead to graceful stop. The GRA interrupt is
 * asserted only when the TX transitions into the stopped state. If this bit is
 * cleared by writing 1 and the TX is still stopped, the bit is not set again.
 */
//@{
#define BP_ENET_EIR_GRA      (28U)         //!< Bit position for ENET_EIR_GRA.
#define BM_ENET_EIR_GRA      (0x10000000U) //!< Bit mask for ENET_EIR_GRA.
#define BS_ENET_EIR_GRA      (1U)          //!< Bit field size in bits for ENET_EIR_GRA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_GRA field.
#define BR_ENET_EIR_GRA(x)   (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_GRA))
#endif

//! @brief Format value for bitfield ENET_EIR_GRA.
#define BF_ENET_EIR_GRA(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_GRA), uint32_t) & BM_ENET_EIR_GRA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GRA field to a new value.
#define BW_ENET_EIR_GRA(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_GRA) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field BABT[29] (W1C)
 *
 * Indicates the transmitted frame length exceeds RCR[MAX_FL] bytes. Usually
 * this condition is caused when a frame that is too long is placed into the
 * transmit data buffer(s). Truncation does not occur.
 */
//@{
#define BP_ENET_EIR_BABT     (29U)         //!< Bit position for ENET_EIR_BABT.
#define BM_ENET_EIR_BABT     (0x20000000U) //!< Bit mask for ENET_EIR_BABT.
#define BS_ENET_EIR_BABT     (1U)          //!< Bit field size in bits for ENET_EIR_BABT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_BABT field.
#define BR_ENET_EIR_BABT(x)  (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_BABT))
#endif

//! @brief Format value for bitfield ENET_EIR_BABT.
#define BF_ENET_EIR_BABT(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_BABT), uint32_t) & BM_ENET_EIR_BABT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BABT field to a new value.
#define BW_ENET_EIR_BABT(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_BABT) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIR, field BABR[30] (W1C)
 *
 * Indicates a frame was received with length in excess of RCR[MAX_FL] bytes.
 */
//@{
#define BP_ENET_EIR_BABR     (30U)         //!< Bit position for ENET_EIR_BABR.
#define BM_ENET_EIR_BABR     (0x40000000U) //!< Bit mask for ENET_EIR_BABR.
#define BS_ENET_EIR_BABR     (1U)          //!< Bit field size in bits for ENET_EIR_BABR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIR_BABR field.
#define BR_ENET_EIR_BABR(x)  (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_BABR))
#endif

//! @brief Format value for bitfield ENET_EIR_BABR.
#define BF_ENET_EIR_BABR(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIR_BABR), uint32_t) & BM_ENET_EIR_BABR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BABR field to a new value.
#define BW_ENET_EIR_BABR(x, v) (BITBAND_ACCESS32(HW_ENET_EIR_ADDR(x), BP_ENET_EIR_BABR) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_EIMR - Interrupt Mask Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_EIMR - Interrupt Mask Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * EIMR controls which interrupt events are allowed to generate actual
 * interrupts. A hardware reset clears this register. If the corresponding bits in the EIR
 * and EIMR registers are set, an interrupt is generated. The interrupt signal
 * remains asserted until a 1 is written to the EIR field (write 1 to clear) or a
 * 0 is written to the EIMR field.
 */
typedef union _hw_enet_eimr
{
    uint32_t U;
    struct _hw_enet_eimr_bitfields
    {
        uint32_t RESERVED0 : 15;       //!< [14:0]
        uint32_t TS_TIMER : 1;         //!< [15] TS_TIMER Interrupt Mask
        uint32_t TS_AVAIL : 1;         //!< [16] TS_AVAIL Interrupt Mask
        uint32_t WAKEUP : 1;           //!< [17] WAKEUP Interrupt Mask
        uint32_t PLR : 1;              //!< [18] PLR Interrupt Mask
        uint32_t UN : 1;               //!< [19] UN Interrupt Mask
        uint32_t RL : 1;               //!< [20] RL Interrupt Mask
        uint32_t LC : 1;               //!< [21] LC Interrupt Mask
        uint32_t EBERR : 1;            //!< [22] EBERR Interrupt Mask
        uint32_t MII : 1;              //!< [23] MII Interrupt Mask
        uint32_t RXB : 1;              //!< [24] RXB Interrupt Mask
        uint32_t RXF : 1;              //!< [25] RXF Interrupt Mask
        uint32_t TXB : 1;              //!< [26] TXB Interrupt Mask
        uint32_t TXF : 1;              //!< [27] TXF Interrupt Mask
        uint32_t GRA : 1;              //!< [28] GRA Interrupt Mask
        uint32_t BABT : 1;             //!< [29] BABT Interrupt Mask
        uint32_t BABR : 1;             //!< [30] BABR Interrupt Mask
        uint32_t RESERVED1 : 1;        //!< [31]
    } B;
} hw_enet_eimr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_EIMR register
 */
//@{
#define HW_ENET_EIMR_ADDR(x)     (REGS_ENET_BASE(x) + 0x8U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_EIMR(x)          (*(__IO hw_enet_eimr_t *) HW_ENET_EIMR_ADDR(x))
#define HW_ENET_EIMR_RD(x)       (HW_ENET_EIMR(x).U)
#define HW_ENET_EIMR_WR(x, v)    (HW_ENET_EIMR(x).U = (v))
#define HW_ENET_EIMR_SET(x, v)   (HW_ENET_EIMR_WR(x, HW_ENET_EIMR_RD(x) |  (v)))
#define HW_ENET_EIMR_CLR(x, v)   (HW_ENET_EIMR_WR(x, HW_ENET_EIMR_RD(x) & ~(v)))
#define HW_ENET_EIMR_TOG(x, v)   (HW_ENET_EIMR_WR(x, HW_ENET_EIMR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_EIMR bitfields
 */

/*!
 * @name Register ENET_EIMR, field TS_TIMER[15] (RW)
 *
 * Corresponds to interrupt source EIR[TS_TIMER] register and determines whether
 * an interrupt condition can generate an interrupt. At every module clock, the
 * EIR samples the signal generated by the interrupting source. The corresponding
 * EIR TS_TIMER field reflects the state of the interrupt signal even if the
 * corresponding EIMR field is cleared.
 */
//@{
#define BP_ENET_EIMR_TS_TIMER (15U)        //!< Bit position for ENET_EIMR_TS_TIMER.
#define BM_ENET_EIMR_TS_TIMER (0x00008000U) //!< Bit mask for ENET_EIMR_TS_TIMER.
#define BS_ENET_EIMR_TS_TIMER (1U)         //!< Bit field size in bits for ENET_EIMR_TS_TIMER.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_TS_TIMER field.
#define BR_ENET_EIMR_TS_TIMER(x) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_TS_TIMER))
#endif

//! @brief Format value for bitfield ENET_EIMR_TS_TIMER.
#define BF_ENET_EIMR_TS_TIMER(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_TS_TIMER), uint32_t) & BM_ENET_EIMR_TS_TIMER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TS_TIMER field to a new value.
#define BW_ENET_EIMR_TS_TIMER(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_TS_TIMER) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field TS_AVAIL[16] (RW)
 *
 * Corresponds to interrupt source EIR[TS_AVAIL] register and determines whether
 * an interrupt condition can generate an interrupt. At every module clock, the
 * EIR samples the signal generated by the interrupting source. The corresponding
 * EIR TS_AVAIL field reflects the state of the interrupt signal even if the
 * corresponding EIMR field is cleared.
 */
//@{
#define BP_ENET_EIMR_TS_AVAIL (16U)        //!< Bit position for ENET_EIMR_TS_AVAIL.
#define BM_ENET_EIMR_TS_AVAIL (0x00010000U) //!< Bit mask for ENET_EIMR_TS_AVAIL.
#define BS_ENET_EIMR_TS_AVAIL (1U)         //!< Bit field size in bits for ENET_EIMR_TS_AVAIL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_TS_AVAIL field.
#define BR_ENET_EIMR_TS_AVAIL(x) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_TS_AVAIL))
#endif

//! @brief Format value for bitfield ENET_EIMR_TS_AVAIL.
#define BF_ENET_EIMR_TS_AVAIL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_TS_AVAIL), uint32_t) & BM_ENET_EIMR_TS_AVAIL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TS_AVAIL field to a new value.
#define BW_ENET_EIMR_TS_AVAIL(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_TS_AVAIL) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field WAKEUP[17] (RW)
 *
 * Corresponds to interrupt source EIR[WAKEUP] register and determines whether
 * an interrupt condition can generate an interrupt. At every module clock, the
 * EIR samples the signal generated by the interrupting source. The corresponding
 * EIR WAKEUP field reflects the state of the interrupt signal even if the
 * corresponding EIMR field is cleared.
 */
//@{
#define BP_ENET_EIMR_WAKEUP  (17U)         //!< Bit position for ENET_EIMR_WAKEUP.
#define BM_ENET_EIMR_WAKEUP  (0x00020000U) //!< Bit mask for ENET_EIMR_WAKEUP.
#define BS_ENET_EIMR_WAKEUP  (1U)          //!< Bit field size in bits for ENET_EIMR_WAKEUP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_WAKEUP field.
#define BR_ENET_EIMR_WAKEUP(x) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_WAKEUP))
#endif

//! @brief Format value for bitfield ENET_EIMR_WAKEUP.
#define BF_ENET_EIMR_WAKEUP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_WAKEUP), uint32_t) & BM_ENET_EIMR_WAKEUP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WAKEUP field to a new value.
#define BW_ENET_EIMR_WAKEUP(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_WAKEUP) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field PLR[18] (RW)
 *
 * Corresponds to interrupt source EIR[PLR] and determines whether an interrupt
 * condition can generate an interrupt. At every module clock, the EIR samples
 * the signal generated by the interrupting source. The corresponding EIR PLR field
 * reflects the state of the interrupt signal even if the corresponding EIMR
 * field is cleared.
 */
//@{
#define BP_ENET_EIMR_PLR     (18U)         //!< Bit position for ENET_EIMR_PLR.
#define BM_ENET_EIMR_PLR     (0x00040000U) //!< Bit mask for ENET_EIMR_PLR.
#define BS_ENET_EIMR_PLR     (1U)          //!< Bit field size in bits for ENET_EIMR_PLR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_PLR field.
#define BR_ENET_EIMR_PLR(x)  (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_PLR))
#endif

//! @brief Format value for bitfield ENET_EIMR_PLR.
#define BF_ENET_EIMR_PLR(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_PLR), uint32_t) & BM_ENET_EIMR_PLR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PLR field to a new value.
#define BW_ENET_EIMR_PLR(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_PLR) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field UN[19] (RW)
 *
 * Corresponds to interrupt source EIR[UN] and determines whether an interrupt
 * condition can generate an interrupt. At every module clock, the EIR samples the
 * signal generated by the interrupting source. The corresponding EIR UN field
 * reflects the state of the interrupt signal even if the corresponding EIMR field
 * is cleared.
 */
//@{
#define BP_ENET_EIMR_UN      (19U)         //!< Bit position for ENET_EIMR_UN.
#define BM_ENET_EIMR_UN      (0x00080000U) //!< Bit mask for ENET_EIMR_UN.
#define BS_ENET_EIMR_UN      (1U)          //!< Bit field size in bits for ENET_EIMR_UN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_UN field.
#define BR_ENET_EIMR_UN(x)   (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_UN))
#endif

//! @brief Format value for bitfield ENET_EIMR_UN.
#define BF_ENET_EIMR_UN(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_UN), uint32_t) & BM_ENET_EIMR_UN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UN field to a new value.
#define BW_ENET_EIMR_UN(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_UN) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field RL[20] (RW)
 *
 * Corresponds to interrupt source EIR[RL] and determines whether an interrupt
 * condition can generate an interrupt. At every module clock, the EIR samples the
 * signal generated by the interrupting source. The corresponding EIR RL field
 * reflects the state of the interrupt signal even if the corresponding EIMR field
 * is cleared.
 */
//@{
#define BP_ENET_EIMR_RL      (20U)         //!< Bit position for ENET_EIMR_RL.
#define BM_ENET_EIMR_RL      (0x00100000U) //!< Bit mask for ENET_EIMR_RL.
#define BS_ENET_EIMR_RL      (1U)          //!< Bit field size in bits for ENET_EIMR_RL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_RL field.
#define BR_ENET_EIMR_RL(x)   (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_RL))
#endif

//! @brief Format value for bitfield ENET_EIMR_RL.
#define BF_ENET_EIMR_RL(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_RL), uint32_t) & BM_ENET_EIMR_RL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RL field to a new value.
#define BW_ENET_EIMR_RL(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_RL) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field LC[21] (RW)
 *
 * Corresponds to interrupt source EIR[LC] and determines whether an interrupt
 * condition can generate an interrupt. At every module clock, the EIR samples the
 * signal generated by the interrupting source. The corresponding EIR LC field
 * reflects the state of the interrupt signal even if the corresponding EIMR field
 * is cleared.
 */
//@{
#define BP_ENET_EIMR_LC      (21U)         //!< Bit position for ENET_EIMR_LC.
#define BM_ENET_EIMR_LC      (0x00200000U) //!< Bit mask for ENET_EIMR_LC.
#define BS_ENET_EIMR_LC      (1U)          //!< Bit field size in bits for ENET_EIMR_LC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_LC field.
#define BR_ENET_EIMR_LC(x)   (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_LC))
#endif

//! @brief Format value for bitfield ENET_EIMR_LC.
#define BF_ENET_EIMR_LC(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_LC), uint32_t) & BM_ENET_EIMR_LC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LC field to a new value.
#define BW_ENET_EIMR_LC(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_LC) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field EBERR[22] (RW)
 *
 * Corresponds to interrupt source EIR[EBERR] and determines whether an
 * interrupt condition can generate an interrupt. At every module clock, the EIR samples
 * the signal generated by the interrupting source. The corresponding EIR EBERR
 * field reflects the state of the interrupt signal even if the corresponding EIMR
 * field is cleared.
 */
//@{
#define BP_ENET_EIMR_EBERR   (22U)         //!< Bit position for ENET_EIMR_EBERR.
#define BM_ENET_EIMR_EBERR   (0x00400000U) //!< Bit mask for ENET_EIMR_EBERR.
#define BS_ENET_EIMR_EBERR   (1U)          //!< Bit field size in bits for ENET_EIMR_EBERR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_EBERR field.
#define BR_ENET_EIMR_EBERR(x) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_EBERR))
#endif

//! @brief Format value for bitfield ENET_EIMR_EBERR.
#define BF_ENET_EIMR_EBERR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_EBERR), uint32_t) & BM_ENET_EIMR_EBERR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EBERR field to a new value.
#define BW_ENET_EIMR_EBERR(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_EBERR) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field MII[23] (RW)
 *
 * Corresponds to interrupt source EIR[MII] and determines whether an interrupt
 * condition can generate an interrupt. At every module clock, the EIR samples
 * the signal generated by the interrupting source. The corresponding EIR MII field
 * reflects the state of the interrupt signal even if the corresponding EIMR
 * field is cleared.
 */
//@{
#define BP_ENET_EIMR_MII     (23U)         //!< Bit position for ENET_EIMR_MII.
#define BM_ENET_EIMR_MII     (0x00800000U) //!< Bit mask for ENET_EIMR_MII.
#define BS_ENET_EIMR_MII     (1U)          //!< Bit field size in bits for ENET_EIMR_MII.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_MII field.
#define BR_ENET_EIMR_MII(x)  (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_MII))
#endif

//! @brief Format value for bitfield ENET_EIMR_MII.
#define BF_ENET_EIMR_MII(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_MII), uint32_t) & BM_ENET_EIMR_MII)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MII field to a new value.
#define BW_ENET_EIMR_MII(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_MII) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field RXB[24] (RW)
 *
 * Corresponds to interrupt source EIR[RXB] and determines whether an interrupt
 * condition can generate an interrupt. At every module clock, the EIR samples
 * the signal generated by the interrupting source. The corresponding EIR RXB field
 * reflects the state of the interrupt signal even if the corresponding EIMR
 * field is cleared.
 */
//@{
#define BP_ENET_EIMR_RXB     (24U)         //!< Bit position for ENET_EIMR_RXB.
#define BM_ENET_EIMR_RXB     (0x01000000U) //!< Bit mask for ENET_EIMR_RXB.
#define BS_ENET_EIMR_RXB     (1U)          //!< Bit field size in bits for ENET_EIMR_RXB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_RXB field.
#define BR_ENET_EIMR_RXB(x)  (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_RXB))
#endif

//! @brief Format value for bitfield ENET_EIMR_RXB.
#define BF_ENET_EIMR_RXB(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_RXB), uint32_t) & BM_ENET_EIMR_RXB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RXB field to a new value.
#define BW_ENET_EIMR_RXB(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_RXB) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field RXF[25] (RW)
 *
 * Corresponds to interrupt source EIR[RXF] and determines whether an interrupt
 * condition can generate an interrupt. At every module clock, the EIR samples
 * the signal generated by the interrupting source. The corresponding EIR RXF field
 * reflects the state of the interrupt signal even if the corresponding EIMR
 * field is cleared.
 */
//@{
#define BP_ENET_EIMR_RXF     (25U)         //!< Bit position for ENET_EIMR_RXF.
#define BM_ENET_EIMR_RXF     (0x02000000U) //!< Bit mask for ENET_EIMR_RXF.
#define BS_ENET_EIMR_RXF     (1U)          //!< Bit field size in bits for ENET_EIMR_RXF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_RXF field.
#define BR_ENET_EIMR_RXF(x)  (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_RXF))
#endif

//! @brief Format value for bitfield ENET_EIMR_RXF.
#define BF_ENET_EIMR_RXF(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_RXF), uint32_t) & BM_ENET_EIMR_RXF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RXF field to a new value.
#define BW_ENET_EIMR_RXF(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_RXF) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field TXB[26] (RW)
 *
 * Corresponds to interrupt source EIR[TXB] and determines whether an interrupt
 * condition can generate an interrupt. At every module clock, the EIR samples
 * the signal generated by the interrupting source. The corresponding EIR TXF field
 * reflects the state of the interrupt signal even if the corresponding EIMR
 * field is cleared.
 *
 * Values:
 * - 0 - The corresponding interrupt source is masked.
 * - 1 - The corresponding interrupt source is not masked.
 */
//@{
#define BP_ENET_EIMR_TXB     (26U)         //!< Bit position for ENET_EIMR_TXB.
#define BM_ENET_EIMR_TXB     (0x04000000U) //!< Bit mask for ENET_EIMR_TXB.
#define BS_ENET_EIMR_TXB     (1U)          //!< Bit field size in bits for ENET_EIMR_TXB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_TXB field.
#define BR_ENET_EIMR_TXB(x)  (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_TXB))
#endif

//! @brief Format value for bitfield ENET_EIMR_TXB.
#define BF_ENET_EIMR_TXB(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_TXB), uint32_t) & BM_ENET_EIMR_TXB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TXB field to a new value.
#define BW_ENET_EIMR_TXB(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_TXB) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field TXF[27] (RW)
 *
 * Corresponds to interrupt source EIR[TXF] and determines whether an interrupt
 * condition can generate an interrupt. At every module clock, the EIR samples
 * the signal generated by the interrupting source. The corresponding EIR TXF field
 * reflects the state of the interrupt signal even if the corresponding EIMR
 * field is cleared.
 *
 * Values:
 * - 0 - The corresponding interrupt source is masked.
 * - 1 - The corresponding interrupt source is not masked.
 */
//@{
#define BP_ENET_EIMR_TXF     (27U)         //!< Bit position for ENET_EIMR_TXF.
#define BM_ENET_EIMR_TXF     (0x08000000U) //!< Bit mask for ENET_EIMR_TXF.
#define BS_ENET_EIMR_TXF     (1U)          //!< Bit field size in bits for ENET_EIMR_TXF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_TXF field.
#define BR_ENET_EIMR_TXF(x)  (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_TXF))
#endif

//! @brief Format value for bitfield ENET_EIMR_TXF.
#define BF_ENET_EIMR_TXF(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_TXF), uint32_t) & BM_ENET_EIMR_TXF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TXF field to a new value.
#define BW_ENET_EIMR_TXF(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_TXF) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field GRA[28] (RW)
 *
 * Corresponds to interrupt source EIR[GRA] and determines whether an interrupt
 * condition can generate an interrupt. At every module clock, the EIR samples
 * the signal generated by the interrupting source. The corresponding EIR GRA field
 * reflects the state of the interrupt signal even if the corresponding EIMR
 * field is cleared.
 *
 * Values:
 * - 0 - The corresponding interrupt source is masked.
 * - 1 - The corresponding interrupt source is not masked.
 */
//@{
#define BP_ENET_EIMR_GRA     (28U)         //!< Bit position for ENET_EIMR_GRA.
#define BM_ENET_EIMR_GRA     (0x10000000U) //!< Bit mask for ENET_EIMR_GRA.
#define BS_ENET_EIMR_GRA     (1U)          //!< Bit field size in bits for ENET_EIMR_GRA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_GRA field.
#define BR_ENET_EIMR_GRA(x)  (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_GRA))
#endif

//! @brief Format value for bitfield ENET_EIMR_GRA.
#define BF_ENET_EIMR_GRA(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_GRA), uint32_t) & BM_ENET_EIMR_GRA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GRA field to a new value.
#define BW_ENET_EIMR_GRA(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_GRA) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field BABT[29] (RW)
 *
 * Corresponds to interrupt source EIR[BABT] and determines whether an interrupt
 * condition can generate an interrupt. At every module clock, the EIR samples
 * the signal generated by the interrupting source. The corresponding EIR BABT
 * field reflects the state of the interrupt signal even if the corresponding EIMR
 * field is cleared.
 *
 * Values:
 * - 0 - The corresponding interrupt source is masked.
 * - 1 - The corresponding interrupt source is not masked.
 */
//@{
#define BP_ENET_EIMR_BABT    (29U)         //!< Bit position for ENET_EIMR_BABT.
#define BM_ENET_EIMR_BABT    (0x20000000U) //!< Bit mask for ENET_EIMR_BABT.
#define BS_ENET_EIMR_BABT    (1U)          //!< Bit field size in bits for ENET_EIMR_BABT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_BABT field.
#define BR_ENET_EIMR_BABT(x) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_BABT))
#endif

//! @brief Format value for bitfield ENET_EIMR_BABT.
#define BF_ENET_EIMR_BABT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_BABT), uint32_t) & BM_ENET_EIMR_BABT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BABT field to a new value.
#define BW_ENET_EIMR_BABT(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_BABT) = (v))
#endif
//@}

/*!
 * @name Register ENET_EIMR, field BABR[30] (RW)
 *
 * Corresponds to interrupt source EIR[BABR] and determines whether an interrupt
 * condition can generate an interrupt. At every module clock, the EIR samples
 * the signal generated by the interrupting source. The corresponding EIR BABR
 * field reflects the state of the interrupt signal even if the corresponding EIMR
 * field is cleared.
 *
 * Values:
 * - 0 - The corresponding interrupt source is masked.
 * - 1 - The corresponding interrupt source is not masked.
 */
//@{
#define BP_ENET_EIMR_BABR    (30U)         //!< Bit position for ENET_EIMR_BABR.
#define BM_ENET_EIMR_BABR    (0x40000000U) //!< Bit mask for ENET_EIMR_BABR.
#define BS_ENET_EIMR_BABR    (1U)          //!< Bit field size in bits for ENET_EIMR_BABR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_EIMR_BABR field.
#define BR_ENET_EIMR_BABR(x) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_BABR))
#endif

//! @brief Format value for bitfield ENET_EIMR_BABR.
#define BF_ENET_EIMR_BABR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_EIMR_BABR), uint32_t) & BM_ENET_EIMR_BABR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BABR field to a new value.
#define BW_ENET_EIMR_BABR(x, v) (BITBAND_ACCESS32(HW_ENET_EIMR_ADDR(x), BP_ENET_EIMR_BABR) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RDAR - Receive Descriptor Active Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RDAR - Receive Descriptor Active Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * RDAR is a command register, written by the user, to indicate that the receive
 * descriptor ring has been updated, that is, that the driver produced empty
 * receive buffers with the empty bit set.
 */
typedef union _hw_enet_rdar
{
    uint32_t U;
    struct _hw_enet_rdar_bitfields
    {
        uint32_t RESERVED0 : 24;       //!< [23:0]
        uint32_t RDAR : 1;             //!< [24] Receive Descriptor Active
        uint32_t RESERVED1 : 7;        //!< [31:25]
    } B;
} hw_enet_rdar_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RDAR register
 */
//@{
#define HW_ENET_RDAR_ADDR(x)     (REGS_ENET_BASE(x) + 0x10U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RDAR(x)          (*(__IO hw_enet_rdar_t *) HW_ENET_RDAR_ADDR(x))
#define HW_ENET_RDAR_RD(x)       (HW_ENET_RDAR(x).U)
#define HW_ENET_RDAR_WR(x, v)    (HW_ENET_RDAR(x).U = (v))
#define HW_ENET_RDAR_SET(x, v)   (HW_ENET_RDAR_WR(x, HW_ENET_RDAR_RD(x) |  (v)))
#define HW_ENET_RDAR_CLR(x, v)   (HW_ENET_RDAR_WR(x, HW_ENET_RDAR_RD(x) & ~(v)))
#define HW_ENET_RDAR_TOG(x, v)   (HW_ENET_RDAR_WR(x, HW_ENET_RDAR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_RDAR bitfields
 */

/*!
 * @name Register ENET_RDAR, field RDAR[24] (RW)
 *
 * Always set to 1 when this register is written, regardless of the value
 * written. This field is cleared by the MAC device when no additional empty
 * descriptors remain in the receive ring. It is also cleared when ECR[ETHEREN] transitions
 * from set to cleared or when ECR[RESET] is set.
 */
//@{
#define BP_ENET_RDAR_RDAR    (24U)         //!< Bit position for ENET_RDAR_RDAR.
#define BM_ENET_RDAR_RDAR    (0x01000000U) //!< Bit mask for ENET_RDAR_RDAR.
#define BS_ENET_RDAR_RDAR    (1U)          //!< Bit field size in bits for ENET_RDAR_RDAR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RDAR_RDAR field.
#define BR_ENET_RDAR_RDAR(x) (BITBAND_ACCESS32(HW_ENET_RDAR_ADDR(x), BP_ENET_RDAR_RDAR))
#endif

//! @brief Format value for bitfield ENET_RDAR_RDAR.
#define BF_ENET_RDAR_RDAR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RDAR_RDAR), uint32_t) & BM_ENET_RDAR_RDAR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDAR field to a new value.
#define BW_ENET_RDAR_RDAR(x, v) (BITBAND_ACCESS32(HW_ENET_RDAR_ADDR(x), BP_ENET_RDAR_RDAR) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_TDAR - Transmit Descriptor Active Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_TDAR - Transmit Descriptor Active Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The TDAR is a command register that the user writes to indicate that the
 * transmit descriptor ring has been updated, that is, that transmit buffers have
 * been produced by the driver with the ready bit set in the buffer descriptor. The
 * TDAR register is cleared at reset, when ECR[ETHEREN] transitions from set to
 * cleared, or when ECR[RESET] is set.
 */
typedef union _hw_enet_tdar
{
    uint32_t U;
    struct _hw_enet_tdar_bitfields
    {
        uint32_t RESERVED0 : 24;       //!< [23:0]
        uint32_t TDAR : 1;             //!< [24] Transmit Descriptor Active
        uint32_t RESERVED1 : 7;        //!< [31:25]
    } B;
} hw_enet_tdar_t;
#endif

/*!
 * @name Constants and macros for entire ENET_TDAR register
 */
//@{
#define HW_ENET_TDAR_ADDR(x)     (REGS_ENET_BASE(x) + 0x14U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_TDAR(x)          (*(__IO hw_enet_tdar_t *) HW_ENET_TDAR_ADDR(x))
#define HW_ENET_TDAR_RD(x)       (HW_ENET_TDAR(x).U)
#define HW_ENET_TDAR_WR(x, v)    (HW_ENET_TDAR(x).U = (v))
#define HW_ENET_TDAR_SET(x, v)   (HW_ENET_TDAR_WR(x, HW_ENET_TDAR_RD(x) |  (v)))
#define HW_ENET_TDAR_CLR(x, v)   (HW_ENET_TDAR_WR(x, HW_ENET_TDAR_RD(x) & ~(v)))
#define HW_ENET_TDAR_TOG(x, v)   (HW_ENET_TDAR_WR(x, HW_ENET_TDAR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_TDAR bitfields
 */

/*!
 * @name Register ENET_TDAR, field TDAR[24] (RW)
 *
 * Always set to 1 when this register is written, regardless of the value
 * written. This bit is cleared by the MAC device when no additional ready descriptors
 * remain in the transmit ring. Also cleared when ECR[ETHEREN] transitions from
 * set to cleared or when ECR[RESET] is set.
 */
//@{
#define BP_ENET_TDAR_TDAR    (24U)         //!< Bit position for ENET_TDAR_TDAR.
#define BM_ENET_TDAR_TDAR    (0x01000000U) //!< Bit mask for ENET_TDAR_TDAR.
#define BS_ENET_TDAR_TDAR    (1U)          //!< Bit field size in bits for ENET_TDAR_TDAR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TDAR_TDAR field.
#define BR_ENET_TDAR_TDAR(x) (BITBAND_ACCESS32(HW_ENET_TDAR_ADDR(x), BP_ENET_TDAR_TDAR))
#endif

//! @brief Format value for bitfield ENET_TDAR_TDAR.
#define BF_ENET_TDAR_TDAR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TDAR_TDAR), uint32_t) & BM_ENET_TDAR_TDAR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDAR field to a new value.
#define BW_ENET_TDAR_TDAR(x, v) (BITBAND_ACCESS32(HW_ENET_TDAR_ADDR(x), BP_ENET_TDAR_TDAR) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_ECR - Ethernet Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_ECR - Ethernet Control Register (RW)
 *
 * Reset value: 0xF0000000U
 *
 * ECR is a read/write user register, though hardware may also alter fields in
 * this register. It controls many of the high level features of the Ethernet MAC,
 * including legacy FEC support through the EN1588 field.
 */
typedef union _hw_enet_ecr
{
    uint32_t U;
    struct _hw_enet_ecr_bitfields
    {
        uint32_t RESET : 1;            //!< [0] Ethernet MAC Reset
        uint32_t ETHEREN : 1;          //!< [1] Ethernet Enable
        uint32_t MAGICEN : 1;          //!< [2] Magic Packet Detection Enable
        uint32_t SLEEP : 1;            //!< [3] Sleep Mode Enable
        uint32_t EN1588 : 1;           //!< [4] EN1588 Enable
        uint32_t RESERVED0 : 1;        //!< [5]
        uint32_t DBGEN : 1;            //!< [6] Debug Enable
        uint32_t STOPEN : 1;           //!< [7] STOPEN Signal Control
        uint32_t DBSWP : 1;            //!< [8] Descriptor Byte Swapping Enable
        uint32_t RESERVED1 : 23;       //!< [31:9]
    } B;
} hw_enet_ecr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_ECR register
 */
//@{
#define HW_ENET_ECR_ADDR(x)      (REGS_ENET_BASE(x) + 0x24U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_ECR(x)           (*(__IO hw_enet_ecr_t *) HW_ENET_ECR_ADDR(x))
#define HW_ENET_ECR_RD(x)        (HW_ENET_ECR(x).U)
#define HW_ENET_ECR_WR(x, v)     (HW_ENET_ECR(x).U = (v))
#define HW_ENET_ECR_SET(x, v)    (HW_ENET_ECR_WR(x, HW_ENET_ECR_RD(x) |  (v)))
#define HW_ENET_ECR_CLR(x, v)    (HW_ENET_ECR_WR(x, HW_ENET_ECR_RD(x) & ~(v)))
#define HW_ENET_ECR_TOG(x, v)    (HW_ENET_ECR_WR(x, HW_ENET_ECR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_ECR bitfields
 */

/*!
 * @name Register ENET_ECR, field RESET[0] (RW)
 *
 * When this field is set, it clears the ETHEREN field.
 */
//@{
#define BP_ENET_ECR_RESET    (0U)          //!< Bit position for ENET_ECR_RESET.
#define BM_ENET_ECR_RESET    (0x00000001U) //!< Bit mask for ENET_ECR_RESET.
#define BS_ENET_ECR_RESET    (1U)          //!< Bit field size in bits for ENET_ECR_RESET.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ECR_RESET field.
#define BR_ENET_ECR_RESET(x) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_RESET))
#endif

//! @brief Format value for bitfield ENET_ECR_RESET.
#define BF_ENET_ECR_RESET(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ECR_RESET), uint32_t) & BM_ENET_ECR_RESET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RESET field to a new value.
#define BW_ENET_ECR_RESET(x, v) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_RESET) = (v))
#endif
//@}

/*!
 * @name Register ENET_ECR, field ETHEREN[1] (RW)
 *
 * Enables/disables the Ethernet MAC. When the MAC is disabled, the buffer
 * descriptors for an aborted transmit frame are not updated. The uDMA, buffer
 * descriptor, and FIFO control logic are reset, including the buffer descriptor and
 * FIFO pointers. Hardware clears this field under the following conditions: RESET
 * is set by software An error condition causes the EBERR field to set. ETHEREN
 * must be set at the very last step during ENET
 * configuration/setup/initialization, only after all other ENET-related registers have been configured. If ETHEREN
 * is cleared to 0 by software then then next time ETHEREN is set, the EIR
 * interrupts must cleared to 0 due to previous pending interrupts.
 *
 * Values:
 * - 0 - Reception immediately stops and transmission stops after a bad CRC is
 *     appended to any currently transmitted frame.
 * - 1 - MAC is enabled, and reception and transmission are possible.
 */
//@{
#define BP_ENET_ECR_ETHEREN  (1U)          //!< Bit position for ENET_ECR_ETHEREN.
#define BM_ENET_ECR_ETHEREN  (0x00000002U) //!< Bit mask for ENET_ECR_ETHEREN.
#define BS_ENET_ECR_ETHEREN  (1U)          //!< Bit field size in bits for ENET_ECR_ETHEREN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ECR_ETHEREN field.
#define BR_ENET_ECR_ETHEREN(x) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_ETHEREN))
#endif

//! @brief Format value for bitfield ENET_ECR_ETHEREN.
#define BF_ENET_ECR_ETHEREN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ECR_ETHEREN), uint32_t) & BM_ENET_ECR_ETHEREN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ETHEREN field to a new value.
#define BW_ENET_ECR_ETHEREN(x, v) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_ETHEREN) = (v))
#endif
//@}

/*!
 * @name Register ENET_ECR, field MAGICEN[2] (RW)
 *
 * Enables/disables magic packet detection. MAGICEN is relevant only if the
 * SLEEP field is set. If MAGICEN is set, changing the SLEEP field enables/disables
 * sleep mode and magic packet detection.
 *
 * Values:
 * - 0 - Magic detection logic disabled.
 * - 1 - The MAC core detects magic packets and asserts EIR[WAKEUP] when a frame
 *     is detected.
 */
//@{
#define BP_ENET_ECR_MAGICEN  (2U)          //!< Bit position for ENET_ECR_MAGICEN.
#define BM_ENET_ECR_MAGICEN  (0x00000004U) //!< Bit mask for ENET_ECR_MAGICEN.
#define BS_ENET_ECR_MAGICEN  (1U)          //!< Bit field size in bits for ENET_ECR_MAGICEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ECR_MAGICEN field.
#define BR_ENET_ECR_MAGICEN(x) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_MAGICEN))
#endif

//! @brief Format value for bitfield ENET_ECR_MAGICEN.
#define BF_ENET_ECR_MAGICEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ECR_MAGICEN), uint32_t) & BM_ENET_ECR_MAGICEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MAGICEN field to a new value.
#define BW_ENET_ECR_MAGICEN(x, v) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_MAGICEN) = (v))
#endif
//@}

/*!
 * @name Register ENET_ECR, field SLEEP[3] (RW)
 *
 * Values:
 * - 0 - Normal operating mode.
 * - 1 - Sleep mode.
 */
//@{
#define BP_ENET_ECR_SLEEP    (3U)          //!< Bit position for ENET_ECR_SLEEP.
#define BM_ENET_ECR_SLEEP    (0x00000008U) //!< Bit mask for ENET_ECR_SLEEP.
#define BS_ENET_ECR_SLEEP    (1U)          //!< Bit field size in bits for ENET_ECR_SLEEP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ECR_SLEEP field.
#define BR_ENET_ECR_SLEEP(x) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_SLEEP))
#endif

//! @brief Format value for bitfield ENET_ECR_SLEEP.
#define BF_ENET_ECR_SLEEP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ECR_SLEEP), uint32_t) & BM_ENET_ECR_SLEEP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SLEEP field to a new value.
#define BW_ENET_ECR_SLEEP(x, v) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_SLEEP) = (v))
#endif
//@}

/*!
 * @name Register ENET_ECR, field EN1588[4] (RW)
 *
 * Enables enhanced functionality of the MAC.
 *
 * Values:
 * - 0 - Legacy FEC buffer descriptors and functions enabled.
 * - 1 - Enhanced frame time-stamping functions enabled.
 */
//@{
#define BP_ENET_ECR_EN1588   (4U)          //!< Bit position for ENET_ECR_EN1588.
#define BM_ENET_ECR_EN1588   (0x00000010U) //!< Bit mask for ENET_ECR_EN1588.
#define BS_ENET_ECR_EN1588   (1U)          //!< Bit field size in bits for ENET_ECR_EN1588.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ECR_EN1588 field.
#define BR_ENET_ECR_EN1588(x) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_EN1588))
#endif

//! @brief Format value for bitfield ENET_ECR_EN1588.
#define BF_ENET_ECR_EN1588(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ECR_EN1588), uint32_t) & BM_ENET_ECR_EN1588)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EN1588 field to a new value.
#define BW_ENET_ECR_EN1588(x, v) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_EN1588) = (v))
#endif
//@}

/*!
 * @name Register ENET_ECR, field DBGEN[6] (RW)
 *
 * Enables the MAC to enter hardware freeze mode when the device enters debug
 * mode.
 *
 * Values:
 * - 0 - MAC continues operation in debug mode.
 * - 1 - MAC enters hardware freeze mode when the processor is in debug mode.
 */
//@{
#define BP_ENET_ECR_DBGEN    (6U)          //!< Bit position for ENET_ECR_DBGEN.
#define BM_ENET_ECR_DBGEN    (0x00000040U) //!< Bit mask for ENET_ECR_DBGEN.
#define BS_ENET_ECR_DBGEN    (1U)          //!< Bit field size in bits for ENET_ECR_DBGEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ECR_DBGEN field.
#define BR_ENET_ECR_DBGEN(x) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_DBGEN))
#endif

//! @brief Format value for bitfield ENET_ECR_DBGEN.
#define BF_ENET_ECR_DBGEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ECR_DBGEN), uint32_t) & BM_ENET_ECR_DBGEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DBGEN field to a new value.
#define BW_ENET_ECR_DBGEN(x, v) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_DBGEN) = (v))
#endif
//@}

/*!
 * @name Register ENET_ECR, field STOPEN[7] (RW)
 *
 * Controls device behavior in doze mode. In doze mode, if this field is set
 * then all the clocks of the ENET assembly are disabled, except the RMII /MII
 * clock. Doze mode is similar to a conditional stop mode entry for the ENET assembly
 * depending on ECR[STOPEN]. If module clocks are gated in this mode, the module
 * can still wake the system after receiving a magic packet in stop mode. MAGICEN
 * must be set prior to entering sleep/stop mode.
 */
//@{
#define BP_ENET_ECR_STOPEN   (7U)          //!< Bit position for ENET_ECR_STOPEN.
#define BM_ENET_ECR_STOPEN   (0x00000080U) //!< Bit mask for ENET_ECR_STOPEN.
#define BS_ENET_ECR_STOPEN   (1U)          //!< Bit field size in bits for ENET_ECR_STOPEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ECR_STOPEN field.
#define BR_ENET_ECR_STOPEN(x) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_STOPEN))
#endif

//! @brief Format value for bitfield ENET_ECR_STOPEN.
#define BF_ENET_ECR_STOPEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ECR_STOPEN), uint32_t) & BM_ENET_ECR_STOPEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STOPEN field to a new value.
#define BW_ENET_ECR_STOPEN(x, v) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_STOPEN) = (v))
#endif
//@}

/*!
 * @name Register ENET_ECR, field DBSWP[8] (RW)
 *
 * Swaps the byte locations of the buffer descriptors. This field must be
 * written to 1 after reset.
 *
 * Values:
 * - 0 - The buffer descriptor bytes are not swapped to support big-endian
 *     devices.
 * - 1 - The buffer descriptor bytes are swapped to support little-endian
 *     devices.
 */
//@{
#define BP_ENET_ECR_DBSWP    (8U)          //!< Bit position for ENET_ECR_DBSWP.
#define BM_ENET_ECR_DBSWP    (0x00000100U) //!< Bit mask for ENET_ECR_DBSWP.
#define BS_ENET_ECR_DBSWP    (1U)          //!< Bit field size in bits for ENET_ECR_DBSWP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ECR_DBSWP field.
#define BR_ENET_ECR_DBSWP(x) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_DBSWP))
#endif

//! @brief Format value for bitfield ENET_ECR_DBSWP.
#define BF_ENET_ECR_DBSWP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ECR_DBSWP), uint32_t) & BM_ENET_ECR_DBSWP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DBSWP field to a new value.
#define BW_ENET_ECR_DBSWP(x, v) (BITBAND_ACCESS32(HW_ENET_ECR_ADDR(x), BP_ENET_ECR_DBSWP) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_MMFR - MII Management Frame Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_MMFR - MII Management Frame Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * Writing to MMFR triggers a management frame transaction to the PHY device
 * unless MSCR is programmed to zero. If MSCR is changed from zero to non-zero
 * during a write to MMFR, an MII frame is generated with the data previously written
 * to the MMFR. This allows MMFR and MSCR to be programmed in either order if
 * MSCR is currently zero. If the MMFR register is written while frame generation is
 * in progress, the frame contents are altered. Software must use the EIR[MII]
 * interrupt indication to avoid writing to the MMFR register while frame
 * generation is in progress.
 */
typedef union _hw_enet_mmfr
{
    uint32_t U;
    struct _hw_enet_mmfr_bitfields
    {
        uint32_t DATA : 16;            //!< [15:0] Management Frame Data
        uint32_t TA : 2;               //!< [17:16] Turn Around
        uint32_t RA : 5;               //!< [22:18] Register Address
        uint32_t PA : 5;               //!< [27:23] PHY Address
        uint32_t OP : 2;               //!< [29:28] Operation Code
        uint32_t ST : 2;               //!< [31:30] Start Of Frame Delimiter
    } B;
} hw_enet_mmfr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_MMFR register
 */
//@{
#define HW_ENET_MMFR_ADDR(x)     (REGS_ENET_BASE(x) + 0x40U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MMFR(x)          (*(__IO hw_enet_mmfr_t *) HW_ENET_MMFR_ADDR(x))
#define HW_ENET_MMFR_RD(x)       (HW_ENET_MMFR(x).U)
#define HW_ENET_MMFR_WR(x, v)    (HW_ENET_MMFR(x).U = (v))
#define HW_ENET_MMFR_SET(x, v)   (HW_ENET_MMFR_WR(x, HW_ENET_MMFR_RD(x) |  (v)))
#define HW_ENET_MMFR_CLR(x, v)   (HW_ENET_MMFR_WR(x, HW_ENET_MMFR_RD(x) & ~(v)))
#define HW_ENET_MMFR_TOG(x, v)   (HW_ENET_MMFR_WR(x, HW_ENET_MMFR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_MMFR bitfields
 */

/*!
 * @name Register ENET_MMFR, field DATA[15:0] (RW)
 *
 * This is the field for data to be written to or read from the PHY register.
 */
//@{
#define BP_ENET_MMFR_DATA    (0U)          //!< Bit position for ENET_MMFR_DATA.
#define BM_ENET_MMFR_DATA    (0x0000FFFFU) //!< Bit mask for ENET_MMFR_DATA.
#define BS_ENET_MMFR_DATA    (16U)         //!< Bit field size in bits for ENET_MMFR_DATA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MMFR_DATA field.
#define BR_ENET_MMFR_DATA(x) (HW_ENET_MMFR(x).B.DATA)
#endif

//! @brief Format value for bitfield ENET_MMFR_DATA.
#define BF_ENET_MMFR_DATA(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_MMFR_DATA), uint32_t) & BM_ENET_MMFR_DATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA field to a new value.
#define BW_ENET_MMFR_DATA(x, v) (HW_ENET_MMFR_WR(x, (HW_ENET_MMFR_RD(x) & ~BM_ENET_MMFR_DATA) | BF_ENET_MMFR_DATA(v)))
#endif
//@}

/*!
 * @name Register ENET_MMFR, field TA[17:16] (RW)
 *
 * This field must be programmed to 10 to generate a valid MII management frame.
 */
//@{
#define BP_ENET_MMFR_TA      (16U)         //!< Bit position for ENET_MMFR_TA.
#define BM_ENET_MMFR_TA      (0x00030000U) //!< Bit mask for ENET_MMFR_TA.
#define BS_ENET_MMFR_TA      (2U)          //!< Bit field size in bits for ENET_MMFR_TA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MMFR_TA field.
#define BR_ENET_MMFR_TA(x)   (HW_ENET_MMFR(x).B.TA)
#endif

//! @brief Format value for bitfield ENET_MMFR_TA.
#define BF_ENET_MMFR_TA(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_MMFR_TA), uint32_t) & BM_ENET_MMFR_TA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TA field to a new value.
#define BW_ENET_MMFR_TA(x, v) (HW_ENET_MMFR_WR(x, (HW_ENET_MMFR_RD(x) & ~BM_ENET_MMFR_TA) | BF_ENET_MMFR_TA(v)))
#endif
//@}

/*!
 * @name Register ENET_MMFR, field RA[22:18] (RW)
 *
 * Specifies one of up to 32 registers within the specified PHY device.
 */
//@{
#define BP_ENET_MMFR_RA      (18U)         //!< Bit position for ENET_MMFR_RA.
#define BM_ENET_MMFR_RA      (0x007C0000U) //!< Bit mask for ENET_MMFR_RA.
#define BS_ENET_MMFR_RA      (5U)          //!< Bit field size in bits for ENET_MMFR_RA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MMFR_RA field.
#define BR_ENET_MMFR_RA(x)   (HW_ENET_MMFR(x).B.RA)
#endif

//! @brief Format value for bitfield ENET_MMFR_RA.
#define BF_ENET_MMFR_RA(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_MMFR_RA), uint32_t) & BM_ENET_MMFR_RA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RA field to a new value.
#define BW_ENET_MMFR_RA(x, v) (HW_ENET_MMFR_WR(x, (HW_ENET_MMFR_RD(x) & ~BM_ENET_MMFR_RA) | BF_ENET_MMFR_RA(v)))
#endif
//@}

/*!
 * @name Register ENET_MMFR, field PA[27:23] (RW)
 *
 * Specifies one of up to 32 attached PHY devices.
 */
//@{
#define BP_ENET_MMFR_PA      (23U)         //!< Bit position for ENET_MMFR_PA.
#define BM_ENET_MMFR_PA      (0x0F800000U) //!< Bit mask for ENET_MMFR_PA.
#define BS_ENET_MMFR_PA      (5U)          //!< Bit field size in bits for ENET_MMFR_PA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MMFR_PA field.
#define BR_ENET_MMFR_PA(x)   (HW_ENET_MMFR(x).B.PA)
#endif

//! @brief Format value for bitfield ENET_MMFR_PA.
#define BF_ENET_MMFR_PA(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_MMFR_PA), uint32_t) & BM_ENET_MMFR_PA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PA field to a new value.
#define BW_ENET_MMFR_PA(x, v) (HW_ENET_MMFR_WR(x, (HW_ENET_MMFR_RD(x) & ~BM_ENET_MMFR_PA) | BF_ENET_MMFR_PA(v)))
#endif
//@}

/*!
 * @name Register ENET_MMFR, field OP[29:28] (RW)
 *
 * Determines the frame operation.
 *
 * Values:
 * - 00 - Write frame operation, but not MII compliant.
 * - 01 - Write frame operation for a valid MII management frame.
 * - 10 - Read frame operation for a valid MII management frame.
 * - 11 - Read frame operation, but not MII compliant.
 */
//@{
#define BP_ENET_MMFR_OP      (28U)         //!< Bit position for ENET_MMFR_OP.
#define BM_ENET_MMFR_OP      (0x30000000U) //!< Bit mask for ENET_MMFR_OP.
#define BS_ENET_MMFR_OP      (2U)          //!< Bit field size in bits for ENET_MMFR_OP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MMFR_OP field.
#define BR_ENET_MMFR_OP(x)   (HW_ENET_MMFR(x).B.OP)
#endif

//! @brief Format value for bitfield ENET_MMFR_OP.
#define BF_ENET_MMFR_OP(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_MMFR_OP), uint32_t) & BM_ENET_MMFR_OP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OP field to a new value.
#define BW_ENET_MMFR_OP(x, v) (HW_ENET_MMFR_WR(x, (HW_ENET_MMFR_RD(x) & ~BM_ENET_MMFR_OP) | BF_ENET_MMFR_OP(v)))
#endif
//@}

/*!
 * @name Register ENET_MMFR, field ST[31:30] (RW)
 *
 * These fields must be programmed to 01 for a valid MII management frame.
 */
//@{
#define BP_ENET_MMFR_ST      (30U)         //!< Bit position for ENET_MMFR_ST.
#define BM_ENET_MMFR_ST      (0xC0000000U) //!< Bit mask for ENET_MMFR_ST.
#define BS_ENET_MMFR_ST      (2U)          //!< Bit field size in bits for ENET_MMFR_ST.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MMFR_ST field.
#define BR_ENET_MMFR_ST(x)   (HW_ENET_MMFR(x).B.ST)
#endif

//! @brief Format value for bitfield ENET_MMFR_ST.
#define BF_ENET_MMFR_ST(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_MMFR_ST), uint32_t) & BM_ENET_MMFR_ST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ST field to a new value.
#define BW_ENET_MMFR_ST(x, v) (HW_ENET_MMFR_WR(x, (HW_ENET_MMFR_RD(x) & ~BM_ENET_MMFR_ST) | BF_ENET_MMFR_ST(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_MSCR - MII Speed Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_MSCR - MII Speed Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * MSCR provides control of the MII clock (MDC pin) frequency and allows a
 * preamble drop on the MII management frame. The MII_SPEED field must be programmed
 * with a value to provide an MDC frequency of less than or equal to 2.5 MHz to be
 * compliant with the IEEE 802.3 MII specification. The MII_SPEED must be set to
 * a non-zero value to source a read or write management frame. After the
 * management frame is complete, the MSCR register may optionally be cleared to turn
 * off MDC. The MDC signal generated has a 50% duty cycle except when MII_SPEED
 * changes during operation. This change takes effect following a rising or falling
 * edge of MDC. If the internal module clock is 25 MHz, programming this register
 * to 0x0000_0004 results in an MDC as stated in the following equation: 25 MHz
 * / ((4 + 1) x 2) = 2.5 MHz The following table shows the optimum values for
 * MII_SPEED as a function of internal module clock frequency. Programming Examples
 * for MSCR Internal MAC clock frequency MSCR [MII_SPEED] MDC frequency 25 MHz
 * 0x4 2.50 MHz 33 MHz 0x6 2.36 MHz 40 MHz 0x7 2.50 MHz 50 MHz 0x9 2.50 MHz 66 MHz
 * 0xD 2.36 MHz
 */
typedef union _hw_enet_mscr
{
    uint32_t U;
    struct _hw_enet_mscr_bitfields
    {
        uint32_t RESERVED0 : 1;        //!< [0]
        uint32_t MII_SPEED : 6;        //!< [6:1] MII Speed
        uint32_t DIS_PRE : 1;          //!< [7] Disable Preamble
        uint32_t HOLDTIME : 3;         //!< [10:8] Hold time On MDIO Output
        uint32_t RESERVED1 : 21;       //!< [31:11]
    } B;
} hw_enet_mscr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_MSCR register
 */
//@{
#define HW_ENET_MSCR_ADDR(x)     (REGS_ENET_BASE(x) + 0x44U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MSCR(x)          (*(__IO hw_enet_mscr_t *) HW_ENET_MSCR_ADDR(x))
#define HW_ENET_MSCR_RD(x)       (HW_ENET_MSCR(x).U)
#define HW_ENET_MSCR_WR(x, v)    (HW_ENET_MSCR(x).U = (v))
#define HW_ENET_MSCR_SET(x, v)   (HW_ENET_MSCR_WR(x, HW_ENET_MSCR_RD(x) |  (v)))
#define HW_ENET_MSCR_CLR(x, v)   (HW_ENET_MSCR_WR(x, HW_ENET_MSCR_RD(x) & ~(v)))
#define HW_ENET_MSCR_TOG(x, v)   (HW_ENET_MSCR_WR(x, HW_ENET_MSCR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_MSCR bitfields
 */

/*!
 * @name Register ENET_MSCR, field MII_SPEED[6:1] (RW)
 *
 * Controls the frequency of the MII management interface clock (MDC) relative
 * to the internal module clock. A value of 0 in this field turns off MDC and
 * leaves it in low voltage state. Any non-zero value results in the MDC frequency
 * of: 1/((MII_SPEED + 1) x 2) of the internal module clock frequency
 */
//@{
#define BP_ENET_MSCR_MII_SPEED (1U)        //!< Bit position for ENET_MSCR_MII_SPEED.
#define BM_ENET_MSCR_MII_SPEED (0x0000007EU) //!< Bit mask for ENET_MSCR_MII_SPEED.
#define BS_ENET_MSCR_MII_SPEED (6U)        //!< Bit field size in bits for ENET_MSCR_MII_SPEED.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MSCR_MII_SPEED field.
#define BR_ENET_MSCR_MII_SPEED(x) (HW_ENET_MSCR(x).B.MII_SPEED)
#endif

//! @brief Format value for bitfield ENET_MSCR_MII_SPEED.
#define BF_ENET_MSCR_MII_SPEED(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_MSCR_MII_SPEED), uint32_t) & BM_ENET_MSCR_MII_SPEED)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MII_SPEED field to a new value.
#define BW_ENET_MSCR_MII_SPEED(x, v) (HW_ENET_MSCR_WR(x, (HW_ENET_MSCR_RD(x) & ~BM_ENET_MSCR_MII_SPEED) | BF_ENET_MSCR_MII_SPEED(v)))
#endif
//@}

/*!
 * @name Register ENET_MSCR, field DIS_PRE[7] (RW)
 *
 * Enables/disables prepending a preamble to the MII management frame. The MII
 * standard allows the preamble to be dropped if the attached PHY devices do not
 * require it.
 *
 * Values:
 * - 0 - Preamble enabled.
 * - 1 - Preamble (32 ones) is not prepended to the MII management frame.
 */
//@{
#define BP_ENET_MSCR_DIS_PRE (7U)          //!< Bit position for ENET_MSCR_DIS_PRE.
#define BM_ENET_MSCR_DIS_PRE (0x00000080U) //!< Bit mask for ENET_MSCR_DIS_PRE.
#define BS_ENET_MSCR_DIS_PRE (1U)          //!< Bit field size in bits for ENET_MSCR_DIS_PRE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MSCR_DIS_PRE field.
#define BR_ENET_MSCR_DIS_PRE(x) (BITBAND_ACCESS32(HW_ENET_MSCR_ADDR(x), BP_ENET_MSCR_DIS_PRE))
#endif

//! @brief Format value for bitfield ENET_MSCR_DIS_PRE.
#define BF_ENET_MSCR_DIS_PRE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_MSCR_DIS_PRE), uint32_t) & BM_ENET_MSCR_DIS_PRE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DIS_PRE field to a new value.
#define BW_ENET_MSCR_DIS_PRE(x, v) (BITBAND_ACCESS32(HW_ENET_MSCR_ADDR(x), BP_ENET_MSCR_DIS_PRE) = (v))
#endif
//@}

/*!
 * @name Register ENET_MSCR, field HOLDTIME[10:8] (RW)
 *
 * IEEE802.3 clause 22 defines a minimum of 10 ns for the hold time on the MDIO
 * output. Depending on the host bus frequency, the setting may need to be
 * increased.
 *
 * Values:
 * - 000 - 1 internal module clock cycle
 * - 001 - 2 internal module clock cycles
 * - 010 - 3 internal module clock cycles
 * - 111 - 8 internal module clock cycles
 */
//@{
#define BP_ENET_MSCR_HOLDTIME (8U)         //!< Bit position for ENET_MSCR_HOLDTIME.
#define BM_ENET_MSCR_HOLDTIME (0x00000700U) //!< Bit mask for ENET_MSCR_HOLDTIME.
#define BS_ENET_MSCR_HOLDTIME (3U)         //!< Bit field size in bits for ENET_MSCR_HOLDTIME.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MSCR_HOLDTIME field.
#define BR_ENET_MSCR_HOLDTIME(x) (HW_ENET_MSCR(x).B.HOLDTIME)
#endif

//! @brief Format value for bitfield ENET_MSCR_HOLDTIME.
#define BF_ENET_MSCR_HOLDTIME(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_MSCR_HOLDTIME), uint32_t) & BM_ENET_MSCR_HOLDTIME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HOLDTIME field to a new value.
#define BW_ENET_MSCR_HOLDTIME(x, v) (HW_ENET_MSCR_WR(x, (HW_ENET_MSCR_RD(x) & ~BM_ENET_MSCR_HOLDTIME) | BF_ENET_MSCR_HOLDTIME(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_MIBC - MIB Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_MIBC - MIB Control Register (RW)
 *
 * Reset value: 0xC0000000U
 *
 * MIBC is a read/write register controlling and observing the state of the MIB
 * block. Access this register to disable the MIB block operation or clear the
 * MIB counters. The MIB_DIS field resets to 1.
 */
typedef union _hw_enet_mibc
{
    uint32_t U;
    struct _hw_enet_mibc_bitfields
    {
        uint32_t RESERVED0 : 29;       //!< [28:0]
        uint32_t MIB_CLEAR : 1;        //!< [29] MIB Clear
        uint32_t MIB_IDLE : 1;         //!< [30] MIB Idle
        uint32_t MIB_DIS : 1;          //!< [31] Disable MIB Logic
    } B;
} hw_enet_mibc_t;
#endif

/*!
 * @name Constants and macros for entire ENET_MIBC register
 */
//@{
#define HW_ENET_MIBC_ADDR(x)     (REGS_ENET_BASE(x) + 0x64U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MIBC(x)          (*(__IO hw_enet_mibc_t *) HW_ENET_MIBC_ADDR(x))
#define HW_ENET_MIBC_RD(x)       (HW_ENET_MIBC(x).U)
#define HW_ENET_MIBC_WR(x, v)    (HW_ENET_MIBC(x).U = (v))
#define HW_ENET_MIBC_SET(x, v)   (HW_ENET_MIBC_WR(x, HW_ENET_MIBC_RD(x) |  (v)))
#define HW_ENET_MIBC_CLR(x, v)   (HW_ENET_MIBC_WR(x, HW_ENET_MIBC_RD(x) & ~(v)))
#define HW_ENET_MIBC_TOG(x, v)   (HW_ENET_MIBC_WR(x, HW_ENET_MIBC_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_MIBC bitfields
 */

/*!
 * @name Register ENET_MIBC, field MIB_CLEAR[29] (RW)
 *
 * If set, all statistics counters are reset to 0. This field is not
 * self-clearing. To clear the MIB counters set and then clear the field.
 */
//@{
#define BP_ENET_MIBC_MIB_CLEAR (29U)       //!< Bit position for ENET_MIBC_MIB_CLEAR.
#define BM_ENET_MIBC_MIB_CLEAR (0x20000000U) //!< Bit mask for ENET_MIBC_MIB_CLEAR.
#define BS_ENET_MIBC_MIB_CLEAR (1U)        //!< Bit field size in bits for ENET_MIBC_MIB_CLEAR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MIBC_MIB_CLEAR field.
#define BR_ENET_MIBC_MIB_CLEAR(x) (BITBAND_ACCESS32(HW_ENET_MIBC_ADDR(x), BP_ENET_MIBC_MIB_CLEAR))
#endif

//! @brief Format value for bitfield ENET_MIBC_MIB_CLEAR.
#define BF_ENET_MIBC_MIB_CLEAR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_MIBC_MIB_CLEAR), uint32_t) & BM_ENET_MIBC_MIB_CLEAR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MIB_CLEAR field to a new value.
#define BW_ENET_MIBC_MIB_CLEAR(x, v) (BITBAND_ACCESS32(HW_ENET_MIBC_ADDR(x), BP_ENET_MIBC_MIB_CLEAR) = (v))
#endif
//@}

/*!
 * @name Register ENET_MIBC, field MIB_IDLE[30] (RO)
 *
 * If this status field is set, the MIB block is not currently updating any MIB
 * counters.
 */
//@{
#define BP_ENET_MIBC_MIB_IDLE (30U)        //!< Bit position for ENET_MIBC_MIB_IDLE.
#define BM_ENET_MIBC_MIB_IDLE (0x40000000U) //!< Bit mask for ENET_MIBC_MIB_IDLE.
#define BS_ENET_MIBC_MIB_IDLE (1U)         //!< Bit field size in bits for ENET_MIBC_MIB_IDLE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MIBC_MIB_IDLE field.
#define BR_ENET_MIBC_MIB_IDLE(x) (BITBAND_ACCESS32(HW_ENET_MIBC_ADDR(x), BP_ENET_MIBC_MIB_IDLE))
#endif
//@}

/*!
 * @name Register ENET_MIBC, field MIB_DIS[31] (RW)
 *
 * If this control field is set, the MIB logic halts and does not update any MIB
 * counters.
 */
//@{
#define BP_ENET_MIBC_MIB_DIS (31U)         //!< Bit position for ENET_MIBC_MIB_DIS.
#define BM_ENET_MIBC_MIB_DIS (0x80000000U) //!< Bit mask for ENET_MIBC_MIB_DIS.
#define BS_ENET_MIBC_MIB_DIS (1U)          //!< Bit field size in bits for ENET_MIBC_MIB_DIS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MIBC_MIB_DIS field.
#define BR_ENET_MIBC_MIB_DIS(x) (BITBAND_ACCESS32(HW_ENET_MIBC_ADDR(x), BP_ENET_MIBC_MIB_DIS))
#endif

//! @brief Format value for bitfield ENET_MIBC_MIB_DIS.
#define BF_ENET_MIBC_MIB_DIS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_MIBC_MIB_DIS), uint32_t) & BM_ENET_MIBC_MIB_DIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MIB_DIS field to a new value.
#define BW_ENET_MIBC_MIB_DIS(x, v) (BITBAND_ACCESS32(HW_ENET_MIBC_ADDR(x), BP_ENET_MIBC_MIB_DIS) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RCR - Receive Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RCR - Receive Control Register (RW)
 *
 * Reset value: 0x05EE0001U
 */
typedef union _hw_enet_rcr
{
    uint32_t U;
    struct _hw_enet_rcr_bitfields
    {
        uint32_t LOOP : 1;             //!< [0] Internal Loopback
        uint32_t DRT : 1;              //!< [1] Disable Receive On Transmit
        uint32_t MII_MODE : 1;         //!< [2] Media Independent Interface Mode
        uint32_t PROM : 1;             //!< [3] Promiscuous Mode
        uint32_t BC_REJ : 1;           //!< [4] Broadcast Frame Reject
        uint32_t FCE : 1;              //!< [5] Flow Control Enable
        uint32_t RESERVED0 : 2;        //!< [7:6]
        uint32_t RMII_MODE : 1;        //!< [8] RMII Mode Enable
        uint32_t RMII_10T : 1;         //!< [9]
        uint32_t RESERVED1 : 2;        //!< [11:10]
        uint32_t PADEN : 1;            //!< [12] Enable Frame Padding Remove On Receive
        uint32_t PAUFWD : 1;           //!< [13] Terminate/Forward Pause Frames
        uint32_t CRCFWD : 1;           //!< [14] Terminate/Forward Received CRC
        uint32_t CFEN : 1;             //!< [15] MAC Control Frame Enable
        uint32_t MAX_FL : 14;          //!< [29:16] Maximum Frame Length
        uint32_t NLC : 1;              //!< [30] Payload Length Check Disable
        uint32_t GRS : 1;              //!< [31] Graceful Receive Stopped
    } B;
} hw_enet_rcr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RCR register
 */
//@{
#define HW_ENET_RCR_ADDR(x)      (REGS_ENET_BASE(x) + 0x84U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RCR(x)           (*(__IO hw_enet_rcr_t *) HW_ENET_RCR_ADDR(x))
#define HW_ENET_RCR_RD(x)        (HW_ENET_RCR(x).U)
#define HW_ENET_RCR_WR(x, v)     (HW_ENET_RCR(x).U = (v))
#define HW_ENET_RCR_SET(x, v)    (HW_ENET_RCR_WR(x, HW_ENET_RCR_RD(x) |  (v)))
#define HW_ENET_RCR_CLR(x, v)    (HW_ENET_RCR_WR(x, HW_ENET_RCR_RD(x) & ~(v)))
#define HW_ENET_RCR_TOG(x, v)    (HW_ENET_RCR_WR(x, HW_ENET_RCR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_RCR bitfields
 */

/*!
 * @name Register ENET_RCR, field LOOP[0] (RW)
 *
 * This is an MII internal loopback, therefore MII_MODE must be written to 1 and
 * RMII_MODE must be written to 0.
 *
 * Values:
 * - 0 - Loopback disabled.
 * - 1 - Transmitted frames are looped back internal to the device and transmit
 *     MII output signals are not asserted. DRT must be cleared.
 */
//@{
#define BP_ENET_RCR_LOOP     (0U)          //!< Bit position for ENET_RCR_LOOP.
#define BM_ENET_RCR_LOOP     (0x00000001U) //!< Bit mask for ENET_RCR_LOOP.
#define BS_ENET_RCR_LOOP     (1U)          //!< Bit field size in bits for ENET_RCR_LOOP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_LOOP field.
#define BR_ENET_RCR_LOOP(x)  (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_LOOP))
#endif

//! @brief Format value for bitfield ENET_RCR_LOOP.
#define BF_ENET_RCR_LOOP(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_LOOP), uint32_t) & BM_ENET_RCR_LOOP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LOOP field to a new value.
#define BW_ENET_RCR_LOOP(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_LOOP) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field DRT[1] (RW)
 *
 * Values:
 * - 0 - Receive path operates independently of transmit. Used for full-duplex
 *     or to monitor transmit activity in half-duplex mode.
 * - 1 - Disable reception of frames while transmitting. Normally used for
 *     half-duplex mode.
 */
//@{
#define BP_ENET_RCR_DRT      (1U)          //!< Bit position for ENET_RCR_DRT.
#define BM_ENET_RCR_DRT      (0x00000002U) //!< Bit mask for ENET_RCR_DRT.
#define BS_ENET_RCR_DRT      (1U)          //!< Bit field size in bits for ENET_RCR_DRT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_DRT field.
#define BR_ENET_RCR_DRT(x)   (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_DRT))
#endif

//! @brief Format value for bitfield ENET_RCR_DRT.
#define BF_ENET_RCR_DRT(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_DRT), uint32_t) & BM_ENET_RCR_DRT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DRT field to a new value.
#define BW_ENET_RCR_DRT(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_DRT) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field MII_MODE[2] (RW)
 *
 * This field must always be set.
 *
 * Values:
 * - 0 - Reserved.
 * - 1 - MII or RMII mode, as indicated by the RMII_MODE field.
 */
//@{
#define BP_ENET_RCR_MII_MODE (2U)          //!< Bit position for ENET_RCR_MII_MODE.
#define BM_ENET_RCR_MII_MODE (0x00000004U) //!< Bit mask for ENET_RCR_MII_MODE.
#define BS_ENET_RCR_MII_MODE (1U)          //!< Bit field size in bits for ENET_RCR_MII_MODE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_MII_MODE field.
#define BR_ENET_RCR_MII_MODE(x) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_MII_MODE))
#endif

//! @brief Format value for bitfield ENET_RCR_MII_MODE.
#define BF_ENET_RCR_MII_MODE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_MII_MODE), uint32_t) & BM_ENET_RCR_MII_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MII_MODE field to a new value.
#define BW_ENET_RCR_MII_MODE(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_MII_MODE) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field PROM[3] (RW)
 *
 * All frames are accepted regardless of address matching.
 *
 * Values:
 * - 0 - Disabled.
 * - 1 - Enabled.
 */
//@{
#define BP_ENET_RCR_PROM     (3U)          //!< Bit position for ENET_RCR_PROM.
#define BM_ENET_RCR_PROM     (0x00000008U) //!< Bit mask for ENET_RCR_PROM.
#define BS_ENET_RCR_PROM     (1U)          //!< Bit field size in bits for ENET_RCR_PROM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_PROM field.
#define BR_ENET_RCR_PROM(x)  (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_PROM))
#endif

//! @brief Format value for bitfield ENET_RCR_PROM.
#define BF_ENET_RCR_PROM(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_PROM), uint32_t) & BM_ENET_RCR_PROM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PROM field to a new value.
#define BW_ENET_RCR_PROM(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_PROM) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field BC_REJ[4] (RW)
 *
 * If set, frames with destination address (DA) equal to 0xFFFF_FFFF_FFFF are
 * rejected unless the PROM field is set. If BC_REJ and PROM are set, frames with
 * broadcast DA are accepted and the MISS (M) is set in the receive buffer
 * descriptor.
 */
//@{
#define BP_ENET_RCR_BC_REJ   (4U)          //!< Bit position for ENET_RCR_BC_REJ.
#define BM_ENET_RCR_BC_REJ   (0x00000010U) //!< Bit mask for ENET_RCR_BC_REJ.
#define BS_ENET_RCR_BC_REJ   (1U)          //!< Bit field size in bits for ENET_RCR_BC_REJ.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_BC_REJ field.
#define BR_ENET_RCR_BC_REJ(x) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_BC_REJ))
#endif

//! @brief Format value for bitfield ENET_RCR_BC_REJ.
#define BF_ENET_RCR_BC_REJ(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_BC_REJ), uint32_t) & BM_ENET_RCR_BC_REJ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BC_REJ field to a new value.
#define BW_ENET_RCR_BC_REJ(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_BC_REJ) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field FCE[5] (RW)
 *
 * If set, the receiver detects PAUSE frames. Upon PAUSE frame detection, the
 * transmitter stops transmitting data frames for a given duration.
 */
//@{
#define BP_ENET_RCR_FCE      (5U)          //!< Bit position for ENET_RCR_FCE.
#define BM_ENET_RCR_FCE      (0x00000020U) //!< Bit mask for ENET_RCR_FCE.
#define BS_ENET_RCR_FCE      (1U)          //!< Bit field size in bits for ENET_RCR_FCE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_FCE field.
#define BR_ENET_RCR_FCE(x)   (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_FCE))
#endif

//! @brief Format value for bitfield ENET_RCR_FCE.
#define BF_ENET_RCR_FCE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_FCE), uint32_t) & BM_ENET_RCR_FCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FCE field to a new value.
#define BW_ENET_RCR_FCE(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_FCE) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field RMII_MODE[8] (RW)
 *
 * Specifies whether the MAC is configured for MII mode or RMII operation .
 *
 * Values:
 * - 0 - MAC configured for MII mode.
 * - 1 - MAC configured for RMII operation.
 */
//@{
#define BP_ENET_RCR_RMII_MODE (8U)         //!< Bit position for ENET_RCR_RMII_MODE.
#define BM_ENET_RCR_RMII_MODE (0x00000100U) //!< Bit mask for ENET_RCR_RMII_MODE.
#define BS_ENET_RCR_RMII_MODE (1U)         //!< Bit field size in bits for ENET_RCR_RMII_MODE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_RMII_MODE field.
#define BR_ENET_RCR_RMII_MODE(x) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_RMII_MODE))
#endif

//! @brief Format value for bitfield ENET_RCR_RMII_MODE.
#define BF_ENET_RCR_RMII_MODE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_RMII_MODE), uint32_t) & BM_ENET_RCR_RMII_MODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RMII_MODE field to a new value.
#define BW_ENET_RCR_RMII_MODE(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_RMII_MODE) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field RMII_10T[9] (RW)
 *
 * Enables 10-Mbps mode of the RMII .
 *
 * Values:
 * - 0 - 100 Mbps operation.
 * - 1 - 10 Mbps operation.
 */
//@{
#define BP_ENET_RCR_RMII_10T (9U)          //!< Bit position for ENET_RCR_RMII_10T.
#define BM_ENET_RCR_RMII_10T (0x00000200U) //!< Bit mask for ENET_RCR_RMII_10T.
#define BS_ENET_RCR_RMII_10T (1U)          //!< Bit field size in bits for ENET_RCR_RMII_10T.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_RMII_10T field.
#define BR_ENET_RCR_RMII_10T(x) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_RMII_10T))
#endif

//! @brief Format value for bitfield ENET_RCR_RMII_10T.
#define BF_ENET_RCR_RMII_10T(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_RMII_10T), uint32_t) & BM_ENET_RCR_RMII_10T)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RMII_10T field to a new value.
#define BW_ENET_RCR_RMII_10T(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_RMII_10T) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field PADEN[12] (RW)
 *
 * Specifies whether the MAC removes padding from received frames.
 *
 * Values:
 * - 0 - No padding is removed on receive by the MAC.
 * - 1 - Padding is removed from received frames.
 */
//@{
#define BP_ENET_RCR_PADEN    (12U)         //!< Bit position for ENET_RCR_PADEN.
#define BM_ENET_RCR_PADEN    (0x00001000U) //!< Bit mask for ENET_RCR_PADEN.
#define BS_ENET_RCR_PADEN    (1U)          //!< Bit field size in bits for ENET_RCR_PADEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_PADEN field.
#define BR_ENET_RCR_PADEN(x) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_PADEN))
#endif

//! @brief Format value for bitfield ENET_RCR_PADEN.
#define BF_ENET_RCR_PADEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_PADEN), uint32_t) & BM_ENET_RCR_PADEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PADEN field to a new value.
#define BW_ENET_RCR_PADEN(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_PADEN) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field PAUFWD[13] (RW)
 *
 * Specifies whether pause frames are terminated or forwarded.
 *
 * Values:
 * - 0 - Pause frames are terminated and discarded in the MAC.
 * - 1 - Pause frames are forwarded to the user application.
 */
//@{
#define BP_ENET_RCR_PAUFWD   (13U)         //!< Bit position for ENET_RCR_PAUFWD.
#define BM_ENET_RCR_PAUFWD   (0x00002000U) //!< Bit mask for ENET_RCR_PAUFWD.
#define BS_ENET_RCR_PAUFWD   (1U)          //!< Bit field size in bits for ENET_RCR_PAUFWD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_PAUFWD field.
#define BR_ENET_RCR_PAUFWD(x) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_PAUFWD))
#endif

//! @brief Format value for bitfield ENET_RCR_PAUFWD.
#define BF_ENET_RCR_PAUFWD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_PAUFWD), uint32_t) & BM_ENET_RCR_PAUFWD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PAUFWD field to a new value.
#define BW_ENET_RCR_PAUFWD(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_PAUFWD) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field CRCFWD[14] (RW)
 *
 * Specifies whether the CRC field of received frames is transmitted or
 * stripped. If padding function is enabled (PADEN = 1), CRCFWD is ignored and the CRC
 * field is checked and always terminated and removed.
 *
 * Values:
 * - 0 - The CRC field of received frames is transmitted to the user application.
 * - 1 - The CRC field is stripped from the frame.
 */
//@{
#define BP_ENET_RCR_CRCFWD   (14U)         //!< Bit position for ENET_RCR_CRCFWD.
#define BM_ENET_RCR_CRCFWD   (0x00004000U) //!< Bit mask for ENET_RCR_CRCFWD.
#define BS_ENET_RCR_CRCFWD   (1U)          //!< Bit field size in bits for ENET_RCR_CRCFWD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_CRCFWD field.
#define BR_ENET_RCR_CRCFWD(x) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_CRCFWD))
#endif

//! @brief Format value for bitfield ENET_RCR_CRCFWD.
#define BF_ENET_RCR_CRCFWD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_CRCFWD), uint32_t) & BM_ENET_RCR_CRCFWD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRCFWD field to a new value.
#define BW_ENET_RCR_CRCFWD(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_CRCFWD) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field CFEN[15] (RW)
 *
 * Enables/disables the MAC control frame.
 *
 * Values:
 * - 0 - MAC control frames with any opcode other than 0x0001 (pause frame) are
 *     accepted and forwarded to the client interface.
 * - 1 - MAC control frames with any opcode other than 0x0001 (pause frame) are
 *     silently discarded.
 */
//@{
#define BP_ENET_RCR_CFEN     (15U)         //!< Bit position for ENET_RCR_CFEN.
#define BM_ENET_RCR_CFEN     (0x00008000U) //!< Bit mask for ENET_RCR_CFEN.
#define BS_ENET_RCR_CFEN     (1U)          //!< Bit field size in bits for ENET_RCR_CFEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_CFEN field.
#define BR_ENET_RCR_CFEN(x)  (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_CFEN))
#endif

//! @brief Format value for bitfield ENET_RCR_CFEN.
#define BF_ENET_RCR_CFEN(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_CFEN), uint32_t) & BM_ENET_RCR_CFEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CFEN field to a new value.
#define BW_ENET_RCR_CFEN(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_CFEN) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field MAX_FL[29:16] (RW)
 *
 * Resets to decimal 1518. Length is measured starting at DA and includes the
 * CRC at the end of the frame. Transmit frames longer than MAX_FL cause the BABT
 * interrupt to occur. Receive frames longer than MAX_FL cause the BABR interrupt
 * to occur and set the LG field in the end of frame receive buffer descriptor.
 * The recommended default value to be programmed is 1518 or 1522 if VLAN tags are
 * supported.
 */
//@{
#define BP_ENET_RCR_MAX_FL   (16U)         //!< Bit position for ENET_RCR_MAX_FL.
#define BM_ENET_RCR_MAX_FL   (0x3FFF0000U) //!< Bit mask for ENET_RCR_MAX_FL.
#define BS_ENET_RCR_MAX_FL   (14U)         //!< Bit field size in bits for ENET_RCR_MAX_FL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_MAX_FL field.
#define BR_ENET_RCR_MAX_FL(x) (HW_ENET_RCR(x).B.MAX_FL)
#endif

//! @brief Format value for bitfield ENET_RCR_MAX_FL.
#define BF_ENET_RCR_MAX_FL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_MAX_FL), uint32_t) & BM_ENET_RCR_MAX_FL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MAX_FL field to a new value.
#define BW_ENET_RCR_MAX_FL(x, v) (HW_ENET_RCR_WR(x, (HW_ENET_RCR_RD(x) & ~BM_ENET_RCR_MAX_FL) | BF_ENET_RCR_MAX_FL(v)))
#endif
//@}

/*!
 * @name Register ENET_RCR, field NLC[30] (RW)
 *
 * Enables/disables a payload length check.
 *
 * Values:
 * - 0 - The payload length check is disabled.
 * - 1 - The core checks the frame's payload length with the frame length/type
 *     field. Errors are indicated in the EIR[PLC] field.
 */
//@{
#define BP_ENET_RCR_NLC      (30U)         //!< Bit position for ENET_RCR_NLC.
#define BM_ENET_RCR_NLC      (0x40000000U) //!< Bit mask for ENET_RCR_NLC.
#define BS_ENET_RCR_NLC      (1U)          //!< Bit field size in bits for ENET_RCR_NLC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_NLC field.
#define BR_ENET_RCR_NLC(x)   (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_NLC))
#endif

//! @brief Format value for bitfield ENET_RCR_NLC.
#define BF_ENET_RCR_NLC(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RCR_NLC), uint32_t) & BM_ENET_RCR_NLC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the NLC field to a new value.
#define BW_ENET_RCR_NLC(x, v) (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_NLC) = (v))
#endif
//@}

/*!
 * @name Register ENET_RCR, field GRS[31] (RO)
 *
 * Read-only status indicating that the MAC receive datapath is stopped.
 */
//@{
#define BP_ENET_RCR_GRS      (31U)         //!< Bit position for ENET_RCR_GRS.
#define BM_ENET_RCR_GRS      (0x80000000U) //!< Bit mask for ENET_RCR_GRS.
#define BS_ENET_RCR_GRS      (1U)          //!< Bit field size in bits for ENET_RCR_GRS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RCR_GRS field.
#define BR_ENET_RCR_GRS(x)   (BITBAND_ACCESS32(HW_ENET_RCR_ADDR(x), BP_ENET_RCR_GRS))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_TCR - Transmit Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_TCR - Transmit Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * TCR is read/write and configures the transmit block. This register is cleared
 * at system reset. FDEN can only be modified when ECR[ETHEREN] is cleared.
 */
typedef union _hw_enet_tcr
{
    uint32_t U;
    struct _hw_enet_tcr_bitfields
    {
        uint32_t GTS : 1;              //!< [0] Graceful Transmit Stop
        uint32_t RESERVED0 : 1;        //!< [1]
        uint32_t FDEN : 1;             //!< [2] Full-Duplex Enable
        uint32_t TFC_PAUSE : 1;        //!< [3] Transmit Frame Control Pause
        uint32_t RFC_PAUSE : 1;        //!< [4] Receive Frame Control Pause
        uint32_t ADDSEL : 3;           //!< [7:5] Source MAC Address Select On Transmit
        uint32_t ADDINS : 1;           //!< [8] Set MAC Address On Transmit
        uint32_t CRCFWD : 1;           //!< [9] Forward Frame From Application With CRC
        uint32_t RESERVED1 : 22;       //!< [31:10]
    } B;
} hw_enet_tcr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_TCR register
 */
//@{
#define HW_ENET_TCR_ADDR(x)      (REGS_ENET_BASE(x) + 0xC4U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_TCR(x)           (*(__IO hw_enet_tcr_t *) HW_ENET_TCR_ADDR(x))
#define HW_ENET_TCR_RD(x)        (HW_ENET_TCR(x).U)
#define HW_ENET_TCR_WR(x, v)     (HW_ENET_TCR(x).U = (v))
#define HW_ENET_TCR_SET(x, v)    (HW_ENET_TCR_WR(x, HW_ENET_TCR_RD(x) |  (v)))
#define HW_ENET_TCR_CLR(x, v)    (HW_ENET_TCR_WR(x, HW_ENET_TCR_RD(x) & ~(v)))
#define HW_ENET_TCR_TOG(x, v)    (HW_ENET_TCR_WR(x, HW_ENET_TCR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_TCR bitfields
 */

/*!
 * @name Register ENET_TCR, field GTS[0] (RW)
 *
 * When this field is set, MAC stops transmission after any frame currently
 * transmitted is complete and EIR[GRA] is set. If frame transmission is not
 * currently underway, the GRA interrupt is asserted immediately. After transmission
 * finishes, clear GTS to restart. The next frame in the transmit FIFO is then
 * transmitted. If an early collision occurs during transmission when GTS is set,
 * transmission stops after the collision. The frame is transmitted again after GTS is
 * cleared. There may be old frames in the transmit FIFO that transmit when GTS
 * is reasserted. To avoid this, clear ECR[ETHEREN] following the GRA interrupt.
 */
//@{
#define BP_ENET_TCR_GTS      (0U)          //!< Bit position for ENET_TCR_GTS.
#define BM_ENET_TCR_GTS      (0x00000001U) //!< Bit mask for ENET_TCR_GTS.
#define BS_ENET_TCR_GTS      (1U)          //!< Bit field size in bits for ENET_TCR_GTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TCR_GTS field.
#define BR_ENET_TCR_GTS(x)   (BITBAND_ACCESS32(HW_ENET_TCR_ADDR(x), BP_ENET_TCR_GTS))
#endif

//! @brief Format value for bitfield ENET_TCR_GTS.
#define BF_ENET_TCR_GTS(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TCR_GTS), uint32_t) & BM_ENET_TCR_GTS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GTS field to a new value.
#define BW_ENET_TCR_GTS(x, v) (BITBAND_ACCESS32(HW_ENET_TCR_ADDR(x), BP_ENET_TCR_GTS) = (v))
#endif
//@}

/*!
 * @name Register ENET_TCR, field FDEN[2] (RW)
 *
 * If this field is set, frames transmit independent of carrier sense and
 * collision inputs. Only modify this bit when ECR[ETHEREN] is cleared.
 */
//@{
#define BP_ENET_TCR_FDEN     (2U)          //!< Bit position for ENET_TCR_FDEN.
#define BM_ENET_TCR_FDEN     (0x00000004U) //!< Bit mask for ENET_TCR_FDEN.
#define BS_ENET_TCR_FDEN     (1U)          //!< Bit field size in bits for ENET_TCR_FDEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TCR_FDEN field.
#define BR_ENET_TCR_FDEN(x)  (BITBAND_ACCESS32(HW_ENET_TCR_ADDR(x), BP_ENET_TCR_FDEN))
#endif

//! @brief Format value for bitfield ENET_TCR_FDEN.
#define BF_ENET_TCR_FDEN(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TCR_FDEN), uint32_t) & BM_ENET_TCR_FDEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FDEN field to a new value.
#define BW_ENET_TCR_FDEN(x, v) (BITBAND_ACCESS32(HW_ENET_TCR_ADDR(x), BP_ENET_TCR_FDEN) = (v))
#endif
//@}

/*!
 * @name Register ENET_TCR, field TFC_PAUSE[3] (RW)
 *
 * Pauses frame transmission. When this field is set, EIR[GRA] is set. With
 * transmission of data frames stopped, the MAC transmits a MAC control PAUSE frame.
 * Next, the MAC clears TFC_PAUSE and resumes transmitting data frames. If the
 * transmitter pauses due to user assertion of GTS or reception of a PAUSE frame,
 * the MAC may continue transmitting a MAC control PAUSE frame.
 *
 * Values:
 * - 0 - No PAUSE frame transmitted.
 * - 1 - The MAC stops transmission of data frames after the current
 *     transmission is complete.
 */
//@{
#define BP_ENET_TCR_TFC_PAUSE (3U)         //!< Bit position for ENET_TCR_TFC_PAUSE.
#define BM_ENET_TCR_TFC_PAUSE (0x00000008U) //!< Bit mask for ENET_TCR_TFC_PAUSE.
#define BS_ENET_TCR_TFC_PAUSE (1U)         //!< Bit field size in bits for ENET_TCR_TFC_PAUSE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TCR_TFC_PAUSE field.
#define BR_ENET_TCR_TFC_PAUSE(x) (BITBAND_ACCESS32(HW_ENET_TCR_ADDR(x), BP_ENET_TCR_TFC_PAUSE))
#endif

//! @brief Format value for bitfield ENET_TCR_TFC_PAUSE.
#define BF_ENET_TCR_TFC_PAUSE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TCR_TFC_PAUSE), uint32_t) & BM_ENET_TCR_TFC_PAUSE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TFC_PAUSE field to a new value.
#define BW_ENET_TCR_TFC_PAUSE(x, v) (BITBAND_ACCESS32(HW_ENET_TCR_ADDR(x), BP_ENET_TCR_TFC_PAUSE) = (v))
#endif
//@}

/*!
 * @name Register ENET_TCR, field RFC_PAUSE[4] (RO)
 *
 * This status field is set when a full-duplex flow control pause frame is
 * received and the transmitter pauses for the duration defined in this pause frame.
 * This field automatically clears when the pause duration is complete.
 */
//@{
#define BP_ENET_TCR_RFC_PAUSE (4U)         //!< Bit position for ENET_TCR_RFC_PAUSE.
#define BM_ENET_TCR_RFC_PAUSE (0x00000010U) //!< Bit mask for ENET_TCR_RFC_PAUSE.
#define BS_ENET_TCR_RFC_PAUSE (1U)         //!< Bit field size in bits for ENET_TCR_RFC_PAUSE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TCR_RFC_PAUSE field.
#define BR_ENET_TCR_RFC_PAUSE(x) (BITBAND_ACCESS32(HW_ENET_TCR_ADDR(x), BP_ENET_TCR_RFC_PAUSE))
#endif
//@}

/*!
 * @name Register ENET_TCR, field ADDSEL[7:5] (RW)
 *
 * If ADDINS is set, indicates the MAC address that overwrites the source MAC
 * address.
 *
 * Values:
 * - 000 - Node MAC address programmed on PADDR1/2 registers.
 * - 100 - Reserved.
 * - 101 - Reserved.
 * - 110 - Reserved.
 */
//@{
#define BP_ENET_TCR_ADDSEL   (5U)          //!< Bit position for ENET_TCR_ADDSEL.
#define BM_ENET_TCR_ADDSEL   (0x000000E0U) //!< Bit mask for ENET_TCR_ADDSEL.
#define BS_ENET_TCR_ADDSEL   (3U)          //!< Bit field size in bits for ENET_TCR_ADDSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TCR_ADDSEL field.
#define BR_ENET_TCR_ADDSEL(x) (HW_ENET_TCR(x).B.ADDSEL)
#endif

//! @brief Format value for bitfield ENET_TCR_ADDSEL.
#define BF_ENET_TCR_ADDSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TCR_ADDSEL), uint32_t) & BM_ENET_TCR_ADDSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDSEL field to a new value.
#define BW_ENET_TCR_ADDSEL(x, v) (HW_ENET_TCR_WR(x, (HW_ENET_TCR_RD(x) & ~BM_ENET_TCR_ADDSEL) | BF_ENET_TCR_ADDSEL(v)))
#endif
//@}

/*!
 * @name Register ENET_TCR, field ADDINS[8] (RW)
 *
 * Values:
 * - 0 - The source MAC address is not modified by the MAC.
 * - 1 - The MAC overwrites the source MAC address with the programmed MAC
 *     address according to ADDSEL.
 */
//@{
#define BP_ENET_TCR_ADDINS   (8U)          //!< Bit position for ENET_TCR_ADDINS.
#define BM_ENET_TCR_ADDINS   (0x00000100U) //!< Bit mask for ENET_TCR_ADDINS.
#define BS_ENET_TCR_ADDINS   (1U)          //!< Bit field size in bits for ENET_TCR_ADDINS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TCR_ADDINS field.
#define BR_ENET_TCR_ADDINS(x) (BITBAND_ACCESS32(HW_ENET_TCR_ADDR(x), BP_ENET_TCR_ADDINS))
#endif

//! @brief Format value for bitfield ENET_TCR_ADDINS.
#define BF_ENET_TCR_ADDINS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TCR_ADDINS), uint32_t) & BM_ENET_TCR_ADDINS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDINS field to a new value.
#define BW_ENET_TCR_ADDINS(x, v) (BITBAND_ACCESS32(HW_ENET_TCR_ADDR(x), BP_ENET_TCR_ADDINS) = (v))
#endif
//@}

/*!
 * @name Register ENET_TCR, field CRCFWD[9] (RW)
 *
 * Values:
 * - 0 - TxBD[TC] controls whether the frame has a CRC from the application.
 * - 1 - The transmitter does not append any CRC to transmitted frames, as it is
 *     expecting a frame with CRC from the application.
 */
//@{
#define BP_ENET_TCR_CRCFWD   (9U)          //!< Bit position for ENET_TCR_CRCFWD.
#define BM_ENET_TCR_CRCFWD   (0x00000200U) //!< Bit mask for ENET_TCR_CRCFWD.
#define BS_ENET_TCR_CRCFWD   (1U)          //!< Bit field size in bits for ENET_TCR_CRCFWD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TCR_CRCFWD field.
#define BR_ENET_TCR_CRCFWD(x) (BITBAND_ACCESS32(HW_ENET_TCR_ADDR(x), BP_ENET_TCR_CRCFWD))
#endif

//! @brief Format value for bitfield ENET_TCR_CRCFWD.
#define BF_ENET_TCR_CRCFWD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TCR_CRCFWD), uint32_t) & BM_ENET_TCR_CRCFWD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRCFWD field to a new value.
#define BW_ENET_TCR_CRCFWD(x, v) (BITBAND_ACCESS32(HW_ENET_TCR_ADDR(x), BP_ENET_TCR_CRCFWD) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_PALR - Physical Address Lower Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_PALR - Physical Address Lower Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * PALR contains the lower 32 bits (bytes 0, 1, 2, 3) of the 48-bit address used
 * in the address recognition process to compare with the destination address
 * (DA) field of receive frames with an individual DA. In addition, this register
 * is used in bytes 0 through 3 of the six-byte source address field when
 * transmitting PAUSE frames. This register is not reset and you must initialize it.
 */
typedef union _hw_enet_palr
{
    uint32_t U;
    struct _hw_enet_palr_bitfields
    {
        uint32_t PADDR1 : 32;          //!< [31:0] Pause Address
    } B;
} hw_enet_palr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_PALR register
 */
//@{
#define HW_ENET_PALR_ADDR(x)     (REGS_ENET_BASE(x) + 0xE4U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_PALR(x)          (*(__IO hw_enet_palr_t *) HW_ENET_PALR_ADDR(x))
#define HW_ENET_PALR_RD(x)       (HW_ENET_PALR(x).U)
#define HW_ENET_PALR_WR(x, v)    (HW_ENET_PALR(x).U = (v))
#define HW_ENET_PALR_SET(x, v)   (HW_ENET_PALR_WR(x, HW_ENET_PALR_RD(x) |  (v)))
#define HW_ENET_PALR_CLR(x, v)   (HW_ENET_PALR_WR(x, HW_ENET_PALR_RD(x) & ~(v)))
#define HW_ENET_PALR_TOG(x, v)   (HW_ENET_PALR_WR(x, HW_ENET_PALR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_PALR bitfields
 */

/*!
 * @name Register ENET_PALR, field PADDR1[31:0] (RW)
 *
 * Bytes 0 (bits 31:24), 1 (bits 23:16), 2 (bits 15:8), and 3 (bits 7:0) of the
 * 6-byte individual address are used for exact match and the source address
 * field in PAUSE frames.
 */
//@{
#define BP_ENET_PALR_PADDR1  (0U)          //!< Bit position for ENET_PALR_PADDR1.
#define BM_ENET_PALR_PADDR1  (0xFFFFFFFFU) //!< Bit mask for ENET_PALR_PADDR1.
#define BS_ENET_PALR_PADDR1  (32U)         //!< Bit field size in bits for ENET_PALR_PADDR1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_PALR_PADDR1 field.
#define BR_ENET_PALR_PADDR1(x) (HW_ENET_PALR(x).U)
#endif

//! @brief Format value for bitfield ENET_PALR_PADDR1.
#define BF_ENET_PALR_PADDR1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_PALR_PADDR1), uint32_t) & BM_ENET_PALR_PADDR1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PADDR1 field to a new value.
#define BW_ENET_PALR_PADDR1(x, v) (HW_ENET_PALR_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_PAUR - Physical Address Upper Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_PAUR - Physical Address Upper Register (RW)
 *
 * Reset value: 0x00008808U
 *
 * PAUR contains the upper 16 bits (bytes 4 and 5) of the 48-bit address used in
 * the address recognition process to compare with the destination address (DA)
 * field of receive frames with an individual DA. In addition, this register is
 * used in bytes 4 and 5 of the six-byte source address field when transmitting
 * PAUSE frames. Bits 15:0 of PAUR contain a constant type field (0x8808) for
 * transmission of PAUSE frames. The upper 16 bits of this register are not reset and
 * you must initialize it.
 */
typedef union _hw_enet_paur
{
    uint32_t U;
    struct _hw_enet_paur_bitfields
    {
        uint32_t TYPE : 16;            //!< [15:0] Type Field In PAUSE Frames
        uint32_t PADDR2 : 16;          //!< [31:16]
    } B;
} hw_enet_paur_t;
#endif

/*!
 * @name Constants and macros for entire ENET_PAUR register
 */
//@{
#define HW_ENET_PAUR_ADDR(x)     (REGS_ENET_BASE(x) + 0xE8U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_PAUR(x)          (*(__IO hw_enet_paur_t *) HW_ENET_PAUR_ADDR(x))
#define HW_ENET_PAUR_RD(x)       (HW_ENET_PAUR(x).U)
#define HW_ENET_PAUR_WR(x, v)    (HW_ENET_PAUR(x).U = (v))
#define HW_ENET_PAUR_SET(x, v)   (HW_ENET_PAUR_WR(x, HW_ENET_PAUR_RD(x) |  (v)))
#define HW_ENET_PAUR_CLR(x, v)   (HW_ENET_PAUR_WR(x, HW_ENET_PAUR_RD(x) & ~(v)))
#define HW_ENET_PAUR_TOG(x, v)   (HW_ENET_PAUR_WR(x, HW_ENET_PAUR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_PAUR bitfields
 */

/*!
 * @name Register ENET_PAUR, field TYPE[15:0] (RO)
 *
 * These fields have a constant value of 0x8808.
 */
//@{
#define BP_ENET_PAUR_TYPE    (0U)          //!< Bit position for ENET_PAUR_TYPE.
#define BM_ENET_PAUR_TYPE    (0x0000FFFFU) //!< Bit mask for ENET_PAUR_TYPE.
#define BS_ENET_PAUR_TYPE    (16U)         //!< Bit field size in bits for ENET_PAUR_TYPE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_PAUR_TYPE field.
#define BR_ENET_PAUR_TYPE(x) (HW_ENET_PAUR(x).B.TYPE)
#endif
//@}

/*!
 * @name Register ENET_PAUR, field PADDR2[31:16] (RW)
 *
 * Bytes 4 (bits 31:24) and 5 (bits 23:16) of the 6-byte individual address used
 * for exact match, and the source address field in PAUSE frames.
 */
//@{
#define BP_ENET_PAUR_PADDR2  (16U)         //!< Bit position for ENET_PAUR_PADDR2.
#define BM_ENET_PAUR_PADDR2  (0xFFFF0000U) //!< Bit mask for ENET_PAUR_PADDR2.
#define BS_ENET_PAUR_PADDR2  (16U)         //!< Bit field size in bits for ENET_PAUR_PADDR2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_PAUR_PADDR2 field.
#define BR_ENET_PAUR_PADDR2(x) (HW_ENET_PAUR(x).B.PADDR2)
#endif

//! @brief Format value for bitfield ENET_PAUR_PADDR2.
#define BF_ENET_PAUR_PADDR2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_PAUR_PADDR2), uint32_t) & BM_ENET_PAUR_PADDR2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PADDR2 field to a new value.
#define BW_ENET_PAUR_PADDR2(x, v) (HW_ENET_PAUR_WR(x, (HW_ENET_PAUR_RD(x) & ~BM_ENET_PAUR_PADDR2) | BF_ENET_PAUR_PADDR2(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_OPD - Opcode/Pause Duration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_OPD - Opcode/Pause Duration Register (RW)
 *
 * Reset value: 0x00010000U
 *
 * OPD is read/write accessible. This register contains the 16-bit opcode and
 * 16-bit pause duration fields used in transmission of a PAUSE frame. The opcode
 * field is a constant value, 0x0001. When another node detects a PAUSE frame,
 * that node pauses transmission for the duration specified in the pause duration
 * field. The lower 16 bits of this register are not reset and you must initialize
 * it.
 */
typedef union _hw_enet_opd
{
    uint32_t U;
    struct _hw_enet_opd_bitfields
    {
        uint32_t PAUSE_DUR : 16;       //!< [15:0] Pause Duration
        uint32_t OPCODE : 16;          //!< [31:16] Opcode Field In PAUSE Frames
    } B;
} hw_enet_opd_t;
#endif

/*!
 * @name Constants and macros for entire ENET_OPD register
 */
//@{
#define HW_ENET_OPD_ADDR(x)      (REGS_ENET_BASE(x) + 0xECU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_OPD(x)           (*(__IO hw_enet_opd_t *) HW_ENET_OPD_ADDR(x))
#define HW_ENET_OPD_RD(x)        (HW_ENET_OPD(x).U)
#define HW_ENET_OPD_WR(x, v)     (HW_ENET_OPD(x).U = (v))
#define HW_ENET_OPD_SET(x, v)    (HW_ENET_OPD_WR(x, HW_ENET_OPD_RD(x) |  (v)))
#define HW_ENET_OPD_CLR(x, v)    (HW_ENET_OPD_WR(x, HW_ENET_OPD_RD(x) & ~(v)))
#define HW_ENET_OPD_TOG(x, v)    (HW_ENET_OPD_WR(x, HW_ENET_OPD_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_OPD bitfields
 */

/*!
 * @name Register ENET_OPD, field PAUSE_DUR[15:0] (RW)
 *
 * Pause duration field used in PAUSE frames.
 */
//@{
#define BP_ENET_OPD_PAUSE_DUR (0U)         //!< Bit position for ENET_OPD_PAUSE_DUR.
#define BM_ENET_OPD_PAUSE_DUR (0x0000FFFFU) //!< Bit mask for ENET_OPD_PAUSE_DUR.
#define BS_ENET_OPD_PAUSE_DUR (16U)        //!< Bit field size in bits for ENET_OPD_PAUSE_DUR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_OPD_PAUSE_DUR field.
#define BR_ENET_OPD_PAUSE_DUR(x) (HW_ENET_OPD(x).B.PAUSE_DUR)
#endif

//! @brief Format value for bitfield ENET_OPD_PAUSE_DUR.
#define BF_ENET_OPD_PAUSE_DUR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_OPD_PAUSE_DUR), uint32_t) & BM_ENET_OPD_PAUSE_DUR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PAUSE_DUR field to a new value.
#define BW_ENET_OPD_PAUSE_DUR(x, v) (HW_ENET_OPD_WR(x, (HW_ENET_OPD_RD(x) & ~BM_ENET_OPD_PAUSE_DUR) | BF_ENET_OPD_PAUSE_DUR(v)))
#endif
//@}

/*!
 * @name Register ENET_OPD, field OPCODE[31:16] (RO)
 *
 * These fields have a constant value of 0x0001.
 */
//@{
#define BP_ENET_OPD_OPCODE   (16U)         //!< Bit position for ENET_OPD_OPCODE.
#define BM_ENET_OPD_OPCODE   (0xFFFF0000U) //!< Bit mask for ENET_OPD_OPCODE.
#define BS_ENET_OPD_OPCODE   (16U)         //!< Bit field size in bits for ENET_OPD_OPCODE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_OPD_OPCODE field.
#define BR_ENET_OPD_OPCODE(x) (HW_ENET_OPD(x).B.OPCODE)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IAUR - Descriptor Individual Upper Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IAUR - Descriptor Individual Upper Address Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * IAUR contains the upper 32 bits of the 64-bit individual address hash table.
 * The address recognition process uses this table to check for a possible match
 * with the destination address (DA) field of receive frames with an individual
 * DA. This register is not reset and you must initialize it.
 */
typedef union _hw_enet_iaur
{
    uint32_t U;
    struct _hw_enet_iaur_bitfields
    {
        uint32_t IADDR1 : 32;          //!< [31:0]
    } B;
} hw_enet_iaur_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IAUR register
 */
//@{
#define HW_ENET_IAUR_ADDR(x)     (REGS_ENET_BASE(x) + 0x118U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IAUR(x)          (*(__IO hw_enet_iaur_t *) HW_ENET_IAUR_ADDR(x))
#define HW_ENET_IAUR_RD(x)       (HW_ENET_IAUR(x).U)
#define HW_ENET_IAUR_WR(x, v)    (HW_ENET_IAUR(x).U = (v))
#define HW_ENET_IAUR_SET(x, v)   (HW_ENET_IAUR_WR(x, HW_ENET_IAUR_RD(x) |  (v)))
#define HW_ENET_IAUR_CLR(x, v)   (HW_ENET_IAUR_WR(x, HW_ENET_IAUR_RD(x) & ~(v)))
#define HW_ENET_IAUR_TOG(x, v)   (HW_ENET_IAUR_WR(x, HW_ENET_IAUR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_IAUR bitfields
 */

/*!
 * @name Register ENET_IAUR, field IADDR1[31:0] (RW)
 *
 * Contains the upper 32 bits of the 64-bit hash table used in the address
 * recognition process for receive frames with a unicast address. Bit 31 of IADDR1
 * contains hash index bit 63. Bit 0 of IADDR1 contains hash index bit 32.
 */
//@{
#define BP_ENET_IAUR_IADDR1  (0U)          //!< Bit position for ENET_IAUR_IADDR1.
#define BM_ENET_IAUR_IADDR1  (0xFFFFFFFFU) //!< Bit mask for ENET_IAUR_IADDR1.
#define BS_ENET_IAUR_IADDR1  (32U)         //!< Bit field size in bits for ENET_IAUR_IADDR1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IAUR_IADDR1 field.
#define BR_ENET_IAUR_IADDR1(x) (HW_ENET_IAUR(x).U)
#endif

//! @brief Format value for bitfield ENET_IAUR_IADDR1.
#define BF_ENET_IAUR_IADDR1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_IAUR_IADDR1), uint32_t) & BM_ENET_IAUR_IADDR1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IADDR1 field to a new value.
#define BW_ENET_IAUR_IADDR1(x, v) (HW_ENET_IAUR_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IALR - Descriptor Individual Lower Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IALR - Descriptor Individual Lower Address Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * IALR contains the lower 32 bits of the 64-bit individual address hash table.
 * The address recognition process uses this table to check for a possible match
 * with the DA field of receive frames with an individual DA. This register is
 * not reset and you must initialize it.
 */
typedef union _hw_enet_ialr
{
    uint32_t U;
    struct _hw_enet_ialr_bitfields
    {
        uint32_t IADDR2 : 32;          //!< [31:0]
    } B;
} hw_enet_ialr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IALR register
 */
//@{
#define HW_ENET_IALR_ADDR(x)     (REGS_ENET_BASE(x) + 0x11CU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IALR(x)          (*(__IO hw_enet_ialr_t *) HW_ENET_IALR_ADDR(x))
#define HW_ENET_IALR_RD(x)       (HW_ENET_IALR(x).U)
#define HW_ENET_IALR_WR(x, v)    (HW_ENET_IALR(x).U = (v))
#define HW_ENET_IALR_SET(x, v)   (HW_ENET_IALR_WR(x, HW_ENET_IALR_RD(x) |  (v)))
#define HW_ENET_IALR_CLR(x, v)   (HW_ENET_IALR_WR(x, HW_ENET_IALR_RD(x) & ~(v)))
#define HW_ENET_IALR_TOG(x, v)   (HW_ENET_IALR_WR(x, HW_ENET_IALR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_IALR bitfields
 */

/*!
 * @name Register ENET_IALR, field IADDR2[31:0] (RW)
 *
 * Contains the lower 32 bits of the 64-bit hash table used in the address
 * recognition process for receive frames with a unicast address. Bit 31 of IADDR2
 * contains hash index bit 31. Bit 0 of IADDR2 contains hash index bit 0.
 */
//@{
#define BP_ENET_IALR_IADDR2  (0U)          //!< Bit position for ENET_IALR_IADDR2.
#define BM_ENET_IALR_IADDR2  (0xFFFFFFFFU) //!< Bit mask for ENET_IALR_IADDR2.
#define BS_ENET_IALR_IADDR2  (32U)         //!< Bit field size in bits for ENET_IALR_IADDR2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IALR_IADDR2 field.
#define BR_ENET_IALR_IADDR2(x) (HW_ENET_IALR(x).U)
#endif

//! @brief Format value for bitfield ENET_IALR_IADDR2.
#define BF_ENET_IALR_IADDR2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_IALR_IADDR2), uint32_t) & BM_ENET_IALR_IADDR2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IADDR2 field to a new value.
#define BW_ENET_IALR_IADDR2(x, v) (HW_ENET_IALR_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_GAUR - Descriptor Group Upper Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_GAUR - Descriptor Group Upper Address Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * GAUR contains the upper 32 bits of the 64-bit hash table used in the address
 * recognition process for receive frames with a multicast address. You must
 * initialize this register.
 */
typedef union _hw_enet_gaur
{
    uint32_t U;
    struct _hw_enet_gaur_bitfields
    {
        uint32_t GADDR1 : 32;          //!< [31:0]
    } B;
} hw_enet_gaur_t;
#endif

/*!
 * @name Constants and macros for entire ENET_GAUR register
 */
//@{
#define HW_ENET_GAUR_ADDR(x)     (REGS_ENET_BASE(x) + 0x120U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_GAUR(x)          (*(__IO hw_enet_gaur_t *) HW_ENET_GAUR_ADDR(x))
#define HW_ENET_GAUR_RD(x)       (HW_ENET_GAUR(x).U)
#define HW_ENET_GAUR_WR(x, v)    (HW_ENET_GAUR(x).U = (v))
#define HW_ENET_GAUR_SET(x, v)   (HW_ENET_GAUR_WR(x, HW_ENET_GAUR_RD(x) |  (v)))
#define HW_ENET_GAUR_CLR(x, v)   (HW_ENET_GAUR_WR(x, HW_ENET_GAUR_RD(x) & ~(v)))
#define HW_ENET_GAUR_TOG(x, v)   (HW_ENET_GAUR_WR(x, HW_ENET_GAUR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_GAUR bitfields
 */

/*!
 * @name Register ENET_GAUR, field GADDR1[31:0] (RW)
 *
 * Contains the upper 32 bits of the 64-bit hash table used in the address
 * recognition process for receive frames with a multicast address. Bit 31 of GADDR1
 * contains hash index bit 63. Bit 0 of GADDR1 contains hash index bit 32.
 */
//@{
#define BP_ENET_GAUR_GADDR1  (0U)          //!< Bit position for ENET_GAUR_GADDR1.
#define BM_ENET_GAUR_GADDR1  (0xFFFFFFFFU) //!< Bit mask for ENET_GAUR_GADDR1.
#define BS_ENET_GAUR_GADDR1  (32U)         //!< Bit field size in bits for ENET_GAUR_GADDR1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_GAUR_GADDR1 field.
#define BR_ENET_GAUR_GADDR1(x) (HW_ENET_GAUR(x).U)
#endif

//! @brief Format value for bitfield ENET_GAUR_GADDR1.
#define BF_ENET_GAUR_GADDR1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_GAUR_GADDR1), uint32_t) & BM_ENET_GAUR_GADDR1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GADDR1 field to a new value.
#define BW_ENET_GAUR_GADDR1(x, v) (HW_ENET_GAUR_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_GALR - Descriptor Group Lower Address Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_GALR - Descriptor Group Lower Address Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * GALR contains the lower 32 bits of the 64-bit hash table used in the address
 * recognition process for receive frames with a multicast address. You must
 * initialize this register.
 */
typedef union _hw_enet_galr
{
    uint32_t U;
    struct _hw_enet_galr_bitfields
    {
        uint32_t GADDR2 : 32;          //!< [31:0]
    } B;
} hw_enet_galr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_GALR register
 */
//@{
#define HW_ENET_GALR_ADDR(x)     (REGS_ENET_BASE(x) + 0x124U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_GALR(x)          (*(__IO hw_enet_galr_t *) HW_ENET_GALR_ADDR(x))
#define HW_ENET_GALR_RD(x)       (HW_ENET_GALR(x).U)
#define HW_ENET_GALR_WR(x, v)    (HW_ENET_GALR(x).U = (v))
#define HW_ENET_GALR_SET(x, v)   (HW_ENET_GALR_WR(x, HW_ENET_GALR_RD(x) |  (v)))
#define HW_ENET_GALR_CLR(x, v)   (HW_ENET_GALR_WR(x, HW_ENET_GALR_RD(x) & ~(v)))
#define HW_ENET_GALR_TOG(x, v)   (HW_ENET_GALR_WR(x, HW_ENET_GALR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_GALR bitfields
 */

/*!
 * @name Register ENET_GALR, field GADDR2[31:0] (RW)
 *
 * Contains the lower 32 bits of the 64-bit hash table used in the address
 * recognition process for receive frames with a multicast address. Bit 31 of GADDR2
 * contains hash index bit 31. Bit 0 of GADDR2 contains hash index bit 0.
 */
//@{
#define BP_ENET_GALR_GADDR2  (0U)          //!< Bit position for ENET_GALR_GADDR2.
#define BM_ENET_GALR_GADDR2  (0xFFFFFFFFU) //!< Bit mask for ENET_GALR_GADDR2.
#define BS_ENET_GALR_GADDR2  (32U)         //!< Bit field size in bits for ENET_GALR_GADDR2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_GALR_GADDR2 field.
#define BR_ENET_GALR_GADDR2(x) (HW_ENET_GALR(x).U)
#endif

//! @brief Format value for bitfield ENET_GALR_GADDR2.
#define BF_ENET_GALR_GADDR2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_GALR_GADDR2), uint32_t) & BM_ENET_GALR_GADDR2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GADDR2 field to a new value.
#define BW_ENET_GALR_GADDR2(x, v) (HW_ENET_GALR_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_TFWR - Transmit FIFO Watermark Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_TFWR - Transmit FIFO Watermark Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * If TFWR[STRFWD] is cleared, TFWR[TFWR] controls the amount of data required
 * in the transmit FIFO before transmission of a frame can begin. This allows you
 * to minimize transmit latency (TFWR = 00 or 01) or allow for larger bus access
 * latency (TFWR = 11) due to contention for the system bus. Setting the
 * watermark to a high value minimizes the risk of transmit FIFO underrun due to
 * contention for the system bus. The byte counts associated with the TFWR field may need
 * to be modified to match a given system requirement. For example, worst case
 * bus access latency by the transmit data DMA channel. When the FIFO level
 * reaches the value the TFWR field and when the STR_FWD is set to '0', the MAC
 * transmit control logic starts frame transmission even before the end-of-frame is
 * available in the FIFO (cut-through operation). If a complete frame has a size
 * smaller than the threshold programmed with TFWR, the MAC also transmits the Frame
 * to the line. To enable store and forward on the Transmit path, set STR_FWD to
 * '1'. In this case, the MAC starts to transmit data only when a complete frame
 * is stored in the Transmit FIFO.
 */
typedef union _hw_enet_tfwr
{
    uint32_t U;
    struct _hw_enet_tfwr_bitfields
    {
        uint32_t TFWR : 6;             //!< [5:0] Transmit FIFO Write
        uint32_t RESERVED0 : 2;        //!< [7:6]
        uint32_t STRFWD : 1;           //!< [8] Store And Forward Enable
        uint32_t RESERVED1 : 23;       //!< [31:9]
    } B;
} hw_enet_tfwr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_TFWR register
 */
//@{
#define HW_ENET_TFWR_ADDR(x)     (REGS_ENET_BASE(x) + 0x144U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_TFWR(x)          (*(__IO hw_enet_tfwr_t *) HW_ENET_TFWR_ADDR(x))
#define HW_ENET_TFWR_RD(x)       (HW_ENET_TFWR(x).U)
#define HW_ENET_TFWR_WR(x, v)    (HW_ENET_TFWR(x).U = (v))
#define HW_ENET_TFWR_SET(x, v)   (HW_ENET_TFWR_WR(x, HW_ENET_TFWR_RD(x) |  (v)))
#define HW_ENET_TFWR_CLR(x, v)   (HW_ENET_TFWR_WR(x, HW_ENET_TFWR_RD(x) & ~(v)))
#define HW_ENET_TFWR_TOG(x, v)   (HW_ENET_TFWR_WR(x, HW_ENET_TFWR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_TFWR bitfields
 */

/*!
 * @name Register ENET_TFWR, field TFWR[5:0] (RW)
 *
 * If TFWR[STRFWD] is cleared, this field indicates the number of bytes, in
 * steps of 64 bytes, written to the transmit FIFO before transmission of a frame
 * begins. If a frame with less than the threshold is written, it is still sent
 * independently of this threshold setting. The threshold is relevant only if the
 * frame is larger than the threshold given. This chip may not support the maximum
 * number of bytes written shown below. See the chip-specific information for the
 * ENET module for this value.
 *
 * Values:
 * - 000000 - 64 bytes written.
 * - 000001 - 64 bytes written.
 * - 000010 - 128 bytes written.
 * - 000011 - 192 bytes written.
 * - 111110 - 3968 bytes written.
 * - 111111 - 4032 bytes written.
 */
//@{
#define BP_ENET_TFWR_TFWR    (0U)          //!< Bit position for ENET_TFWR_TFWR.
#define BM_ENET_TFWR_TFWR    (0x0000003FU) //!< Bit mask for ENET_TFWR_TFWR.
#define BS_ENET_TFWR_TFWR    (6U)          //!< Bit field size in bits for ENET_TFWR_TFWR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TFWR_TFWR field.
#define BR_ENET_TFWR_TFWR(x) (HW_ENET_TFWR(x).B.TFWR)
#endif

//! @brief Format value for bitfield ENET_TFWR_TFWR.
#define BF_ENET_TFWR_TFWR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TFWR_TFWR), uint32_t) & BM_ENET_TFWR_TFWR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TFWR field to a new value.
#define BW_ENET_TFWR_TFWR(x, v) (HW_ENET_TFWR_WR(x, (HW_ENET_TFWR_RD(x) & ~BM_ENET_TFWR_TFWR) | BF_ENET_TFWR_TFWR(v)))
#endif
//@}

/*!
 * @name Register ENET_TFWR, field STRFWD[8] (RW)
 *
 * Values:
 * - 0 - Reset. The transmission start threshold is programmed in TFWR[TFWR].
 * - 1 - Enabled.
 */
//@{
#define BP_ENET_TFWR_STRFWD  (8U)          //!< Bit position for ENET_TFWR_STRFWD.
#define BM_ENET_TFWR_STRFWD  (0x00000100U) //!< Bit mask for ENET_TFWR_STRFWD.
#define BS_ENET_TFWR_STRFWD  (1U)          //!< Bit field size in bits for ENET_TFWR_STRFWD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TFWR_STRFWD field.
#define BR_ENET_TFWR_STRFWD(x) (BITBAND_ACCESS32(HW_ENET_TFWR_ADDR(x), BP_ENET_TFWR_STRFWD))
#endif

//! @brief Format value for bitfield ENET_TFWR_STRFWD.
#define BF_ENET_TFWR_STRFWD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TFWR_STRFWD), uint32_t) & BM_ENET_TFWR_STRFWD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STRFWD field to a new value.
#define BW_ENET_TFWR_STRFWD(x, v) (BITBAND_ACCESS32(HW_ENET_TFWR_ADDR(x), BP_ENET_TFWR_STRFWD) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RDSR - Receive Descriptor Ring Start Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RDSR - Receive Descriptor Ring Start Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * RDSR points to the beginning of the circular receive buffer descriptor queue
 * in external memory. This pointer must be 64-bit aligned (bits 2-0 must be
 * zero); however, it is recommended to be 128-bit aligned, that is, evenly divisible
 * by 16. This register must be initialized prior to operation
 */
typedef union _hw_enet_rdsr
{
    uint32_t U;
    struct _hw_enet_rdsr_bitfields
    {
        uint32_t RESERVED0 : 3;        //!< [2:0]
        uint32_t R_DES_START : 29;     //!< [31:3]
    } B;
} hw_enet_rdsr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RDSR register
 */
//@{
#define HW_ENET_RDSR_ADDR(x)     (REGS_ENET_BASE(x) + 0x180U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RDSR(x)          (*(__IO hw_enet_rdsr_t *) HW_ENET_RDSR_ADDR(x))
#define HW_ENET_RDSR_RD(x)       (HW_ENET_RDSR(x).U)
#define HW_ENET_RDSR_WR(x, v)    (HW_ENET_RDSR(x).U = (v))
#define HW_ENET_RDSR_SET(x, v)   (HW_ENET_RDSR_WR(x, HW_ENET_RDSR_RD(x) |  (v)))
#define HW_ENET_RDSR_CLR(x, v)   (HW_ENET_RDSR_WR(x, HW_ENET_RDSR_RD(x) & ~(v)))
#define HW_ENET_RDSR_TOG(x, v)   (HW_ENET_RDSR_WR(x, HW_ENET_RDSR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_RDSR bitfields
 */

/*!
 * @name Register ENET_RDSR, field R_DES_START[31:3] (RW)
 *
 * Pointer to the beginning of the receive buffer descriptor queue.
 */
//@{
#define BP_ENET_RDSR_R_DES_START (3U)      //!< Bit position for ENET_RDSR_R_DES_START.
#define BM_ENET_RDSR_R_DES_START (0xFFFFFFF8U) //!< Bit mask for ENET_RDSR_R_DES_START.
#define BS_ENET_RDSR_R_DES_START (29U)     //!< Bit field size in bits for ENET_RDSR_R_DES_START.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RDSR_R_DES_START field.
#define BR_ENET_RDSR_R_DES_START(x) (HW_ENET_RDSR(x).B.R_DES_START)
#endif

//! @brief Format value for bitfield ENET_RDSR_R_DES_START.
#define BF_ENET_RDSR_R_DES_START(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RDSR_R_DES_START), uint32_t) & BM_ENET_RDSR_R_DES_START)

#ifndef __LANGUAGE_ASM__
//! @brief Set the R_DES_START field to a new value.
#define BW_ENET_RDSR_R_DES_START(x, v) (HW_ENET_RDSR_WR(x, (HW_ENET_RDSR_RD(x) & ~BM_ENET_RDSR_R_DES_START) | BF_ENET_RDSR_R_DES_START(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_TDSR - Transmit Buffer Descriptor Ring Start Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_TDSR - Transmit Buffer Descriptor Ring Start Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * TDSR provides a pointer to the beginning of the circular transmit buffer
 * descriptor queue in external memory. This pointer must be 64-bit aligned (bits 2-0
 * must be zero); however, it is recommended to be 128-bit aligned, that is,
 * evenly divisible by 16. This register must be initialized prior to operation.
 */
typedef union _hw_enet_tdsr
{
    uint32_t U;
    struct _hw_enet_tdsr_bitfields
    {
        uint32_t RESERVED0 : 3;        //!< [2:0]
        uint32_t X_DES_START : 29;     //!< [31:3]
    } B;
} hw_enet_tdsr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_TDSR register
 */
//@{
#define HW_ENET_TDSR_ADDR(x)     (REGS_ENET_BASE(x) + 0x184U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_TDSR(x)          (*(__IO hw_enet_tdsr_t *) HW_ENET_TDSR_ADDR(x))
#define HW_ENET_TDSR_RD(x)       (HW_ENET_TDSR(x).U)
#define HW_ENET_TDSR_WR(x, v)    (HW_ENET_TDSR(x).U = (v))
#define HW_ENET_TDSR_SET(x, v)   (HW_ENET_TDSR_WR(x, HW_ENET_TDSR_RD(x) |  (v)))
#define HW_ENET_TDSR_CLR(x, v)   (HW_ENET_TDSR_WR(x, HW_ENET_TDSR_RD(x) & ~(v)))
#define HW_ENET_TDSR_TOG(x, v)   (HW_ENET_TDSR_WR(x, HW_ENET_TDSR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_TDSR bitfields
 */

/*!
 * @name Register ENET_TDSR, field X_DES_START[31:3] (RW)
 *
 * Pointer to the beginning of the transmit buffer descriptor queue.
 */
//@{
#define BP_ENET_TDSR_X_DES_START (3U)      //!< Bit position for ENET_TDSR_X_DES_START.
#define BM_ENET_TDSR_X_DES_START (0xFFFFFFF8U) //!< Bit mask for ENET_TDSR_X_DES_START.
#define BS_ENET_TDSR_X_DES_START (29U)     //!< Bit field size in bits for ENET_TDSR_X_DES_START.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TDSR_X_DES_START field.
#define BR_ENET_TDSR_X_DES_START(x) (HW_ENET_TDSR(x).B.X_DES_START)
#endif

//! @brief Format value for bitfield ENET_TDSR_X_DES_START.
#define BF_ENET_TDSR_X_DES_START(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TDSR_X_DES_START), uint32_t) & BM_ENET_TDSR_X_DES_START)

#ifndef __LANGUAGE_ASM__
//! @brief Set the X_DES_START field to a new value.
#define BW_ENET_TDSR_X_DES_START(x, v) (HW_ENET_TDSR_WR(x, (HW_ENET_TDSR_RD(x) & ~BM_ENET_TDSR_X_DES_START) | BF_ENET_TDSR_X_DES_START(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_MRBR - Maximum Receive Buffer Size Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_MRBR - Maximum Receive Buffer Size Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MRBR is a user-programmable register that dictates the maximum size of
 * all receive buffers. This value should take into consideration that the receive
 * CRC is always written into the last receive buffer. To allow one maximum size
 * frame per buffer, MRBR must be set to RCR[MAX_FL] or larger. To properly align
 * the buffer, MRBR must be evenly divisible by 16. To ensure this, bits 3-0 are
 * set to zero by the device. To minimize bus usage (descriptor fetches), set
 * MRBR greater than or equal to 256 bytes. This register must be initialized
 * before operation.
 */
typedef union _hw_enet_mrbr
{
    uint32_t U;
    struct _hw_enet_mrbr_bitfields
    {
        uint32_t RESERVED0 : 4;        //!< [3:0]
        uint32_t R_BUF_SIZE : 10;      //!< [13:4]
        uint32_t RESERVED1 : 18;       //!< [31:14]
    } B;
} hw_enet_mrbr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_MRBR register
 */
//@{
#define HW_ENET_MRBR_ADDR(x)     (REGS_ENET_BASE(x) + 0x188U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_MRBR(x)          (*(__IO hw_enet_mrbr_t *) HW_ENET_MRBR_ADDR(x))
#define HW_ENET_MRBR_RD(x)       (HW_ENET_MRBR(x).U)
#define HW_ENET_MRBR_WR(x, v)    (HW_ENET_MRBR(x).U = (v))
#define HW_ENET_MRBR_SET(x, v)   (HW_ENET_MRBR_WR(x, HW_ENET_MRBR_RD(x) |  (v)))
#define HW_ENET_MRBR_CLR(x, v)   (HW_ENET_MRBR_WR(x, HW_ENET_MRBR_RD(x) & ~(v)))
#define HW_ENET_MRBR_TOG(x, v)   (HW_ENET_MRBR_WR(x, HW_ENET_MRBR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_MRBR bitfields
 */

/*!
 * @name Register ENET_MRBR, field R_BUF_SIZE[13:4] (RW)
 *
 * Receive buffer size in bytes.
 */
//@{
#define BP_ENET_MRBR_R_BUF_SIZE (4U)       //!< Bit position for ENET_MRBR_R_BUF_SIZE.
#define BM_ENET_MRBR_R_BUF_SIZE (0x00003FF0U) //!< Bit mask for ENET_MRBR_R_BUF_SIZE.
#define BS_ENET_MRBR_R_BUF_SIZE (10U)      //!< Bit field size in bits for ENET_MRBR_R_BUF_SIZE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_MRBR_R_BUF_SIZE field.
#define BR_ENET_MRBR_R_BUF_SIZE(x) (HW_ENET_MRBR(x).B.R_BUF_SIZE)
#endif

//! @brief Format value for bitfield ENET_MRBR_R_BUF_SIZE.
#define BF_ENET_MRBR_R_BUF_SIZE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_MRBR_R_BUF_SIZE), uint32_t) & BM_ENET_MRBR_R_BUF_SIZE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the R_BUF_SIZE field to a new value.
#define BW_ENET_MRBR_R_BUF_SIZE(x, v) (HW_ENET_MRBR_WR(x, (HW_ENET_MRBR_RD(x) & ~BM_ENET_MRBR_R_BUF_SIZE) | BF_ENET_MRBR_R_BUF_SIZE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RSFL - Receive FIFO Section Full Threshold
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RSFL - Receive FIFO Section Full Threshold (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rsfl
{
    uint32_t U;
    struct _hw_enet_rsfl_bitfields
    {
        uint32_t RX_SECTION_FULL : 8;  //!< [7:0] Value Of Receive FIFO
                                       //! Section Full Threshold
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_enet_rsfl_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RSFL register
 */
//@{
#define HW_ENET_RSFL_ADDR(x)     (REGS_ENET_BASE(x) + 0x190U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RSFL(x)          (*(__IO hw_enet_rsfl_t *) HW_ENET_RSFL_ADDR(x))
#define HW_ENET_RSFL_RD(x)       (HW_ENET_RSFL(x).U)
#define HW_ENET_RSFL_WR(x, v)    (HW_ENET_RSFL(x).U = (v))
#define HW_ENET_RSFL_SET(x, v)   (HW_ENET_RSFL_WR(x, HW_ENET_RSFL_RD(x) |  (v)))
#define HW_ENET_RSFL_CLR(x, v)   (HW_ENET_RSFL_WR(x, HW_ENET_RSFL_RD(x) & ~(v)))
#define HW_ENET_RSFL_TOG(x, v)   (HW_ENET_RSFL_WR(x, HW_ENET_RSFL_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_RSFL bitfields
 */

/*!
 * @name Register ENET_RSFL, field RX_SECTION_FULL[7:0] (RW)
 *
 * Value, in 64-bit words, of the receive FIFO section full threshold. Clear
 * this field to enable store and forward on the RX FIFO. When programming a value
 * greater than 0 (cut-through operation), it must be greater than
 * RAEM[RX_ALMOST_EMPTY]. When the FIFO level reaches the value in this field, data is available
 * in the Receive FIFO (cut-through operation).
 */
//@{
#define BP_ENET_RSFL_RX_SECTION_FULL (0U)  //!< Bit position for ENET_RSFL_RX_SECTION_FULL.
#define BM_ENET_RSFL_RX_SECTION_FULL (0x000000FFU) //!< Bit mask for ENET_RSFL_RX_SECTION_FULL.
#define BS_ENET_RSFL_RX_SECTION_FULL (8U)  //!< Bit field size in bits for ENET_RSFL_RX_SECTION_FULL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RSFL_RX_SECTION_FULL field.
#define BR_ENET_RSFL_RX_SECTION_FULL(x) (HW_ENET_RSFL(x).B.RX_SECTION_FULL)
#endif

//! @brief Format value for bitfield ENET_RSFL_RX_SECTION_FULL.
#define BF_ENET_RSFL_RX_SECTION_FULL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RSFL_RX_SECTION_FULL), uint32_t) & BM_ENET_RSFL_RX_SECTION_FULL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SECTION_FULL field to a new value.
#define BW_ENET_RSFL_RX_SECTION_FULL(x, v) (HW_ENET_RSFL_WR(x, (HW_ENET_RSFL_RD(x) & ~BM_ENET_RSFL_RX_SECTION_FULL) | BF_ENET_RSFL_RX_SECTION_FULL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RSEM - Receive FIFO Section Empty Threshold
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RSEM - Receive FIFO Section Empty Threshold (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rsem
{
    uint32_t U;
    struct _hw_enet_rsem_bitfields
    {
        uint32_t RX_SECTION_EMPTY : 8; //!< [7:0] Value Of The Receive FIFO
                                       //! Section Empty Threshold
        uint32_t RESERVED0 : 8;        //!< [15:8]
        uint32_t STAT_SECTION_EMPTY : 5; //!< [20:16] RX Status FIFO Section
                                       //! Empty Threshold
        uint32_t RESERVED1 : 11;       //!< [31:21]
    } B;
} hw_enet_rsem_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RSEM register
 */
//@{
#define HW_ENET_RSEM_ADDR(x)     (REGS_ENET_BASE(x) + 0x194U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RSEM(x)          (*(__IO hw_enet_rsem_t *) HW_ENET_RSEM_ADDR(x))
#define HW_ENET_RSEM_RD(x)       (HW_ENET_RSEM(x).U)
#define HW_ENET_RSEM_WR(x, v)    (HW_ENET_RSEM(x).U = (v))
#define HW_ENET_RSEM_SET(x, v)   (HW_ENET_RSEM_WR(x, HW_ENET_RSEM_RD(x) |  (v)))
#define HW_ENET_RSEM_CLR(x, v)   (HW_ENET_RSEM_WR(x, HW_ENET_RSEM_RD(x) & ~(v)))
#define HW_ENET_RSEM_TOG(x, v)   (HW_ENET_RSEM_WR(x, HW_ENET_RSEM_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_RSEM bitfields
 */

/*!
 * @name Register ENET_RSEM, field RX_SECTION_EMPTY[7:0] (RW)
 *
 * Value, in 64-bit words, of the receive FIFO section empty threshold. When the
 * FIFO has reached this level, a pause frame will be issued. A value of 0
 * disables automatic pause frame generation. When the FIFO level goes below the value
 * programmed in this field, an XON pause frame is issued to indicate the FIFO
 * congestion is cleared to the remote Ethernet client. The section-empty
 * threshold indications from both FIFOs are OR'ed to cause XOFF pause frame generation.
 */
//@{
#define BP_ENET_RSEM_RX_SECTION_EMPTY (0U) //!< Bit position for ENET_RSEM_RX_SECTION_EMPTY.
#define BM_ENET_RSEM_RX_SECTION_EMPTY (0x000000FFU) //!< Bit mask for ENET_RSEM_RX_SECTION_EMPTY.
#define BS_ENET_RSEM_RX_SECTION_EMPTY (8U) //!< Bit field size in bits for ENET_RSEM_RX_SECTION_EMPTY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RSEM_RX_SECTION_EMPTY field.
#define BR_ENET_RSEM_RX_SECTION_EMPTY(x) (HW_ENET_RSEM(x).B.RX_SECTION_EMPTY)
#endif

//! @brief Format value for bitfield ENET_RSEM_RX_SECTION_EMPTY.
#define BF_ENET_RSEM_RX_SECTION_EMPTY(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RSEM_RX_SECTION_EMPTY), uint32_t) & BM_ENET_RSEM_RX_SECTION_EMPTY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_SECTION_EMPTY field to a new value.
#define BW_ENET_RSEM_RX_SECTION_EMPTY(x, v) (HW_ENET_RSEM_WR(x, (HW_ENET_RSEM_RD(x) & ~BM_ENET_RSEM_RX_SECTION_EMPTY) | BF_ENET_RSEM_RX_SECTION_EMPTY(v)))
#endif
//@}

/*!
 * @name Register ENET_RSEM, field STAT_SECTION_EMPTY[20:16] (RW)
 *
 * Defines number of frames in the receive FIFO, independent of its size, that
 * can be accepted. If the limit is reached, reception will continue normally,
 * however a pause frame will be triggered to indicate a possible congestion to the
 * remote device to avoid FIFO overflow. A value of 0 disables automatic pause
 * frame generation
 */
//@{
#define BP_ENET_RSEM_STAT_SECTION_EMPTY (16U) //!< Bit position for ENET_RSEM_STAT_SECTION_EMPTY.
#define BM_ENET_RSEM_STAT_SECTION_EMPTY (0x001F0000U) //!< Bit mask for ENET_RSEM_STAT_SECTION_EMPTY.
#define BS_ENET_RSEM_STAT_SECTION_EMPTY (5U) //!< Bit field size in bits for ENET_RSEM_STAT_SECTION_EMPTY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RSEM_STAT_SECTION_EMPTY field.
#define BR_ENET_RSEM_STAT_SECTION_EMPTY(x) (HW_ENET_RSEM(x).B.STAT_SECTION_EMPTY)
#endif

//! @brief Format value for bitfield ENET_RSEM_STAT_SECTION_EMPTY.
#define BF_ENET_RSEM_STAT_SECTION_EMPTY(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RSEM_STAT_SECTION_EMPTY), uint32_t) & BM_ENET_RSEM_STAT_SECTION_EMPTY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STAT_SECTION_EMPTY field to a new value.
#define BW_ENET_RSEM_STAT_SECTION_EMPTY(x, v) (HW_ENET_RSEM_WR(x, (HW_ENET_RSEM_RD(x) & ~BM_ENET_RSEM_STAT_SECTION_EMPTY) | BF_ENET_RSEM_STAT_SECTION_EMPTY(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RAEM - Receive FIFO Almost Empty Threshold
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RAEM - Receive FIFO Almost Empty Threshold (RW)
 *
 * Reset value: 0x00000004U
 */
typedef union _hw_enet_raem
{
    uint32_t U;
    struct _hw_enet_raem_bitfields
    {
        uint32_t RX_ALMOST_EMPTY : 8;  //!< [7:0] Value Of The Receive FIFO
                                       //! Almost Empty Threshold
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_enet_raem_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RAEM register
 */
//@{
#define HW_ENET_RAEM_ADDR(x)     (REGS_ENET_BASE(x) + 0x198U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RAEM(x)          (*(__IO hw_enet_raem_t *) HW_ENET_RAEM_ADDR(x))
#define HW_ENET_RAEM_RD(x)       (HW_ENET_RAEM(x).U)
#define HW_ENET_RAEM_WR(x, v)    (HW_ENET_RAEM(x).U = (v))
#define HW_ENET_RAEM_SET(x, v)   (HW_ENET_RAEM_WR(x, HW_ENET_RAEM_RD(x) |  (v)))
#define HW_ENET_RAEM_CLR(x, v)   (HW_ENET_RAEM_WR(x, HW_ENET_RAEM_RD(x) & ~(v)))
#define HW_ENET_RAEM_TOG(x, v)   (HW_ENET_RAEM_WR(x, HW_ENET_RAEM_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_RAEM bitfields
 */

/*!
 * @name Register ENET_RAEM, field RX_ALMOST_EMPTY[7:0] (RW)
 *
 * Value, in 64-bit words, of the receive FIFO almost empty threshold. When the
 * FIFO level reaches the value programmed in this field and the end-of-frame has
 * not been received for the frame yet, the core receive read control stops FIFO
 * read (and subsequently stops transferring data to the MAC client
 * application). It continues to deliver the frame, if again more data than the threshold or
 * the end-of-frame is available in the FIFO. A minimum value of 4 should be set.
 */
//@{
#define BP_ENET_RAEM_RX_ALMOST_EMPTY (0U)  //!< Bit position for ENET_RAEM_RX_ALMOST_EMPTY.
#define BM_ENET_RAEM_RX_ALMOST_EMPTY (0x000000FFU) //!< Bit mask for ENET_RAEM_RX_ALMOST_EMPTY.
#define BS_ENET_RAEM_RX_ALMOST_EMPTY (8U)  //!< Bit field size in bits for ENET_RAEM_RX_ALMOST_EMPTY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RAEM_RX_ALMOST_EMPTY field.
#define BR_ENET_RAEM_RX_ALMOST_EMPTY(x) (HW_ENET_RAEM(x).B.RX_ALMOST_EMPTY)
#endif

//! @brief Format value for bitfield ENET_RAEM_RX_ALMOST_EMPTY.
#define BF_ENET_RAEM_RX_ALMOST_EMPTY(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RAEM_RX_ALMOST_EMPTY), uint32_t) & BM_ENET_RAEM_RX_ALMOST_EMPTY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_ALMOST_EMPTY field to a new value.
#define BW_ENET_RAEM_RX_ALMOST_EMPTY(x, v) (HW_ENET_RAEM_WR(x, (HW_ENET_RAEM_RD(x) & ~BM_ENET_RAEM_RX_ALMOST_EMPTY) | BF_ENET_RAEM_RX_ALMOST_EMPTY(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RAFL - Receive FIFO Almost Full Threshold
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RAFL - Receive FIFO Almost Full Threshold (RW)
 *
 * Reset value: 0x00000004U
 */
typedef union _hw_enet_rafl
{
    uint32_t U;
    struct _hw_enet_rafl_bitfields
    {
        uint32_t RX_ALMOST_FULL : 8;   //!< [7:0] Value Of The Receive FIFO
                                       //! Almost Full Threshold
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_enet_rafl_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RAFL register
 */
//@{
#define HW_ENET_RAFL_ADDR(x)     (REGS_ENET_BASE(x) + 0x19CU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RAFL(x)          (*(__IO hw_enet_rafl_t *) HW_ENET_RAFL_ADDR(x))
#define HW_ENET_RAFL_RD(x)       (HW_ENET_RAFL(x).U)
#define HW_ENET_RAFL_WR(x, v)    (HW_ENET_RAFL(x).U = (v))
#define HW_ENET_RAFL_SET(x, v)   (HW_ENET_RAFL_WR(x, HW_ENET_RAFL_RD(x) |  (v)))
#define HW_ENET_RAFL_CLR(x, v)   (HW_ENET_RAFL_WR(x, HW_ENET_RAFL_RD(x) & ~(v)))
#define HW_ENET_RAFL_TOG(x, v)   (HW_ENET_RAFL_WR(x, HW_ENET_RAFL_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_RAFL bitfields
 */

/*!
 * @name Register ENET_RAFL, field RX_ALMOST_FULL[7:0] (RW)
 *
 * Value, in 64-bit words, of the receive FIFO almost full threshold. When the
 * FIFO level comes close to the maximum, so that there is no more space for at
 * least RX_ALMOST_FULL number of words, the MAC stops writing data in the FIFO and
 * truncates the received frame to avoid FIFO overflow. The corresponding error
 * status will be set when the frame is delivered to the application. A minimum
 * value of 4 should be set.
 */
//@{
#define BP_ENET_RAFL_RX_ALMOST_FULL (0U)   //!< Bit position for ENET_RAFL_RX_ALMOST_FULL.
#define BM_ENET_RAFL_RX_ALMOST_FULL (0x000000FFU) //!< Bit mask for ENET_RAFL_RX_ALMOST_FULL.
#define BS_ENET_RAFL_RX_ALMOST_FULL (8U)   //!< Bit field size in bits for ENET_RAFL_RX_ALMOST_FULL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RAFL_RX_ALMOST_FULL field.
#define BR_ENET_RAFL_RX_ALMOST_FULL(x) (HW_ENET_RAFL(x).B.RX_ALMOST_FULL)
#endif

//! @brief Format value for bitfield ENET_RAFL_RX_ALMOST_FULL.
#define BF_ENET_RAFL_RX_ALMOST_FULL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RAFL_RX_ALMOST_FULL), uint32_t) & BM_ENET_RAFL_RX_ALMOST_FULL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RX_ALMOST_FULL field to a new value.
#define BW_ENET_RAFL_RX_ALMOST_FULL(x, v) (HW_ENET_RAFL_WR(x, (HW_ENET_RAFL_RD(x) & ~BM_ENET_RAFL_RX_ALMOST_FULL) | BF_ENET_RAFL_RX_ALMOST_FULL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_TSEM - Transmit FIFO Section Empty Threshold
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_TSEM - Transmit FIFO Section Empty Threshold (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_tsem
{
    uint32_t U;
    struct _hw_enet_tsem_bitfields
    {
        uint32_t TX_SECTION_EMPTY : 8; //!< [7:0] Value Of The Transmit FIFO
                                       //! Section Empty Threshold
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_enet_tsem_t;
#endif

/*!
 * @name Constants and macros for entire ENET_TSEM register
 */
//@{
#define HW_ENET_TSEM_ADDR(x)     (REGS_ENET_BASE(x) + 0x1A0U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_TSEM(x)          (*(__IO hw_enet_tsem_t *) HW_ENET_TSEM_ADDR(x))
#define HW_ENET_TSEM_RD(x)       (HW_ENET_TSEM(x).U)
#define HW_ENET_TSEM_WR(x, v)    (HW_ENET_TSEM(x).U = (v))
#define HW_ENET_TSEM_SET(x, v)   (HW_ENET_TSEM_WR(x, HW_ENET_TSEM_RD(x) |  (v)))
#define HW_ENET_TSEM_CLR(x, v)   (HW_ENET_TSEM_WR(x, HW_ENET_TSEM_RD(x) & ~(v)))
#define HW_ENET_TSEM_TOG(x, v)   (HW_ENET_TSEM_WR(x, HW_ENET_TSEM_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_TSEM bitfields
 */

/*!
 * @name Register ENET_TSEM, field TX_SECTION_EMPTY[7:0] (RW)
 *
 * Value, in 64-bit words, of the transmit FIFO section empty threshold. See
 * Transmit FIFOFour programmable thresholds are available which control the core
 * operation. for more information.
 */
//@{
#define BP_ENET_TSEM_TX_SECTION_EMPTY (0U) //!< Bit position for ENET_TSEM_TX_SECTION_EMPTY.
#define BM_ENET_TSEM_TX_SECTION_EMPTY (0x000000FFU) //!< Bit mask for ENET_TSEM_TX_SECTION_EMPTY.
#define BS_ENET_TSEM_TX_SECTION_EMPTY (8U) //!< Bit field size in bits for ENET_TSEM_TX_SECTION_EMPTY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TSEM_TX_SECTION_EMPTY field.
#define BR_ENET_TSEM_TX_SECTION_EMPTY(x) (HW_ENET_TSEM(x).B.TX_SECTION_EMPTY)
#endif

//! @brief Format value for bitfield ENET_TSEM_TX_SECTION_EMPTY.
#define BF_ENET_TSEM_TX_SECTION_EMPTY(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TSEM_TX_SECTION_EMPTY), uint32_t) & BM_ENET_TSEM_TX_SECTION_EMPTY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_SECTION_EMPTY field to a new value.
#define BW_ENET_TSEM_TX_SECTION_EMPTY(x, v) (HW_ENET_TSEM_WR(x, (HW_ENET_TSEM_RD(x) & ~BM_ENET_TSEM_TX_SECTION_EMPTY) | BF_ENET_TSEM_TX_SECTION_EMPTY(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_TAEM - Transmit FIFO Almost Empty Threshold
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_TAEM - Transmit FIFO Almost Empty Threshold (RW)
 *
 * Reset value: 0x00000004U
 */
typedef union _hw_enet_taem
{
    uint32_t U;
    struct _hw_enet_taem_bitfields
    {
        uint32_t TX_ALMOST_EMPTY : 8;  //!< [7:0] Value of Transmit FIFO
                                       //! Almost Empty Threshold
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_enet_taem_t;
#endif

/*!
 * @name Constants and macros for entire ENET_TAEM register
 */
//@{
#define HW_ENET_TAEM_ADDR(x)     (REGS_ENET_BASE(x) + 0x1A4U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_TAEM(x)          (*(__IO hw_enet_taem_t *) HW_ENET_TAEM_ADDR(x))
#define HW_ENET_TAEM_RD(x)       (HW_ENET_TAEM(x).U)
#define HW_ENET_TAEM_WR(x, v)    (HW_ENET_TAEM(x).U = (v))
#define HW_ENET_TAEM_SET(x, v)   (HW_ENET_TAEM_WR(x, HW_ENET_TAEM_RD(x) |  (v)))
#define HW_ENET_TAEM_CLR(x, v)   (HW_ENET_TAEM_WR(x, HW_ENET_TAEM_RD(x) & ~(v)))
#define HW_ENET_TAEM_TOG(x, v)   (HW_ENET_TAEM_WR(x, HW_ENET_TAEM_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_TAEM bitfields
 */

/*!
 * @name Register ENET_TAEM, field TX_ALMOST_EMPTY[7:0] (RW)
 *
 * Value, in 64-bit words, of the transmit FIFO almost empty threshold. When the
 * FIFO level reaches the value programmed in this field, and no end-of-frame is
 * available for the frame, the MAC transmit logic, to avoid FIFO underflow,
 * stops reading the FIFO and transmits a frame with an MII error indication. See
 * Transmit FIFOFour programmable thresholds are available which control the core
 * operation. for more information. A minimum value of 4 should be set.
 */
//@{
#define BP_ENET_TAEM_TX_ALMOST_EMPTY (0U)  //!< Bit position for ENET_TAEM_TX_ALMOST_EMPTY.
#define BM_ENET_TAEM_TX_ALMOST_EMPTY (0x000000FFU) //!< Bit mask for ENET_TAEM_TX_ALMOST_EMPTY.
#define BS_ENET_TAEM_TX_ALMOST_EMPTY (8U)  //!< Bit field size in bits for ENET_TAEM_TX_ALMOST_EMPTY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TAEM_TX_ALMOST_EMPTY field.
#define BR_ENET_TAEM_TX_ALMOST_EMPTY(x) (HW_ENET_TAEM(x).B.TX_ALMOST_EMPTY)
#endif

//! @brief Format value for bitfield ENET_TAEM_TX_ALMOST_EMPTY.
#define BF_ENET_TAEM_TX_ALMOST_EMPTY(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TAEM_TX_ALMOST_EMPTY), uint32_t) & BM_ENET_TAEM_TX_ALMOST_EMPTY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_ALMOST_EMPTY field to a new value.
#define BW_ENET_TAEM_TX_ALMOST_EMPTY(x, v) (HW_ENET_TAEM_WR(x, (HW_ENET_TAEM_RD(x) & ~BM_ENET_TAEM_TX_ALMOST_EMPTY) | BF_ENET_TAEM_TX_ALMOST_EMPTY(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_TAFL - Transmit FIFO Almost Full Threshold
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_TAFL - Transmit FIFO Almost Full Threshold (RW)
 *
 * Reset value: 0x00000008U
 */
typedef union _hw_enet_tafl
{
    uint32_t U;
    struct _hw_enet_tafl_bitfields
    {
        uint32_t TX_ALMOST_FULL : 8;   //!< [7:0] Value Of The Transmit FIFO
                                       //! Almost Full Threshold
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_enet_tafl_t;
#endif

/*!
 * @name Constants and macros for entire ENET_TAFL register
 */
//@{
#define HW_ENET_TAFL_ADDR(x)     (REGS_ENET_BASE(x) + 0x1A8U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_TAFL(x)          (*(__IO hw_enet_tafl_t *) HW_ENET_TAFL_ADDR(x))
#define HW_ENET_TAFL_RD(x)       (HW_ENET_TAFL(x).U)
#define HW_ENET_TAFL_WR(x, v)    (HW_ENET_TAFL(x).U = (v))
#define HW_ENET_TAFL_SET(x, v)   (HW_ENET_TAFL_WR(x, HW_ENET_TAFL_RD(x) |  (v)))
#define HW_ENET_TAFL_CLR(x, v)   (HW_ENET_TAFL_WR(x, HW_ENET_TAFL_RD(x) & ~(v)))
#define HW_ENET_TAFL_TOG(x, v)   (HW_ENET_TAFL_WR(x, HW_ENET_TAFL_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_TAFL bitfields
 */

/*!
 * @name Register ENET_TAFL, field TX_ALMOST_FULL[7:0] (RW)
 *
 * Value, in 64-bit words, of the transmit FIFO almost full threshold. A minimum
 * value of six is required . A recommended value of at least 8 should be set
 * allowing a latency of two clock cycles to the application. If more latency is
 * required the value can be increased as necessary (latency = TAFL - 5). When the
 * FIFO level comes close to the maximum, so that there is no more space for at
 * least TX_ALMOST_FULL number of words, the pin ff_tx_rdy is deasserted. If the
 * application does not react on this signal, the FIFO write control logic, to
 * avoid FIFO overflow, truncates the current frame and sets the error status. As a
 * result, the frame will be transmitted with an GMII/MII error indication. See
 * Transmit FIFOFour programmable thresholds are available which control the core
 * operation. for more information. A FIFO overflow is a fatal error and requires
 * a global reset on the transmit datapath or at least deassertion of ETHEREN.
 */
//@{
#define BP_ENET_TAFL_TX_ALMOST_FULL (0U)   //!< Bit position for ENET_TAFL_TX_ALMOST_FULL.
#define BM_ENET_TAFL_TX_ALMOST_FULL (0x000000FFU) //!< Bit mask for ENET_TAFL_TX_ALMOST_FULL.
#define BS_ENET_TAFL_TX_ALMOST_FULL (8U)   //!< Bit field size in bits for ENET_TAFL_TX_ALMOST_FULL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TAFL_TX_ALMOST_FULL field.
#define BR_ENET_TAFL_TX_ALMOST_FULL(x) (HW_ENET_TAFL(x).B.TX_ALMOST_FULL)
#endif

//! @brief Format value for bitfield ENET_TAFL_TX_ALMOST_FULL.
#define BF_ENET_TAFL_TX_ALMOST_FULL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TAFL_TX_ALMOST_FULL), uint32_t) & BM_ENET_TAFL_TX_ALMOST_FULL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX_ALMOST_FULL field to a new value.
#define BW_ENET_TAFL_TX_ALMOST_FULL(x, v) (HW_ENET_TAFL_WR(x, (HW_ENET_TAFL_RD(x) & ~BM_ENET_TAFL_TX_ALMOST_FULL) | BF_ENET_TAFL_TX_ALMOST_FULL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_TIPG - Transmit Inter-Packet Gap
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_TIPG - Transmit Inter-Packet Gap (RW)
 *
 * Reset value: 0x0000000CU
 */
typedef union _hw_enet_tipg
{
    uint32_t U;
    struct _hw_enet_tipg_bitfields
    {
        uint32_t IPG : 5;              //!< [4:0] Transmit Inter-Packet Gap
        uint32_t RESERVED0 : 27;       //!< [31:5]
    } B;
} hw_enet_tipg_t;
#endif

/*!
 * @name Constants and macros for entire ENET_TIPG register
 */
//@{
#define HW_ENET_TIPG_ADDR(x)     (REGS_ENET_BASE(x) + 0x1ACU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_TIPG(x)          (*(__IO hw_enet_tipg_t *) HW_ENET_TIPG_ADDR(x))
#define HW_ENET_TIPG_RD(x)       (HW_ENET_TIPG(x).U)
#define HW_ENET_TIPG_WR(x, v)    (HW_ENET_TIPG(x).U = (v))
#define HW_ENET_TIPG_SET(x, v)   (HW_ENET_TIPG_WR(x, HW_ENET_TIPG_RD(x) |  (v)))
#define HW_ENET_TIPG_CLR(x, v)   (HW_ENET_TIPG_WR(x, HW_ENET_TIPG_RD(x) & ~(v)))
#define HW_ENET_TIPG_TOG(x, v)   (HW_ENET_TIPG_WR(x, HW_ENET_TIPG_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_TIPG bitfields
 */

/*!
 * @name Register ENET_TIPG, field IPG[4:0] (RW)
 *
 * Indicates the IPG, in bytes, between transmitted frames. Valid values range
 * from 8 to 27. If value is less than 8, the IPG is 8. If value is greater than
 * 27, the IPG is 27.
 */
//@{
#define BP_ENET_TIPG_IPG     (0U)          //!< Bit position for ENET_TIPG_IPG.
#define BM_ENET_TIPG_IPG     (0x0000001FU) //!< Bit mask for ENET_TIPG_IPG.
#define BS_ENET_TIPG_IPG     (5U)          //!< Bit field size in bits for ENET_TIPG_IPG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TIPG_IPG field.
#define BR_ENET_TIPG_IPG(x)  (HW_ENET_TIPG(x).B.IPG)
#endif

//! @brief Format value for bitfield ENET_TIPG_IPG.
#define BF_ENET_TIPG_IPG(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TIPG_IPG), uint32_t) & BM_ENET_TIPG_IPG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPG field to a new value.
#define BW_ENET_TIPG_IPG(x, v) (HW_ENET_TIPG_WR(x, (HW_ENET_TIPG_RD(x) & ~BM_ENET_TIPG_IPG) | BF_ENET_TIPG_IPG(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_FTRL - Frame Truncation Length
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_FTRL - Frame Truncation Length (RW)
 *
 * Reset value: 0x000007FFU
 */
typedef union _hw_enet_ftrl
{
    uint32_t U;
    struct _hw_enet_ftrl_bitfields
    {
        uint32_t TRUNC_FL : 14;        //!< [13:0] Frame Truncation Length
        uint32_t RESERVED0 : 18;       //!< [31:14]
    } B;
} hw_enet_ftrl_t;
#endif

/*!
 * @name Constants and macros for entire ENET_FTRL register
 */
//@{
#define HW_ENET_FTRL_ADDR(x)     (REGS_ENET_BASE(x) + 0x1B0U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_FTRL(x)          (*(__IO hw_enet_ftrl_t *) HW_ENET_FTRL_ADDR(x))
#define HW_ENET_FTRL_RD(x)       (HW_ENET_FTRL(x).U)
#define HW_ENET_FTRL_WR(x, v)    (HW_ENET_FTRL(x).U = (v))
#define HW_ENET_FTRL_SET(x, v)   (HW_ENET_FTRL_WR(x, HW_ENET_FTRL_RD(x) |  (v)))
#define HW_ENET_FTRL_CLR(x, v)   (HW_ENET_FTRL_WR(x, HW_ENET_FTRL_RD(x) & ~(v)))
#define HW_ENET_FTRL_TOG(x, v)   (HW_ENET_FTRL_WR(x, HW_ENET_FTRL_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_FTRL bitfields
 */

/*!
 * @name Register ENET_FTRL, field TRUNC_FL[13:0] (RW)
 *
 * Indicates the value a receive frame is truncated, if it is greater than this
 * value. Must be greater than or equal to RCR[MAX_FL]. Truncation happens at
 * TRUNC_FL. However, when truncation occurs, the application (FIFO) may receive
 * less data, guaranteeing that it never receives more than the set limit.
 */
//@{
#define BP_ENET_FTRL_TRUNC_FL (0U)         //!< Bit position for ENET_FTRL_TRUNC_FL.
#define BM_ENET_FTRL_TRUNC_FL (0x00003FFFU) //!< Bit mask for ENET_FTRL_TRUNC_FL.
#define BS_ENET_FTRL_TRUNC_FL (14U)        //!< Bit field size in bits for ENET_FTRL_TRUNC_FL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_FTRL_TRUNC_FL field.
#define BR_ENET_FTRL_TRUNC_FL(x) (HW_ENET_FTRL(x).B.TRUNC_FL)
#endif

//! @brief Format value for bitfield ENET_FTRL_TRUNC_FL.
#define BF_ENET_FTRL_TRUNC_FL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_FTRL_TRUNC_FL), uint32_t) & BM_ENET_FTRL_TRUNC_FL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TRUNC_FL field to a new value.
#define BW_ENET_FTRL_TRUNC_FL(x, v) (HW_ENET_FTRL_WR(x, (HW_ENET_FTRL_RD(x) & ~BM_ENET_FTRL_TRUNC_FL) | BF_ENET_FTRL_TRUNC_FL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_TACC - Transmit Accelerator Function Configuration
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_TACC - Transmit Accelerator Function Configuration (RW)
 *
 * Reset value: 0x00000000U
 *
 * TACC controls accelerator actions when sending frames. The register can be
 * changed before or after each frame, but it must remain unmodified during frame
 * writes into the transmit FIFO. The TFWR[STRFWD] field must be set to use the
 * checksum feature.
 */
typedef union _hw_enet_tacc
{
    uint32_t U;
    struct _hw_enet_tacc_bitfields
    {
        uint32_t SHIFT16 : 1;          //!< [0] TX FIFO Shift-16
        uint32_t RESERVED0 : 2;        //!< [2:1]
        uint32_t IPCHK : 1;            //!< [3]
        uint32_t PROCHK : 1;           //!< [4]
        uint32_t RESERVED1 : 27;       //!< [31:5]
    } B;
} hw_enet_tacc_t;
#endif

/*!
 * @name Constants and macros for entire ENET_TACC register
 */
//@{
#define HW_ENET_TACC_ADDR(x)     (REGS_ENET_BASE(x) + 0x1C0U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_TACC(x)          (*(__IO hw_enet_tacc_t *) HW_ENET_TACC_ADDR(x))
#define HW_ENET_TACC_RD(x)       (HW_ENET_TACC(x).U)
#define HW_ENET_TACC_WR(x, v)    (HW_ENET_TACC(x).U = (v))
#define HW_ENET_TACC_SET(x, v)   (HW_ENET_TACC_WR(x, HW_ENET_TACC_RD(x) |  (v)))
#define HW_ENET_TACC_CLR(x, v)   (HW_ENET_TACC_WR(x, HW_ENET_TACC_RD(x) & ~(v)))
#define HW_ENET_TACC_TOG(x, v)   (HW_ENET_TACC_WR(x, HW_ENET_TACC_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_TACC bitfields
 */

/*!
 * @name Register ENET_TACC, field SHIFT16[0] (RW)
 *
 * Values:
 * - 0 - Disabled.
 * - 1 - Indicates to the transmit data FIFO that the written frames contain two
 *     additional octets before the frame data. This means the actual frame
 *     begins at bit 16 of the first word written into the FIFO. This function allows
 *     putting the frame payload on a 32-bit boundary in memory, as the 14-byte
 *     Ethernet header is extended to a 16-byte header.
 */
//@{
#define BP_ENET_TACC_SHIFT16 (0U)          //!< Bit position for ENET_TACC_SHIFT16.
#define BM_ENET_TACC_SHIFT16 (0x00000001U) //!< Bit mask for ENET_TACC_SHIFT16.
#define BS_ENET_TACC_SHIFT16 (1U)          //!< Bit field size in bits for ENET_TACC_SHIFT16.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TACC_SHIFT16 field.
#define BR_ENET_TACC_SHIFT16(x) (BITBAND_ACCESS32(HW_ENET_TACC_ADDR(x), BP_ENET_TACC_SHIFT16))
#endif

//! @brief Format value for bitfield ENET_TACC_SHIFT16.
#define BF_ENET_TACC_SHIFT16(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TACC_SHIFT16), uint32_t) & BM_ENET_TACC_SHIFT16)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SHIFT16 field to a new value.
#define BW_ENET_TACC_SHIFT16(x, v) (BITBAND_ACCESS32(HW_ENET_TACC_ADDR(x), BP_ENET_TACC_SHIFT16) = (v))
#endif
//@}

/*!
 * @name Register ENET_TACC, field IPCHK[3] (RW)
 *
 * Enables insertion of IP header checksum.
 *
 * Values:
 * - 0 - Checksum is not inserted.
 * - 1 - If an IP frame is transmitted, the checksum is inserted automatically.
 *     The IP header checksum field must be cleared. If a non-IP frame is
 *     transmitted the frame is not modified.
 */
//@{
#define BP_ENET_TACC_IPCHK   (3U)          //!< Bit position for ENET_TACC_IPCHK.
#define BM_ENET_TACC_IPCHK   (0x00000008U) //!< Bit mask for ENET_TACC_IPCHK.
#define BS_ENET_TACC_IPCHK   (1U)          //!< Bit field size in bits for ENET_TACC_IPCHK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TACC_IPCHK field.
#define BR_ENET_TACC_IPCHK(x) (BITBAND_ACCESS32(HW_ENET_TACC_ADDR(x), BP_ENET_TACC_IPCHK))
#endif

//! @brief Format value for bitfield ENET_TACC_IPCHK.
#define BF_ENET_TACC_IPCHK(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TACC_IPCHK), uint32_t) & BM_ENET_TACC_IPCHK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPCHK field to a new value.
#define BW_ENET_TACC_IPCHK(x, v) (BITBAND_ACCESS32(HW_ENET_TACC_ADDR(x), BP_ENET_TACC_IPCHK) = (v))
#endif
//@}

/*!
 * @name Register ENET_TACC, field PROCHK[4] (RW)
 *
 * Enables insertion of protocol checksum.
 *
 * Values:
 * - 0 - Checksum not inserted.
 * - 1 - If an IP frame with a known protocol is transmitted, the checksum is
 *     inserted automatically into the frame. The checksum field must be cleared.
 *     The other frames are not modified.
 */
//@{
#define BP_ENET_TACC_PROCHK  (4U)          //!< Bit position for ENET_TACC_PROCHK.
#define BM_ENET_TACC_PROCHK  (0x00000010U) //!< Bit mask for ENET_TACC_PROCHK.
#define BS_ENET_TACC_PROCHK  (1U)          //!< Bit field size in bits for ENET_TACC_PROCHK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TACC_PROCHK field.
#define BR_ENET_TACC_PROCHK(x) (BITBAND_ACCESS32(HW_ENET_TACC_ADDR(x), BP_ENET_TACC_PROCHK))
#endif

//! @brief Format value for bitfield ENET_TACC_PROCHK.
#define BF_ENET_TACC_PROCHK(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TACC_PROCHK), uint32_t) & BM_ENET_TACC_PROCHK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PROCHK field to a new value.
#define BW_ENET_TACC_PROCHK(x, v) (BITBAND_ACCESS32(HW_ENET_TACC_ADDR(x), BP_ENET_TACC_PROCHK) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RACC - Receive Accelerator Function Configuration
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RACC - Receive Accelerator Function Configuration (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_racc
{
    uint32_t U;
    struct _hw_enet_racc_bitfields
    {
        uint32_t PADREM : 1;           //!< [0] Enable Padding Removal For Short IP
                                       //! Frames
        uint32_t IPDIS : 1;            //!< [1] Enable Discard Of Frames With Wrong IPv4
                                       //! Header Checksum
        uint32_t PRODIS : 1;           //!< [2] Enable Discard Of Frames With Wrong
                                       //! Protocol Checksum
        uint32_t RESERVED0 : 3;        //!< [5:3]
        uint32_t LINEDIS : 1;          //!< [6] Enable Discard Of Frames With MAC
                                       //! Layer Errors
        uint32_t SHIFT16 : 1;          //!< [7] RX FIFO Shift-16
        uint32_t RESERVED1 : 24;       //!< [31:8]
    } B;
} hw_enet_racc_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RACC register
 */
//@{
#define HW_ENET_RACC_ADDR(x)     (REGS_ENET_BASE(x) + 0x1C4U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RACC(x)          (*(__IO hw_enet_racc_t *) HW_ENET_RACC_ADDR(x))
#define HW_ENET_RACC_RD(x)       (HW_ENET_RACC(x).U)
#define HW_ENET_RACC_WR(x, v)    (HW_ENET_RACC(x).U = (v))
#define HW_ENET_RACC_SET(x, v)   (HW_ENET_RACC_WR(x, HW_ENET_RACC_RD(x) |  (v)))
#define HW_ENET_RACC_CLR(x, v)   (HW_ENET_RACC_WR(x, HW_ENET_RACC_RD(x) & ~(v)))
#define HW_ENET_RACC_TOG(x, v)   (HW_ENET_RACC_WR(x, HW_ENET_RACC_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_RACC bitfields
 */

/*!
 * @name Register ENET_RACC, field PADREM[0] (RW)
 *
 * Values:
 * - 0 - Padding not removed.
 * - 1 - Any bytes following the IP payload section of the frame are removed
 *     from the frame.
 */
//@{
#define BP_ENET_RACC_PADREM  (0U)          //!< Bit position for ENET_RACC_PADREM.
#define BM_ENET_RACC_PADREM  (0x00000001U) //!< Bit mask for ENET_RACC_PADREM.
#define BS_ENET_RACC_PADREM  (1U)          //!< Bit field size in bits for ENET_RACC_PADREM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RACC_PADREM field.
#define BR_ENET_RACC_PADREM(x) (BITBAND_ACCESS32(HW_ENET_RACC_ADDR(x), BP_ENET_RACC_PADREM))
#endif

//! @brief Format value for bitfield ENET_RACC_PADREM.
#define BF_ENET_RACC_PADREM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RACC_PADREM), uint32_t) & BM_ENET_RACC_PADREM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PADREM field to a new value.
#define BW_ENET_RACC_PADREM(x, v) (BITBAND_ACCESS32(HW_ENET_RACC_ADDR(x), BP_ENET_RACC_PADREM) = (v))
#endif
//@}

/*!
 * @name Register ENET_RACC, field IPDIS[1] (RW)
 *
 * Values:
 * - 0 - Frames with wrong IPv4 header checksum are not discarded.
 * - 1 - If an IPv4 frame is received with a mismatching header checksum, the
 *     frame is discarded. IPv6 has no header checksum and is not affected by this
 *     setting. Discarding is only available when the RX FIFO operates in store
 *     and forward mode (RSFL cleared).
 */
//@{
#define BP_ENET_RACC_IPDIS   (1U)          //!< Bit position for ENET_RACC_IPDIS.
#define BM_ENET_RACC_IPDIS   (0x00000002U) //!< Bit mask for ENET_RACC_IPDIS.
#define BS_ENET_RACC_IPDIS   (1U)          //!< Bit field size in bits for ENET_RACC_IPDIS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RACC_IPDIS field.
#define BR_ENET_RACC_IPDIS(x) (BITBAND_ACCESS32(HW_ENET_RACC_ADDR(x), BP_ENET_RACC_IPDIS))
#endif

//! @brief Format value for bitfield ENET_RACC_IPDIS.
#define BF_ENET_RACC_IPDIS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RACC_IPDIS), uint32_t) & BM_ENET_RACC_IPDIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPDIS field to a new value.
#define BW_ENET_RACC_IPDIS(x, v) (BITBAND_ACCESS32(HW_ENET_RACC_ADDR(x), BP_ENET_RACC_IPDIS) = (v))
#endif
//@}

/*!
 * @name Register ENET_RACC, field PRODIS[2] (RW)
 *
 * Values:
 * - 0 - Frames with wrong checksum are not discarded.
 * - 1 - If a TCP/IP, UDP/IP, or ICMP/IP frame is received that has a wrong TCP,
 *     UDP, or ICMP checksum, the frame is discarded. Discarding is only
 *     available when the RX FIFO operates in store and forward mode (RSFL cleared).
 */
//@{
#define BP_ENET_RACC_PRODIS  (2U)          //!< Bit position for ENET_RACC_PRODIS.
#define BM_ENET_RACC_PRODIS  (0x00000004U) //!< Bit mask for ENET_RACC_PRODIS.
#define BS_ENET_RACC_PRODIS  (1U)          //!< Bit field size in bits for ENET_RACC_PRODIS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RACC_PRODIS field.
#define BR_ENET_RACC_PRODIS(x) (BITBAND_ACCESS32(HW_ENET_RACC_ADDR(x), BP_ENET_RACC_PRODIS))
#endif

//! @brief Format value for bitfield ENET_RACC_PRODIS.
#define BF_ENET_RACC_PRODIS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RACC_PRODIS), uint32_t) & BM_ENET_RACC_PRODIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRODIS field to a new value.
#define BW_ENET_RACC_PRODIS(x, v) (BITBAND_ACCESS32(HW_ENET_RACC_ADDR(x), BP_ENET_RACC_PRODIS) = (v))
#endif
//@}

/*!
 * @name Register ENET_RACC, field LINEDIS[6] (RW)
 *
 * Values:
 * - 0 - Frames with errors are not discarded.
 * - 1 - Any frame received with a CRC, length, or PHY error is automatically
 *     discarded and not forwarded to the user application interface.
 */
//@{
#define BP_ENET_RACC_LINEDIS (6U)          //!< Bit position for ENET_RACC_LINEDIS.
#define BM_ENET_RACC_LINEDIS (0x00000040U) //!< Bit mask for ENET_RACC_LINEDIS.
#define BS_ENET_RACC_LINEDIS (1U)          //!< Bit field size in bits for ENET_RACC_LINEDIS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RACC_LINEDIS field.
#define BR_ENET_RACC_LINEDIS(x) (BITBAND_ACCESS32(HW_ENET_RACC_ADDR(x), BP_ENET_RACC_LINEDIS))
#endif

//! @brief Format value for bitfield ENET_RACC_LINEDIS.
#define BF_ENET_RACC_LINEDIS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RACC_LINEDIS), uint32_t) & BM_ENET_RACC_LINEDIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LINEDIS field to a new value.
#define BW_ENET_RACC_LINEDIS(x, v) (BITBAND_ACCESS32(HW_ENET_RACC_ADDR(x), BP_ENET_RACC_LINEDIS) = (v))
#endif
//@}

/*!
 * @name Register ENET_RACC, field SHIFT16[7] (RW)
 *
 * When this field is set, the actual frame data starts at bit 16 of the first
 * word read from the RX FIFO aligning the Ethernet payload on a 32-bit boundary.
 * This function only affects the FIFO storage and has no influence on the
 * statistics, which use the actual length of the frame received.
 *
 * Values:
 * - 0 - Disabled.
 * - 1 - Instructs the MAC to write two additional bytes in front of each frame
 *     received into the RX FIFO.
 */
//@{
#define BP_ENET_RACC_SHIFT16 (7U)          //!< Bit position for ENET_RACC_SHIFT16.
#define BM_ENET_RACC_SHIFT16 (0x00000080U) //!< Bit mask for ENET_RACC_SHIFT16.
#define BS_ENET_RACC_SHIFT16 (1U)          //!< Bit field size in bits for ENET_RACC_SHIFT16.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RACC_SHIFT16 field.
#define BR_ENET_RACC_SHIFT16(x) (BITBAND_ACCESS32(HW_ENET_RACC_ADDR(x), BP_ENET_RACC_SHIFT16))
#endif

//! @brief Format value for bitfield ENET_RACC_SHIFT16.
#define BF_ENET_RACC_SHIFT16(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_RACC_SHIFT16), uint32_t) & BM_ENET_RACC_SHIFT16)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SHIFT16 field to a new value.
#define BW_ENET_RACC_SHIFT16(x, v) (BITBAND_ACCESS32(HW_ENET_RACC_ADDR(x), BP_ENET_RACC_SHIFT16) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_PACKETS - Tx Packet Count Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_PACKETS - Tx Packet Count Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_packets
{
    uint32_t U;
    struct _hw_enet_rmon_t_packets_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_packets_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_PACKETS register
 */
//@{
#define HW_ENET_RMON_T_PACKETS_ADDR(x) (REGS_ENET_BASE(x) + 0x204U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_PACKETS(x) (*(__I hw_enet_rmon_t_packets_t *) HW_ENET_RMON_T_PACKETS_ADDR(x))
#define HW_ENET_RMON_T_PACKETS_RD(x) (HW_ENET_RMON_T_PACKETS(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_PACKETS bitfields
 */

/*!
 * @name Register ENET_RMON_T_PACKETS, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_PACKETS_TXPKTS (0U) //!< Bit position for ENET_RMON_T_PACKETS_TXPKTS.
#define BM_ENET_RMON_T_PACKETS_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_PACKETS_TXPKTS.
#define BS_ENET_RMON_T_PACKETS_TXPKTS (16U) //!< Bit field size in bits for ENET_RMON_T_PACKETS_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_PACKETS_TXPKTS field.
#define BR_ENET_RMON_T_PACKETS_TXPKTS(x) (HW_ENET_RMON_T_PACKETS(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_BC_PKT - Tx Broadcast Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_BC_PKT - Tx Broadcast Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * RMON Tx Broadcast Packets
 */
typedef union _hw_enet_rmon_t_bc_pkt
{
    uint32_t U;
    struct _hw_enet_rmon_t_bc_pkt_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Broadcast packets
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_bc_pkt_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_BC_PKT register
 */
//@{
#define HW_ENET_RMON_T_BC_PKT_ADDR(x) (REGS_ENET_BASE(x) + 0x208U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_BC_PKT(x) (*(__I hw_enet_rmon_t_bc_pkt_t *) HW_ENET_RMON_T_BC_PKT_ADDR(x))
#define HW_ENET_RMON_T_BC_PKT_RD(x) (HW_ENET_RMON_T_BC_PKT(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_BC_PKT bitfields
 */

/*!
 * @name Register ENET_RMON_T_BC_PKT, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_BC_PKT_TXPKTS (0U)  //!< Bit position for ENET_RMON_T_BC_PKT_TXPKTS.
#define BM_ENET_RMON_T_BC_PKT_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_BC_PKT_TXPKTS.
#define BS_ENET_RMON_T_BC_PKT_TXPKTS (16U) //!< Bit field size in bits for ENET_RMON_T_BC_PKT_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_BC_PKT_TXPKTS field.
#define BR_ENET_RMON_T_BC_PKT_TXPKTS(x) (HW_ENET_RMON_T_BC_PKT(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_MC_PKT - Tx Multicast Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_MC_PKT - Tx Multicast Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_mc_pkt
{
    uint32_t U;
    struct _hw_enet_rmon_t_mc_pkt_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Multicast packets
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_mc_pkt_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_MC_PKT register
 */
//@{
#define HW_ENET_RMON_T_MC_PKT_ADDR(x) (REGS_ENET_BASE(x) + 0x20CU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_MC_PKT(x) (*(__I hw_enet_rmon_t_mc_pkt_t *) HW_ENET_RMON_T_MC_PKT_ADDR(x))
#define HW_ENET_RMON_T_MC_PKT_RD(x) (HW_ENET_RMON_T_MC_PKT(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_MC_PKT bitfields
 */

/*!
 * @name Register ENET_RMON_T_MC_PKT, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_MC_PKT_TXPKTS (0U)  //!< Bit position for ENET_RMON_T_MC_PKT_TXPKTS.
#define BM_ENET_RMON_T_MC_PKT_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_MC_PKT_TXPKTS.
#define BS_ENET_RMON_T_MC_PKT_TXPKTS (16U) //!< Bit field size in bits for ENET_RMON_T_MC_PKT_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_MC_PKT_TXPKTS field.
#define BR_ENET_RMON_T_MC_PKT_TXPKTS(x) (HW_ENET_RMON_T_MC_PKT(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_CRC_ALIGN - Tx Packets with CRC/Align Error Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_CRC_ALIGN - Tx Packets with CRC/Align Error Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_crc_align
{
    uint32_t U;
    struct _hw_enet_rmon_t_crc_align_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packets with CRC/align error
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_crc_align_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_CRC_ALIGN register
 */
//@{
#define HW_ENET_RMON_T_CRC_ALIGN_ADDR(x) (REGS_ENET_BASE(x) + 0x210U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_CRC_ALIGN(x) (*(__I hw_enet_rmon_t_crc_align_t *) HW_ENET_RMON_T_CRC_ALIGN_ADDR(x))
#define HW_ENET_RMON_T_CRC_ALIGN_RD(x) (HW_ENET_RMON_T_CRC_ALIGN(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_CRC_ALIGN bitfields
 */

/*!
 * @name Register ENET_RMON_T_CRC_ALIGN, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_CRC_ALIGN_TXPKTS (0U) //!< Bit position for ENET_RMON_T_CRC_ALIGN_TXPKTS.
#define BM_ENET_RMON_T_CRC_ALIGN_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_CRC_ALIGN_TXPKTS.
#define BS_ENET_RMON_T_CRC_ALIGN_TXPKTS (16U) //!< Bit field size in bits for ENET_RMON_T_CRC_ALIGN_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_CRC_ALIGN_TXPKTS field.
#define BR_ENET_RMON_T_CRC_ALIGN_TXPKTS(x) (HW_ENET_RMON_T_CRC_ALIGN(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_UNDERSIZE - Tx Packets Less Than Bytes and Good CRC Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_UNDERSIZE - Tx Packets Less Than Bytes and Good CRC Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_undersize
{
    uint32_t U;
    struct _hw_enet_rmon_t_undersize_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_undersize_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_UNDERSIZE register
 */
//@{
#define HW_ENET_RMON_T_UNDERSIZE_ADDR(x) (REGS_ENET_BASE(x) + 0x214U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_UNDERSIZE(x) (*(__I hw_enet_rmon_t_undersize_t *) HW_ENET_RMON_T_UNDERSIZE_ADDR(x))
#define HW_ENET_RMON_T_UNDERSIZE_RD(x) (HW_ENET_RMON_T_UNDERSIZE(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_UNDERSIZE bitfields
 */

/*!
 * @name Register ENET_RMON_T_UNDERSIZE, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_UNDERSIZE_TXPKTS (0U) //!< Bit position for ENET_RMON_T_UNDERSIZE_TXPKTS.
#define BM_ENET_RMON_T_UNDERSIZE_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_UNDERSIZE_TXPKTS.
#define BS_ENET_RMON_T_UNDERSIZE_TXPKTS (16U) //!< Bit field size in bits for ENET_RMON_T_UNDERSIZE_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_UNDERSIZE_TXPKTS field.
#define BR_ENET_RMON_T_UNDERSIZE_TXPKTS(x) (HW_ENET_RMON_T_UNDERSIZE(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_OVERSIZE - Tx Packets GT MAX_FL bytes and Good CRC Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_OVERSIZE - Tx Packets GT MAX_FL bytes and Good CRC Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_oversize
{
    uint32_t U;
    struct _hw_enet_rmon_t_oversize_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_oversize_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_OVERSIZE register
 */
//@{
#define HW_ENET_RMON_T_OVERSIZE_ADDR(x) (REGS_ENET_BASE(x) + 0x218U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_OVERSIZE(x) (*(__I hw_enet_rmon_t_oversize_t *) HW_ENET_RMON_T_OVERSIZE_ADDR(x))
#define HW_ENET_RMON_T_OVERSIZE_RD(x) (HW_ENET_RMON_T_OVERSIZE(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_OVERSIZE bitfields
 */

/*!
 * @name Register ENET_RMON_T_OVERSIZE, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_OVERSIZE_TXPKTS (0U) //!< Bit position for ENET_RMON_T_OVERSIZE_TXPKTS.
#define BM_ENET_RMON_T_OVERSIZE_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_OVERSIZE_TXPKTS.
#define BS_ENET_RMON_T_OVERSIZE_TXPKTS (16U) //!< Bit field size in bits for ENET_RMON_T_OVERSIZE_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_OVERSIZE_TXPKTS field.
#define BR_ENET_RMON_T_OVERSIZE_TXPKTS(x) (HW_ENET_RMON_T_OVERSIZE(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_FRAG - Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_FRAG - Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
typedef union _hw_enet_rmon_t_frag
{
    uint32_t U;
    struct _hw_enet_rmon_t_frag_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_frag_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_FRAG register
 */
//@{
#define HW_ENET_RMON_T_FRAG_ADDR(x) (REGS_ENET_BASE(x) + 0x21CU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_FRAG(x)   (*(__I hw_enet_rmon_t_frag_t *) HW_ENET_RMON_T_FRAG_ADDR(x))
#define HW_ENET_RMON_T_FRAG_RD(x) (HW_ENET_RMON_T_FRAG(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_FRAG bitfields
 */

/*!
 * @name Register ENET_RMON_T_FRAG, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_FRAG_TXPKTS (0U)    //!< Bit position for ENET_RMON_T_FRAG_TXPKTS.
#define BM_ENET_RMON_T_FRAG_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_FRAG_TXPKTS.
#define BS_ENET_RMON_T_FRAG_TXPKTS (16U)   //!< Bit field size in bits for ENET_RMON_T_FRAG_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_FRAG_TXPKTS field.
#define BR_ENET_RMON_T_FRAG_TXPKTS(x) (HW_ENET_RMON_T_FRAG(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_JAB - Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_JAB - Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_jab
{
    uint32_t U;
    struct _hw_enet_rmon_t_jab_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_jab_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_JAB register
 */
//@{
#define HW_ENET_RMON_T_JAB_ADDR(x) (REGS_ENET_BASE(x) + 0x220U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_JAB(x)    (*(__I hw_enet_rmon_t_jab_t *) HW_ENET_RMON_T_JAB_ADDR(x))
#define HW_ENET_RMON_T_JAB_RD(x) (HW_ENET_RMON_T_JAB(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_JAB bitfields
 */

/*!
 * @name Register ENET_RMON_T_JAB, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_JAB_TXPKTS (0U)     //!< Bit position for ENET_RMON_T_JAB_TXPKTS.
#define BM_ENET_RMON_T_JAB_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_JAB_TXPKTS.
#define BS_ENET_RMON_T_JAB_TXPKTS (16U)    //!< Bit field size in bits for ENET_RMON_T_JAB_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_JAB_TXPKTS field.
#define BR_ENET_RMON_T_JAB_TXPKTS(x) (HW_ENET_RMON_T_JAB(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_COL - Tx Collision Count Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_COL - Tx Collision Count Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_col
{
    uint32_t U;
    struct _hw_enet_rmon_t_col_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_col_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_COL register
 */
//@{
#define HW_ENET_RMON_T_COL_ADDR(x) (REGS_ENET_BASE(x) + 0x224U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_COL(x)    (*(__I hw_enet_rmon_t_col_t *) HW_ENET_RMON_T_COL_ADDR(x))
#define HW_ENET_RMON_T_COL_RD(x) (HW_ENET_RMON_T_COL(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_COL bitfields
 */

/*!
 * @name Register ENET_RMON_T_COL, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_COL_TXPKTS (0U)     //!< Bit position for ENET_RMON_T_COL_TXPKTS.
#define BM_ENET_RMON_T_COL_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_COL_TXPKTS.
#define BS_ENET_RMON_T_COL_TXPKTS (16U)    //!< Bit field size in bits for ENET_RMON_T_COL_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_COL_TXPKTS field.
#define BR_ENET_RMON_T_COL_TXPKTS(x) (HW_ENET_RMON_T_COL(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_P64 - Tx 64-Byte Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_P64 - Tx 64-Byte Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
typedef union _hw_enet_rmon_t_p64
{
    uint32_t U;
    struct _hw_enet_rmon_t_p64_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_p64_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_P64 register
 */
//@{
#define HW_ENET_RMON_T_P64_ADDR(x) (REGS_ENET_BASE(x) + 0x228U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_P64(x)    (*(__I hw_enet_rmon_t_p64_t *) HW_ENET_RMON_T_P64_ADDR(x))
#define HW_ENET_RMON_T_P64_RD(x) (HW_ENET_RMON_T_P64(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_P64 bitfields
 */

/*!
 * @name Register ENET_RMON_T_P64, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_P64_TXPKTS (0U)     //!< Bit position for ENET_RMON_T_P64_TXPKTS.
#define BM_ENET_RMON_T_P64_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_P64_TXPKTS.
#define BS_ENET_RMON_T_P64_TXPKTS (16U)    //!< Bit field size in bits for ENET_RMON_T_P64_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_P64_TXPKTS field.
#define BR_ENET_RMON_T_P64_TXPKTS(x) (HW_ENET_RMON_T_P64(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_P65TO127 - Tx 65- to 127-byte Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_P65TO127 - Tx 65- to 127-byte Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_p65to127
{
    uint32_t U;
    struct _hw_enet_rmon_t_p65to127_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_p65to127_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_P65TO127 register
 */
//@{
#define HW_ENET_RMON_T_P65TO127_ADDR(x) (REGS_ENET_BASE(x) + 0x22CU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_P65TO127(x) (*(__I hw_enet_rmon_t_p65to127_t *) HW_ENET_RMON_T_P65TO127_ADDR(x))
#define HW_ENET_RMON_T_P65TO127_RD(x) (HW_ENET_RMON_T_P65TO127(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_P65TO127 bitfields
 */

/*!
 * @name Register ENET_RMON_T_P65TO127, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_P65TO127_TXPKTS (0U) //!< Bit position for ENET_RMON_T_P65TO127_TXPKTS.
#define BM_ENET_RMON_T_P65TO127_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_P65TO127_TXPKTS.
#define BS_ENET_RMON_T_P65TO127_TXPKTS (16U) //!< Bit field size in bits for ENET_RMON_T_P65TO127_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_P65TO127_TXPKTS field.
#define BR_ENET_RMON_T_P65TO127_TXPKTS(x) (HW_ENET_RMON_T_P65TO127(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_P128TO255 - Tx 128- to 255-byte Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_P128TO255 - Tx 128- to 255-byte Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_p128to255
{
    uint32_t U;
    struct _hw_enet_rmon_t_p128to255_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_p128to255_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_P128TO255 register
 */
//@{
#define HW_ENET_RMON_T_P128TO255_ADDR(x) (REGS_ENET_BASE(x) + 0x230U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_P128TO255(x) (*(__I hw_enet_rmon_t_p128to255_t *) HW_ENET_RMON_T_P128TO255_ADDR(x))
#define HW_ENET_RMON_T_P128TO255_RD(x) (HW_ENET_RMON_T_P128TO255(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_P128TO255 bitfields
 */

/*!
 * @name Register ENET_RMON_T_P128TO255, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_P128TO255_TXPKTS (0U) //!< Bit position for ENET_RMON_T_P128TO255_TXPKTS.
#define BM_ENET_RMON_T_P128TO255_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_P128TO255_TXPKTS.
#define BS_ENET_RMON_T_P128TO255_TXPKTS (16U) //!< Bit field size in bits for ENET_RMON_T_P128TO255_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_P128TO255_TXPKTS field.
#define BR_ENET_RMON_T_P128TO255_TXPKTS(x) (HW_ENET_RMON_T_P128TO255(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_P256TO511 - Tx 256- to 511-byte Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_P256TO511 - Tx 256- to 511-byte Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_p256to511
{
    uint32_t U;
    struct _hw_enet_rmon_t_p256to511_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_p256to511_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_P256TO511 register
 */
//@{
#define HW_ENET_RMON_T_P256TO511_ADDR(x) (REGS_ENET_BASE(x) + 0x234U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_P256TO511(x) (*(__I hw_enet_rmon_t_p256to511_t *) HW_ENET_RMON_T_P256TO511_ADDR(x))
#define HW_ENET_RMON_T_P256TO511_RD(x) (HW_ENET_RMON_T_P256TO511(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_P256TO511 bitfields
 */

/*!
 * @name Register ENET_RMON_T_P256TO511, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_P256TO511_TXPKTS (0U) //!< Bit position for ENET_RMON_T_P256TO511_TXPKTS.
#define BM_ENET_RMON_T_P256TO511_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_P256TO511_TXPKTS.
#define BS_ENET_RMON_T_P256TO511_TXPKTS (16U) //!< Bit field size in bits for ENET_RMON_T_P256TO511_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_P256TO511_TXPKTS field.
#define BR_ENET_RMON_T_P256TO511_TXPKTS(x) (HW_ENET_RMON_T_P256TO511(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_P512TO1023 - Tx 512- to 1023-byte Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_P512TO1023 - Tx 512- to 1023-byte Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * .
 */
typedef union _hw_enet_rmon_t_p512to1023
{
    uint32_t U;
    struct _hw_enet_rmon_t_p512to1023_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_p512to1023_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_P512TO1023 register
 */
//@{
#define HW_ENET_RMON_T_P512TO1023_ADDR(x) (REGS_ENET_BASE(x) + 0x238U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_P512TO1023(x) (*(__I hw_enet_rmon_t_p512to1023_t *) HW_ENET_RMON_T_P512TO1023_ADDR(x))
#define HW_ENET_RMON_T_P512TO1023_RD(x) (HW_ENET_RMON_T_P512TO1023(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_P512TO1023 bitfields
 */

/*!
 * @name Register ENET_RMON_T_P512TO1023, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_P512TO1023_TXPKTS (0U) //!< Bit position for ENET_RMON_T_P512TO1023_TXPKTS.
#define BM_ENET_RMON_T_P512TO1023_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_P512TO1023_TXPKTS.
#define BS_ENET_RMON_T_P512TO1023_TXPKTS (16U) //!< Bit field size in bits for ENET_RMON_T_P512TO1023_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_P512TO1023_TXPKTS field.
#define BR_ENET_RMON_T_P512TO1023_TXPKTS(x) (HW_ENET_RMON_T_P512TO1023(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_P1024TO2047 - Tx 1024- to 2047-byte Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_P1024TO2047 - Tx 1024- to 2047-byte Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_p1024to2047
{
    uint32_t U;
    struct _hw_enet_rmon_t_p1024to2047_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_p1024to2047_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_P1024TO2047 register
 */
//@{
#define HW_ENET_RMON_T_P1024TO2047_ADDR(x) (REGS_ENET_BASE(x) + 0x23CU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_P1024TO2047(x) (*(__I hw_enet_rmon_t_p1024to2047_t *) HW_ENET_RMON_T_P1024TO2047_ADDR(x))
#define HW_ENET_RMON_T_P1024TO2047_RD(x) (HW_ENET_RMON_T_P1024TO2047(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_P1024TO2047 bitfields
 */

/*!
 * @name Register ENET_RMON_T_P1024TO2047, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_P1024TO2047_TXPKTS (0U) //!< Bit position for ENET_RMON_T_P1024TO2047_TXPKTS.
#define BM_ENET_RMON_T_P1024TO2047_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_P1024TO2047_TXPKTS.
#define BS_ENET_RMON_T_P1024TO2047_TXPKTS (16U) //!< Bit field size in bits for ENET_RMON_T_P1024TO2047_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_P1024TO2047_TXPKTS field.
#define BR_ENET_RMON_T_P1024TO2047_TXPKTS(x) (HW_ENET_RMON_T_P1024TO2047(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_P_GTE2048 - Tx Packets Greater Than 2048 Bytes Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_P_GTE2048 - Tx Packets Greater Than 2048 Bytes Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_p_gte2048
{
    uint32_t U;
    struct _hw_enet_rmon_t_p_gte2048_bitfields
    {
        uint32_t TXPKTS : 16;          //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_t_p_gte2048_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_P_GTE2048 register
 */
//@{
#define HW_ENET_RMON_T_P_GTE2048_ADDR(x) (REGS_ENET_BASE(x) + 0x240U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_P_GTE2048(x) (*(__I hw_enet_rmon_t_p_gte2048_t *) HW_ENET_RMON_T_P_GTE2048_ADDR(x))
#define HW_ENET_RMON_T_P_GTE2048_RD(x) (HW_ENET_RMON_T_P_GTE2048(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_P_GTE2048 bitfields
 */

/*!
 * @name Register ENET_RMON_T_P_GTE2048, field TXPKTS[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_P_GTE2048_TXPKTS (0U) //!< Bit position for ENET_RMON_T_P_GTE2048_TXPKTS.
#define BM_ENET_RMON_T_P_GTE2048_TXPKTS (0x0000FFFFU) //!< Bit mask for ENET_RMON_T_P_GTE2048_TXPKTS.
#define BS_ENET_RMON_T_P_GTE2048_TXPKTS (16U) //!< Bit field size in bits for ENET_RMON_T_P_GTE2048_TXPKTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_P_GTE2048_TXPKTS field.
#define BR_ENET_RMON_T_P_GTE2048_TXPKTS(x) (HW_ENET_RMON_T_P_GTE2048(x).B.TXPKTS)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_T_OCTETS - Tx Octets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_T_OCTETS - Tx Octets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_t_octets
{
    uint32_t U;
    struct _hw_enet_rmon_t_octets_bitfields
    {
        uint32_t TXOCTS : 32;          //!< [31:0] Octet count
    } B;
} hw_enet_rmon_t_octets_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_T_OCTETS register
 */
//@{
#define HW_ENET_RMON_T_OCTETS_ADDR(x) (REGS_ENET_BASE(x) + 0x244U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_T_OCTETS(x) (*(__I hw_enet_rmon_t_octets_t *) HW_ENET_RMON_T_OCTETS_ADDR(x))
#define HW_ENET_RMON_T_OCTETS_RD(x) (HW_ENET_RMON_T_OCTETS(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_T_OCTETS bitfields
 */

/*!
 * @name Register ENET_RMON_T_OCTETS, field TXOCTS[31:0] (RO)
 */
//@{
#define BP_ENET_RMON_T_OCTETS_TXOCTS (0U)  //!< Bit position for ENET_RMON_T_OCTETS_TXOCTS.
#define BM_ENET_RMON_T_OCTETS_TXOCTS (0xFFFFFFFFU) //!< Bit mask for ENET_RMON_T_OCTETS_TXOCTS.
#define BS_ENET_RMON_T_OCTETS_TXOCTS (32U) //!< Bit field size in bits for ENET_RMON_T_OCTETS_TXOCTS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_T_OCTETS_TXOCTS field.
#define BR_ENET_RMON_T_OCTETS_TXOCTS(x) (HW_ENET_RMON_T_OCTETS(x).U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_T_FRAME_OK - Frames Transmitted OK Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_T_FRAME_OK - Frames Transmitted OK Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_t_frame_ok
{
    uint32_t U;
    struct _hw_enet_ieee_t_frame_ok_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_t_frame_ok_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_T_FRAME_OK register
 */
//@{
#define HW_ENET_IEEE_T_FRAME_OK_ADDR(x) (REGS_ENET_BASE(x) + 0x24CU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_T_FRAME_OK(x) (*(__I hw_enet_ieee_t_frame_ok_t *) HW_ENET_IEEE_T_FRAME_OK_ADDR(x))
#define HW_ENET_IEEE_T_FRAME_OK_RD(x) (HW_ENET_IEEE_T_FRAME_OK(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_T_FRAME_OK bitfields
 */

/*!
 * @name Register ENET_IEEE_T_FRAME_OK, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_T_FRAME_OK_COUNT (0U) //!< Bit position for ENET_IEEE_T_FRAME_OK_COUNT.
#define BM_ENET_IEEE_T_FRAME_OK_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_T_FRAME_OK_COUNT.
#define BS_ENET_IEEE_T_FRAME_OK_COUNT (16U) //!< Bit field size in bits for ENET_IEEE_T_FRAME_OK_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_T_FRAME_OK_COUNT field.
#define BR_ENET_IEEE_T_FRAME_OK_COUNT(x) (HW_ENET_IEEE_T_FRAME_OK(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_T_1COL - Frames Transmitted with Single Collision Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_T_1COL - Frames Transmitted with Single Collision Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_t_1col
{
    uint32_t U;
    struct _hw_enet_ieee_t_1col_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_t_1col_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_T_1COL register
 */
//@{
#define HW_ENET_IEEE_T_1COL_ADDR(x) (REGS_ENET_BASE(x) + 0x250U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_T_1COL(x)   (*(__I hw_enet_ieee_t_1col_t *) HW_ENET_IEEE_T_1COL_ADDR(x))
#define HW_ENET_IEEE_T_1COL_RD(x) (HW_ENET_IEEE_T_1COL(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_T_1COL bitfields
 */

/*!
 * @name Register ENET_IEEE_T_1COL, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_T_1COL_COUNT (0U)     //!< Bit position for ENET_IEEE_T_1COL_COUNT.
#define BM_ENET_IEEE_T_1COL_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_T_1COL_COUNT.
#define BS_ENET_IEEE_T_1COL_COUNT (16U)    //!< Bit field size in bits for ENET_IEEE_T_1COL_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_T_1COL_COUNT field.
#define BR_ENET_IEEE_T_1COL_COUNT(x) (HW_ENET_IEEE_T_1COL(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_T_MCOL - Frames Transmitted with Multiple Collisions Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_T_MCOL - Frames Transmitted with Multiple Collisions Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_t_mcol
{
    uint32_t U;
    struct _hw_enet_ieee_t_mcol_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_t_mcol_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_T_MCOL register
 */
//@{
#define HW_ENET_IEEE_T_MCOL_ADDR(x) (REGS_ENET_BASE(x) + 0x254U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_T_MCOL(x)   (*(__I hw_enet_ieee_t_mcol_t *) HW_ENET_IEEE_T_MCOL_ADDR(x))
#define HW_ENET_IEEE_T_MCOL_RD(x) (HW_ENET_IEEE_T_MCOL(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_T_MCOL bitfields
 */

/*!
 * @name Register ENET_IEEE_T_MCOL, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_T_MCOL_COUNT (0U)     //!< Bit position for ENET_IEEE_T_MCOL_COUNT.
#define BM_ENET_IEEE_T_MCOL_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_T_MCOL_COUNT.
#define BS_ENET_IEEE_T_MCOL_COUNT (16U)    //!< Bit field size in bits for ENET_IEEE_T_MCOL_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_T_MCOL_COUNT field.
#define BR_ENET_IEEE_T_MCOL_COUNT(x) (HW_ENET_IEEE_T_MCOL(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_T_DEF - Frames Transmitted after Deferral Delay Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_T_DEF - Frames Transmitted after Deferral Delay Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_t_def
{
    uint32_t U;
    struct _hw_enet_ieee_t_def_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_t_def_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_T_DEF register
 */
//@{
#define HW_ENET_IEEE_T_DEF_ADDR(x) (REGS_ENET_BASE(x) + 0x258U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_T_DEF(x)    (*(__I hw_enet_ieee_t_def_t *) HW_ENET_IEEE_T_DEF_ADDR(x))
#define HW_ENET_IEEE_T_DEF_RD(x) (HW_ENET_IEEE_T_DEF(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_T_DEF bitfields
 */

/*!
 * @name Register ENET_IEEE_T_DEF, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_T_DEF_COUNT (0U)      //!< Bit position for ENET_IEEE_T_DEF_COUNT.
#define BM_ENET_IEEE_T_DEF_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_T_DEF_COUNT.
#define BS_ENET_IEEE_T_DEF_COUNT (16U)     //!< Bit field size in bits for ENET_IEEE_T_DEF_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_T_DEF_COUNT field.
#define BR_ENET_IEEE_T_DEF_COUNT(x) (HW_ENET_IEEE_T_DEF(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_T_LCOL - Frames Transmitted with Late Collision Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_T_LCOL - Frames Transmitted with Late Collision Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_t_lcol
{
    uint32_t U;
    struct _hw_enet_ieee_t_lcol_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_t_lcol_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_T_LCOL register
 */
//@{
#define HW_ENET_IEEE_T_LCOL_ADDR(x) (REGS_ENET_BASE(x) + 0x25CU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_T_LCOL(x)   (*(__I hw_enet_ieee_t_lcol_t *) HW_ENET_IEEE_T_LCOL_ADDR(x))
#define HW_ENET_IEEE_T_LCOL_RD(x) (HW_ENET_IEEE_T_LCOL(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_T_LCOL bitfields
 */

/*!
 * @name Register ENET_IEEE_T_LCOL, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_T_LCOL_COUNT (0U)     //!< Bit position for ENET_IEEE_T_LCOL_COUNT.
#define BM_ENET_IEEE_T_LCOL_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_T_LCOL_COUNT.
#define BS_ENET_IEEE_T_LCOL_COUNT (16U)    //!< Bit field size in bits for ENET_IEEE_T_LCOL_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_T_LCOL_COUNT field.
#define BR_ENET_IEEE_T_LCOL_COUNT(x) (HW_ENET_IEEE_T_LCOL(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_T_EXCOL - Frames Transmitted with Excessive Collisions Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_T_EXCOL - Frames Transmitted with Excessive Collisions Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_t_excol
{
    uint32_t U;
    struct _hw_enet_ieee_t_excol_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_t_excol_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_T_EXCOL register
 */
//@{
#define HW_ENET_IEEE_T_EXCOL_ADDR(x) (REGS_ENET_BASE(x) + 0x260U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_T_EXCOL(x)  (*(__I hw_enet_ieee_t_excol_t *) HW_ENET_IEEE_T_EXCOL_ADDR(x))
#define HW_ENET_IEEE_T_EXCOL_RD(x) (HW_ENET_IEEE_T_EXCOL(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_T_EXCOL bitfields
 */

/*!
 * @name Register ENET_IEEE_T_EXCOL, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_T_EXCOL_COUNT (0U)    //!< Bit position for ENET_IEEE_T_EXCOL_COUNT.
#define BM_ENET_IEEE_T_EXCOL_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_T_EXCOL_COUNT.
#define BS_ENET_IEEE_T_EXCOL_COUNT (16U)   //!< Bit field size in bits for ENET_IEEE_T_EXCOL_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_T_EXCOL_COUNT field.
#define BR_ENET_IEEE_T_EXCOL_COUNT(x) (HW_ENET_IEEE_T_EXCOL(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_T_MACERR - Frames Transmitted with Tx FIFO Underrun Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_T_MACERR - Frames Transmitted with Tx FIFO Underrun Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_t_macerr
{
    uint32_t U;
    struct _hw_enet_ieee_t_macerr_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_t_macerr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_T_MACERR register
 */
//@{
#define HW_ENET_IEEE_T_MACERR_ADDR(x) (REGS_ENET_BASE(x) + 0x264U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_T_MACERR(x) (*(__I hw_enet_ieee_t_macerr_t *) HW_ENET_IEEE_T_MACERR_ADDR(x))
#define HW_ENET_IEEE_T_MACERR_RD(x) (HW_ENET_IEEE_T_MACERR(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_T_MACERR bitfields
 */

/*!
 * @name Register ENET_IEEE_T_MACERR, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_T_MACERR_COUNT (0U)   //!< Bit position for ENET_IEEE_T_MACERR_COUNT.
#define BM_ENET_IEEE_T_MACERR_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_T_MACERR_COUNT.
#define BS_ENET_IEEE_T_MACERR_COUNT (16U)  //!< Bit field size in bits for ENET_IEEE_T_MACERR_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_T_MACERR_COUNT field.
#define BR_ENET_IEEE_T_MACERR_COUNT(x) (HW_ENET_IEEE_T_MACERR(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_T_CSERR - Frames Transmitted with Carrier Sense Error Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_T_CSERR - Frames Transmitted with Carrier Sense Error Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_t_cserr
{
    uint32_t U;
    struct _hw_enet_ieee_t_cserr_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_t_cserr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_T_CSERR register
 */
//@{
#define HW_ENET_IEEE_T_CSERR_ADDR(x) (REGS_ENET_BASE(x) + 0x268U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_T_CSERR(x)  (*(__I hw_enet_ieee_t_cserr_t *) HW_ENET_IEEE_T_CSERR_ADDR(x))
#define HW_ENET_IEEE_T_CSERR_RD(x) (HW_ENET_IEEE_T_CSERR(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_T_CSERR bitfields
 */

/*!
 * @name Register ENET_IEEE_T_CSERR, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_T_CSERR_COUNT (0U)    //!< Bit position for ENET_IEEE_T_CSERR_COUNT.
#define BM_ENET_IEEE_T_CSERR_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_T_CSERR_COUNT.
#define BS_ENET_IEEE_T_CSERR_COUNT (16U)   //!< Bit field size in bits for ENET_IEEE_T_CSERR_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_T_CSERR_COUNT field.
#define BR_ENET_IEEE_T_CSERR_COUNT(x) (HW_ENET_IEEE_T_CSERR(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_T_FDXFC - Flow Control Pause Frames Transmitted Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_T_FDXFC - Flow Control Pause Frames Transmitted Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_t_fdxfc
{
    uint32_t U;
    struct _hw_enet_ieee_t_fdxfc_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_t_fdxfc_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_T_FDXFC register
 */
//@{
#define HW_ENET_IEEE_T_FDXFC_ADDR(x) (REGS_ENET_BASE(x) + 0x270U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_T_FDXFC(x)  (*(__I hw_enet_ieee_t_fdxfc_t *) HW_ENET_IEEE_T_FDXFC_ADDR(x))
#define HW_ENET_IEEE_T_FDXFC_RD(x) (HW_ENET_IEEE_T_FDXFC(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_T_FDXFC bitfields
 */

/*!
 * @name Register ENET_IEEE_T_FDXFC, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_T_FDXFC_COUNT (0U)    //!< Bit position for ENET_IEEE_T_FDXFC_COUNT.
#define BM_ENET_IEEE_T_FDXFC_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_T_FDXFC_COUNT.
#define BS_ENET_IEEE_T_FDXFC_COUNT (16U)   //!< Bit field size in bits for ENET_IEEE_T_FDXFC_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_T_FDXFC_COUNT field.
#define BR_ENET_IEEE_T_FDXFC_COUNT(x) (HW_ENET_IEEE_T_FDXFC(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_T_OCTETS_OK - Octet Count for Frames Transmitted w/o Error Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_T_OCTETS_OK - Octet Count for Frames Transmitted w/o Error Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * Counts total octets (includes header and FCS fields).
 */
typedef union _hw_enet_ieee_t_octets_ok
{
    uint32_t U;
    struct _hw_enet_ieee_t_octets_ok_bitfields
    {
        uint32_t COUNT : 32;           //!< [31:0] Octet count
    } B;
} hw_enet_ieee_t_octets_ok_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_T_OCTETS_OK register
 */
//@{
#define HW_ENET_IEEE_T_OCTETS_OK_ADDR(x) (REGS_ENET_BASE(x) + 0x274U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_T_OCTETS_OK(x) (*(__I hw_enet_ieee_t_octets_ok_t *) HW_ENET_IEEE_T_OCTETS_OK_ADDR(x))
#define HW_ENET_IEEE_T_OCTETS_OK_RD(x) (HW_ENET_IEEE_T_OCTETS_OK(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_T_OCTETS_OK bitfields
 */

/*!
 * @name Register ENET_IEEE_T_OCTETS_OK, field COUNT[31:0] (RO)
 */
//@{
#define BP_ENET_IEEE_T_OCTETS_OK_COUNT (0U) //!< Bit position for ENET_IEEE_T_OCTETS_OK_COUNT.
#define BM_ENET_IEEE_T_OCTETS_OK_COUNT (0xFFFFFFFFU) //!< Bit mask for ENET_IEEE_T_OCTETS_OK_COUNT.
#define BS_ENET_IEEE_T_OCTETS_OK_COUNT (32U) //!< Bit field size in bits for ENET_IEEE_T_OCTETS_OK_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_T_OCTETS_OK_COUNT field.
#define BR_ENET_IEEE_T_OCTETS_OK_COUNT(x) (HW_ENET_IEEE_T_OCTETS_OK(x).U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_PACKETS - Rx Packet Count Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_PACKETS - Rx Packet Count Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_packets
{
    uint32_t U;
    struct _hw_enet_rmon_r_packets_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_packets_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_PACKETS register
 */
//@{
#define HW_ENET_RMON_R_PACKETS_ADDR(x) (REGS_ENET_BASE(x) + 0x284U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_PACKETS(x) (*(__I hw_enet_rmon_r_packets_t *) HW_ENET_RMON_R_PACKETS_ADDR(x))
#define HW_ENET_RMON_R_PACKETS_RD(x) (HW_ENET_RMON_R_PACKETS(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_PACKETS bitfields
 */

/*!
 * @name Register ENET_RMON_R_PACKETS, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_PACKETS_COUNT (0U)  //!< Bit position for ENET_RMON_R_PACKETS_COUNT.
#define BM_ENET_RMON_R_PACKETS_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_PACKETS_COUNT.
#define BS_ENET_RMON_R_PACKETS_COUNT (16U) //!< Bit field size in bits for ENET_RMON_R_PACKETS_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_PACKETS_COUNT field.
#define BR_ENET_RMON_R_PACKETS_COUNT(x) (HW_ENET_RMON_R_PACKETS(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_BC_PKT - Rx Broadcast Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_BC_PKT - Rx Broadcast Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_bc_pkt
{
    uint32_t U;
    struct _hw_enet_rmon_r_bc_pkt_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_bc_pkt_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_BC_PKT register
 */
//@{
#define HW_ENET_RMON_R_BC_PKT_ADDR(x) (REGS_ENET_BASE(x) + 0x288U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_BC_PKT(x) (*(__I hw_enet_rmon_r_bc_pkt_t *) HW_ENET_RMON_R_BC_PKT_ADDR(x))
#define HW_ENET_RMON_R_BC_PKT_RD(x) (HW_ENET_RMON_R_BC_PKT(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_BC_PKT bitfields
 */

/*!
 * @name Register ENET_RMON_R_BC_PKT, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_BC_PKT_COUNT (0U)   //!< Bit position for ENET_RMON_R_BC_PKT_COUNT.
#define BM_ENET_RMON_R_BC_PKT_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_BC_PKT_COUNT.
#define BS_ENET_RMON_R_BC_PKT_COUNT (16U)  //!< Bit field size in bits for ENET_RMON_R_BC_PKT_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_BC_PKT_COUNT field.
#define BR_ENET_RMON_R_BC_PKT_COUNT(x) (HW_ENET_RMON_R_BC_PKT(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_MC_PKT - Rx Multicast Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_MC_PKT - Rx Multicast Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_mc_pkt
{
    uint32_t U;
    struct _hw_enet_rmon_r_mc_pkt_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_mc_pkt_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_MC_PKT register
 */
//@{
#define HW_ENET_RMON_R_MC_PKT_ADDR(x) (REGS_ENET_BASE(x) + 0x28CU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_MC_PKT(x) (*(__I hw_enet_rmon_r_mc_pkt_t *) HW_ENET_RMON_R_MC_PKT_ADDR(x))
#define HW_ENET_RMON_R_MC_PKT_RD(x) (HW_ENET_RMON_R_MC_PKT(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_MC_PKT bitfields
 */

/*!
 * @name Register ENET_RMON_R_MC_PKT, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_MC_PKT_COUNT (0U)   //!< Bit position for ENET_RMON_R_MC_PKT_COUNT.
#define BM_ENET_RMON_R_MC_PKT_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_MC_PKT_COUNT.
#define BS_ENET_RMON_R_MC_PKT_COUNT (16U)  //!< Bit field size in bits for ENET_RMON_R_MC_PKT_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_MC_PKT_COUNT field.
#define BR_ENET_RMON_R_MC_PKT_COUNT(x) (HW_ENET_RMON_R_MC_PKT(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_CRC_ALIGN - Rx Packets with CRC/Align Error Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_CRC_ALIGN - Rx Packets with CRC/Align Error Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_crc_align
{
    uint32_t U;
    struct _hw_enet_rmon_r_crc_align_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_crc_align_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_CRC_ALIGN register
 */
//@{
#define HW_ENET_RMON_R_CRC_ALIGN_ADDR(x) (REGS_ENET_BASE(x) + 0x290U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_CRC_ALIGN(x) (*(__I hw_enet_rmon_r_crc_align_t *) HW_ENET_RMON_R_CRC_ALIGN_ADDR(x))
#define HW_ENET_RMON_R_CRC_ALIGN_RD(x) (HW_ENET_RMON_R_CRC_ALIGN(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_CRC_ALIGN bitfields
 */

/*!
 * @name Register ENET_RMON_R_CRC_ALIGN, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_CRC_ALIGN_COUNT (0U) //!< Bit position for ENET_RMON_R_CRC_ALIGN_COUNT.
#define BM_ENET_RMON_R_CRC_ALIGN_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_CRC_ALIGN_COUNT.
#define BS_ENET_RMON_R_CRC_ALIGN_COUNT (16U) //!< Bit field size in bits for ENET_RMON_R_CRC_ALIGN_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_CRC_ALIGN_COUNT field.
#define BR_ENET_RMON_R_CRC_ALIGN_COUNT(x) (HW_ENET_RMON_R_CRC_ALIGN(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_UNDERSIZE - Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_UNDERSIZE - Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_undersize
{
    uint32_t U;
    struct _hw_enet_rmon_r_undersize_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_undersize_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_UNDERSIZE register
 */
//@{
#define HW_ENET_RMON_R_UNDERSIZE_ADDR(x) (REGS_ENET_BASE(x) + 0x294U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_UNDERSIZE(x) (*(__I hw_enet_rmon_r_undersize_t *) HW_ENET_RMON_R_UNDERSIZE_ADDR(x))
#define HW_ENET_RMON_R_UNDERSIZE_RD(x) (HW_ENET_RMON_R_UNDERSIZE(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_UNDERSIZE bitfields
 */

/*!
 * @name Register ENET_RMON_R_UNDERSIZE, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_UNDERSIZE_COUNT (0U) //!< Bit position for ENET_RMON_R_UNDERSIZE_COUNT.
#define BM_ENET_RMON_R_UNDERSIZE_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_UNDERSIZE_COUNT.
#define BS_ENET_RMON_R_UNDERSIZE_COUNT (16U) //!< Bit field size in bits for ENET_RMON_R_UNDERSIZE_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_UNDERSIZE_COUNT field.
#define BR_ENET_RMON_R_UNDERSIZE_COUNT(x) (HW_ENET_RMON_R_UNDERSIZE(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_OVERSIZE - Rx Packets Greater Than MAX_FL and Good CRC Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_OVERSIZE - Rx Packets Greater Than MAX_FL and Good CRC Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_oversize
{
    uint32_t U;
    struct _hw_enet_rmon_r_oversize_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_oversize_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_OVERSIZE register
 */
//@{
#define HW_ENET_RMON_R_OVERSIZE_ADDR(x) (REGS_ENET_BASE(x) + 0x298U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_OVERSIZE(x) (*(__I hw_enet_rmon_r_oversize_t *) HW_ENET_RMON_R_OVERSIZE_ADDR(x))
#define HW_ENET_RMON_R_OVERSIZE_RD(x) (HW_ENET_RMON_R_OVERSIZE(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_OVERSIZE bitfields
 */

/*!
 * @name Register ENET_RMON_R_OVERSIZE, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_OVERSIZE_COUNT (0U) //!< Bit position for ENET_RMON_R_OVERSIZE_COUNT.
#define BM_ENET_RMON_R_OVERSIZE_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_OVERSIZE_COUNT.
#define BS_ENET_RMON_R_OVERSIZE_COUNT (16U) //!< Bit field size in bits for ENET_RMON_R_OVERSIZE_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_OVERSIZE_COUNT field.
#define BR_ENET_RMON_R_OVERSIZE_COUNT(x) (HW_ENET_RMON_R_OVERSIZE(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_FRAG - Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_FRAG - Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_frag
{
    uint32_t U;
    struct _hw_enet_rmon_r_frag_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_frag_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_FRAG register
 */
//@{
#define HW_ENET_RMON_R_FRAG_ADDR(x) (REGS_ENET_BASE(x) + 0x29CU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_FRAG(x)   (*(__I hw_enet_rmon_r_frag_t *) HW_ENET_RMON_R_FRAG_ADDR(x))
#define HW_ENET_RMON_R_FRAG_RD(x) (HW_ENET_RMON_R_FRAG(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_FRAG bitfields
 */

/*!
 * @name Register ENET_RMON_R_FRAG, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_FRAG_COUNT (0U)     //!< Bit position for ENET_RMON_R_FRAG_COUNT.
#define BM_ENET_RMON_R_FRAG_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_FRAG_COUNT.
#define BS_ENET_RMON_R_FRAG_COUNT (16U)    //!< Bit field size in bits for ENET_RMON_R_FRAG_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_FRAG_COUNT field.
#define BR_ENET_RMON_R_FRAG_COUNT(x) (HW_ENET_RMON_R_FRAG(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_JAB - Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_JAB - Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_jab
{
    uint32_t U;
    struct _hw_enet_rmon_r_jab_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_jab_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_JAB register
 */
//@{
#define HW_ENET_RMON_R_JAB_ADDR(x) (REGS_ENET_BASE(x) + 0x2A0U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_JAB(x)    (*(__I hw_enet_rmon_r_jab_t *) HW_ENET_RMON_R_JAB_ADDR(x))
#define HW_ENET_RMON_R_JAB_RD(x) (HW_ENET_RMON_R_JAB(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_JAB bitfields
 */

/*!
 * @name Register ENET_RMON_R_JAB, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_JAB_COUNT (0U)      //!< Bit position for ENET_RMON_R_JAB_COUNT.
#define BM_ENET_RMON_R_JAB_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_JAB_COUNT.
#define BS_ENET_RMON_R_JAB_COUNT (16U)     //!< Bit field size in bits for ENET_RMON_R_JAB_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_JAB_COUNT field.
#define BR_ENET_RMON_R_JAB_COUNT(x) (HW_ENET_RMON_R_JAB(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_P64 - Rx 64-Byte Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_P64 - Rx 64-Byte Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_p64
{
    uint32_t U;
    struct _hw_enet_rmon_r_p64_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_p64_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_P64 register
 */
//@{
#define HW_ENET_RMON_R_P64_ADDR(x) (REGS_ENET_BASE(x) + 0x2A8U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_P64(x)    (*(__I hw_enet_rmon_r_p64_t *) HW_ENET_RMON_R_P64_ADDR(x))
#define HW_ENET_RMON_R_P64_RD(x) (HW_ENET_RMON_R_P64(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_P64 bitfields
 */

/*!
 * @name Register ENET_RMON_R_P64, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_P64_COUNT (0U)      //!< Bit position for ENET_RMON_R_P64_COUNT.
#define BM_ENET_RMON_R_P64_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_P64_COUNT.
#define BS_ENET_RMON_R_P64_COUNT (16U)     //!< Bit field size in bits for ENET_RMON_R_P64_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_P64_COUNT field.
#define BR_ENET_RMON_R_P64_COUNT(x) (HW_ENET_RMON_R_P64(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_P65TO127 - Rx 65- to 127-Byte Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_P65TO127 - Rx 65- to 127-Byte Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_p65to127
{
    uint32_t U;
    struct _hw_enet_rmon_r_p65to127_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_p65to127_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_P65TO127 register
 */
//@{
#define HW_ENET_RMON_R_P65TO127_ADDR(x) (REGS_ENET_BASE(x) + 0x2ACU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_P65TO127(x) (*(__I hw_enet_rmon_r_p65to127_t *) HW_ENET_RMON_R_P65TO127_ADDR(x))
#define HW_ENET_RMON_R_P65TO127_RD(x) (HW_ENET_RMON_R_P65TO127(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_P65TO127 bitfields
 */

/*!
 * @name Register ENET_RMON_R_P65TO127, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_P65TO127_COUNT (0U) //!< Bit position for ENET_RMON_R_P65TO127_COUNT.
#define BM_ENET_RMON_R_P65TO127_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_P65TO127_COUNT.
#define BS_ENET_RMON_R_P65TO127_COUNT (16U) //!< Bit field size in bits for ENET_RMON_R_P65TO127_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_P65TO127_COUNT field.
#define BR_ENET_RMON_R_P65TO127_COUNT(x) (HW_ENET_RMON_R_P65TO127(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_P128TO255 - Rx 128- to 255-Byte Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_P128TO255 - Rx 128- to 255-Byte Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_p128to255
{
    uint32_t U;
    struct _hw_enet_rmon_r_p128to255_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_p128to255_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_P128TO255 register
 */
//@{
#define HW_ENET_RMON_R_P128TO255_ADDR(x) (REGS_ENET_BASE(x) + 0x2B0U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_P128TO255(x) (*(__I hw_enet_rmon_r_p128to255_t *) HW_ENET_RMON_R_P128TO255_ADDR(x))
#define HW_ENET_RMON_R_P128TO255_RD(x) (HW_ENET_RMON_R_P128TO255(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_P128TO255 bitfields
 */

/*!
 * @name Register ENET_RMON_R_P128TO255, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_P128TO255_COUNT (0U) //!< Bit position for ENET_RMON_R_P128TO255_COUNT.
#define BM_ENET_RMON_R_P128TO255_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_P128TO255_COUNT.
#define BS_ENET_RMON_R_P128TO255_COUNT (16U) //!< Bit field size in bits for ENET_RMON_R_P128TO255_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_P128TO255_COUNT field.
#define BR_ENET_RMON_R_P128TO255_COUNT(x) (HW_ENET_RMON_R_P128TO255(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_P256TO511 - Rx 256- to 511-Byte Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_P256TO511 - Rx 256- to 511-Byte Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_p256to511
{
    uint32_t U;
    struct _hw_enet_rmon_r_p256to511_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_p256to511_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_P256TO511 register
 */
//@{
#define HW_ENET_RMON_R_P256TO511_ADDR(x) (REGS_ENET_BASE(x) + 0x2B4U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_P256TO511(x) (*(__I hw_enet_rmon_r_p256to511_t *) HW_ENET_RMON_R_P256TO511_ADDR(x))
#define HW_ENET_RMON_R_P256TO511_RD(x) (HW_ENET_RMON_R_P256TO511(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_P256TO511 bitfields
 */

/*!
 * @name Register ENET_RMON_R_P256TO511, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_P256TO511_COUNT (0U) //!< Bit position for ENET_RMON_R_P256TO511_COUNT.
#define BM_ENET_RMON_R_P256TO511_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_P256TO511_COUNT.
#define BS_ENET_RMON_R_P256TO511_COUNT (16U) //!< Bit field size in bits for ENET_RMON_R_P256TO511_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_P256TO511_COUNT field.
#define BR_ENET_RMON_R_P256TO511_COUNT(x) (HW_ENET_RMON_R_P256TO511(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_P512TO1023 - Rx 512- to 1023-Byte Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_P512TO1023 - Rx 512- to 1023-Byte Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_p512to1023
{
    uint32_t U;
    struct _hw_enet_rmon_r_p512to1023_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_p512to1023_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_P512TO1023 register
 */
//@{
#define HW_ENET_RMON_R_P512TO1023_ADDR(x) (REGS_ENET_BASE(x) + 0x2B8U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_P512TO1023(x) (*(__I hw_enet_rmon_r_p512to1023_t *) HW_ENET_RMON_R_P512TO1023_ADDR(x))
#define HW_ENET_RMON_R_P512TO1023_RD(x) (HW_ENET_RMON_R_P512TO1023(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_P512TO1023 bitfields
 */

/*!
 * @name Register ENET_RMON_R_P512TO1023, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_P512TO1023_COUNT (0U) //!< Bit position for ENET_RMON_R_P512TO1023_COUNT.
#define BM_ENET_RMON_R_P512TO1023_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_P512TO1023_COUNT.
#define BS_ENET_RMON_R_P512TO1023_COUNT (16U) //!< Bit field size in bits for ENET_RMON_R_P512TO1023_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_P512TO1023_COUNT field.
#define BR_ENET_RMON_R_P512TO1023_COUNT(x) (HW_ENET_RMON_R_P512TO1023(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_P1024TO2047 - Rx 1024- to 2047-Byte Packets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_P1024TO2047 - Rx 1024- to 2047-Byte Packets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_p1024to2047
{
    uint32_t U;
    struct _hw_enet_rmon_r_p1024to2047_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_p1024to2047_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_P1024TO2047 register
 */
//@{
#define HW_ENET_RMON_R_P1024TO2047_ADDR(x) (REGS_ENET_BASE(x) + 0x2BCU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_P1024TO2047(x) (*(__I hw_enet_rmon_r_p1024to2047_t *) HW_ENET_RMON_R_P1024TO2047_ADDR(x))
#define HW_ENET_RMON_R_P1024TO2047_RD(x) (HW_ENET_RMON_R_P1024TO2047(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_P1024TO2047 bitfields
 */

/*!
 * @name Register ENET_RMON_R_P1024TO2047, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_P1024TO2047_COUNT (0U) //!< Bit position for ENET_RMON_R_P1024TO2047_COUNT.
#define BM_ENET_RMON_R_P1024TO2047_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_P1024TO2047_COUNT.
#define BS_ENET_RMON_R_P1024TO2047_COUNT (16U) //!< Bit field size in bits for ENET_RMON_R_P1024TO2047_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_P1024TO2047_COUNT field.
#define BR_ENET_RMON_R_P1024TO2047_COUNT(x) (HW_ENET_RMON_R_P1024TO2047(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_GTE2048 - Rx Packets Greater than 2048 Bytes Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_GTE2048 - Rx Packets Greater than 2048 Bytes Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_gte2048
{
    uint32_t U;
    struct _hw_enet_rmon_r_gte2048_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Packet count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_rmon_r_gte2048_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_GTE2048 register
 */
//@{
#define HW_ENET_RMON_R_GTE2048_ADDR(x) (REGS_ENET_BASE(x) + 0x2C0U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_GTE2048(x) (*(__I hw_enet_rmon_r_gte2048_t *) HW_ENET_RMON_R_GTE2048_ADDR(x))
#define HW_ENET_RMON_R_GTE2048_RD(x) (HW_ENET_RMON_R_GTE2048(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_GTE2048 bitfields
 */

/*!
 * @name Register ENET_RMON_R_GTE2048, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_GTE2048_COUNT (0U)  //!< Bit position for ENET_RMON_R_GTE2048_COUNT.
#define BM_ENET_RMON_R_GTE2048_COUNT (0x0000FFFFU) //!< Bit mask for ENET_RMON_R_GTE2048_COUNT.
#define BS_ENET_RMON_R_GTE2048_COUNT (16U) //!< Bit field size in bits for ENET_RMON_R_GTE2048_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_GTE2048_COUNT field.
#define BR_ENET_RMON_R_GTE2048_COUNT(x) (HW_ENET_RMON_R_GTE2048(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_RMON_R_OCTETS - Rx Octets Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_RMON_R_OCTETS - Rx Octets Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_rmon_r_octets
{
    uint32_t U;
    struct _hw_enet_rmon_r_octets_bitfields
    {
        uint32_t COUNT : 32;           //!< [31:0] Octet count
    } B;
} hw_enet_rmon_r_octets_t;
#endif

/*!
 * @name Constants and macros for entire ENET_RMON_R_OCTETS register
 */
//@{
#define HW_ENET_RMON_R_OCTETS_ADDR(x) (REGS_ENET_BASE(x) + 0x2C4U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_RMON_R_OCTETS(x) (*(__I hw_enet_rmon_r_octets_t *) HW_ENET_RMON_R_OCTETS_ADDR(x))
#define HW_ENET_RMON_R_OCTETS_RD(x) (HW_ENET_RMON_R_OCTETS(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_RMON_R_OCTETS bitfields
 */

/*!
 * @name Register ENET_RMON_R_OCTETS, field COUNT[31:0] (RO)
 */
//@{
#define BP_ENET_RMON_R_OCTETS_COUNT (0U)   //!< Bit position for ENET_RMON_R_OCTETS_COUNT.
#define BM_ENET_RMON_R_OCTETS_COUNT (0xFFFFFFFFU) //!< Bit mask for ENET_RMON_R_OCTETS_COUNT.
#define BS_ENET_RMON_R_OCTETS_COUNT (32U)  //!< Bit field size in bits for ENET_RMON_R_OCTETS_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_RMON_R_OCTETS_COUNT field.
#define BR_ENET_RMON_R_OCTETS_COUNT(x) (HW_ENET_RMON_R_OCTETS(x).U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_R_DROP - Frames not Counted Correctly Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_R_DROP - Frames not Counted Correctly Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * Counter increments if a frame with invalid or missing SFD character is
 * detected and has been dropped. None of the other counters increments if this counter
 * increments.
 */
typedef union _hw_enet_ieee_r_drop
{
    uint32_t U;
    struct _hw_enet_ieee_r_drop_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_r_drop_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_R_DROP register
 */
//@{
#define HW_ENET_IEEE_R_DROP_ADDR(x) (REGS_ENET_BASE(x) + 0x2C8U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_R_DROP(x)   (*(__I hw_enet_ieee_r_drop_t *) HW_ENET_IEEE_R_DROP_ADDR(x))
#define HW_ENET_IEEE_R_DROP_RD(x) (HW_ENET_IEEE_R_DROP(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_R_DROP bitfields
 */

/*!
 * @name Register ENET_IEEE_R_DROP, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_R_DROP_COUNT (0U)     //!< Bit position for ENET_IEEE_R_DROP_COUNT.
#define BM_ENET_IEEE_R_DROP_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_R_DROP_COUNT.
#define BS_ENET_IEEE_R_DROP_COUNT (16U)    //!< Bit field size in bits for ENET_IEEE_R_DROP_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_R_DROP_COUNT field.
#define BR_ENET_IEEE_R_DROP_COUNT(x) (HW_ENET_IEEE_R_DROP(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_R_FRAME_OK - Frames Received OK Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_R_FRAME_OK - Frames Received OK Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_r_frame_ok
{
    uint32_t U;
    struct _hw_enet_ieee_r_frame_ok_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_r_frame_ok_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_R_FRAME_OK register
 */
//@{
#define HW_ENET_IEEE_R_FRAME_OK_ADDR(x) (REGS_ENET_BASE(x) + 0x2CCU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_R_FRAME_OK(x) (*(__I hw_enet_ieee_r_frame_ok_t *) HW_ENET_IEEE_R_FRAME_OK_ADDR(x))
#define HW_ENET_IEEE_R_FRAME_OK_RD(x) (HW_ENET_IEEE_R_FRAME_OK(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_R_FRAME_OK bitfields
 */

/*!
 * @name Register ENET_IEEE_R_FRAME_OK, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_R_FRAME_OK_COUNT (0U) //!< Bit position for ENET_IEEE_R_FRAME_OK_COUNT.
#define BM_ENET_IEEE_R_FRAME_OK_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_R_FRAME_OK_COUNT.
#define BS_ENET_IEEE_R_FRAME_OK_COUNT (16U) //!< Bit field size in bits for ENET_IEEE_R_FRAME_OK_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_R_FRAME_OK_COUNT field.
#define BR_ENET_IEEE_R_FRAME_OK_COUNT(x) (HW_ENET_IEEE_R_FRAME_OK(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_R_CRC - Frames Received with CRC Error Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_R_CRC - Frames Received with CRC Error Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_r_crc
{
    uint32_t U;
    struct _hw_enet_ieee_r_crc_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_r_crc_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_R_CRC register
 */
//@{
#define HW_ENET_IEEE_R_CRC_ADDR(x) (REGS_ENET_BASE(x) + 0x2D0U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_R_CRC(x)    (*(__I hw_enet_ieee_r_crc_t *) HW_ENET_IEEE_R_CRC_ADDR(x))
#define HW_ENET_IEEE_R_CRC_RD(x) (HW_ENET_IEEE_R_CRC(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_R_CRC bitfields
 */

/*!
 * @name Register ENET_IEEE_R_CRC, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_R_CRC_COUNT (0U)      //!< Bit position for ENET_IEEE_R_CRC_COUNT.
#define BM_ENET_IEEE_R_CRC_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_R_CRC_COUNT.
#define BS_ENET_IEEE_R_CRC_COUNT (16U)     //!< Bit field size in bits for ENET_IEEE_R_CRC_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_R_CRC_COUNT field.
#define BR_ENET_IEEE_R_CRC_COUNT(x) (HW_ENET_IEEE_R_CRC(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_R_ALIGN - Frames Received with Alignment Error Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_R_ALIGN - Frames Received with Alignment Error Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_r_align
{
    uint32_t U;
    struct _hw_enet_ieee_r_align_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_r_align_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_R_ALIGN register
 */
//@{
#define HW_ENET_IEEE_R_ALIGN_ADDR(x) (REGS_ENET_BASE(x) + 0x2D4U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_R_ALIGN(x)  (*(__I hw_enet_ieee_r_align_t *) HW_ENET_IEEE_R_ALIGN_ADDR(x))
#define HW_ENET_IEEE_R_ALIGN_RD(x) (HW_ENET_IEEE_R_ALIGN(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_R_ALIGN bitfields
 */

/*!
 * @name Register ENET_IEEE_R_ALIGN, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_R_ALIGN_COUNT (0U)    //!< Bit position for ENET_IEEE_R_ALIGN_COUNT.
#define BM_ENET_IEEE_R_ALIGN_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_R_ALIGN_COUNT.
#define BS_ENET_IEEE_R_ALIGN_COUNT (16U)   //!< Bit field size in bits for ENET_IEEE_R_ALIGN_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_R_ALIGN_COUNT field.
#define BR_ENET_IEEE_R_ALIGN_COUNT(x) (HW_ENET_IEEE_R_ALIGN(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_R_MACERR - Receive FIFO Overflow Count Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_R_MACERR - Receive FIFO Overflow Count Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_r_macerr
{
    uint32_t U;
    struct _hw_enet_ieee_r_macerr_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_r_macerr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_R_MACERR register
 */
//@{
#define HW_ENET_IEEE_R_MACERR_ADDR(x) (REGS_ENET_BASE(x) + 0x2D8U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_R_MACERR(x) (*(__I hw_enet_ieee_r_macerr_t *) HW_ENET_IEEE_R_MACERR_ADDR(x))
#define HW_ENET_IEEE_R_MACERR_RD(x) (HW_ENET_IEEE_R_MACERR(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_R_MACERR bitfields
 */

/*!
 * @name Register ENET_IEEE_R_MACERR, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_R_MACERR_COUNT (0U)   //!< Bit position for ENET_IEEE_R_MACERR_COUNT.
#define BM_ENET_IEEE_R_MACERR_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_R_MACERR_COUNT.
#define BS_ENET_IEEE_R_MACERR_COUNT (16U)  //!< Bit field size in bits for ENET_IEEE_R_MACERR_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_R_MACERR_COUNT field.
#define BR_ENET_IEEE_R_MACERR_COUNT(x) (HW_ENET_IEEE_R_MACERR(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_R_FDXFC - Flow Control Pause Frames Received Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_R_FDXFC - Flow Control Pause Frames Received Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_r_fdxfc
{
    uint32_t U;
    struct _hw_enet_ieee_r_fdxfc_bitfields
    {
        uint32_t COUNT : 16;           //!< [15:0] Pause frame count
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_enet_ieee_r_fdxfc_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_R_FDXFC register
 */
//@{
#define HW_ENET_IEEE_R_FDXFC_ADDR(x) (REGS_ENET_BASE(x) + 0x2DCU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_R_FDXFC(x)  (*(__I hw_enet_ieee_r_fdxfc_t *) HW_ENET_IEEE_R_FDXFC_ADDR(x))
#define HW_ENET_IEEE_R_FDXFC_RD(x) (HW_ENET_IEEE_R_FDXFC(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_R_FDXFC bitfields
 */

/*!
 * @name Register ENET_IEEE_R_FDXFC, field COUNT[15:0] (RO)
 */
//@{
#define BP_ENET_IEEE_R_FDXFC_COUNT (0U)    //!< Bit position for ENET_IEEE_R_FDXFC_COUNT.
#define BM_ENET_IEEE_R_FDXFC_COUNT (0x0000FFFFU) //!< Bit mask for ENET_IEEE_R_FDXFC_COUNT.
#define BS_ENET_IEEE_R_FDXFC_COUNT (16U)   //!< Bit field size in bits for ENET_IEEE_R_FDXFC_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_R_FDXFC_COUNT field.
#define BR_ENET_IEEE_R_FDXFC_COUNT(x) (HW_ENET_IEEE_R_FDXFC(x).B.COUNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_IEEE_R_OCTETS_OK - Octet Count for Frames Received without Error Statistic Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_IEEE_R_OCTETS_OK - Octet Count for Frames Received without Error Statistic Register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_ieee_r_octets_ok
{
    uint32_t U;
    struct _hw_enet_ieee_r_octets_ok_bitfields
    {
        uint32_t COUNT : 32;           //!< [31:0] Octet count
    } B;
} hw_enet_ieee_r_octets_ok_t;
#endif

/*!
 * @name Constants and macros for entire ENET_IEEE_R_OCTETS_OK register
 */
//@{
#define HW_ENET_IEEE_R_OCTETS_OK_ADDR(x) (REGS_ENET_BASE(x) + 0x2E0U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_IEEE_R_OCTETS_OK(x) (*(__I hw_enet_ieee_r_octets_ok_t *) HW_ENET_IEEE_R_OCTETS_OK_ADDR(x))
#define HW_ENET_IEEE_R_OCTETS_OK_RD(x) (HW_ENET_IEEE_R_OCTETS_OK(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_IEEE_R_OCTETS_OK bitfields
 */

/*!
 * @name Register ENET_IEEE_R_OCTETS_OK, field COUNT[31:0] (RO)
 */
//@{
#define BP_ENET_IEEE_R_OCTETS_OK_COUNT (0U) //!< Bit position for ENET_IEEE_R_OCTETS_OK_COUNT.
#define BM_ENET_IEEE_R_OCTETS_OK_COUNT (0xFFFFFFFFU) //!< Bit mask for ENET_IEEE_R_OCTETS_OK_COUNT.
#define BS_ENET_IEEE_R_OCTETS_OK_COUNT (32U) //!< Bit field size in bits for ENET_IEEE_R_OCTETS_OK_COUNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_IEEE_R_OCTETS_OK_COUNT field.
#define BR_ENET_IEEE_R_OCTETS_OK_COUNT(x) (HW_ENET_IEEE_R_OCTETS_OK(x).U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_ATCR - Adjustable Timer Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_ATCR - Adjustable Timer Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * ATCR command fields can trigger the corresponding events directly. It is not
 * necessary to preserve any of the configuration fields when a command field is
 * set in the register, that is, no read-modify-write is required. The fields are
 * automatically cleared after the command completes.
 */
typedef union _hw_enet_atcr
{
    uint32_t U;
    struct _hw_enet_atcr_bitfields
    {
        uint32_t EN : 1;               //!< [0] Enable Timer
        uint32_t RESERVED0 : 1;        //!< [1]
        uint32_t OFFEN : 1;            //!< [2] Enable One-Shot Offset Event
        uint32_t OFFRST : 1;           //!< [3] Reset Timer On Offset Event
        uint32_t PEREN : 1;            //!< [4] Enable Periodical Event
        uint32_t RESERVED1 : 2;        //!< [6:5]
        uint32_t PINPER : 1;           //!< [7]
        uint32_t RESERVED2 : 1;        //!< [8]
        uint32_t RESTART : 1;          //!< [9] Reset Timer
        uint32_t RESERVED3 : 1;        //!< [10]
        uint32_t CAPTURE : 1;          //!< [11] Capture Timer Value
        uint32_t RESERVED4 : 1;        //!< [12]
        uint32_t SLAVE : 1;            //!< [13] Enable Timer Slave Mode
        uint32_t RESERVED5 : 18;       //!< [31:14]
    } B;
} hw_enet_atcr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_ATCR register
 */
//@{
#define HW_ENET_ATCR_ADDR(x)     (REGS_ENET_BASE(x) + 0x400U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_ATCR(x)          (*(__IO hw_enet_atcr_t *) HW_ENET_ATCR_ADDR(x))
#define HW_ENET_ATCR_RD(x)       (HW_ENET_ATCR(x).U)
#define HW_ENET_ATCR_WR(x, v)    (HW_ENET_ATCR(x).U = (v))
#define HW_ENET_ATCR_SET(x, v)   (HW_ENET_ATCR_WR(x, HW_ENET_ATCR_RD(x) |  (v)))
#define HW_ENET_ATCR_CLR(x, v)   (HW_ENET_ATCR_WR(x, HW_ENET_ATCR_RD(x) & ~(v)))
#define HW_ENET_ATCR_TOG(x, v)   (HW_ENET_ATCR_WR(x, HW_ENET_ATCR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_ATCR bitfields
 */

/*!
 * @name Register ENET_ATCR, field EN[0] (RW)
 *
 * Values:
 * - 0 - The timer stops at the current value.
 * - 1 - The timer starts incrementing.
 */
//@{
#define BP_ENET_ATCR_EN      (0U)          //!< Bit position for ENET_ATCR_EN.
#define BM_ENET_ATCR_EN      (0x00000001U) //!< Bit mask for ENET_ATCR_EN.
#define BS_ENET_ATCR_EN      (1U)          //!< Bit field size in bits for ENET_ATCR_EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATCR_EN field.
#define BR_ENET_ATCR_EN(x)   (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_EN))
#endif

//! @brief Format value for bitfield ENET_ATCR_EN.
#define BF_ENET_ATCR_EN(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATCR_EN), uint32_t) & BM_ENET_ATCR_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EN field to a new value.
#define BW_ENET_ATCR_EN(x, v) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_EN) = (v))
#endif
//@}

/*!
 * @name Register ENET_ATCR, field OFFEN[2] (RW)
 *
 * Values:
 * - 0 - Disable.
 * - 1 - The timer can be reset to zero when the given offset time is reached
 *     (offset event). The field is cleared when the offset event is reached, so no
 *     further event occurs until the field is set again. The timer offset value
 *     must be set before setting this field.
 */
//@{
#define BP_ENET_ATCR_OFFEN   (2U)          //!< Bit position for ENET_ATCR_OFFEN.
#define BM_ENET_ATCR_OFFEN   (0x00000004U) //!< Bit mask for ENET_ATCR_OFFEN.
#define BS_ENET_ATCR_OFFEN   (1U)          //!< Bit field size in bits for ENET_ATCR_OFFEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATCR_OFFEN field.
#define BR_ENET_ATCR_OFFEN(x) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_OFFEN))
#endif

//! @brief Format value for bitfield ENET_ATCR_OFFEN.
#define BF_ENET_ATCR_OFFEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATCR_OFFEN), uint32_t) & BM_ENET_ATCR_OFFEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OFFEN field to a new value.
#define BW_ENET_ATCR_OFFEN(x, v) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_OFFEN) = (v))
#endif
//@}

/*!
 * @name Register ENET_ATCR, field OFFRST[3] (RW)
 *
 * Values:
 * - 0 - The timer is not affected and no action occurs, besides clearing OFFEN,
 *     when the offset is reached.
 * - 1 - If OFFEN is set, the timer resets to zero when the offset setting is
 *     reached. The offset event does not cause a timer interrupt.
 */
//@{
#define BP_ENET_ATCR_OFFRST  (3U)          //!< Bit position for ENET_ATCR_OFFRST.
#define BM_ENET_ATCR_OFFRST  (0x00000008U) //!< Bit mask for ENET_ATCR_OFFRST.
#define BS_ENET_ATCR_OFFRST  (1U)          //!< Bit field size in bits for ENET_ATCR_OFFRST.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATCR_OFFRST field.
#define BR_ENET_ATCR_OFFRST(x) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_OFFRST))
#endif

//! @brief Format value for bitfield ENET_ATCR_OFFRST.
#define BF_ENET_ATCR_OFFRST(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATCR_OFFRST), uint32_t) & BM_ENET_ATCR_OFFRST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OFFRST field to a new value.
#define BW_ENET_ATCR_OFFRST(x, v) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_OFFRST) = (v))
#endif
//@}

/*!
 * @name Register ENET_ATCR, field PEREN[4] (RW)
 *
 * Values:
 * - 0 - Disable.
 * - 1 - A period event interrupt can be generated (EIR[TS_TIMER]) and the event
 *     signal output is asserted when the timer wraps around according to the
 *     periodic setting ATPER. The timer period value must be set before setting
 *     this bit. Not all devices contain the event signal output. See the chip
 *     configuration details.
 */
//@{
#define BP_ENET_ATCR_PEREN   (4U)          //!< Bit position for ENET_ATCR_PEREN.
#define BM_ENET_ATCR_PEREN   (0x00000010U) //!< Bit mask for ENET_ATCR_PEREN.
#define BS_ENET_ATCR_PEREN   (1U)          //!< Bit field size in bits for ENET_ATCR_PEREN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATCR_PEREN field.
#define BR_ENET_ATCR_PEREN(x) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_PEREN))
#endif

//! @brief Format value for bitfield ENET_ATCR_PEREN.
#define BF_ENET_ATCR_PEREN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATCR_PEREN), uint32_t) & BM_ENET_ATCR_PEREN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PEREN field to a new value.
#define BW_ENET_ATCR_PEREN(x, v) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_PEREN) = (v))
#endif
//@}

/*!
 * @name Register ENET_ATCR, field PINPER[7] (RW)
 *
 * Enables event signal output assertion on period event. Not all devices
 * contain the event signal output. See the chip configuration details.
 *
 * Values:
 * - 0 - Disable.
 * - 1 - Enable.
 */
//@{
#define BP_ENET_ATCR_PINPER  (7U)          //!< Bit position for ENET_ATCR_PINPER.
#define BM_ENET_ATCR_PINPER  (0x00000080U) //!< Bit mask for ENET_ATCR_PINPER.
#define BS_ENET_ATCR_PINPER  (1U)          //!< Bit field size in bits for ENET_ATCR_PINPER.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATCR_PINPER field.
#define BR_ENET_ATCR_PINPER(x) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_PINPER))
#endif

//! @brief Format value for bitfield ENET_ATCR_PINPER.
#define BF_ENET_ATCR_PINPER(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATCR_PINPER), uint32_t) & BM_ENET_ATCR_PINPER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PINPER field to a new value.
#define BW_ENET_ATCR_PINPER(x, v) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_PINPER) = (v))
#endif
//@}

/*!
 * @name Register ENET_ATCR, field RESTART[9] (RW)
 *
 * Resets the timer to zero. This has no effect on the counter enable. If the
 * counter is enabled when this field is set, the timer is reset to zero and starts
 * counting from there. When set, all other fields are ignored during a write.
 */
//@{
#define BP_ENET_ATCR_RESTART (9U)          //!< Bit position for ENET_ATCR_RESTART.
#define BM_ENET_ATCR_RESTART (0x00000200U) //!< Bit mask for ENET_ATCR_RESTART.
#define BS_ENET_ATCR_RESTART (1U)          //!< Bit field size in bits for ENET_ATCR_RESTART.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATCR_RESTART field.
#define BR_ENET_ATCR_RESTART(x) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_RESTART))
#endif

//! @brief Format value for bitfield ENET_ATCR_RESTART.
#define BF_ENET_ATCR_RESTART(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATCR_RESTART), uint32_t) & BM_ENET_ATCR_RESTART)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RESTART field to a new value.
#define BW_ENET_ATCR_RESTART(x, v) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_RESTART) = (v))
#endif
//@}

/*!
 * @name Register ENET_ATCR, field CAPTURE[11] (RW)
 *
 * Values:
 * - 0 - No effect.
 * - 1 - The current time is captured and can be read from the ATVR register.
 */
//@{
#define BP_ENET_ATCR_CAPTURE (11U)         //!< Bit position for ENET_ATCR_CAPTURE.
#define BM_ENET_ATCR_CAPTURE (0x00000800U) //!< Bit mask for ENET_ATCR_CAPTURE.
#define BS_ENET_ATCR_CAPTURE (1U)          //!< Bit field size in bits for ENET_ATCR_CAPTURE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATCR_CAPTURE field.
#define BR_ENET_ATCR_CAPTURE(x) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_CAPTURE))
#endif

//! @brief Format value for bitfield ENET_ATCR_CAPTURE.
#define BF_ENET_ATCR_CAPTURE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATCR_CAPTURE), uint32_t) & BM_ENET_ATCR_CAPTURE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CAPTURE field to a new value.
#define BW_ENET_ATCR_CAPTURE(x, v) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_CAPTURE) = (v))
#endif
//@}

/*!
 * @name Register ENET_ATCR, field SLAVE[13] (RW)
 *
 * Values:
 * - 0 - The timer is active and all configuration fields in this register are
 *     relevant.
 * - 1 - The internal timer is disabled and the externally provided timer value
 *     is used. All other fields, except CAPTURE, in this register have no
 *     effect. CAPTURE can still be used to capture the current timer value.
 */
//@{
#define BP_ENET_ATCR_SLAVE   (13U)         //!< Bit position for ENET_ATCR_SLAVE.
#define BM_ENET_ATCR_SLAVE   (0x00002000U) //!< Bit mask for ENET_ATCR_SLAVE.
#define BS_ENET_ATCR_SLAVE   (1U)          //!< Bit field size in bits for ENET_ATCR_SLAVE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATCR_SLAVE field.
#define BR_ENET_ATCR_SLAVE(x) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_SLAVE))
#endif

//! @brief Format value for bitfield ENET_ATCR_SLAVE.
#define BF_ENET_ATCR_SLAVE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATCR_SLAVE), uint32_t) & BM_ENET_ATCR_SLAVE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SLAVE field to a new value.
#define BW_ENET_ATCR_SLAVE(x, v) (BITBAND_ACCESS32(HW_ENET_ATCR_ADDR(x), BP_ENET_ATCR_SLAVE) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_ATVR - Timer Value Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_ATVR - Timer Value Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_atvr
{
    uint32_t U;
    struct _hw_enet_atvr_bitfields
    {
        uint32_t ATIME : 32;           //!< [31:0]
    } B;
} hw_enet_atvr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_ATVR register
 */
//@{
#define HW_ENET_ATVR_ADDR(x)     (REGS_ENET_BASE(x) + 0x404U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_ATVR(x)          (*(__IO hw_enet_atvr_t *) HW_ENET_ATVR_ADDR(x))
#define HW_ENET_ATVR_RD(x)       (HW_ENET_ATVR(x).U)
#define HW_ENET_ATVR_WR(x, v)    (HW_ENET_ATVR(x).U = (v))
#define HW_ENET_ATVR_SET(x, v)   (HW_ENET_ATVR_WR(x, HW_ENET_ATVR_RD(x) |  (v)))
#define HW_ENET_ATVR_CLR(x, v)   (HW_ENET_ATVR_WR(x, HW_ENET_ATVR_RD(x) & ~(v)))
#define HW_ENET_ATVR_TOG(x, v)   (HW_ENET_ATVR_WR(x, HW_ENET_ATVR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_ATVR bitfields
 */

/*!
 * @name Register ENET_ATVR, field ATIME[31:0] (RW)
 *
 * A write sets the timer. A read returns the last captured value. To read the
 * current value, issue a capture command (set ATCR[CAPTURE]) prior to reading
 * this register.
 */
//@{
#define BP_ENET_ATVR_ATIME   (0U)          //!< Bit position for ENET_ATVR_ATIME.
#define BM_ENET_ATVR_ATIME   (0xFFFFFFFFU) //!< Bit mask for ENET_ATVR_ATIME.
#define BS_ENET_ATVR_ATIME   (32U)         //!< Bit field size in bits for ENET_ATVR_ATIME.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATVR_ATIME field.
#define BR_ENET_ATVR_ATIME(x) (HW_ENET_ATVR(x).U)
#endif

//! @brief Format value for bitfield ENET_ATVR_ATIME.
#define BF_ENET_ATVR_ATIME(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATVR_ATIME), uint32_t) & BM_ENET_ATVR_ATIME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ATIME field to a new value.
#define BW_ENET_ATVR_ATIME(x, v) (HW_ENET_ATVR_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_ATOFF - Timer Offset Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_ATOFF - Timer Offset Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_atoff
{
    uint32_t U;
    struct _hw_enet_atoff_bitfields
    {
        uint32_t OFFSET : 32;          //!< [31:0]
    } B;
} hw_enet_atoff_t;
#endif

/*!
 * @name Constants and macros for entire ENET_ATOFF register
 */
//@{
#define HW_ENET_ATOFF_ADDR(x)    (REGS_ENET_BASE(x) + 0x408U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_ATOFF(x)         (*(__IO hw_enet_atoff_t *) HW_ENET_ATOFF_ADDR(x))
#define HW_ENET_ATOFF_RD(x)      (HW_ENET_ATOFF(x).U)
#define HW_ENET_ATOFF_WR(x, v)   (HW_ENET_ATOFF(x).U = (v))
#define HW_ENET_ATOFF_SET(x, v)  (HW_ENET_ATOFF_WR(x, HW_ENET_ATOFF_RD(x) |  (v)))
#define HW_ENET_ATOFF_CLR(x, v)  (HW_ENET_ATOFF_WR(x, HW_ENET_ATOFF_RD(x) & ~(v)))
#define HW_ENET_ATOFF_TOG(x, v)  (HW_ENET_ATOFF_WR(x, HW_ENET_ATOFF_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_ATOFF bitfields
 */

/*!
 * @name Register ENET_ATOFF, field OFFSET[31:0] (RW)
 *
 * Offset value for one-shot event generation. When the timer reaches the value,
 * an event can be generated to reset the counter. If the increment value in
 * ATINC is given in true nanoseconds, this value is also given in true nanoseconds.
 */
//@{
#define BP_ENET_ATOFF_OFFSET (0U)          //!< Bit position for ENET_ATOFF_OFFSET.
#define BM_ENET_ATOFF_OFFSET (0xFFFFFFFFU) //!< Bit mask for ENET_ATOFF_OFFSET.
#define BS_ENET_ATOFF_OFFSET (32U)         //!< Bit field size in bits for ENET_ATOFF_OFFSET.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATOFF_OFFSET field.
#define BR_ENET_ATOFF_OFFSET(x) (HW_ENET_ATOFF(x).U)
#endif

//! @brief Format value for bitfield ENET_ATOFF_OFFSET.
#define BF_ENET_ATOFF_OFFSET(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATOFF_OFFSET), uint32_t) & BM_ENET_ATOFF_OFFSET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OFFSET field to a new value.
#define BW_ENET_ATOFF_OFFSET(x, v) (HW_ENET_ATOFF_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_ATPER - Timer Period Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_ATPER - Timer Period Register (RW)
 *
 * Reset value: 0x3B9ACA00U
 */
typedef union _hw_enet_atper
{
    uint32_t U;
    struct _hw_enet_atper_bitfields
    {
        uint32_t PERIOD : 32;          //!< [31:0]
    } B;
} hw_enet_atper_t;
#endif

/*!
 * @name Constants and macros for entire ENET_ATPER register
 */
//@{
#define HW_ENET_ATPER_ADDR(x)    (REGS_ENET_BASE(x) + 0x40CU)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_ATPER(x)         (*(__IO hw_enet_atper_t *) HW_ENET_ATPER_ADDR(x))
#define HW_ENET_ATPER_RD(x)      (HW_ENET_ATPER(x).U)
#define HW_ENET_ATPER_WR(x, v)   (HW_ENET_ATPER(x).U = (v))
#define HW_ENET_ATPER_SET(x, v)  (HW_ENET_ATPER_WR(x, HW_ENET_ATPER_RD(x) |  (v)))
#define HW_ENET_ATPER_CLR(x, v)  (HW_ENET_ATPER_WR(x, HW_ENET_ATPER_RD(x) & ~(v)))
#define HW_ENET_ATPER_TOG(x, v)  (HW_ENET_ATPER_WR(x, HW_ENET_ATPER_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_ATPER bitfields
 */

/*!
 * @name Register ENET_ATPER, field PERIOD[31:0] (RW)
 *
 * Value for generating periodic events. Each instance the timer reaches this
 * value, the period event occurs and the timer restarts. If the increment value in
 * ATINC is given in true nanoseconds, this value is also given in true
 * nanoseconds. The value should be initialized to 1,000,000,000 (1 x 10 9 ) to represent
 * a timer wrap around of one second. The increment value set in ATINC should be
 * set to the true nanoseconds of the period of clock ts_clk, hence implementing
 * a true 1 second counter.
 */
//@{
#define BP_ENET_ATPER_PERIOD (0U)          //!< Bit position for ENET_ATPER_PERIOD.
#define BM_ENET_ATPER_PERIOD (0xFFFFFFFFU) //!< Bit mask for ENET_ATPER_PERIOD.
#define BS_ENET_ATPER_PERIOD (32U)         //!< Bit field size in bits for ENET_ATPER_PERIOD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATPER_PERIOD field.
#define BR_ENET_ATPER_PERIOD(x) (HW_ENET_ATPER(x).U)
#endif

//! @brief Format value for bitfield ENET_ATPER_PERIOD.
#define BF_ENET_ATPER_PERIOD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATPER_PERIOD), uint32_t) & BM_ENET_ATPER_PERIOD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PERIOD field to a new value.
#define BW_ENET_ATPER_PERIOD(x, v) (HW_ENET_ATPER_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_ATCOR - Timer Correction Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_ATCOR - Timer Correction Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_atcor
{
    uint32_t U;
    struct _hw_enet_atcor_bitfields
    {
        uint32_t COR : 31;             //!< [30:0] Correction Counter Wrap-Around Value
        uint32_t RESERVED0 : 1;        //!< [31]
    } B;
} hw_enet_atcor_t;
#endif

/*!
 * @name Constants and macros for entire ENET_ATCOR register
 */
//@{
#define HW_ENET_ATCOR_ADDR(x)    (REGS_ENET_BASE(x) + 0x410U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_ATCOR(x)         (*(__IO hw_enet_atcor_t *) HW_ENET_ATCOR_ADDR(x))
#define HW_ENET_ATCOR_RD(x)      (HW_ENET_ATCOR(x).U)
#define HW_ENET_ATCOR_WR(x, v)   (HW_ENET_ATCOR(x).U = (v))
#define HW_ENET_ATCOR_SET(x, v)  (HW_ENET_ATCOR_WR(x, HW_ENET_ATCOR_RD(x) |  (v)))
#define HW_ENET_ATCOR_CLR(x, v)  (HW_ENET_ATCOR_WR(x, HW_ENET_ATCOR_RD(x) & ~(v)))
#define HW_ENET_ATCOR_TOG(x, v)  (HW_ENET_ATCOR_WR(x, HW_ENET_ATCOR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_ATCOR bitfields
 */

/*!
 * @name Register ENET_ATCOR, field COR[30:0] (RW)
 *
 * Defines after how many timer clock cycles (ts_clk) the correction counter
 * should be reset and trigger a correction increment on the timer. The amount of
 * correction is defined in ATINC[INC_CORR]. A value of 0 disables the correction
 * counter and no corrections occur. This value is given in clock cycles, not in
 * nanoseconds as all other values.
 */
//@{
#define BP_ENET_ATCOR_COR    (0U)          //!< Bit position for ENET_ATCOR_COR.
#define BM_ENET_ATCOR_COR    (0x7FFFFFFFU) //!< Bit mask for ENET_ATCOR_COR.
#define BS_ENET_ATCOR_COR    (31U)         //!< Bit field size in bits for ENET_ATCOR_COR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATCOR_COR field.
#define BR_ENET_ATCOR_COR(x) (HW_ENET_ATCOR(x).B.COR)
#endif

//! @brief Format value for bitfield ENET_ATCOR_COR.
#define BF_ENET_ATCOR_COR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATCOR_COR), uint32_t) & BM_ENET_ATCOR_COR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the COR field to a new value.
#define BW_ENET_ATCOR_COR(x, v) (HW_ENET_ATCOR_WR(x, (HW_ENET_ATCOR_RD(x) & ~BM_ENET_ATCOR_COR) | BF_ENET_ATCOR_COR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_ATINC - Time-Stamping Clock Period Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_ATINC - Time-Stamping Clock Period Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_atinc
{
    uint32_t U;
    struct _hw_enet_atinc_bitfields
    {
        uint32_t INC : 7;              //!< [6:0] Clock Period Of The Timestamping Clock
                                       //! (ts_clk) In Nanoseconds
        uint32_t RESERVED0 : 1;        //!< [7]
        uint32_t INC_CORR : 7;         //!< [14:8] Correction Increment Value
        uint32_t RESERVED1 : 17;       //!< [31:15]
    } B;
} hw_enet_atinc_t;
#endif

/*!
 * @name Constants and macros for entire ENET_ATINC register
 */
//@{
#define HW_ENET_ATINC_ADDR(x)    (REGS_ENET_BASE(x) + 0x414U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_ATINC(x)         (*(__IO hw_enet_atinc_t *) HW_ENET_ATINC_ADDR(x))
#define HW_ENET_ATINC_RD(x)      (HW_ENET_ATINC(x).U)
#define HW_ENET_ATINC_WR(x, v)   (HW_ENET_ATINC(x).U = (v))
#define HW_ENET_ATINC_SET(x, v)  (HW_ENET_ATINC_WR(x, HW_ENET_ATINC_RD(x) |  (v)))
#define HW_ENET_ATINC_CLR(x, v)  (HW_ENET_ATINC_WR(x, HW_ENET_ATINC_RD(x) & ~(v)))
#define HW_ENET_ATINC_TOG(x, v)  (HW_ENET_ATINC_WR(x, HW_ENET_ATINC_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_ATINC bitfields
 */

/*!
 * @name Register ENET_ATINC, field INC[6:0] (RW)
 *
 * The timer increments by this amount each clock cycle. For example, set to 10
 * for 100 MHz, 8 for 125 MHz, 5 for 200 MHz. For highest precision, use a value
 * that is an integer fraction of the period set in ATPER.
 */
//@{
#define BP_ENET_ATINC_INC    (0U)          //!< Bit position for ENET_ATINC_INC.
#define BM_ENET_ATINC_INC    (0x0000007FU) //!< Bit mask for ENET_ATINC_INC.
#define BS_ENET_ATINC_INC    (7U)          //!< Bit field size in bits for ENET_ATINC_INC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATINC_INC field.
#define BR_ENET_ATINC_INC(x) (HW_ENET_ATINC(x).B.INC)
#endif

//! @brief Format value for bitfield ENET_ATINC_INC.
#define BF_ENET_ATINC_INC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATINC_INC), uint32_t) & BM_ENET_ATINC_INC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INC field to a new value.
#define BW_ENET_ATINC_INC(x, v) (HW_ENET_ATINC_WR(x, (HW_ENET_ATINC_RD(x) & ~BM_ENET_ATINC_INC) | BF_ENET_ATINC_INC(v)))
#endif
//@}

/*!
 * @name Register ENET_ATINC, field INC_CORR[14:8] (RW)
 *
 * This value is added every time the correction timer expires (every clock
 * cycle given in ATCOR). A value less than INC slows down the timer. A value greater
 * than INC speeds up the timer.
 */
//@{
#define BP_ENET_ATINC_INC_CORR (8U)        //!< Bit position for ENET_ATINC_INC_CORR.
#define BM_ENET_ATINC_INC_CORR (0x00007F00U) //!< Bit mask for ENET_ATINC_INC_CORR.
#define BS_ENET_ATINC_INC_CORR (7U)        //!< Bit field size in bits for ENET_ATINC_INC_CORR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATINC_INC_CORR field.
#define BR_ENET_ATINC_INC_CORR(x) (HW_ENET_ATINC(x).B.INC_CORR)
#endif

//! @brief Format value for bitfield ENET_ATINC_INC_CORR.
#define BF_ENET_ATINC_INC_CORR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_ATINC_INC_CORR), uint32_t) & BM_ENET_ATINC_INC_CORR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INC_CORR field to a new value.
#define BW_ENET_ATINC_INC_CORR(x, v) (HW_ENET_ATINC_WR(x, (HW_ENET_ATINC_RD(x) & ~BM_ENET_ATINC_INC_CORR) | BF_ENET_ATINC_INC_CORR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_ATSTMP - Timestamp of Last Transmitted Frame
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_ATSTMP - Timestamp of Last Transmitted Frame (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_atstmp
{
    uint32_t U;
    struct _hw_enet_atstmp_bitfields
    {
        uint32_t TIMESTAMP : 32;       //!< [31:0]
    } B;
} hw_enet_atstmp_t;
#endif

/*!
 * @name Constants and macros for entire ENET_ATSTMP register
 */
//@{
#define HW_ENET_ATSTMP_ADDR(x)   (REGS_ENET_BASE(x) + 0x418U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_ATSTMP(x)        (*(__I hw_enet_atstmp_t *) HW_ENET_ATSTMP_ADDR(x))
#define HW_ENET_ATSTMP_RD(x)     (HW_ENET_ATSTMP(x).U)
#endif
//@}

/*
 * Constants & macros for individual ENET_ATSTMP bitfields
 */

/*!
 * @name Register ENET_ATSTMP, field TIMESTAMP[31:0] (RO)
 *
 * Timestamp of the last frame transmitted by the core that had TxBD[TS] set .
 * This register is only valid when EIR[TS_AVAIL] is set.
 */
//@{
#define BP_ENET_ATSTMP_TIMESTAMP (0U)      //!< Bit position for ENET_ATSTMP_TIMESTAMP.
#define BM_ENET_ATSTMP_TIMESTAMP (0xFFFFFFFFU) //!< Bit mask for ENET_ATSTMP_TIMESTAMP.
#define BS_ENET_ATSTMP_TIMESTAMP (32U)     //!< Bit field size in bits for ENET_ATSTMP_TIMESTAMP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_ATSTMP_TIMESTAMP field.
#define BR_ENET_ATSTMP_TIMESTAMP(x) (HW_ENET_ATSTMP(x).U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_TGSR - Timer Global Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_TGSR - Timer Global Status Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_tgsr
{
    uint32_t U;
    struct _hw_enet_tgsr_bitfields
    {
        uint32_t TF0 : 1;              //!< [0] Copy Of Timer Flag For Channel 0
        uint32_t TF1 : 1;              //!< [1] Copy Of Timer Flag For Channel 1
        uint32_t TF2 : 1;              //!< [2] Copy Of Timer Flag For Channel 2
        uint32_t TF3 : 1;              //!< [3] Copy Of Timer Flag For Channel 3
        uint32_t RESERVED0 : 28;       //!< [31:4]
    } B;
} hw_enet_tgsr_t;
#endif

/*!
 * @name Constants and macros for entire ENET_TGSR register
 */
//@{
#define HW_ENET_TGSR_ADDR(x)     (REGS_ENET_BASE(x) + 0x604U)

#ifndef __LANGUAGE_ASM__
#define HW_ENET_TGSR(x)          (*(__IO hw_enet_tgsr_t *) HW_ENET_TGSR_ADDR(x))
#define HW_ENET_TGSR_RD(x)       (HW_ENET_TGSR(x).U)
#define HW_ENET_TGSR_WR(x, v)    (HW_ENET_TGSR(x).U = (v))
#define HW_ENET_TGSR_SET(x, v)   (HW_ENET_TGSR_WR(x, HW_ENET_TGSR_RD(x) |  (v)))
#define HW_ENET_TGSR_CLR(x, v)   (HW_ENET_TGSR_WR(x, HW_ENET_TGSR_RD(x) & ~(v)))
#define HW_ENET_TGSR_TOG(x, v)   (HW_ENET_TGSR_WR(x, HW_ENET_TGSR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_TGSR bitfields
 */

/*!
 * @name Register ENET_TGSR, field TF0[0] (W1C)
 *
 * Values:
 * - 0 - Timer Flag for Channel 0 is clear
 * - 1 - Timer Flag for Channel 0 is set
 */
//@{
#define BP_ENET_TGSR_TF0     (0U)          //!< Bit position for ENET_TGSR_TF0.
#define BM_ENET_TGSR_TF0     (0x00000001U) //!< Bit mask for ENET_TGSR_TF0.
#define BS_ENET_TGSR_TF0     (1U)          //!< Bit field size in bits for ENET_TGSR_TF0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TGSR_TF0 field.
#define BR_ENET_TGSR_TF0(x)  (BITBAND_ACCESS32(HW_ENET_TGSR_ADDR(x), BP_ENET_TGSR_TF0))
#endif

//! @brief Format value for bitfield ENET_TGSR_TF0.
#define BF_ENET_TGSR_TF0(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TGSR_TF0), uint32_t) & BM_ENET_TGSR_TF0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TF0 field to a new value.
#define BW_ENET_TGSR_TF0(x, v) (BITBAND_ACCESS32(HW_ENET_TGSR_ADDR(x), BP_ENET_TGSR_TF0) = (v))
#endif
//@}

/*!
 * @name Register ENET_TGSR, field TF1[1] (W1C)
 *
 * Values:
 * - 0 - Timer Flag for Channel 1 is clear
 * - 1 - Timer Flag for Channel 1 is set
 */
//@{
#define BP_ENET_TGSR_TF1     (1U)          //!< Bit position for ENET_TGSR_TF1.
#define BM_ENET_TGSR_TF1     (0x00000002U) //!< Bit mask for ENET_TGSR_TF1.
#define BS_ENET_TGSR_TF1     (1U)          //!< Bit field size in bits for ENET_TGSR_TF1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TGSR_TF1 field.
#define BR_ENET_TGSR_TF1(x)  (BITBAND_ACCESS32(HW_ENET_TGSR_ADDR(x), BP_ENET_TGSR_TF1))
#endif

//! @brief Format value for bitfield ENET_TGSR_TF1.
#define BF_ENET_TGSR_TF1(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TGSR_TF1), uint32_t) & BM_ENET_TGSR_TF1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TF1 field to a new value.
#define BW_ENET_TGSR_TF1(x, v) (BITBAND_ACCESS32(HW_ENET_TGSR_ADDR(x), BP_ENET_TGSR_TF1) = (v))
#endif
//@}

/*!
 * @name Register ENET_TGSR, field TF2[2] (W1C)
 *
 * Values:
 * - 0 - Timer Flag for Channel 2 is clear
 * - 1 - Timer Flag for Channel 2 is set
 */
//@{
#define BP_ENET_TGSR_TF2     (2U)          //!< Bit position for ENET_TGSR_TF2.
#define BM_ENET_TGSR_TF2     (0x00000004U) //!< Bit mask for ENET_TGSR_TF2.
#define BS_ENET_TGSR_TF2     (1U)          //!< Bit field size in bits for ENET_TGSR_TF2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TGSR_TF2 field.
#define BR_ENET_TGSR_TF2(x)  (BITBAND_ACCESS32(HW_ENET_TGSR_ADDR(x), BP_ENET_TGSR_TF2))
#endif

//! @brief Format value for bitfield ENET_TGSR_TF2.
#define BF_ENET_TGSR_TF2(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TGSR_TF2), uint32_t) & BM_ENET_TGSR_TF2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TF2 field to a new value.
#define BW_ENET_TGSR_TF2(x, v) (BITBAND_ACCESS32(HW_ENET_TGSR_ADDR(x), BP_ENET_TGSR_TF2) = (v))
#endif
//@}

/*!
 * @name Register ENET_TGSR, field TF3[3] (W1C)
 *
 * Values:
 * - 0 - Timer Flag for Channel 3 is clear
 * - 1 - Timer Flag for Channel 3 is set
 */
//@{
#define BP_ENET_TGSR_TF3     (3U)          //!< Bit position for ENET_TGSR_TF3.
#define BM_ENET_TGSR_TF3     (0x00000008U) //!< Bit mask for ENET_TGSR_TF3.
#define BS_ENET_TGSR_TF3     (1U)          //!< Bit field size in bits for ENET_TGSR_TF3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TGSR_TF3 field.
#define BR_ENET_TGSR_TF3(x)  (BITBAND_ACCESS32(HW_ENET_TGSR_ADDR(x), BP_ENET_TGSR_TF3))
#endif

//! @brief Format value for bitfield ENET_TGSR_TF3.
#define BF_ENET_TGSR_TF3(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TGSR_TF3), uint32_t) & BM_ENET_TGSR_TF3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TF3 field to a new value.
#define BW_ENET_TGSR_TF3(x, v) (BITBAND_ACCESS32(HW_ENET_TGSR_ADDR(x), BP_ENET_TGSR_TF3) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_ENET_TCSRn - Timer Control Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_TCSRn - Timer Control Status Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_tcsrn
{
    uint32_t U;
    struct _hw_enet_tcsrn_bitfields
    {
        uint32_t TDRE : 1;             //!< [0] Timer DMA Request Enable
        uint32_t RESERVED0 : 1;        //!< [1]
        uint32_t TMODE : 4;            //!< [5:2] Timer Mode
        uint32_t TIE : 1;              //!< [6] Timer Interrupt Enable
        uint32_t TF : 1;               //!< [7] Timer Flag
        uint32_t RESERVED1 : 24;       //!< [31:8]
    } B;
} hw_enet_tcsrn_t;
#endif

/*!
 * @name Constants and macros for entire ENET_TCSRn register
 */
//@{
#define HW_ENET_TCSRn_COUNT (4U)

#define HW_ENET_TCSRn_ADDR(x, n) (REGS_ENET_BASE(x) + 0x608U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_ENET_TCSRn(x, n)      (*(__IO hw_enet_tcsrn_t *) HW_ENET_TCSRn_ADDR(x, n))
#define HW_ENET_TCSRn_RD(x, n)   (HW_ENET_TCSRn(x, n).U)
#define HW_ENET_TCSRn_WR(x, n, v) (HW_ENET_TCSRn(x, n).U = (v))
#define HW_ENET_TCSRn_SET(x, n, v) (HW_ENET_TCSRn_WR(x, n, HW_ENET_TCSRn_RD(x, n) |  (v)))
#define HW_ENET_TCSRn_CLR(x, n, v) (HW_ENET_TCSRn_WR(x, n, HW_ENET_TCSRn_RD(x, n) & ~(v)))
#define HW_ENET_TCSRn_TOG(x, n, v) (HW_ENET_TCSRn_WR(x, n, HW_ENET_TCSRn_RD(x, n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_TCSRn bitfields
 */

/*!
 * @name Register ENET_TCSRn, field TDRE[0] (RW)
 *
 * Values:
 * - 0 - DMA request is disabled
 * - 1 - DMA request is enabled
 */
//@{
#define BP_ENET_TCSRn_TDRE   (0U)          //!< Bit position for ENET_TCSRn_TDRE.
#define BM_ENET_TCSRn_TDRE   (0x00000001U) //!< Bit mask for ENET_TCSRn_TDRE.
#define BS_ENET_TCSRn_TDRE   (1U)          //!< Bit field size in bits for ENET_TCSRn_TDRE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TCSRn_TDRE field.
#define BR_ENET_TCSRn_TDRE(x, n) (BITBAND_ACCESS32(HW_ENET_TCSRn_ADDR(x, n), BP_ENET_TCSRn_TDRE))
#endif

//! @brief Format value for bitfield ENET_TCSRn_TDRE.
#define BF_ENET_TCSRn_TDRE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TCSRn_TDRE), uint32_t) & BM_ENET_TCSRn_TDRE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDRE field to a new value.
#define BW_ENET_TCSRn_TDRE(x, n, v) (BITBAND_ACCESS32(HW_ENET_TCSRn_ADDR(x, n), BP_ENET_TCSRn_TDRE) = (v))
#endif
//@}

/*!
 * @name Register ENET_TCSRn, field TMODE[5:2] (RW)
 *
 * Updating the Timer Mode field takes a few cycles to register because it is
 * synchronized to the 1588 clock. The version of Timer Mode returned on a read is
 * from the 1588 clock domain. When changing Timer Mode, always disable the
 * channel and read this register to verify the channel is disabled first.
 *
 * Values:
 * - 0000 - Timer Channel is disabled.
 * - 0001 - Timer Channel is configured for Input Capture on rising edge
 * - 0010 - Timer Channel is configured for Input Capture on falling edge
 * - 0011 - Timer Channel is configured for Input Capture on both edges
 * - 0100 - Timer Channel is configured for Output Compare - software only
 * - 0101 - Timer Channel is configured for Output Compare - toggle output on
 *     compare
 * - 0110 - Timer Channel is configured for Output Compare - clear output on
 *     compare
 * - 0111 - Timer Channel is configured for Output Compare - set output on
 *     compare
 * - 1000 - Reserved
 * - 1010 - Timer Channel is configured for Output Compare - clear output on
 *     compare, set output on overflow
 * - 10x1 - Timer Channel is configured for Output Compare - set output on
 *     compare, clear output on overflow
 * - 1100 - Reserved
 * - 1110 - Timer Channel is configured for Output Compare - pulse output low on
 *     compare for one 1588 clock cycle
 * - 1111 - Timer Channel is configured for Output Compare - pulse output high
 *     on compare for one 1588 clock cycle
 */
//@{
#define BP_ENET_TCSRn_TMODE  (2U)          //!< Bit position for ENET_TCSRn_TMODE.
#define BM_ENET_TCSRn_TMODE  (0x0000003CU) //!< Bit mask for ENET_TCSRn_TMODE.
#define BS_ENET_TCSRn_TMODE  (4U)          //!< Bit field size in bits for ENET_TCSRn_TMODE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TCSRn_TMODE field.
#define BR_ENET_TCSRn_TMODE(x, n) (HW_ENET_TCSRn(x, n).B.TMODE)
#endif

//! @brief Format value for bitfield ENET_TCSRn_TMODE.
#define BF_ENET_TCSRn_TMODE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TCSRn_TMODE), uint32_t) & BM_ENET_TCSRn_TMODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TMODE field to a new value.
#define BW_ENET_TCSRn_TMODE(x, n, v) (HW_ENET_TCSRn_WR(x, n, (HW_ENET_TCSRn_RD(x, n) & ~BM_ENET_TCSRn_TMODE) | BF_ENET_TCSRn_TMODE(v)))
#endif
//@}

/*!
 * @name Register ENET_TCSRn, field TIE[6] (RW)
 *
 * Values:
 * - 0 - Interrupt is disabled
 * - 1 - Interrupt is enabled
 */
//@{
#define BP_ENET_TCSRn_TIE    (6U)          //!< Bit position for ENET_TCSRn_TIE.
#define BM_ENET_TCSRn_TIE    (0x00000040U) //!< Bit mask for ENET_TCSRn_TIE.
#define BS_ENET_TCSRn_TIE    (1U)          //!< Bit field size in bits for ENET_TCSRn_TIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TCSRn_TIE field.
#define BR_ENET_TCSRn_TIE(x, n) (BITBAND_ACCESS32(HW_ENET_TCSRn_ADDR(x, n), BP_ENET_TCSRn_TIE))
#endif

//! @brief Format value for bitfield ENET_TCSRn_TIE.
#define BF_ENET_TCSRn_TIE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TCSRn_TIE), uint32_t) & BM_ENET_TCSRn_TIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TIE field to a new value.
#define BW_ENET_TCSRn_TIE(x, n, v) (BITBAND_ACCESS32(HW_ENET_TCSRn_ADDR(x, n), BP_ENET_TCSRn_TIE) = (v))
#endif
//@}

/*!
 * @name Register ENET_TCSRn, field TF[7] (W1C)
 *
 * Sets when input capture or output compare occurs. This flag is double
 * buffered between the module clock and 1588 clock domains. When this field is 1, it
 * can be cleared to 0 by writing 1 to it.
 *
 * Values:
 * - 0 - Input Capture or Output Compare has not occurred
 * - 1 - Input Capture or Output Compare has occurred
 */
//@{
#define BP_ENET_TCSRn_TF     (7U)          //!< Bit position for ENET_TCSRn_TF.
#define BM_ENET_TCSRn_TF     (0x00000080U) //!< Bit mask for ENET_TCSRn_TF.
#define BS_ENET_TCSRn_TF     (1U)          //!< Bit field size in bits for ENET_TCSRn_TF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TCSRn_TF field.
#define BR_ENET_TCSRn_TF(x, n) (BITBAND_ACCESS32(HW_ENET_TCSRn_ADDR(x, n), BP_ENET_TCSRn_TF))
#endif

//! @brief Format value for bitfield ENET_TCSRn_TF.
#define BF_ENET_TCSRn_TF(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TCSRn_TF), uint32_t) & BM_ENET_TCSRn_TF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TF field to a new value.
#define BW_ENET_TCSRn_TF(x, n, v) (BITBAND_ACCESS32(HW_ENET_TCSRn_ADDR(x, n), BP_ENET_TCSRn_TF) = (v))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_ENET_TCCRn - Timer Compare Capture Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_ENET_TCCRn - Timer Compare Capture Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_enet_tccrn
{
    uint32_t U;
    struct _hw_enet_tccrn_bitfields
    {
        uint32_t TCC : 32;             //!< [31:0] Timer Capture Compare
    } B;
} hw_enet_tccrn_t;
#endif

/*!
 * @name Constants and macros for entire ENET_TCCRn register
 */
//@{
#define HW_ENET_TCCRn_COUNT (4U)

#define HW_ENET_TCCRn_ADDR(x, n) (REGS_ENET_BASE(x) + 0x60CU + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_ENET_TCCRn(x, n)      (*(__IO hw_enet_tccrn_t *) HW_ENET_TCCRn_ADDR(x, n))
#define HW_ENET_TCCRn_RD(x, n)   (HW_ENET_TCCRn(x, n).U)
#define HW_ENET_TCCRn_WR(x, n, v) (HW_ENET_TCCRn(x, n).U = (v))
#define HW_ENET_TCCRn_SET(x, n, v) (HW_ENET_TCCRn_WR(x, n, HW_ENET_TCCRn_RD(x, n) |  (v)))
#define HW_ENET_TCCRn_CLR(x, n, v) (HW_ENET_TCCRn_WR(x, n, HW_ENET_TCCRn_RD(x, n) & ~(v)))
#define HW_ENET_TCCRn_TOG(x, n, v) (HW_ENET_TCCRn_WR(x, n, HW_ENET_TCCRn_RD(x, n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual ENET_TCCRn bitfields
 */

/*!
 * @name Register ENET_TCCRn, field TCC[31:0] (RW)
 *
 * This register is double buffered between the module clock and 1588 clock
 * domains. When configured for compare, the 1588 clock domain updates with the value
 * in the module clock domain whenever the Timer Channel is first enabled and on
 * each subsequent compare. Write to this register with the first compare value
 * before enabling the Timer Channel. When the Timer Channel is enabled, write
 * the second compare value either immediately, or at least before the first
 * compare occurs. After each compare, write the next compare value before the previous
 * compare occurs and before clearing the Timer Flag. The compare occurs one
 * 1588 clock cycle after the IEEE 1588 Counter increments past the compare value in
 * the 1588 clock domain. If the compare value is less than the value of the
 * 1588 Counter when the Timer Channel is first enabled, then the compare does not
 * occur until following the next overflow of the 1588 Counter. If the compare
 * value is greater than the IEEE 1588 Counter when the 1588 Counter overflows, or
 * the compare value is less than the value of the IEEE 1588 Counter after the
 * overflow, then the compare occurs one 1588 clock cycle following the overflow.
 * When configured for Capture, the value of the IEEE 1588 Counter is captured into
 * the 1588 clock domain and then updated into the module clock domain, provided
 * the Timer Flag is clear. Always read the capture value before clearing the
 * Timer Flag.
 */
//@{
#define BP_ENET_TCCRn_TCC    (0U)          //!< Bit position for ENET_TCCRn_TCC.
#define BM_ENET_TCCRn_TCC    (0xFFFFFFFFU) //!< Bit mask for ENET_TCCRn_TCC.
#define BS_ENET_TCCRn_TCC    (32U)         //!< Bit field size in bits for ENET_TCCRn_TCC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the ENET_TCCRn_TCC field.
#define BR_ENET_TCCRn_TCC(x, n) (HW_ENET_TCCRn(x, n).U)
#endif

//! @brief Format value for bitfield ENET_TCCRn_TCC.
#define BF_ENET_TCCRn_TCC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_ENET_TCCRn_TCC), uint32_t) & BM_ENET_TCCRn_TCC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TCC field to a new value.
#define BW_ENET_TCCRn_TCC(x, n, v) (HW_ENET_TCCRn_WR(x, n, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_enet_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All ENET module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_enet
{
    uint8_t _reserved0[4];
    __IO hw_enet_eir_t EIR;                //!< [0x4] Interrupt Event Register
    __IO hw_enet_eimr_t EIMR;              //!< [0x8] Interrupt Mask Register
    uint8_t _reserved1[4];
    __IO hw_enet_rdar_t RDAR;              //!< [0x10] Receive Descriptor Active Register
    __IO hw_enet_tdar_t TDAR;              //!< [0x14] Transmit Descriptor Active Register
    uint8_t _reserved2[12];
    __IO hw_enet_ecr_t ECR;                //!< [0x24] Ethernet Control Register
    uint8_t _reserved3[24];
    __IO hw_enet_mmfr_t MMFR;              //!< [0x40] MII Management Frame Register
    __IO hw_enet_mscr_t MSCR;              //!< [0x44] MII Speed Control Register
    uint8_t _reserved4[28];
    __IO hw_enet_mibc_t MIBC;              //!< [0x64] MIB Control Register
    uint8_t _reserved5[28];
    __IO hw_enet_rcr_t RCR;                //!< [0x84] Receive Control Register
    uint8_t _reserved6[60];
    __IO hw_enet_tcr_t TCR;                //!< [0xC4] Transmit Control Register
    uint8_t _reserved7[28];
    __IO hw_enet_palr_t PALR;              //!< [0xE4] Physical Address Lower Register
    __IO hw_enet_paur_t PAUR;              //!< [0xE8] Physical Address Upper Register
    __IO hw_enet_opd_t OPD;                //!< [0xEC] Opcode/Pause Duration Register
    uint8_t _reserved8[40];
    __IO hw_enet_iaur_t IAUR;              //!< [0x118] Descriptor Individual Upper Address Register
    __IO hw_enet_ialr_t IALR;              //!< [0x11C] Descriptor Individual Lower Address Register
    __IO hw_enet_gaur_t GAUR;              //!< [0x120] Descriptor Group Upper Address Register
    __IO hw_enet_galr_t GALR;              //!< [0x124] Descriptor Group Lower Address Register
    uint8_t _reserved9[28];
    __IO hw_enet_tfwr_t TFWR;              //!< [0x144] Transmit FIFO Watermark Register
    uint8_t _reserved10[56];
    __IO hw_enet_rdsr_t RDSR;              //!< [0x180] Receive Descriptor Ring Start Register
    __IO hw_enet_tdsr_t TDSR;              //!< [0x184] Transmit Buffer Descriptor Ring Start Register
    __IO hw_enet_mrbr_t MRBR;              //!< [0x188] Maximum Receive Buffer Size Register
    uint8_t _reserved11[4];
    __IO hw_enet_rsfl_t RSFL;              //!< [0x190] Receive FIFO Section Full Threshold
    __IO hw_enet_rsem_t RSEM;              //!< [0x194] Receive FIFO Section Empty Threshold
    __IO hw_enet_raem_t RAEM;              //!< [0x198] Receive FIFO Almost Empty Threshold
    __IO hw_enet_rafl_t RAFL;              //!< [0x19C] Receive FIFO Almost Full Threshold
    __IO hw_enet_tsem_t TSEM;              //!< [0x1A0] Transmit FIFO Section Empty Threshold
    __IO hw_enet_taem_t TAEM;              //!< [0x1A4] Transmit FIFO Almost Empty Threshold
    __IO hw_enet_tafl_t TAFL;              //!< [0x1A8] Transmit FIFO Almost Full Threshold
    __IO hw_enet_tipg_t TIPG;              //!< [0x1AC] Transmit Inter-Packet Gap
    __IO hw_enet_ftrl_t FTRL;              //!< [0x1B0] Frame Truncation Length
    uint8_t _reserved12[12];
    __IO hw_enet_tacc_t TACC;              //!< [0x1C0] Transmit Accelerator Function Configuration
    __IO hw_enet_racc_t RACC;              //!< [0x1C4] Receive Accelerator Function Configuration
    uint8_t _reserved13[60];
    __I hw_enet_rmon_t_packets_t RMON_T_PACKETS; //!< [0x204] Tx Packet Count Statistic Register
    __I hw_enet_rmon_t_bc_pkt_t RMON_T_BC_PKT; //!< [0x208] Tx Broadcast Packets Statistic Register
    __I hw_enet_rmon_t_mc_pkt_t RMON_T_MC_PKT; //!< [0x20C] Tx Multicast Packets Statistic Register
    __I hw_enet_rmon_t_crc_align_t RMON_T_CRC_ALIGN; //!< [0x210] Tx Packets with CRC/Align Error Statistic Register
    __I hw_enet_rmon_t_undersize_t RMON_T_UNDERSIZE; //!< [0x214] Tx Packets Less Than Bytes and Good CRC Statistic Register
    __I hw_enet_rmon_t_oversize_t RMON_T_OVERSIZE; //!< [0x218] Tx Packets GT MAX_FL bytes and Good CRC Statistic Register
    __I hw_enet_rmon_t_frag_t RMON_T_FRAG; //!< [0x21C] Tx Packets Less Than 64 Bytes and Bad CRC Statistic Register
    __I hw_enet_rmon_t_jab_t RMON_T_JAB;   //!< [0x220] Tx Packets Greater Than MAX_FL bytes and Bad CRC Statistic Register
    __I hw_enet_rmon_t_col_t RMON_T_COL;   //!< [0x224] Tx Collision Count Statistic Register
    __I hw_enet_rmon_t_p64_t RMON_T_P64;   //!< [0x228] Tx 64-Byte Packets Statistic Register
    __I hw_enet_rmon_t_p65to127_t RMON_T_P65TO127; //!< [0x22C] Tx 65- to 127-byte Packets Statistic Register
    __I hw_enet_rmon_t_p128to255_t RMON_T_P128TO255; //!< [0x230] Tx 128- to 255-byte Packets Statistic Register
    __I hw_enet_rmon_t_p256to511_t RMON_T_P256TO511; //!< [0x234] Tx 256- to 511-byte Packets Statistic Register
    __I hw_enet_rmon_t_p512to1023_t RMON_T_P512TO1023; //!< [0x238] Tx 512- to 1023-byte Packets Statistic Register
    __I hw_enet_rmon_t_p1024to2047_t RMON_T_P1024TO2047; //!< [0x23C] Tx 1024- to 2047-byte Packets Statistic Register
    __I hw_enet_rmon_t_p_gte2048_t RMON_T_P_GTE2048; //!< [0x240] Tx Packets Greater Than 2048 Bytes Statistic Register
    __I hw_enet_rmon_t_octets_t RMON_T_OCTETS; //!< [0x244] Tx Octets Statistic Register
    uint8_t _reserved14[4];
    __I hw_enet_ieee_t_frame_ok_t IEEE_T_FRAME_OK; //!< [0x24C] Frames Transmitted OK Statistic Register
    __I hw_enet_ieee_t_1col_t IEEE_T_1COL; //!< [0x250] Frames Transmitted with Single Collision Statistic Register
    __I hw_enet_ieee_t_mcol_t IEEE_T_MCOL; //!< [0x254] Frames Transmitted with Multiple Collisions Statistic Register
    __I hw_enet_ieee_t_def_t IEEE_T_DEF;   //!< [0x258] Frames Transmitted after Deferral Delay Statistic Register
    __I hw_enet_ieee_t_lcol_t IEEE_T_LCOL; //!< [0x25C] Frames Transmitted with Late Collision Statistic Register
    __I hw_enet_ieee_t_excol_t IEEE_T_EXCOL; //!< [0x260] Frames Transmitted with Excessive Collisions Statistic Register
    __I hw_enet_ieee_t_macerr_t IEEE_T_MACERR; //!< [0x264] Frames Transmitted with Tx FIFO Underrun Statistic Register
    __I hw_enet_ieee_t_cserr_t IEEE_T_CSERR; //!< [0x268] Frames Transmitted with Carrier Sense Error Statistic Register
    uint8_t _reserved15[4];
    __I hw_enet_ieee_t_fdxfc_t IEEE_T_FDXFC; //!< [0x270] Flow Control Pause Frames Transmitted Statistic Register
    __I hw_enet_ieee_t_octets_ok_t IEEE_T_OCTETS_OK; //!< [0x274] Octet Count for Frames Transmitted w/o Error Statistic Register
    uint8_t _reserved16[12];
    __I hw_enet_rmon_r_packets_t RMON_R_PACKETS; //!< [0x284] Rx Packet Count Statistic Register
    __I hw_enet_rmon_r_bc_pkt_t RMON_R_BC_PKT; //!< [0x288] Rx Broadcast Packets Statistic Register
    __I hw_enet_rmon_r_mc_pkt_t RMON_R_MC_PKT; //!< [0x28C] Rx Multicast Packets Statistic Register
    __I hw_enet_rmon_r_crc_align_t RMON_R_CRC_ALIGN; //!< [0x290] Rx Packets with CRC/Align Error Statistic Register
    __I hw_enet_rmon_r_undersize_t RMON_R_UNDERSIZE; //!< [0x294] Rx Packets with Less Than 64 Bytes and Good CRC Statistic Register
    __I hw_enet_rmon_r_oversize_t RMON_R_OVERSIZE; //!< [0x298] Rx Packets Greater Than MAX_FL and Good CRC Statistic Register
    __I hw_enet_rmon_r_frag_t RMON_R_FRAG; //!< [0x29C] Rx Packets Less Than 64 Bytes and Bad CRC Statistic Register
    __I hw_enet_rmon_r_jab_t RMON_R_JAB;   //!< [0x2A0] Rx Packets Greater Than MAX_FL Bytes and Bad CRC Statistic Register
    uint8_t _reserved17[4];
    __I hw_enet_rmon_r_p64_t RMON_R_P64;   //!< [0x2A8] Rx 64-Byte Packets Statistic Register
    __I hw_enet_rmon_r_p65to127_t RMON_R_P65TO127; //!< [0x2AC] Rx 65- to 127-Byte Packets Statistic Register
    __I hw_enet_rmon_r_p128to255_t RMON_R_P128TO255; //!< [0x2B0] Rx 128- to 255-Byte Packets Statistic Register
    __I hw_enet_rmon_r_p256to511_t RMON_R_P256TO511; //!< [0x2B4] Rx 256- to 511-Byte Packets Statistic Register
    __I hw_enet_rmon_r_p512to1023_t RMON_R_P512TO1023; //!< [0x2B8] Rx 512- to 1023-Byte Packets Statistic Register
    __I hw_enet_rmon_r_p1024to2047_t RMON_R_P1024TO2047; //!< [0x2BC] Rx 1024- to 2047-Byte Packets Statistic Register
    __I hw_enet_rmon_r_gte2048_t RMON_R_GTE2048; //!< [0x2C0] Rx Packets Greater than 2048 Bytes Statistic Register
    __I hw_enet_rmon_r_octets_t RMON_R_OCTETS; //!< [0x2C4] Rx Octets Statistic Register
    __I hw_enet_ieee_r_drop_t IEEE_R_DROP; //!< [0x2C8] Frames not Counted Correctly Statistic Register
    __I hw_enet_ieee_r_frame_ok_t IEEE_R_FRAME_OK; //!< [0x2CC] Frames Received OK Statistic Register
    __I hw_enet_ieee_r_crc_t IEEE_R_CRC;   //!< [0x2D0] Frames Received with CRC Error Statistic Register
    __I hw_enet_ieee_r_align_t IEEE_R_ALIGN; //!< [0x2D4] Frames Received with Alignment Error Statistic Register
    __I hw_enet_ieee_r_macerr_t IEEE_R_MACERR; //!< [0x2D8] Receive FIFO Overflow Count Statistic Register
    __I hw_enet_ieee_r_fdxfc_t IEEE_R_FDXFC; //!< [0x2DC] Flow Control Pause Frames Received Statistic Register
    __I hw_enet_ieee_r_octets_ok_t IEEE_R_OCTETS_OK; //!< [0x2E0] Octet Count for Frames Received without Error Statistic Register
    uint8_t _reserved18[284];
    __IO hw_enet_atcr_t ATCR;              //!< [0x400] Adjustable Timer Control Register
    __IO hw_enet_atvr_t ATVR;              //!< [0x404] Timer Value Register
    __IO hw_enet_atoff_t ATOFF;            //!< [0x408] Timer Offset Register
    __IO hw_enet_atper_t ATPER;            //!< [0x40C] Timer Period Register
    __IO hw_enet_atcor_t ATCOR;            //!< [0x410] Timer Correction Register
    __IO hw_enet_atinc_t ATINC;            //!< [0x414] Time-Stamping Clock Period Register
    __I hw_enet_atstmp_t ATSTMP;           //!< [0x418] Timestamp of Last Transmitted Frame
    uint8_t _reserved19[488];
    __IO hw_enet_tgsr_t TGSR;              //!< [0x604] Timer Global Status Register
    struct {
        __IO hw_enet_tcsrn_t TCSRn;        //!< [0x608] Timer Control Status Register
        __IO hw_enet_tccrn_t TCCRn;        //!< [0x60C] Timer Compare Capture Register
    } CHANNEL[4];
} hw_enet_t;
#pragma pack()

//! @brief Macro to access all ENET registers.
//! @param x ENET instance number.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_ENET(0)</code>.
#define HW_ENET(x)     (*(hw_enet_t *) REGS_ENET_BASE(x))
#endif

#endif // __HW_ENET_REGISTERS_H__
// v22/130726/0.9
// EOF
