#ifndef SENSORS_H
#define SENSORS_H

//Internal sensors
#include "Dht11.h"         //Temperature & humidity sensor
#include "LPS22HBSensor.h" //Pressure sensor
#include "LSM6DSLSensor.h" //Accelerometer & gyroscope
#include "VL53L0X.h"       //Proximity sensor


/* For errors while reading values */
#define VALUE_ERROR -1
int press_status;

/* Interface definition */
static DevI2C devI2c(PB_11,PB_10);

/* Environment sensors */
Dht11 hum_temp_s(D4);
DigitalIn light_s(D6);
static LPS22HBSensor press_s(&devI2c);

/* Motion sensors */
static LSM6DSLSensor acc_gyro(&devI2c,LSM6DSL_ACC_GYRO_I2C_ADDRESS_LOW,PD_11); // low address

/* Range sensor - B-L475E-IOT01A2 only */
static DigitalOut shutdown_pin(PC_6);
static VL53L0X range(&devI2c, &shutdown_pin, PC_7);

/* Variables */
int mag_axes[3];
int acc_axes[3];
int gyro_axes[3];
unsigned int distance;
float temp;
float hum;
int light;
float press;

/* Functions */
void enable_sensors();
void get_values();
void get_motion_data(int dt, int* speed, int* prev_speed, int* prev_pos, int* prev_angle);

#endif
