#include "mbed.h"
#include "Sensors.h"
#include "ThingSpeak.h"
#include "CANbus.h"

int main()
{
  //ISM43362Interface wifi(MBED_CONF_APP_WIFI_SPI_MOSI, MBED_CONF_APP_WIFI_SPI_MISO, MBED_CONF_APP_WIFI_SPI_SCLK, MBED_CONF_APP_WIFI_SPI_NSS, MBED_CONF_APP_WIFI_RESET, MBED_CONF_APP_WIFI_DATAREADY, MBED_CONF_APP_WIFI_WAKEUP, false);

  /******* Connecting to Wi-Fi and ThingSpeak *******/
  int count = 0;
  count = scan_demo(&wifi);
  if (count == 0) {
      printf("No WIFI APNs found - can't continue further.\n");
      return -1;
  }

  printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
  int ret = wifi.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
  if (ret != 0) {
      printf("\nConnection error\n");
      return -1;
  }
  printf("Success\n\n");

  /******* Using sensors and publishing to ThingSpeak *******/
  enable_sensors();
  char urlBuffer[100];
  char ThingSpeak_key[20];
  char valBuf[20];

  CANMessage msg;
  struct VMS_Msg1 packed_data;
  Timer t;

  int i;
  int speed = 0;
  int angle = 0;
  int speed_3D[3] = {0,0,0};
  int pos_3D[3] = {0,0,0};

  while(1)
  {
    for(i=1; i<6; i++)
    {
      t.start(); //start timer
      get_values();
      sprintf(ThingSpeak_key, "MBED_CONF_APP_THINGSPEAK_KEY_SENSORS_%d", i);
      memset(ThingSpeak_key, 0, sizeof(ThingSpeak_key));

      sprintf(urlBuffer, "GET http://api.thingspeak.com/update?key=%s", ThingSpeak_key);

      //Temperature
      sprintf(valBuf, "&field1=%f", temp);
      strcat(urlBuffer, valBuf);
      memset(valBuf, 0, sizeof(valBuf));

      //Humidity
      sprintf(valBuf, "&field2=%f", hum);
      strcat(urlBuffer, valBuf);
      memset(valBuf, 0, sizeof(valBuf));

      //Light
      sprintf(valBuf, "&field3=%d", light);
      strcat(urlBuffer, valBuf);
      memset(valBuf, 0, sizeof(valBuf));

      //Pressure
      if(press_status != VALUE_ERROR)
      {
          sprintf(valBuf, "&field4=%f", press);
          strcat(urlBuffer, valBuf);
          memset(valBuf, 0, sizeof(valBuf));
      }

      //Motion parameters
     

      while(t.read() < 3)
      {
        get_motion_data(0.05, &speed, speed_3D, pos_3D, &angle);
        wait(0.05);
      }

      sprintf(valBuf, "&field5=%d", speed);
      strcat(urlBuffer, valBuf);
      memset(valBuf, 0, sizeof(valBuf));

      sprintf(valBuf, "&field6=%d", pos_3D[0]);
      strcat(urlBuffer, valBuf);
      memset(valBuf, 0, sizeof(valBuf));

      sprintf(valBuf, "&field7=%d", pos_3D[1]);
      strcat(urlBuffer, valBuf);
      memset(valBuf, 0, sizeof(valBuf));

      sprintf(valBuf, "&field8=%d", angle);
      strcat(urlBuffer, valBuf);
      memset(valBuf, 0, sizeof(valBuf));

      send_values(urlBuffer);
      memset(urlBuffer, 0, sizeof(urlBuffer));

      //Same with CAN data

      if(can.read(msg))
      {
        packed_data = data_pack(msg.data);
        data_parse(packed_data);
        sprintf(ThingSpeak_key, "MBED_CONF_APP_THINGSPEAK_KEY_CAN_%d", i);
        sprintf(urlBuffer, "GET http://api.thingspeak.com/update?key=%s", ThingSpeak_key);
        memset(ThingSpeak_key, 0, sizeof(ThingSpeak_key));

        sprintf(valBuf, "&field1=%d", battery_current);
        strcat(urlBuffer, valBuf);
        memset(valBuf, 0, sizeof(valBuf));

        sprintf(valBuf, "&field2=%d", battery_voltage);
        strcat(urlBuffer, valBuf);
        memset(valBuf, 0, sizeof(valBuf));

        sprintf(valBuf, "&field3=%d", Bat_SOC);
        strcat(urlBuffer, valBuf);
        memset(valBuf, 0, sizeof(valBuf));

        sprintf(valBuf, "&field4=%d", speed);
        strcat(urlBuffer, valBuf);
        memset(valBuf, 0, sizeof(valBuf));

        sprintf(valBuf, "&field5=%d", motorTemperature);
        strcat(urlBuffer, valBuf);
        memset(valBuf, 0, sizeof(valBuf));

        send_values(urlBuffer);
        memset(urlBuffer, 0, sizeof(urlBuffer));
      }
      else
      {
        printf("Error reading CAN message. \r\n");
      }

      while(t.read() < 3){} //Wait until 3s passes
      t.stop();
      t.reset();
    }

  }

  return 0;
}
