#include "ThingSpeak.h"

//#include "Sensors.h"


const char *sec2str(nsapi_security_t sec)
{
    switch (sec) {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

int scan_demo(WiFiInterface *wifi)
{
    WiFiAccessPoint *ap;

    printf("Scan:\n");

    int count = wifi->scan(NULL,0);
    printf("%d networks available.\n", count);

    /* Limit number of network arbitrary to 15 */
    count = count < 15 ? count : 15;

    ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);
    for (int i = 0; i < count; i++)
    {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
    }

    delete[] ap;
    return count;
}


void send_values(char* urlBuffer)
{
  TCPSocket socket;
  socket.open(&wifi);
  int scount;
  int bufLen = strlen(urlBuffer);

  if(socket.connect("api.thingspeak.com", 80) == 0)
  {
    scount = socket.send(urlBuffer, bufLen+1);
    printf ("Message sent: strlen=%d,urlBuffer=%.*s\r\n",bufLen,bufLen-2,urlBuffer);
  }
  else printf("Failed to connect to ThingSpeak.\r\n");


  // Recieve a simple http response and print out the response line
  char rbuffer[2000];
  int response = socket.recv(rbuffer, sizeof rbuffer);
  if (response < 0) {
      printf("Error receiving data: %d\n\r", response);
  } else {
      printf("recv %d [%.*s]\n\r", response, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);
  }

  socket.close();

}
