#ifndef CANBUS_H
#define CANBUS_H

#include "mbed.h"

/* Variables for collecting values */
int battery_current, battery_voltage, Bat_SOC, speed, motorTemperature;

/* Configure CAN pins */
CAN can(D15, D14);

/* Functions */
struct VMS_Msg1 data_pack(int* data);
void data_parse(struct VMS_Msg1 packed_data);

#pragma pack(push, 1)
struct VMS_Msg1{
    int battery_current:16;
    int battery_voltage:8;
    int Bat_SOC:8;
    int speed:8;
    int motorTemperature:8;
    int Gear:2;
    int KeyLocation:2;
    int downrating:1;
    int AirCondEnable:1;
    int PEPScert:2;
    int ReadySignal:8;
}VMS_Msg1;
#pragma pack(pop)


#endif
