//
// mbed POV by Kanpapa 
// May.29,2010
//
// StarBoard Orange version
// Sep.25,2010
//

// mbed
//  p5 input
//  p7-p13 output
//

// Original Version
//   Japanino POV by Musashinodenpa
// http://otonanokagaku.net/japanino/sketch/index.html

#include "mbed.h"

#include "TextLCD.h"
TextLCD     lcd( p24, p26, p27, p28, p29, p30 ); // rs, e, d0-d3

DigitalIn  sw(p5);

DigitalOut led1(p7);
DigitalOut led2(p8);
DigitalOut led3(p9);
DigitalOut led4(p10);
DigitalOut led5(p11);
DigitalOut led6(p12);
DigitalOut led7(p13);

DigitalOut sw_status1(LED1);
DigitalOut sw_status2(LED2);
DigitalOut sw_status3(LED3);
DigitalOut sw_status4(LED4);

unsigned char bitmap[20][8] = {
{0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,1},
{0,1,1,1,1,1,1,1},
{0,1,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0},
{0,0,0,0,1,1,1,0},
{0,0,0,1,1,1,1,1},
{0,0,1,1,1,1,1,1},
{0,1,1,1,1,1,1,0},
{0,0,1,1,1,1,1,1},
{0,0,0,1,1,1,1,1},
{0,0,0,0,1,1,1,0},
{0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1},
{0,1,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1},
{1,0,0,0,0,0,0,0}
};

/**
 * Display a splash screen.
 */
void splash(void) {
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf("StarBoard Orange");
    lcd.locate(0, 1);
    lcd.printf("mbed P.O.V. demo");
}

int pos = 0;
int i = 0;

int main() {

  splash();

  sw.mode(PullUp);
  int led_no = 1;

  while(1){

   if(sw.read() == 0) {
   
     if (led_no == 1) {
        sw_status1 = 1;     // LED1 on
        sw_status4 = 0;     // LED4 off
     }
     if (led_no == 2){
        sw_status2 = 1;     // LED2 on
        sw_status1 = 0;     // LED1 off
     }
     if (led_no == 3){
        sw_status3 = 1;     // LED3 on
        sw_status2 = 0;     // LED2 off
     }
     if (led_no == 4){
        sw_status4 = 1;     // LED4 on
        sw_status3 = 0;     // LED3 off
     }

     pos = 0;
     wait(0.006);   // 6ms

     led_no++;   
     if (led_no > 4) {
      led_no = 1;
     }
     
    while(bitmap[++pos][0] != 1) {
      led1.write(bitmap[pos][1]);
      led2.write(bitmap[pos][2]);
      led3.write(bitmap[pos][3]);
      led4.write(bitmap[pos][4]);
      led5.write(bitmap[pos][5]);
      led6.write(bitmap[pos][6]);
      led7.write(bitmap[pos][7]);
            
      wait(0.002);  // 2ms
    }

    // LED off
    led1.write(0);
    led2.write(0);
    led3.write(0);
    led4.write(0);
    led5.write(0);
    led6.write(0);
    led7.write(0);
   }
  }
}