//
// mbed POV by Kanpapa 
// May.29,2010
//

// mbed
//  p6 input
//  p7-p13 output
//

// Original Version
//   Japanino POV by Musashinodenpa
// http://otonanokagaku.net/japanino/sketch/index.html

#include "mbed.h"

DigitalIn  sw(p6);

DigitalOut led1(p7);
DigitalOut led2(p8);
DigitalOut led3(p9);
DigitalOut led4(p10);
DigitalOut led5(p11);
DigitalOut led6(p12);
DigitalOut led7(p13);

int bitmap[20][8] = {
{0,0,0,0,0,0,0,0},
{0,1,0,0,0,0,0,1},
{0,1,1,1,1,1,1,1},
{0,1,0,0,0,0,0,1},
{0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0},
{0,0,0,0,1,1,1,0},
{0,0,0,1,1,1,1,1},
{0,0,1,1,1,1,1,1},
{0,1,1,1,1,1,1,0},
{0,0,1,1,1,1,1,1},
{0,0,0,1,1,1,1,1},
{0,0,0,0,1,1,1,0},
{0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1},
{0,1,0,0,0,0,0,0},
{0,1,0,0,0,0,0,0},
{0,0,1,1,1,1,1,1},
{1,0,0,0,0,0,0,0}
};

int pos = 0;
int i = 0;

int main() {
  sw.mode(PullUp);

  while(1){

   if(sw.read() == 0) {
    wait(0.006);   // 6ms
    pos = 0;

    while(bitmap[++pos][0] != 1) {
      led1.write(bitmap[pos][1]);
      led2.write(bitmap[pos][2]);
      led3.write(bitmap[pos][3]);
      led4.write(bitmap[pos][4]);
      led5.write(bitmap[pos][5]);
      led6.write(bitmap[pos][6]);
      led7.write(bitmap[pos][7]);
            
      wait(0.002);  // 2ms
    }

    // LED off
    led1.write(0);
    led2.write(0);
    led3.write(0);
    led4.write(0);
    led5.write(0);
    led6.write(0);
    led7.write(0);
   }
  }
}