//
// mbed POV melody sound by Kanpapa
// Jun.19, 2010
//

// mbed
//  p21 speaker

// Original Version
//  2010/1/21 by Tom Igoe
//  http://arduino.cc/en/Tutorial/Tone
//  2010/4/23 by otonano kagaku
//  http://otonanokagaku.net/japanino/sketch/sketch_02.html

#include "mbed.h"
#include "Beeper.h"

DigitalOut myled(LED1);
Beeper myBeeper(p21);

// MIDI NOTE data
#define NOTE_C4 60
#define NOTE_D4 62
#define NOTE_E4 64
#define NOTE_F4 65
#define NOTE_G4 67
#define NOTE_A4 69
#define NOTE_B4 71 

// melody data
int melody[] = {
 NOTE_C4, NOTE_F4, NOTE_F4, NOTE_A4, NOTE_G4, NOTE_F4, NOTE_A4, 0, NOTE_G4, NOTE_F4, NOTE_D4, NOTE_C4 ,0 };

int noteDurations[] = {
 8,8,2,16,16,8,4,4,4,2,4,2,4 
};

int main() {
 while(1) {
 for (int thisNote = 0; thisNote < 13; thisNote++) {
   myled = 1;
   int noteDuration = 2000/noteDurations[thisNote];
   
   if (melody[thisNote] == 0) {
    wait_ms(noteDuration);
   } else {
    myBeeper.note(melody[thisNote],(float)noteDuration/1000);
   }

   myled = 0;
   
   int pauseBetweenNotes = noteDuration * 0.30;

   wait_ms(pauseBetweenNotes);
 }
 wait_ms(1000);
 }
}