/* 
 * micro:bit weather:bit + SSD1306 OLED 128x64 OLED Test program
 *
 * Copyright (c) 2017 Kazuhiro Ouchi (@kanpapa)
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * version 0.1 Initial Release
 */
#include "MicroBit.h"
#include "mbed_logo.h"
#include "SSD1308.h"  // https://os.mbed.com/users/wim/code/SSD1308_128x64_I2C/
#include "BME280.h"   // https://os.mbed.com/users/MACRUM/code/BME280/

MicroBit uBit;
MicroBitI2C i2c(I2C_SDA0, I2C_SCL0); 

// Instantiate OLED SSD1306
// I2C address 0x78
SSD1308 oled = SSD1308(i2c, SSD1308_SA0);

// I2C address 0x76(default)
// Instantiate BME280 sensor
BME280 sensor = BME280(i2c);
     
int main() {
    // Initialise the micro:bit runtime.
    uBit.init();
    
    // micro:bit LED test
    uBit.display.scroll("HELLO WORLD! :)");
    
    // OLED test
    oled.writeString(0, 0, "Hello World !");
   
    oled.fillDisplay(0xAA);
    oled.setDisplayOff();
    wait(1);   
    oled.setDisplayOn();
 
    // weather info display
    while (1) {
        oled.clearDisplay();
        oled.setDisplayInverse();
        wait(0.5);
        oled.setDisplayNormal();                                         
 
        oled.writeBitmap((uint8_t*) mbed_logo);
        wait(1);
    
        oled.clearDisplay();
        oled.printf("%2.2f degC, %04.2f hPa, %2.2f %%\n", sensor.getTemperature(), sensor.getPressure(), sensor.getHumidity());
        wait(10);
    }
} //main    