//
// VFD test program
//
#include "mbed.h"
#include "vfd_gp1059.h"

/*
=========================
FUTABA VFD GP1059A01(I/O)
-------------------------
p9     1 (D0)  I/O
p10    2 (D1)  I/O
p11    3 (D2)  I/O
p12    4 (D3)  I/O
p13    5 (D4)  I/O
p14    6 (D5)  I/O
p15    7 (D6)  I/O
p16    8 (D7)  I/O
p21    10 (INT) O
p22    11 (WR)  I
p23    12 (RD)  I
p24    13 (CS)  I
p25    14 (C/D) I
*/

VFD_GP1059   vfd(p9, p10, p11, p12, p13, p14, p15, p16,    p21, p22, p23, p24, p25);

//
// For SD_card
//
//#include "SDFileSystem.h"
//SDFileSystem  sd(p5, p6, p7, p8, "sd");  //  mosi, miso, sclk, cs, name  (HW modification candidate)

LocalFileSystem local("local");

// LED Status
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

const uint8_t LOW = 0;

unsigned char reverse_bit(unsigned char x){
    const unsigned int bit[]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
    unsigned char y = 0;
    for (int i = 0; i < 8; i++){
        if ((bit[i] & x) != 0){
            y |= bit[7-i];
        }
    }
    return(y);
}

//
// FONTX2 test routine
// @gingaxx
//

//#define  kanji_file    "/local/SHMZN16X.FNT"
//#define  kanji_file  "/local/k12x10.fnt"
#define kanji_file "/local/J2KZN16A.FNT"

int cx = 0;
int cy = 0;
//int offsety = 0;
//bool kstate = false;
//unsigned char kbuf;

FILE *fp;   // File open buffer

unsigned short  start[92], end[92]; // table
unsigned char   font[64];           // kanji image read buffer              

char            Identifier[6+1];    // 00-05 "FONTX2"   
char            FontName[8+1];      // 06-13 Font name    
unsigned char   XSize;              // 14            
unsigned char   YSize;              // 15
unsigned char   CodeType;           // 16 0:ASCII, 1:KANJI   
unsigned char   Tnum;               // 17 Table entry number

//#define FONT_XBYTE        ((XSize + 7) >> 3)
//#define FONT_YBYTE        ((YSize + 7) >> 3)

void kanji_init(){ 
    //move cursor 
    fp = fopen(kanji_file , "r");

    if(!fp) {
        printf("File could not be opened!\n");
        led1 = 1;
        exit(1);
    }

    fgets(Identifier,   6+1, fp);    // FONTX2
    fgets(FontName,     8+1, fp);        
    fread(&XSize,       1, 1, fp);        
    fread(&YSize,       1, 1, fp);        
    fread(&CodeType,    1, 1, fp);  
    fread(&Tnum,        1, 1, fp);

    printf("Identifier: %s\n\r",Identifier);
    printf("FontName: %s\n\r",FontName);
    printf("XSize: %d\n\r",XSize);
    printf("YSize: %d\n\r",YSize);
    printf("CodeType: %d\n\r",CodeType);
    printf("Tnum: %d\n\r",Tnum);
    
    // Table read
    for (int a = 0; a < Tnum; a++){
        fread(&start[a], 1, 2, fp);
        fread(&end[a]  , 1, 2, fp);
    }
}

//Kanji puts  cr = kanji cord
void k_puts(int cr){

    const unsigned char bit_chk[]={0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01};

    // calculate kanji address
    int c = 0;
    int adrs = 0;
    while(cr > start[c]){
        if (cr > end[c]){
            adrs += end[c] - start[c] + 1;
        } else {
            adrs += cr - start[c];
        }
        c++;
    }
    c--;
    printf("cr=%X, table num=%d, adrs=%d \r\n",cr,c,adrs);
    
    // Kanji image Read
    fseek( fp, Tnum * 4 + 18 + 32 * adrs, SEEK_SET );
    fread( &font, 1, 32, fp);
    
    // debug dump
    for (int s = 0; s < 32 ; s++){
        printf(" %02x ",font[s]);
    }
    printf("\r\n"); 

    // kanji put
    c = 0;
    unsigned int vfd_address = cx * 8 * 16 + cy * 2;
    //printf("VFD address: %04x\r\n",vfd_address);

    int n = 0;
    for (int j = 0; j < 2 ; j++) {
        for (int x = 0; x < 8; x++) {
            //printf("set VFD address: %04x\r\n",vfd_address);
            vfd.set_write_read_address(vfd_address);
            int m = 0;
            for (int k = 0; k < 2 ; k++) {
                unsigned int d = 0;      
                for (int i = 0; i < 8; i++) {
                    if (font[m * 2 + j] & bit_chk[x]) {
                        //printf("BIT on!\r\n");
                        d = d | 1;
                    }   
                    if (i < 7) {
                        d = d << 1;
                    }
                    //printf("i:%d, k:%d, m:%d, font:%02x, bit_chk:%02x, data:%02x\r\n",i,k,m,font[m*2+j],bit_chk[x],d);
                    m++;
                }
                //printf("send_data: %02x\r\n",d);
                vfd.send_data(d);
            }
            vfd_address = vfd_address + 8;
        }
        n++;
    }
    
#ifdef TATEGAKI    // tategaki
    for (int x = 0; x < 16; x++){
        //printf("set VFD address: %04x\r\n",vfd_address);
        //printf("send_data: font[%d] = %02x\r\n",x,font[c]);
        vfd.set_write_read_address(vfd_address + 1);
        vfd.send_data(reverse_bit(font[c]));
        c++;

        //printf("set VFD address2: %04x\r\n",vfd_address);
        //printf("send_data2: font[%d] = %02x\r\n",x,font[c]);
        vfd.set_write_read_address(vfd_address);
        vfd.send_data(reverse_bit(font[c]));
        c++;

        vfd_address = vfd_address + 8;
    }
#endif // TATEGAKI

    // move cursor 
    cx++;
    if (cx >= 15){   //LF control
        cx = 0;
        cy++;
    }
}

void kanji_end(){
    fclose(fp);
}


void blink_LED() {
    for (int i = 0 ; i < 5 ; i++) {
        led4 = 1;
        wait(0.2);
        led4 = 0;
        wait(0.2);
    }
    return;
}

int main() {

    led1 = LOW;
    led2 = LOW;
    led3 = LOW;
    led4 = LOW;
        
    // Start Sign
    blink_LED();
    
    vfd.cls();
        
    // FONTX2 test
    vfd.set_disp_start_address(0);  // Display address: 000000H
    vfd.luminance_adjustment(0x0f);    // 100%

    kanji_init();
    printf("kanji_init()\r\n");
    
    for (unsigned int kc = 0x8801; kc < 0x8820 ; kc++){
        k_puts(kc);  // 8abf
    }
    
    kanji_end();
    printf("kanji_end()\r\n");
    
    // END Sign
    blink_LED();    
}