//
// VFD BMP file display program
// 2011/11/26 by @kanpapa
//

#include "mbed.h"
#include "vfd_gp1059.h"

/*
=====================
GP1059A01(I/O)
---------------------
p9     1 (D0)  I/O
p10    2 (D1)  I/O
p11    3 (D2)  I/O
p12    4 (D3)  I/O
p13    5 (D4)  I/O
p14    6 (D5)  I/O
p15    7 (D6)  I/O
p16    8 (D7)  I/O
p21    10 (INT) O
p22    11 (WR)  I
p23    12 (RD)  I
p24    13 (CS)  I
p25    14 (C/D) I
*/

VFD_GP1059   vfd(p9, p10, p11, p12, p13, p14, p15, p16,    p21, p22, p23, p24, p25);

//
// For SD_card
//
#include "SDFileSystem.h"
//SDFileSystem    sd(p5, p6, p7, p13, "sd");  //  mosi, miso, sclk, cs, name
SDFileSystem  sd(p5, p6, p7, p8, "sd");  //  mosi, miso, sclk, cs, name  (HW modification candidate)

Serial pc(USBTX, USBRX);
LocalFileSystem local("local");

// LED Status
// mbed
DigitalOut led1(LED1);
// LPCXpresso
//DigitalOut led1(P0_22);

unsigned char reverse_bit(unsigned char x){
    const unsigned int bit[]={0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
    unsigned char y = 0;
    for (int i = 0; i < 8; i++){
        if ((bit[i] & x) != 0){
            y |= bit[7-i];
        }
    }
    return(y);
}

void blink_LED() {
    for (int i = 0 ; i < 5 ; i++) {
        led1 = 1;
        wait(0.2);
        led1 = 0;
        wait(0.2);
    }
    return;
}


/*
 *
 *   BMP file data handler sample
 *
 *      reference : http://www.umekkii.jp/data/computer/file_format/bitmap.cgi
 *
 */

#include    <stdio.h>


// mono color bitmap 1214byte
#define        BUFFER_SIZE            1280

typedef struct  bmp_header_st    {
    unsigned short  bfType            __attribute__((packed));
    unsigned long   bfSize            __attribute__((packed));
    unsigned short  bfReserved1       __attribute__((packed));
    unsigned short  bfReserved2       __attribute__((packed));
    unsigned long   bfOffBits         __attribute__((packed));

    unsigned long   biSize            __attribute__((packed));
    long            biWidth           __attribute__((packed));
    long            biHeight          __attribute__((packed));
    unsigned short  biPlanes          __attribute__((packed));
    unsigned short  biBitCount        __attribute__((packed));
    unsigned long   biCompression     __attribute__((packed));
    unsigned long   biSizeImage       __attribute__((packed));
    long            biXPixPerMeter    __attribute__((packed));
    long            biYPixPerMeter    __attribute__((packed));
    unsigned long   biClrUsed         __attribute__((packed));
    unsigned long   biCirImportant    __attribute__((packed));
}
bmp_header;

typedef struct  color_palette_st    {
    unsigned char    red;
    unsigned char    green;
    unsigned char    blue;
    unsigned char    dummy;
}
color_palette;

void print_bit(unsigned char x){
    const unsigned int bit[]={0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01};
    for (int i = 0; i < 8; i++){
        if ((bit[i] & x) != 0){
            printf("1");
        } else {
            printf(" ");
        }
    }
    return;
}

int read_bmp_mono(const char *file_name, unsigned char *buffer, int buffer_size){
    FILE             *fs;
    bmp_header       bh;
    color_palette    cp[2];
    printf( "BMP file access sample\r\n");

    if ( NULL == (fs = fopen( file_name, "rb" )) ) {
        printf( "file open error when opening file \"%s\"\r\n", file_name );
        return ( 1 );
    }

    /*
     *   reading header
     */

    fread( &bh, sizeof( bh ), 1, fs );

    printf( "  bfType         : 0x%04X\r\n", bh.bfType );
    printf( "  bfSize         : %ld\r\n",    bh.bfSize );
    printf( "  bfOffBits      : %ld\r\n",    bh.bfOffBits );
    printf( "  biSize         : %lu\r\n",    bh.biSize );
    printf( "  biWidth        : %ld\r\n",    bh.biWidth );
    printf( "  biHeight       : %ld\r\n",    bh.biHeight );
    printf( "  biPlanes       : %d\r\n",     bh.biPlanes );
    printf( "  biBitCount     : %d\r\n",     bh.biBitCount );
    printf( "  biCompression  : %lu\r\n",    bh.biCompression );
    printf( "  biSizeImage    : %lu\r\n",    bh.biSizeImage );
    printf( "  biXPixPerMeter : %ld\r\n",    bh.biXPixPerMeter );
    printf( "  biYPixPerMeter : %ld\r\n",    bh.biYPixPerMeter );
    printf( "  biClrUsed      : %lu\r\n",    bh.biClrUsed );
    printf( "  biCirImportant : %lu\r\n",    bh.biCirImportant );

    /*
     *   checking header  (mono color pallet:2)
     */
    if ( (bh.bfType != 0x4D42)      // "BM"
            || (bh.bfOffBits != 54 + 2 * sizeof( color_palette ) )  // pallet data 2
            || (bh.biBitCount != 1)                                 // color 1bit
            || (bh.biCompression != 0)
       ) {
        printf( "unsupported file format\r\n" );
        fclose( fs );
        return ( 1 );
    }

    /*
     *   header information
     */
    printf( "header read, the image data size is %lu bytes\r\n", bh.bfSize );
    printf( "   the image data size is %lu bytes\r\n", bh.biSizeImage );
    printf( "   horizontal size %lu pixels\r\n", bh.biWidth );
    printf( "   vertical   size %lu pixels\r\n", bh.biHeight );

    /*
     *   read color palette
     */

    for ( int i = 0; i < 2; i++ ) {
        fread( &(cp[i]), sizeof( color_palette ), 1, fs );
        printf( "color pallet No.0x%02X : R:0x%02X - G:0x%02X - B:0x%02X\r\n", i, (cp[i]).red, (cp[i]).green, (cp[i]).blue );
    }

    /*
     *   read pixel data
     */
    unsigned long readsize = fread( buffer, sizeof( unsigned char ) , buffer_size, fs );
    printf( "Readsize: %d\r\n", readsize);

    fclose( fs );
    return( 0 );
}

bool CheckExtention( const char* filename, const char* ext )
{
    if ( filename && ext )
    {
        return 0 == std::strcmp(std::strrchr(filename, '.'), ext);
    }
    return false;
}


int display_bmp(char * bmp_file) {
    unsigned char    buffer[ BUFFER_SIZE ];

        printf("bmp_file: %s\n\r",bmp_file);    
        if ( read_bmp_mono(bmp_file, buffer, sizeof( buffer )) != 0) {
            printf( "file open error when opening file \"%s\"\r\n", bmp_file);
            return ( 1 );
        }
    
        //
        // SET VRAM
        //
        const unsigned int bit[]={0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01};

        for (int y = 0; y < 5; y++){
            unsigned int address = y;
            for (int x = 0 ; x < 30 ; x++) {
                int bufbit = 0;     // buffer bit
                for ( int z = 0; z < 8 ; z++) {
                    unsigned char d = 0;          // vram data
                    int dbit = 0;       // vram data bit
                    for ( int i = 0 ; i < 8 ; i++) {
                        //printf("buffer[%d]\r\n", 32 * (35 - (y * 8 + i)) + x );
                        if ((bit[bufbit] & buffer[32 * (35 - (y * 8 + i)) + x]) == 0){
                            d = d | bit[dbit];
                        }
                        dbit++;
                    }
                    bufbit++;
                
                    // write VRAM
                    //printf( "VRAM address: %04x Data: %02x\r\n", address, d);
                    vfd.set_write_read_address(address);
                    vfd.send_data(d);
                
                    address = address + 8;
                }
            }
        }
        return(0);
}

int main() {
    const char* ext1 = ".bmp";
    const char* ext2 = ".BMP";

    // mono color bitmap
    //const char *bmp_file[] = {"/local/kumamoto.bmp", "/local/narita.bmp"};
    //const char *bmp_file[] = {"/sd/kumamoto.bmp", "/sd/narita.bmp"};

    printf( "BMP file access sample\r\n");

    vfd.cls();

    vfd.luminance_adjustment(0x0f); // 100%

    while(1) {
        DIR *dir = opendir("/sd/");
    
        struct dirent *dent;

        if ( dir ) {
            while( dent = readdir( dir ) ){
                printf("%s\r\n", dent->d_name);
                if (CheckExtention(dent->d_name, ext1) || CheckExtention(dent->d_name, ext2)) {
                    char file_name[256] = "/sd/";
                    strcat(file_name, dent->d_name);
                    int ret = display_bmp(file_name);
                    
                    // wait
                    if (ret == 0){
                        wait(5);
                        vfd.cls();
                        wait(1);
                    }
                }
            }
        } else {
            printf("Filed to open directory\r\n");
            return(1);
        }
        closedir( dir );
    }   
}
