/*

mbed ROM Reader for 2332/2316

Read from ROM and dump to local file(ROM1.BIN)

===============
Status LED
-----------
LED1: nouse
LED2: Busy
LED3: End
LED4: Error

===============
ROM Connection
---------------
mbed   2332/2316
p5     9  (O0)
p6     10 (O1)
p7     11 (O2)
p8     13 (O3)
p9     14 (O4)
p10    15 (O5)
p11    16 (O6)
p12    17 (O7)
p13    8 (A0)
p14    7 (A1)
p15    6 (A2)
p16    5 (A3)
p17    4 (A4)
p18    3 (A5)
p19    2 (A6)
p20    1 (A7)
p21    23 (A8)
p22    22 (A9)
p23    19 (A10)
p24    18 (A11)
p25    20 (/CE1)
p26    21 (CE2)
VU     24 (Vcc)
GND    12 (GND)
================

*/

#include "mbed.h"

Serial pc(USBTX, USBRX);
LocalFileSystem local("local");

// ROM DATA PORT
BusIn DATA(p5, p6, p7, p8, p9, p10, p11, p12);

// ROM ADDRESS PORT
BusOut ADRS(p13, p14, p15, p16, p17, p18, p19, p20, p21, p22, p23, p24);

// Chip Enable
DigitalOut CE1(p25);

// Chip Enable2 
DigitalOut CE2(p26);

// LED Status
DigitalOut busyled(LED2);
DigitalOut endled(LED3);
DigitalOut errled(LED4);

const uint8_t HIGH = 1;
const uint8_t LOW = 0;

// 2332 (4096*8byte)
//const uint16_t MAX_ADDRESS = 4096;

// 2316 (2048*8byte)
const uint16_t MAX_ADDRESS = 2048;

FILE *fp;
char out_filename[] = "/local/rom1.bin";

uint8_t ROM_read(uint16_t address){
    uint8_t read_byte;

    // LED ON
    busyled = HIGH;

    // SET ADDRESS
    ADRS = address;
    
    CE2 = HIGH;
    wait_us(10);    
    CE1 = LOW;
    wait_us(10);

    read_byte = DATA;
    wait_us(10);

    CE1 = HIGH;
    CE2 = LOW;
    
    busyled = LOW;
    return read_byte;  
}

void read_rom(){
    uint8_t read_data;
    
    pc.printf("READ from ROM\n");
   
    if ( NULL == (fp = fopen( out_filename, "w" )) ) {
        pc.printf("File open error.\n");
        errled = HIGH;
        busyled = LOW;
        return;
    }
    for (uint16_t address = 0; address < MAX_ADDRESS; address++){
        if (!(address % 16)) pc.printf("\n%04X:", address);
        read_data =  ROM_read(address);
        fprintf(fp, "%c", read_data);
        pc.printf("%02X ",read_data);
    }
    pc.printf("\nSuccess!\n");

    return;        
}

void blink_LED() {
    for (int i = 0 ; i < 10 ; i++) {
        busyled = 1;
        wait(0.2);
        busyled = 0;
        wait(0.2);
    }
    return;
}

int main() {

    busyled = HIGH;
    endled = LOW;
    errled = LOW;
    
    CE1 = HIGH;
    CE2 = LOW;

    ADRS = 0;
    
    pc.printf("ROM Reader\n");
    pc.printf("MAX Address: %5d\n", MAX_ADDRESS);

    wait(3);

    // Start Sign
    blink_LED();
    
    read_rom();
    
    fclose( fp );
    
    // END Sign
    blink_LED();
    
}