#include "mbed.h"
#include "SNIC_WifiInterface.h"
#include "HTTPServer.h"

#include "control_motors.h"

/**
 * Wifi AP parameter
 */

/* Set this */ 
#define WIFI_SSID           "KDDI_hackathon04"
#define WIFI_SECUTIRY_KEY   "123456789"
#define WIFI_SECURITY_TYPE  e_SEC_WPA2_AES
//#define WIFI_SECURITY_TYPE  e_SEC_OPEN
//#define WIFI_SECURITY_TYPE  e_SEC_WEP
//#define WIFI_SECURITY_TYPE  e_SEC_WPA_TKIP
//#define WIFI_SECURITY_TYPE  e_SEC_WPA2_AES
//#define WIFI_SECURITY_TYPE  e_SEC_WPA2_MIXED

#define IP_ADDRESS      "192.168.100.149"
#define NET_MASK        "255.255.255.0"
#define DEFAULT_GATEWAY "192.168.100.1"

#define PORT_NUMBER     80

#define _DEBUG

Serial pc(USBTX, USBRX);    // This is required when defined "_DEBUG"

Serial tocos(p13, p14);     // TOCOS TWE-Lite (Serial)

/** Wi-Fi SNIC UART Interface*/
C_SNIC_WifiInterface     mSNICwifi( p9, p10, NC, NC, p30 );

// Left motor
PwmOut mPwmMotorL(p23);
DigitalOut mDoutMotorL1(p15);
DigitalOut mDoutMotorL2(p16);

// Rigth motor
PwmOut mPwmMotorR(p22);
DigitalOut mDoutMotorR1(p18);
DigitalOut mDoutMotorR2(p17);

// Tail motor
PwmOut mPwmMotorTail(p21);
DigitalOut mDoutMotorTail1(p19);
DigitalOut mDoutMotorTail2(p20);


void wifi_connect()
{
    // Initialize Wi-Fi interface
    if(mSNICwifi.init()!=0){
        printf("Wi-Fi initial failed\r\n");
        mbed_die();
    }
    wait(0.5);
    
    if(mSNICwifi.disconnect()!= 0 )
    {
        printf("on the disconnect state\r\n");
        mbed_die();
    } 
    wait(0.3);

    // Connect to AP
    if(mSNICwifi.connect( WIFI_SSID,strlen(WIFI_SSID), 
                          WIFI_SECURITY_TYPE, 
                          WIFI_SECUTIRY_KEY, 
                          strlen(WIFI_SECUTIRY_KEY))!=0)
    {
        printf("Connect AP is failed\r\n");
        mbed_die();
    }
    wait(0.5);
    
    int retIp = mSNICwifi.setIPConfig(false, IP_ADDRESS, NET_MASK, DEFAULT_GATEWAY);
    
    printf("IP_ADDRESS:%s, NET_MASK:%s, DEFAULT_GATEWAY:%s\r\n",IP_ADDRESS, NET_MASK, DEFAULT_GATEWAY);
    
}

void uart_callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    sprintf("%c\n", pc.getc());
    led2 = !led2;
}

int main()
{
    // for debug
    pc.baud( 115200 );

    pc.printf("program start.\r\n");
    
    tocos.attach(&uart_callback);
    
    mPwmMotorL.period_ms(20);
    mPwmMotorR.period_ms(20);
    mPwmMotorTail.period_ms(20);

    wifi_connect();

    HTTPServer srv;
    
    pc.printf("server init.\r\n");
    srv.init(PORT_NUMBER);
    
    wait(1);
    pc.printf("server running.\r\n");
    srv.run();
}