#include "control_motors.h"

bool parse_request(char *request){
    
    bool okFlag = false;
    
    char req[1024];
    strcpy(req, request + 1);

    char* str = strtok(req, "/");
    
    if(strcmp(str, "api") == 0){
        str = strtok(NULL,"/");

        if(strcmp(str, "motor") == 0){
            str = strtok(NULL,"?");

            if(strcmp(str, "right") == 0){

                str = strtok(NULL,"="); //"speed"
                str = strtok(NULL,""); //            
                
                int speed = atoi(str);

                // motor right
                move(MOTOR_RIGHT, speed);
                okFlag = true;

            }else if(strcmp(str, "left") == 0){
                
                str = strtok(NULL,"="); //"speed"
                str = strtok(NULL,""); //            
                
                int speed = atoi(str);

                // motor left
                move(MOTOR_LEFT, speed);
                okFlag = true;

            }
            
        }else if(strcmp(str, "tail") == 0){
            str = strtok(NULL,"/");
            if(strcmp(str, "swing") == 0){
                str = strtok(NULL,"/");
                if(strcmp(str, "start") == 0){
                    
                    // tail start
                    start_shaking_tail();
                    
                    okFlag = true;
                    
                }else if(strcmp(str, "end") == 0){

                    // tail end
                    stop_shaking_tail();
                    
                    okFlag = true;
                    
                }
            }
        }
    }
    
    if(!okFlag){
        printf("error: request=%s\n", request);
        return false;
    }
    
    return true;
}


void move(int motor_id, int speed){
    if(motor_id == MOTOR_RIGHT){
        printf("motor right speed = %d\n", speed);
        
        // モーター制御の処理
            if(speed > 0){
            mPwmMotorR = (float)speed/255;
            mDoutMotorR1 = 1;
            mDoutMotorR2 = 0;
        }else if (speed < 0){
            mPwmMotorR = -(float)speed/255;
            mDoutMotorR1 = 0;
            mDoutMotorR2 = 1;
        }else{
            mPwmMotorR = 0;
            mDoutMotorR1 = 0;
            mDoutMotorR2 = 0;
        }

    }else if(motor_id == MOTOR_LEFT){
        printf("motor left speed = %d\n", speed);
        
        // モーター制御の処理
       if(speed > 0){
            mPwmMotorL = (float)speed/255;
            mDoutMotorL1 = 1;
            mDoutMotorL2 = 0;
        }else if (speed < 0){
            mPwmMotorL = -(float)speed/255;
            mDoutMotorL1 = 0;
            mDoutMotorL2 = 1;
        }else{
            mPwmMotorL = 0.0;
            mDoutMotorL1 = 0;
            mDoutMotorL2 = 0;
        }

    }
}


void start_shaking_tail(){
    printf("start_shaking_tail\n");

    // モーター制御の処理
    mPwmMotorTail = 0.8;
    mDoutMotorTail1 = 1;
    mDoutMotorTail2 = 0;

}

    
void stop_shaking_tail(){
    printf("stop_shaking_tail\n");

    // モーター制御の処理
    mPwmMotorTail = 0.0;
    mDoutMotorTail1 = 0;
    mDoutMotorTail2 = 0;

}
