#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h" // basicauth enabled. http://mbed.org/users/kazushi2008/code/HTTPClient/
#include "MPL115A2.h"

I2C i2c(p9, p10);        // sda, scl
Serial pc(USBTX, USBRX); // tx, rx

MPL115A2 p_sensor(&i2c);

EthernetInterface eth;
HTTPClient twitter;
char str[512];

int main() 
{
    char info[128];
    
    p_sensor.begin();   
    p_sensor.ReadSensor();
    
    sprintf(info, "I am tweeting from my mbed! Pressure = %f, Temperature = %f",  p_sensor.GetPressure(),p_sensor.GetTemperature());
    printf("%s",info);

    eth.init(); //Use DHCP

    eth.connect();
        
    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("status", info);

    printf("\nTrying to post data...\n");
    twitter.basicAuth("myuser", "mypass"); //We use basic authentication, replace with you account's parameters
    int ret = twitter.post("http://api.supertweet.net/1.1/statuses/update.json", map, &inText);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, twitter.getHTTPResponseCode());
    }
        
    eth.disconnect();  

    while(1) {
    }
}
