#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

EthernetInterface eth;
HTTPClient twitter;
char str[512];

int main() 
{
    eth.init(); //Use DHCP

    eth.connect();
        
    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("status", "I am tweeting from my mbed!");

    printf("\nTrying to post data...\n");
    twitter.basicAuth("myuser", "mypass"); //We use basic authentication, replace with you account's parameters
    int ret = twitter.post("http://api.supertweet.net/1.1/statuses/update.json", map, &inText);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, twitter.getHTTPResponseCode());
    }
        
    eth.disconnect();  

    while(1) {
    }
}
