#include "mbed.h"

// OLED
#include "MARMEX_OB_oled.h"
MARMEX_OB_oled   oled1( p5, p7, p27, p24, p26 ); // mosi, sclk, cs, rst, power_control

InterruptIn button(p29);
DigitalOut beep(p30);

DigitalOut led(LED1);
DigitalOut min(LED3);
DigitalOut flash(LED4);

int total_cnt = 0;
int cpm_cnt = 0;
int cpm_old = 0;

void splash_oled(void) {
    oled1.background( 0x000000 );
    oled1.cls();
    
    oled1.locate( 0, 0 );
    oled1.printf( "GMT D3372 Count" );
    
    oled1.locate( 0, 1 );
    oled1.printf( "SPI = %s", MERMEX_OB_SPI_MODE_STR );

    for (int s = 1 ; s < 8 ; s++) {
        oled1.fill(0, MARMEX_OB_oled::HEIGHT - (s * 10),  MARMEX_OB_oled::WIDTH, 1, 0x000000ff);
    }
}

void beep_on(void) {
    for (int i = 1; i < 100 ; i++) {
        beep = 1;
        wait_us(500);
        beep = 0;
        wait_us(500);
    }
}

void flip() {
    led = !led;
    total_cnt++;
    cpm_cnt++;
    oled1.locate(0, 3);
    oled1.printf("Total:%d", total_cnt);

    beep_on();
}
    
int main() {

    int x = 0;
    
    splash_oled();

    beep_on();
    
    button.rise(&flip);  // attach the address of the flip function to the rising edge
    while(1) {
        if (cpm_cnt != 0) {
            cpm_old = cpm_cnt;
        }
        cpm_cnt = 0;
        for (int i = 1; i < 60; i++) {           // wait around, interrupts will interrupt this!
            flash = !flash;         // 1sec
            wait(1);
        }
        min = !min;     // 1min
        oled1.locate(0,4);
        oled1.printf("%d cpm", cpm_old);
        
        oled1.fill(x, MARMEX_OB_oled::HEIGHT - (cpm_old * 10), 1, (cpm_old * 10), 0x0000ff00);
        x++;
        if (x > MARMEX_OB_oled::WIDTH) { x = 0; }
    }
}