#include "mbed.h"
#include "akiledmatrix.h"

AkiLedMatrix::AkiLedMatrix(PinName sin1,
                 PinName sin2,
                 PinName sin3,
                 PinName clock,
                 PinName latch,
                 PinName strobe,
                 const int ledunit,
                 const int rowsize,
                 const int delay,
                 const int shift_count_init) :
                 _sin1(sin1),
                 _sin2(sin2),
                 _sin3(sin3),
                 _clock(clock),
                 _latch(latch),
                 _strobe(strobe),
                 _ledunit(ledunit),
                 _rowsize(rowsize),
                 _delay(delay),
                 _shift_count_init(shift_count_init) {
                 // initrize
                 _sin1 = 0;
                 _sin2 = 0;
                 _sin3 = 0;
                 _clock = 0;
                 _latch = 1;
                 _strobe = 0; // LED ON
                 shift_count = shift_count_init;
                 }

//
// bit shift array[buf_rowsize]
//
void AkiLedMatrix::bitshift(unsigned char *array, int xsize){
    int top_bit = 0, work_bit = 0;
    for (int y = 0; y < (16 * xsize); y = y + xsize){
        for (int x = 0; x < xsize; x++){
            if ((array[x + y] & 0x80) != 0){
                if (x == 0){
                    top_bit = 1;
                } else {            
                    work_bit = 1;
                }
            } else {
                if (x == 0){
                    top_bit = 0;
                } else {            
                    work_bit = 0;
                }
            }
            // Right shift
            array[x + y] = array[x + y] << 1;

            if (x != 0){
                array[x + y - 1 ] = array[x + y - 1 ] | work_bit;
            }
        }
        // set lower bit (last byte)
        array[y + xsize - 1] = array[y + xsize - 1] | top_bit;
    }
}

void AkiLedMatrix::display(unsigned char *buffer) {
    for (int y = 0; y < 16; y++){
        int bufp = y * _rowsize;  // buffer pointer
        for (int ledno = (_ledunit - 1); ledno >= 0; ledno--){
            uint16_t led1_data = buffer[bufp + ledno * 4]     << 8 | buffer[bufp + ledno * 4 + 1];
            uint16_t led2_data = buffer[bufp + ledno * 4 + 2] << 8 | buffer[bufp + ledno * 4 + 3];
            
            for (int x = 0; x < 16; x++){
                if (x == y){
                    _sin1 = 1;
                } else {
                    _sin1 = 0;
                }
                
                // LED1
                _sin2 = led1_data & 0x01;
                led1_data = led1_data >> 1;
                
                // LED2
                _sin3 = led2_data & 0x01;
                led2_data = led2_data >> 1;
                
                wait_us(2);         // tSETUP min:1.2us
                
                // set clock
                _clock = 1;
                wait_us(1);         // twCLK min:1.0us
                _clock = 0;
            }
        }

        // set latch
        _latch = 0;
        wait_us(2);             // twLAT min:2.0us
        _latch = 1;
            
        wait_us(_delay);
        
        // shift check
        if (_shift_count_init != 0){
            if (shift_count-- == 0){
                bitshift(buffer, _rowsize);
                shift_count = _shift_count_init;
            }
        }
    }
}

int AkiLedMatrix::getrowsize(){
    return _rowsize;
}

int AkiLedMatrix::getledunit(){
    return _ledunit;
}
