//
// Akizuki LED Matrix Sample program 8 (using class library)
//

#include "mbed.h"
#include "akiledmatrix.h"

// LEDMatrix      mbed
// ----------   --------
// 1 LED_PWR
// 2 SIN_1 ----- p5 line
// 3 SIN_2 ----- p6 LED1 row
// 4 SIN_3 ----- p7 LED2 row
// 5 CLOCK ----- p8
// 6 LATCH ----- p9
// 7 STROBE ---- p10
// 8 IC_PWR
// 9 GND
// 10 GND

// ledunit = 2
// LED buff rowsize = 8
// delay = 1000
// shift_count = 50
AkiLedMatrix ledmatrix(p5, p6, p7, p8, p9, p10, 2, 8, 1000, 50);

int main() {
    unsigned char buffer[] = {
    //      UNIT1                 UNIT2
    // LED1       LED2       LED1       LED2
    0xff,0xff, 0xff,0xff, 0x00,0x00, 0x00,0x00, // D15
    0xff,0xff, 0xff,0xff, 0x00,0x00, 0x00,0x00, // D14
    0xff,0xff, 0xff,0xff, 0x00,0x00, 0x00,0x00, // D13
    0xff,0xe7, 0xff,0xfc, 0x00,0x18, 0x00,0x03, // D12
    0xff,0xe7, 0xff,0xfc, 0x00,0x18, 0x00,0x03, // D11
    0xff,0xe7, 0xff,0xfc, 0x00,0x18, 0x00,0x03, // D10
    0x44,0x60, 0xe0,0xe0, 0xbb,0x9f, 0x1f,0x1f, // D9
    0x00,0x20, 0x40,0x40, 0xff,0xdf, 0xbf,0xbf, // D8
    0x33,0x26, 0x4e,0x4c, 0xcc,0xd9, 0xb1,0xb3, // D7
    0x33,0x26, 0x40,0x4c, 0xcc,0xd9, 0xbf,0xb3, // D6
    0x33,0x26, 0x4f,0xcc, 0xcc,0xd9, 0xb0,0x33, // D5
    0x33,0x20, 0x60,0xc0, 0xcc,0xdf, 0x9f,0x3f, // D4
    0x33,0x28, 0xf1,0xe4, 0xcc,0xd7, 0x0e,0x1b, // D3
    0xff,0xff, 0xff,0xff, 0x00,0x00, 0x00,0x00, // D2
    0xff,0xff, 0xff,0xff, 0x00,0x00, 0x00,0x00, // D1
    0xff,0xff, 0xff,0xff, 0x00,0x00, 0x00,0x00}; // D0

    while(1){
       ledmatrix.display(buffer);
    }
}
