#include "mbed.h"

//Pin connected to Data in (DS) of 74HC595
DigitalOut dataPin(dp9);
//Pin connected to latch pin (ST_CP) of 74HC595
DigitalOut latchPin(dp10);
//Pin connected to clock pin (SH_CP) of 74HC595
DigitalOut clockPin(dp11);

uint8_t Tab[]={0xc0,0xf9,0xa4,0xb0,0x99,0x92,0x82,0xf8,0x80,0x90,0xff};

void shiftOut(DigitalOut data, DigitalOut clk, int sdata) {
    for (int i = 7; i >= 0; i--) {
        clk = 0;
        if(sdata & (1 << i)){
            data = 1;
        } else {
            data = 0;
        }
        clk = 1;
        data = 0;
    }
}

void leddisp(long n){
    char disp[9];
    
    sprintf(disp, "%08d¥n", n);
    
    for (int c = 8; c >= 0 ;c--){
        // write to the shift register with the correct bit set high:
        latchPin = 0;
        // shift the bits out:
        shiftOut(dataPin, clockPin, Tab[disp[c] - 48]);
        // turn on the output so the LEDs can light up:
        latchPin = 1;
    }
}

int main() {
    long number = 0;
    while(1) {
        leddisp(number++);
        if (number > 99999999) {
            number = 0;
        }
        wait(0.1);
    }
}
