// Hello World example for the USBMIDI library
#if 1 

 
#include "mbed.h"
#include "USBSerial.h"


void setup(void)
{
    RCC_ClkInitTypeDef RCC_ClkInitStruct;
    RCC_OscInitTypeDef RCC_OscInitStruct;
 
    RCC_OscInitStruct.OscillatorType =  RCC_OSCILLATORTYPE_LSI|RCC_OSCILLATORTYPE_HSE;
    RCC_OscInitStruct.HSEState =        RCC_HSE_ON;
    
    RCC_OscInitStruct.LSIState =        RCC_LSI_ON;
    RCC_OscInitStruct.PLL.PLLState =    RCC_PLL_ON;
    RCC_OscInitStruct.PLL.PLLSource =   RCC_PLLSOURCE_HSE;
    
RCC_OscInitStruct.PLL.PLLM            = 25;             // VCO input clock = 1 MHz (25 MHz / 25)
RCC_OscInitStruct.PLL.PLLN            = 192;           // VCO output clock = 192 MHz (1 MHz * 192)
RCC_OscInitStruct.PLL.PLLP            = RCC_PLLP_DIV2; // PLLCLK = 96 MHz (192 MHz / 2)
RCC_OscInitStruct.PLL.PLLQ            = 4;             // USB clock = 48 MHz (192 MHz / 4) --> Good for USB
  
  HAL_RCC_OscConfig(&RCC_OscInitStruct);
 
    RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_SYSCLK|RCC_CLOCKTYPE_PCLK1;
    RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
    HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2);
    
    SystemCoreClockUpdate();
    SystemCoreClock = 96000000;
    
    //HAL_RCC_MCOConfig(RCC_MCO2, RCC_MCO2SOURCE_SYSCLK, RCC_MCODIV_1);        // output SYSCLOCK to pin PC9 to monitor frequency
}

 

DigitalOut myled(PC_13);

int main() {    

    setup();

    USBSerial pc;
         
         
    while (1) {    
       pc.printf("\ncalisse de guidoune!");
       myled = !myled; // LED 
        wait_ms( 100 ); 
    }
} 


#endif 

#if 0 

#include "mbed.h"
#include "USBMIDI.h"


void setup(void)
{
    RCC_ClkInitTypeDef RCC_ClkInitStruct;
    RCC_OscInitTypeDef RCC_OscInitStruct;
 
    RCC_OscInitStruct.OscillatorType =  RCC_OSCILLATORTYPE_LSI|RCC_OSCILLATORTYPE_HSE;
    RCC_OscInitStruct.HSEState =        RCC_HSE_ON;
    
    RCC_OscInitStruct.LSIState =        RCC_LSI_ON;
    RCC_OscInitStruct.PLL.PLLState =    RCC_PLL_ON;
    RCC_OscInitStruct.PLL.PLLSource =   RCC_PLLSOURCE_HSE;
    
RCC_OscInitStruct.PLL.PLLM            = 25;             // VCO input clock = 1 MHz (25 MHz / 25)
RCC_OscInitStruct.PLL.PLLN            = 192;           // VCO output clock = 192 MHz (1 MHz * 192)
RCC_OscInitStruct.PLL.PLLP            = RCC_PLLP_DIV2; // PLLCLK = 96 MHz (192 MHz / 2)
RCC_OscInitStruct.PLL.PLLQ            = 4;             // USB clock = 48 MHz (192 MHz / 4) --> Good for USB
  
  HAL_RCC_OscConfig(&RCC_OscInitStruct);
 
    RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_SYSCLK|RCC_CLOCKTYPE_PCLK1;
    RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
    HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2);
    
    SystemCoreClockUpdate();
    SystemCoreClock = 96000000;
    
    //HAL_RCC_MCOConfig(RCC_MCO2, RCC_MCO2SOURCE_SYSCLK, RCC_MCODIV_1);        // output SYSCLOCK to pin PC9 to monitor frequency
}

 

int main() {    

    setup();

    USBMIDI midi;
    
         
    while (1) {    
        for(int i=48; i<83; i++) {     // send some messages!
            midi.write(MIDIMessage::NoteOn(i));
            wait(0.25);
            midi.write(MIDIMessage::NoteOff(i));
            wait(0.5);
            myled = !myled; // LED 
        }
    }
}
#endif 