/* mbed MCP4822 Library, for driving the 12-Bit DAC with internal Vref and SPI interface
 * Copyright (c) 2015, Created by Steen Joergensen (stjo2809)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 #include "mbed.h"
 #include "MCP4822.h"
 
//=============================================================================
// Public functions
//=============================================================================

    MCP4822::MCP4822(SPI& spi, PinName nLDAC, PinName nCs) : _spi(spi), _nLDAC(nLDAC), _nCs(nCs)
    {
        
    }
    
   /* 
    MCP4822::MCP4822(PinName nLDAC, PinName mosi, PinName miso,PinName sck, PinName nCs) : _nLDAC(nLDAC), _mosi(mosi), _miso(miso), _sck(sck), _nCs(nCs)
    {
        SPI _spi(_mosi,_miso,_sck);    
    }
 */   
    void MCP4822::a(bool gain, int data)
    {
        _write(0, gain, 1, data);    
    }
    
    void MCP4822::b(bool gain, int data)
    {
        _write(1, gain, 1, data);     
    }
   
    void MCP4822::ldac(bool act)
    {
        _nLDAC = ~act;    
    }
    
    void MCP4822::shdn(bool output, bool act)
    {
        _write(output, 1, ~act, 0x00);    
    }
    
//=============================================================================
// Private functions
//=============================================================================

    char MCP4822::_make_upper_half(bool output, bool gain, bool shdn, int data)
    {
        char responce = 0;
        
        if(output == '0')
        {
            responce = responce | CB_OUTPUT_A;        
        }
        else
        {
            responce = responce | CB_OUTPUT_B;      
        }
        
        if(gain == '0')
        {
            responce = responce | CB_GAIN_2X;        
        }
        else
        {
            responce = responce | CB_GAIN_1X;      
        }
        
        if(shdn == '0')
        {
            responce = responce | CB_NSHDN;        
        }
        else
        {
            responce = responce | CB_SHDN;      
        }
        
        if(data > 0xff && data < 0xfff)
        {
            responce = responce | (data >> 8);        
        }
        
        return responce;     
    }
    
    char MCP4822::_make_lower_half(int data)
    {
      return (data & 0xff);    
    }
    
    void MCP4822::_write(bool output, bool gain, bool shdn, int data)  
    {
        
        _upper_half = _make_upper_half(output, gain, shdn, data);
        _lower_half = _make_lower_half(data);
        
        _nCs = 0;
        _spi.write(_upper_half);
        _spi.write(_lower_half);
        _nCs = 1;    
    }