
#include "mbed.h" 

 

void setup(void)
{
    RCC_ClkInitTypeDef RCC_ClkInitStruct;
    RCC_OscInitTypeDef RCC_OscInitStruct;
 
    RCC_OscInitStruct.OscillatorType =  RCC_OSCILLATORTYPE_LSI|RCC_OSCILLATORTYPE_HSE;
    RCC_OscInitStruct.HSEState =        RCC_HSE_ON;
    
    RCC_OscInitStruct.LSIState =        RCC_LSI_ON;
    RCC_OscInitStruct.PLL.PLLState =    RCC_PLL_ON;
    RCC_OscInitStruct.PLL.PLLSource =   RCC_PLLSOURCE_HSE;
    
RCC_OscInitStruct.PLL.PLLM            = 25;             // VCO input clock = 1 MHz (25 MHz / 25)
RCC_OscInitStruct.PLL.PLLN            = 192;           // VCO output clock = 192 MHz (1 MHz * 192)
RCC_OscInitStruct.PLL.PLLP            = RCC_PLLP_DIV2; // PLLCLK = 96 MHz (192 MHz / 2)
RCC_OscInitStruct.PLL.PLLQ            = 4;             // USB clock = 48 MHz (192 MHz / 4) --> Good for USB
  
  HAL_RCC_OscConfig(&RCC_OscInitStruct);
 
    RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_SYSCLK|RCC_CLOCKTYPE_PCLK1;
    RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
    HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2);
    
    SystemCoreClockUpdate();
    SystemCoreClock = 96000000;
    
    //HAL_RCC_MCOConfig(RCC_MCO2, RCC_MCO2SOURCE_SYSCLK, RCC_MCODIV_1);        // output SYSCLOCK to pin PC9 to monitor frequency
}


