#if 1
#include "mbed.h"
#include "USBMIDI.h"
#include "MCP4822.h"


void setup(void)
{
    RCC_ClkInitTypeDef RCC_ClkInitStruct;
    RCC_OscInitTypeDef RCC_OscInitStruct;
 
    RCC_OscInitStruct.OscillatorType =  RCC_OSCILLATORTYPE_LSI|RCC_OSCILLATORTYPE_HSE;
    RCC_OscInitStruct.HSEState =        RCC_HSE_ON;
    
    RCC_OscInitStruct.LSIState =        RCC_LSI_ON;
    RCC_OscInitStruct.PLL.PLLState =    RCC_PLL_ON;
    RCC_OscInitStruct.PLL.PLLSource =   RCC_PLLSOURCE_HSE;
    
RCC_OscInitStruct.PLL.PLLM            = 25;             // VCO input clock = 1 MHz (25 MHz / 25)
RCC_OscInitStruct.PLL.PLLN            = 192;           // VCO output clock = 192 MHz (1 MHz * 192)
RCC_OscInitStruct.PLL.PLLP            = RCC_PLLP_DIV2; // PLLCLK = 96 MHz (192 MHz / 2)
RCC_OscInitStruct.PLL.PLLQ            = 4;             // USB clock = 48 MHz (192 MHz / 4) --> Good for USB
  
  HAL_RCC_OscConfig(&RCC_OscInitStruct);
 
    RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_SYSCLK|RCC_CLOCKTYPE_PCLK1;
    RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
    HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2);
    
    SystemCoreClockUpdate();
    SystemCoreClock = 96000000;
    
    //HAL_RCC_MCOConfig(RCC_MCO2, RCC_MCO2SOURCE_SYSCLK, RCC_MCODIV_1);        // output SYSCLOCK to pin PC9 to monitor frequency
}

DigitalOut myled( PC_13); 
DigitalOut gate_A( PB_2);  
DigitalOut gate_B( PB_10); 
SPI spi(  PA_7, PA_6, PA_5); 
MCP4822 dac(spi, PB_1, PB_0 );
    
void show_message(MIDIMessage msg) {
    switch (msg.type()) {
        case MIDIMessage::NoteOffType:
            //TODO
            break;
        case MIDIMessage::NoteOnType:
            // TODO  
            //cf  = msg.key();
            //cf  = msg.velocity();
            
            break;
        case MIDIMessage::PolyphonicAftertouchType:
            // TODO code 
            break;
        case MIDIMessage::ControlChangeType:
            // TODO code 
            break;
        case MIDIMessage::AllNotesOffType:
            // TODO 
            break;
        case MIDIMessage::ErrorType:
            // TODO code 
            break;
        case MIDIMessage::ProgramChangeType:
            // TODO code 
            break;
        case MIDIMessage::ChannelAftertouchType:
            // TODO code 
            break;
        case MIDIMessage::PitchWheelType:
            // TODO code 
            break;
        case MIDIMessage::SysExType:
            // TODO code 
            break; 
        default:
           // leds = 0;
           break; 
    }
}

int main() {    

    setup();

    USBMIDI midi;
    
    
    
    midi.attach(show_message);
         
    while (1) {    
        for(int i=48; i<83; i++) {     // send some messages!
            midi.write(MIDIMessage::NoteOn(i));
            dac.a(0,1024);
            dac.b(0,1024);
            gate_A = 1 ; 
            gate_B = 1 ; 
            
            wait(0.25);
            midi.write(MIDIMessage::NoteOff(i));
            gate_A = 0 ; 
            gate_B = 0 ; 
            dac.a(0,512);
            dac.b(0,512);
            
            wait(0.5);
            myled = !myled; // LED 
        }
    }
}
#endif 
#if 0
#include "mbed.h"
#include "USBMIDI.h"


void setup(void)
{
    RCC_ClkInitTypeDef RCC_ClkInitStruct;
    RCC_OscInitTypeDef RCC_OscInitStruct;
 
    RCC_OscInitStruct.OscillatorType =  RCC_OSCILLATORTYPE_LSI|RCC_OSCILLATORTYPE_HSE;
    RCC_OscInitStruct.HSEState =        RCC_HSE_ON;
    
    RCC_OscInitStruct.LSIState =        RCC_LSI_ON;
    RCC_OscInitStruct.PLL.PLLState =    RCC_PLL_ON;
    RCC_OscInitStruct.PLL.PLLSource =   RCC_PLLSOURCE_HSE;
    
RCC_OscInitStruct.PLL.PLLM            = 25;             // VCO input clock = 1 MHz (25 MHz / 25)
RCC_OscInitStruct.PLL.PLLN            = 192;           // VCO output clock = 192 MHz (1 MHz * 192)
RCC_OscInitStruct.PLL.PLLP            = RCC_PLLP_DIV2; // PLLCLK = 96 MHz (192 MHz / 2)
RCC_OscInitStruct.PLL.PLLQ            = 4;             // USB clock = 48 MHz (192 MHz / 4) --> Good for USB
  
  HAL_RCC_OscConfig(&RCC_OscInitStruct);
 
    RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_SYSCLK|RCC_CLOCKTYPE_PCLK1;
    RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
    HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2);
    
    SystemCoreClockUpdate();
    SystemCoreClock = 96000000;
    
    //HAL_RCC_MCOConfig(RCC_MCO2, RCC_MCO2SOURCE_SYSCLK, RCC_MCODIV_1);        // output SYSCLOCK to pin PC9 to monitor frequency
}

 DigitalOut myled( PC_13); 

int main() {    

    setup();

    USBMIDI midi;
    
         
    while (1) {    
        for(int i=48; i<83; i++) {     // send some messages!
            midi.write(MIDIMessage::NoteOn(i));
            wait(0.25);
            midi.write(MIDIMessage::NoteOff(i));
            wait(0.5);
            myled = !myled; // LED 
        }
    }
}
#endif 

