#include "mbed.h"
#include "Stepper.h"

// Pin setup
DigitalOut step(p22);
DigitalOut dir(p21);
DigitalOut m1(p23);
DigitalOut m0(p24);
DigitalOut step_indicator(LED1);


// Microstepping config
// (m1)|(m0)|(mode)
// 0|0|full
// 0|1|1/2
// 0|Z|1/4
// 1|0|8 usteps/sec
// 1|1|16 usteps/sec
// 1|Z|32 usteps/sec
int delay = 10;

int main() 
{   
    m1 = 0;
    m0 = 0;
    step = 0;
    dir = 1;
    step_indicator = 0;
    
    while(1) {
        for (int i=1; i<=200*16; ++i) {
            step = 1;
            step_indicator = 1;
            wait_ms(delay);
            step = 0;
            step_indicator = 0;
            wait_ms(delay);
        }
        dir = !dir;
        wait(1.0);
    }
}