//Include required libraries (uLCD, mbed, rtos, etc.)
#include "mbed.h"
#include "rtos.h"
//#include "uLCD_4DGL.h"
//#include "wave_player.h"
//#include "stdio.h"
//#include "RGBLed.h"
//#include "SDFileSystem.h"

//Initialize all objects
//uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;
//SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
//RawSerial  blue(p13,p14);
//RGBLed myRGB(p21, p22, p23);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
//AnalogOut DACout(p18);
//wave_player waver(&DACout);

Mutex mut;
 
// Thread 1
// Bounce a circle around the screen centered randomly every 100ms
void thread1(void const *args)
{   
    int i;
    //int xLCD, yLCD;
    while(true) {       // thread loop
        mut.lock();
        ////uLCD.baudrate(3000000);
        ////uLCD.cls();
        ////uLCD.color(RED);
        ////uLCD.background_color(BLACK);
        ////uLCD.set_font(FONT_7X8);
        //////uLCD.text_mode(TRANSPARENT);
        ////uLCD.text_bold(ON);
        ////uLCD.printf("Count1: %d", i);
        led1 = !led1;
        mut.unlock();
        i++;
        
        Thread::wait(1000);
    }
}
 
// Thread 2
// prints a counter to the center of the screen
void thread2(void const *args)
{
    int k;
    while(true) {       // thread loop
        mut.lock();
        ////uLCD.baudrate(3000000);
        ////uLCD.cls();
        ////uLCD.color(BLUE);
        ////uLCD.background_color(BLACK);
        ////uLCD.set_font(FONT_7X8);
        //////uLCD.text_mode(TRANSPARENT);
        ////uLCD.text_bold(ON);
        ////uLCD.printf("Count2: %d", k);
        led2 = !led2;
        mut.unlock();
        k++;
        
        Thread::wait(500);
    }
}
 
//Thread 3
//Do a "fancy" lighting effect on the RGB LED #include "ultrasonic.h"
void thread3(void const *args)
{
    //mut.lock();
    //FILE *wave_file;
    //printf("\r\n\nHello, wave world!\n\r");
    //Thread::wait(1000);
    //wave_file=fopen("/sd/chirp.wav","r");
    //if(wave_file==NULL) printf("file open error!\n\n\r");
    //waver.play(wave_file);
    //fclose(wave_file);
    //mut.unlock();
    while(true) {       // thread loop
        led3 = !led3;
        Thread::wait(1000);
    }
}

// Thread 4
// Reads inputs from the bluetooth module
//void thread4(void const *args)
//{
//    while(true) {       // thread loop
//        mut.lock();
//        myRGB.write(1.0,0.0,0.0); //red
//        wait(2.0);
//        myRGB.write(0.0,1.0,0.0); //green
//        wait(2.0);
//        myRGB.write(0.0,0.0,1.0); //blue
//        wait(2.0);
//        myRGB.write(1.0,0.2,0.0); //yellow = red + some green
//        wait(2.0);
//        //white with a slow fade to black dimming effect
//        for (float x=1.0; x>=0.0001; x=x*0.99) {
//            myRGB.write(x, x, x);
//            wait(0.005);
//        }
//        mut.unlock();
//        //wait(2.0);
//        Thread::wait(1000);
//    }
//}

int main()
{
    Thread t1(thread1); 
    Thread t2(thread2); 
    Thread t3(thread3); 
    //Thread t4(thread4);
    //wait(0.1); // wait for uLCD ready

    while(true) {       // main is the next thread
        led4 = !led4;
        Thread::wait(500);   // wait 0.5s
    }
}