#include "mbed.h"
#include "PinDetect.h"

// THIS PROGRAM IS FOR DEMONSTRATING PROBLEMS 1 - 3 OF LAB #1
// NOW INCLUDES PARTS 8

// Input declarations
// Input/output type yourvariable(physical pin)
DigitalIn pb_1(p5);
DigitalIn dip1(p8);
DigitalIn dip2(p9);
DigitalIn dip3(p10);
PinDetect pb_2_up(p6);
PinDetect pb_2_down(p7);
PinDetect pb_3_up(p11);
PinDetect pb_3_down(p12);
AnalogIn pot8(p20);


// Output declarations
DigitalOut redLED(p30);
DigitalOut mbedLED2(LED2);
DigitalOut mbedLED3(LED3);
DigitalOut mbedLED4(LED4);
PwmOut pwmLED(LED1);
PwmOut redPwm(p23);
PwmOut greenPwm(p22);
PwmOut bluePwm(p21);
PwmOut greenLED(p24);
//AnalogOut aout(p18);

// Global variables for pwm changes
// duty_cycle_2 ranges from 0.0f - 1.0f
float volatile duty_cycle_2 = 0.5f;
float volatile duty_cycle_3 = 0.5f;

// Callback routine is interrupt activated by a debounced pb_2_up hit
void pb2up_hit_callback (void) {
    if(duty_cycle_2 < 1.0f) {
        duty_cycle_2 += 0.1f;
    } else if(duty_cycle_2 > 1.0f) {
        duty_cycle_2 = 1.0f;
    }
}
// Callback routine is interrupt activated by a debounced pb_2_down hit
void pb2down_hit_callback (void) {
    if(duty_cycle_2 > 0.0f) {
        duty_cycle_2 -= 0.1f;
    } else if(duty_cycle_2 < 0.0f) {
        duty_cycle_2 = 0.0f;
    }
}
// Callback routine is interrupt activated by a debounced pb_2_up hit
void pb3up_hit_callback (void) {
    if(duty_cycle_3 < 1.0f) {
        duty_cycle_3 += 0.1f;
    } else if(duty_cycle_3 > 1.0f) {
        duty_cycle_3 = 1.0f;
    }
}
// Callback routine is interrupt activated by a debounced pb_2_down hit
void pb3down_hit_callback (void) {
    if(duty_cycle_3 > 0.0f) {
        duty_cycle_3 -= 0.1f;
    } else if(duty_cycle_3 < 0.0f) {
        duty_cycle_3 = 0.0f;
    }
}

int main()  { 
    //duty_cycle_2 = 0.5f;
    
    // Variable Declarations
    pb_2_up.mode(PullUp);
    pb_2_down.mode(PullUp);
    pb_3_up.mode(PullUp);
    pb_3_down.mode(PullUp);
    dip1.mode(PullUp);
    dip2.mode(PullUp);
    dip3.mode(PullUp);
    
    wait(0.1);
    // Setup Interrupt callback functions for pb up and down
    pb_2_up.attach_deasserted(&pb2up_hit_callback);
    pb_2_down.attach_deasserted(&pb2down_hit_callback);
    pb_3_up.attach_deasserted(&pb3up_hit_callback);
    pb_3_down.attach_deasserted(&pb3down_hit_callback);
    //Start sampling pb up and down inputs using interrupts
    pb_2_up.setSampleFrequency();
    pb_2_down.setSampleFrequency();
    pb_3_up.setSampleFrequency();
    pb_3_down.setSampleFrequency();
    // pwmLED variable declarations
    
    while(1) {
        redLED = !pb_1;
        pwmLED = duty_cycle_2;

        if (!dip1) {
            redPwm = duty_cycle_3;
        } else {
            redPwm = 0.0f;
        }

        if (!dip2) {
            greenPwm = duty_cycle_3;
        } else {
            greenPwm = 0.0f;
        }
        if (!dip3) {
            bluePwm = duty_cycle_3;
        } else {
            bluePwm = 0.0f;
        }
        greenLED = pot8;
    }
}