#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "stm32746g_discovery_ts.h"

#include <stdio.h>
#include <stdlib.h>

#include <math.h>
#include <time.h>
//taille de la map généré aléatoirement
#define LONGUEUR 7
#define LARGEUR 7
//taille de la map qui sera "réellement" utilisée :: map aléatoire multipliée par 3
#define MAP_WIDTH 21
#define MAP_HEIGHT 21

# define M_PI           3.14159265358979323846

#define TICKS_PER_SEC 64

#define WALL_SIZE 64
#define CAMERA_HEIGHT 32
#define SCREEN_WIDTH 480 
#define SCREEN_HEIGHT 272
#define DISTANCE_SCREEN_CAMERA 640

void screen_init();
void screen_draw();

typedef int color;
typedef char ident; //contiendra 5 bits (54321)b, le 5 pour la verif, 4 pour haut, 3 droite, 2 bas et 1 gauche
//en binaire, si l'un des 4 derniers bit est à 1, le mur associé est fermé

typedef color worldmap[MAP_HEIGHT][MAP_WIDTH];
typedef ident minimap[LARGEUR][LONGUEUR];

typedef struct position{
    double x;
    double y;
}position;

typedef struct inputState{
    int x;
    int y;
}inputState;

typedef struct dist_and_color{
    double distance;
    color color;
}dist_and_color;    

void show_world(position pos,worldmap map);

void arrow_up(position *pos,double vx,double vy);
void arrow_down(position *pos,double vx,double vy);


void rotation(double * vx,double * vy, double theta);
void arrow_right(double * vx,double * vy);
void arrow_left(double * vx,double * vy);


color tangent_wall_h(double xprime,int yprime,double vy, worldmap map);
color tangent_wall_v(int xprime,double yprime,double vx, worldmap map);

dist_and_color dda_h(position pos,double vx, double vy,worldmap map);
dist_and_color dda_v(position pos,double vx, double vy,worldmap map);
dist_and_color dda(position pos,double vx, double vy,worldmap map);


void display(position pos, double vx, double vy, worldmap map);

int getInputState(inputState *iS);

void createMap(minimap mini, worldmap world);
void gerenatePosition(int* i_pt, int* j_pt, worldmap world);
void generateSortie(int i, int j, worldmap world);
int verificationFin(position pos, worldmap world);
