#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "GAME_ENGINE.h"

int main()
{  
    srand( (unsigned int) time(0) );
    inputState iS;
    clock_t start_t, end_t;

    minimap mini;
    worldmap world;
    createMap(mini, world);

    int i = 0;
    int j = 0;
    int verifi = 0;
    int verifj = 0;
    int fin;
    
    gerenatePosition(&i, &j, world);
    generateSortie(i, j, world);
    
    position pos ={(i*64 + 32),(j*64 + 32)};
    double vx =0,vy=10;
    if (BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize()) != TS_OK) 
    {
        BSP_LCD_Clear(LCD_COLOR_BLACK);
        BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else 
    {
        BSP_LCD_Clear(LCD_COLOR_BLACK);
        BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Nouvelle Partie", CENTER_MODE);
    }
    HAL_Delay(1000);
    //rotation(&vx,&vy,M_PI/3)
    
    while(1)
    {
        start_t = clock();
        if(getInputState(&iS)==1)
        {
            if(iS.y>211)
            {
                arrow_down(&pos, vx, vy);
            }
            else if(iS.y<61)
            {
                arrow_up(&pos, vx, vy);
            }
            else if(iS.x>280)
            {
                rotation(&vx,&vy,2*M_PI-M_PI/45);   
            }
            else if(iS.x<200)
            {
                rotation(&vx,&vy,M_PI/45);   
            }
            else
            {
            }
            
            display(pos,vx,vy,world);
        }
        else
        {
            display(pos,vx,vy,world);
        }
        
        do
        {
            end_t=clock();
        }
        while(((double)(end_t - start_t) / CLOCKS_PER_SEC)<((double)1/TICKS_PER_SEC));
        
        fin = verificationFin(pos, world);
        if(fin == 1)
        {
            do
            {
                BSP_LCD_Clear(LCD_COLOR_BLACK);
                BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"Victoire", CENTER_MODE);
            }
            while(1);
        }
    }
}
