#ifndef MBED_MOTOR_h
#define MBED_MOTOR_h

#include "mbed.h"

#define PWMOFFSET 512 // pwm @ Duty 50% 
#define MaxBuf 255  // buffer size to store the speed data

class MotorCtl
{
    public:
    
        MotorCtl(PinName Pwm, BusOut &Dir, PinName tachoA, PinName tachoB);
        
        ~MotorCtl();

        int getRPM();
        float CalculateCumDis();
        float CalculateRelaDis();
        float CalculateVelocity();
        int getTarget();
        int getError();
        float getKP();
        float getKI();
        float getKD();
        int *getHistory();
        int getCurrentPosition();
        
        void SetPeriod(long pwmPeriod); // set pwm period
        void setTarget(int spd);
        void setPID(float p, float i, float d);
        void setDirection(); // set the direction
        
        
        //Control Methods
        void UpdateCurrentPosition();
        void PIDControl();
        void Reset(void);


        
    private:
        PwmOut _pwm;
        BusOut _Dir;
        DigitalInOut _tachoA;
        DigitalInOut _tachoB;
        Ticker _tick;
        
        long CurrentPosition, PreviousPosition, DistancePosition; // Position Value
        int CurrentSpeed, Error,PreviousError; // Speed Data
        float duty; // Duty level ( 0-1024)
        unsigned int pwmPeriod; // default 50ms
        unsigned char pwmpin; // PB2 ( 10 )
        unsigned char ppin, npin,dr;  // dr =10 means ccwise, dr=0 means clockwise
        unsigned int CntPerRev;
        unsigned int DeltaT;
        unsigned char PreviousEncode;
        float kp, ki, kd;
        int integ, derv,control,cw0[MaxBuf];
        unsigned char cpidx;
        float CalculateRPM(int DeltaCnt); // Calculate RPM value

        float vel;
        int TargetSpeed;

};
#endif
        
        
        