#include "mbed.h"
#include "WizFi310Interface.h"
#include "DHT.h"
#include "MQTTClient.h"
#include "MQTTmbed.h"
#include "MQTTSocket.h"
#define ECHO_SERVER_PORT   7
#define USE_DHCP    1

#define SECURE WizFi310::SEC_WPA2_MIXED
#define AP_SSID "cdi1"// Input SSID
#define AP_PASSWORD "cdilab17" // Input PW

#if defined(TARGET_WIZwiki_W7500)
Serial pc(USBTX, USBRX);
WizFi310Interface wifi(D1, D0, D7, D6, D8, NC, 115200);
#endif

int arrivedcount = 0;

 class MQTTWIZ: public MQTTSocket
{
public:    
    MQTTWIZ()
    {
        wait(1);
        this->createSocket();
    }
};

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
}

void baud(int baudrate) {
    Serial s(USBTX, USBRX);
    s.baud(baudrate);
}

int main (void)
{
    baud(115200);
    //Wifi Connection
    wifi.init();
    printf("WizFi310 \r\n");
    wifi.connect(SECURE,AP_SSID, AP_PASSWORD,WizFi310::WM_STATION);
    printf("IP Address is %s\r\n", wifi.getIPAddress());
    //MQTT Connection
    printf("Wait a second...\r\n");
    char* topic = "wizfi/temp";
    MQTTWIZ ipstack = MQTTWIZ();
    MQTT::Client<MQTTWIZ, Countdown> client = MQTT::Client<MQTTWIZ, Countdown>(ipstack);
    DHT sensor(D14, DHT11);
    char* hostname = "172.16.73.4";
    int port = 1883;
    int rc = ipstack.connect(hostname, port);
    printf("Topic: %s\r\n",topic);
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
    data.MQTTVersion = 3;
    data.clientID.cstring = "dinesh12319237983712";
    rc = client.connect(data);
    rc = client.subscribe(topic, MQTT::QOS1, messageArrived);
    MQTT::Message message;
     int error = 0;
    char buf[100]="Hello World";
    float temp=0.0;
    while (true) 
    {
        error = sensor.readData();
        if (0 == error) 
        {
            temp = sensor.ReadTemperature(CELCIUS);
        }
        
        message.qos = MQTT::QOS0;
        message.retained = false;
        message.dup = false;
        sprintf(buf, "%3.1f", temp);
        message.payload = (void*)buf;
        message.payloadlen = strlen(buf);
        rc = client.publish("wizfi/temp", message);
        printf("Temperature Published : %s\r\n",message.payload);
        client.yield(60000);
    }
}

