// Wire
// 09 I2C
// 10 I2C
// 11 Analog Switch A (on-intervals)
// 12 Analog Switch B (off-intervals)
// 13 TX (MIDI OUT)
// 15 VR A1/B1
// 16 VR A2/B2
// 17 VR A3/B3
// 18 VR A4/B4
// 19 VR C1

#include "mbed.h"
#include "rtos.h"
#include "MIDI.h"

#define MILISECOND 1000
#define INTERVAL 5
#define RANDOMNESS 10

#define MIN_OFF_INTERVAL 100
#define MIN_ON_INTERVAL 10

Serial pc(USBTX, USBRX);

int notes[4] = { 60, 64, 67, 71 };

Mutex midiMutex;
Mutex vrSelectorMutex;

MIDI midi(p13, p14);

DigitalOut vrSelectorA(p11);
DigitalOut vrSelectorB(p12);

AnalogIn vr1(p15);
AnalogIn vr2(p16);
AnalogIn vr3(p17);
AnalogIn vr4(p18);
AnalogIn vr5(p19);

AnalogIn vrs[4] = { vr1, vr2, vr3, vr4 };

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalOut leds[4] = { led1, led2, led3, led4 };

void led_thread(void const *args) {
    int num = *(int *)args;
    while (true) {
        // Send MIDI note off
        leds[num] = 0;
        midiMutex.lock();
        midi.sendNoteOn(notes[num], 0, num + 1);
        midiMutex.unlock();
        // Read parameters
        vrSelectorMutex.lock();
        vrSelectorA = 1; vrSelectorB = 0;
        Thread::wait(1);
        float a = vrs[num];
        vrSelectorA = 0; vrSelectorB = 1;
        Thread::wait(1);
        float b = vrs[num];
        vrSelectorMutex.unlock();
        float c = vr5;
        float randomness1 = ((float)rand() / (float)RAND_MAX * RANDOMNESS * 2.0 - RANDOMNESS) * c;
        float randomness2 = ((float)rand() / (float)RAND_MAX * RANDOMNESS * 2.0 - RANDOMNESS) * c;
        int interval1 = (a * 60 + randomness1) * MILISECOND;
        int interval2 = (b * 60 + randomness2) * MILISECOND;        
        if (interval1 <= 0) {
            interval1 = 0;
        }
        if (interval2 <= 0) {
            interval2 = 0;
        }
        pc.printf("ch.%d: off_interval=%d, on_interval=%d\n", num + 1, interval2, interval1); 
        // Off-interval
        Thread::wait(interval2 + MIN_OFF_INTERVAL);
        // Send MIDI note on
        leds[num] = 1;
        midiMutex.lock();
        midi.sendNoteOn(notes[num], 127, 1);
        midiMutex.unlock();
        // On-interval
        Thread::wait(interval1 + MIN_ON_INTERVAL);
    }
}

int main() {
    pc.printf("Hello.\n");

    srand(1);
    midi.begin();
    // readVRs();
    int one = 0, two = 1, three = 2, four = 3;
    Thread thread1(led_thread, &one);
    Thread thread2(led_thread, &two);
    Thread thread3(led_thread, &three);
    Thread thread4(led_thread, &four);
    while (true) {
        Thread::wait(INTERVAL * MILISECOND);
    }
}
