/*
 Wtv020sd16p.cpp - Library to control a WTV020-SD-16P module 
 Created by Diego J. Arevalo, August 6th, 2012 for  Arduino plaform
 Modified by Kamil Kanas, 17/5/2017 for mbed platforms
 Tested with FRDM KL25Z board
 Released into the public domain 9/7/2017.
 */

#ifndef WTV020SD16_h
#define WTV020SD16_h
#include "mbed.h"

  
class Wtv020sd16p
{
public:
  void reset();
  void playVoice(int voiceNumber);
  void asyncPlayVoice(int voiceNumber);
  void stopVoice();
  void pauseVoice();
  void mute();
  void unmute();
private:
  void sendCommand(unsigned int command);
  int _busyPinState;
  
};

#endif


